/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.robolectric.res.FileFsFile;
import org.robolectric.res.FsFile;
import org.robolectric.util.Join;
import org.robolectric.util.Util;

public abstract class Fs {
    public static Fs fromJar(URL url) {
        return new JarFs(new File(Fs.fixFileURL(url).getPath()));
    }

    private static URI fixFileURL(URL u) {
        if (!"file".equals(u.getProtocol())) {
            throw new IllegalArgumentException();
        }
        return new File(u.getPath()).toURI();
    }

    @Deprecated
    public static FsFile fileFromPath(String urlString) {
        if (urlString.startsWith("jar:")) {
            String[] parts = urlString.replaceFirst("jar:", "").split("!");
            JarFs fs = new JarFs(new File(parts[0]));
            return ((Fs)fs).join(parts[1].substring(1));
        }
        return new FileFsFile(new File(urlString));
    }

    public static FsFile fromURL(URL url) {
        switch (url.getProtocol()) {
            case "file": {
                return new FileFsFile(new File(url.getPath()));
            }
            case "jar": {
                String[] parts = url.getPath().split("!");
                try {
                    Fs fs = Fs.fromJar(new URL(parts[0]));
                    return fs.join(parts[1].substring(1));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        throw new IllegalArgumentException("unsupported fs type for '" + url + "'");
    }

    public static FsFile newFile(File file) {
        return new FileFsFile(file);
    }

    public static FsFile newJarFile(File file) {
        JarFs jarFs;
        JarFs jarFs2 = jarFs = new JarFs(file);
        Objects.requireNonNull(jarFs2);
        return jarFs2.new JarFs.JarFsFile("");
    }

    public static FsFile newFile(String filePath) {
        return new FileFsFile(filePath);
    }

    public static FsFile currentDirectory() {
        return Fs.newFile(new File("."));
    }

    public abstract FsFile join(String var1);

    static class JarFs
    extends Fs {
        private static final Map<File, NavigableMap<String, JarEntry>> CACHE = new LinkedHashMap<File, NavigableMap<String, JarEntry>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<File, NavigableMap<String, JarEntry>> fileNavigableMapEntry) {
                return this.size() > 10;
            }
        };
        private final JarFile jarFile;
        private final NavigableMap<String, JarEntry> jarEntryMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarFs(File file) {
            NavigableMap<String, JarEntry> cachedMap;
            try {
                this.jarFile = new JarFile(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Map<File, NavigableMap<String, JarEntry>> map = CACHE;
            synchronized (map) {
                cachedMap = CACHE.get(file.getAbsoluteFile());
            }
            if (cachedMap == null) {
                cachedMap = new TreeMap<String, JarEntry>();
                Enumeration<JarEntry> entries = this.jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    cachedMap.put(jarEntry.getName(), jarEntry);
                }
                Map<File, NavigableMap<String, JarEntry>> map2 = CACHE;
                synchronized (map2) {
                    CACHE.put(file.getAbsoluteFile(), cachedMap);
                }
            }
            this.jarEntryMap = cachedMap;
        }

        @Override
        public FsFile join(String folderBaseName) {
            return new JarFsFile(folderBaseName);
        }

        class JarFsFile
        implements FsFile {
            private final String path;

            public JarFsFile(String path) {
                this.path = path.replaceAll("^/+", "");
            }

            @Override
            public boolean exists() {
                return this.isFile() || this.isDirectory();
            }

            @Override
            public boolean isDirectory() {
                return JarFs.this.jarEntryMap.containsKey(this.path + "/");
            }

            @Override
            public boolean isFile() {
                return JarFs.this.jarEntryMap.containsKey(this.path);
            }

            @Override
            public FsFile[] listFiles() {
                return this.listFiles(fsFile -> true);
            }

            @Override
            public FsFile[] listFiles(FsFile.Filter filter) {
                NavigableSet<Object> strings = JarFs.this.jarEntryMap.navigableKeySet();
                int startOfFilename = 0;
                if (!this.path.equals("")) {
                    if (!this.isDirectory()) {
                        return null;
                    }
                    strings = strings.subSet(this.path + "/", false, this.path + "0", false);
                    startOfFilename = this.path.length() + 2;
                }
                ArrayList<JarFsFile> fsFiles = new ArrayList<JarFsFile>();
                for (String string : strings) {
                    int nextSlash = string.indexOf(47, startOfFilename);
                    JarFsFile fsFile = nextSlash == string.length() - 1 ? new JarFsFile(string.substring(0, string.length() - 1)) : (nextSlash == -1 ? new JarFsFile(string) : null);
                    if (fsFile == null || !filter.accept(fsFile)) continue;
                    fsFiles.add(fsFile);
                }
                return fsFiles.toArray(new FsFile[fsFiles.size()]);
            }

            @Override
            public String[] listFileNames() {
                ArrayList<String> fileNames = new ArrayList<String>();
                for (FsFile fsFile : this.listFiles()) {
                    fileNames.add(fsFile.getName());
                }
                return fileNames.toArray(new String[fileNames.size()]);
            }

            @Override
            public FsFile getParent() {
                int index = this.path.lastIndexOf(47);
                String parent = index != -1 ? this.path.substring(0, index) : "";
                return new JarFsFile(parent);
            }

            @Override
            public String getName() {
                int index = this.path.lastIndexOf(47);
                return index != -1 ? this.path.substring(index + 1, this.path.length()) : this.path;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new BufferedInputStream(JarFs.this.jarFile.getInputStream((ZipEntry)JarFs.this.jarEntryMap.get(this.path)));
            }

            @Override
            public byte[] getBytes() throws IOException {
                return Util.readBytes((InputStream)JarFs.this.jarFile.getInputStream((ZipEntry)JarFs.this.jarEntryMap.get(this.path)));
            }

            @Override
            public FsFile join(String ... pathParts) {
                return new JarFsFile(this.path + "/" + Join.join((String)"/", Arrays.asList(pathParts)));
            }

            @Override
            public String getBaseName() {
                String name = this.getName();
                int dotIndex = name.indexOf(".");
                return dotIndex >= 0 ? name.substring(0, dotIndex) : name;
            }

            @Override
            public String getPath() {
                return "jar:file:" + this.getJarFileName() + "!/" + this.path;
            }

            @Override
            public long length() {
                return JarFs.this.jarFile.getEntry(this.path).getSize();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                JarFsFile jarFsFile = (JarFsFile)o;
                if (!this.getJarFileName().equals(jarFsFile.getJarFileName())) {
                    return false;
                }
                return this.path.equals(jarFsFile.path);
            }

            private String getJarFileName() {
                return JarFs.this.jarFile.getName();
            }

            @Override
            public int hashCode() {
                return this.getJarFileName().hashCode() * 31 + this.path.hashCode();
            }

            @Override
            public String toString() {
                return this.getPath();
            }
        }
    }
}

