package org.robolectric.res.android;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

// transliterated from https://android.googlesource.com/platform/frameworks/base/+/android-7.1.1_r13/libs/androidfw/LocaleDataTables.cpp
public class LocaleDataTables {

  // Auto-generated by frameworks/base/tools/localedata/extract_icu_data.py
  static final byte[][] SCRIPT_CODES = {
    /* 0  */ {'A', 'h', 'o', 'm'},
    /* 1  */ {'A', 'r', 'a', 'b'},
    /* 2  */ {'A', 'r', 'm', 'i'},
    /* 3  */ {'A', 'r', 'm', 'n'},
    /* 4  */ {'A', 'v', 's', 't'},
    /* 5  */ {'B', 'a', 'm', 'u'},
    /* 6  */ {'B', 'a', 's', 's'},
    /* 7  */ {'B', 'e', 'n', 'g'},
    /* 8  */ {'B', 'r', 'a', 'h'},
    /* 9  */ {'C', 'a', 'n', 's'},
    /* 10 */ {'C', 'a', 'r', 'i'},
    /* 11 */ {'C', 'h', 'a', 'm'},
    /* 12 */ {'C', 'h', 'e', 'r'},
    /* 13 */ {'C', 'o', 'p', 't'},
    /* 14 */ {'C', 'p', 'r', 't'},
    /* 15 */ {'C', 'y', 'r', 'l'},
    /* 16 */ {'D', 'e', 'v', 'a'},
    /* 17 */ {'E', 'g', 'y', 'p'},
    /* 18 */ {'E', 't', 'h', 'i'},
    /* 19 */ {'G', 'e', 'o', 'r'},
    /* 20 */ {'G', 'o', 't', 'h'},
    /* 21 */ {'G', 'r', 'e', 'k'},
    /* 22 */ {'G', 'u', 'j', 'r'},
    /* 23 */ {'G', 'u', 'r', 'u'},
    /* 24 */ {'H', 'a', 'n', 's'},
    /* 25 */ {'H', 'a', 'n', 't'},
    /* 26 */ {'H', 'a', 't', 'r'},
    /* 27 */ {'H', 'e', 'b', 'r'},
    /* 28 */ {'H', 'l', 'u', 'w'},
    /* 29 */ {'H', 'm', 'n', 'g'},
    /* 30 */ {'I', 't', 'a', 'l'},
    /* 31 */ {'J', 'p', 'a', 'n'},
    /* 32 */ {'K', 'a', 'l', 'i'},
    /* 33 */ {'K', 'a', 'n', 'a'},
    /* 34 */ {'K', 'h', 'a', 'r'},
    /* 35 */ {'K', 'h', 'm', 'r'},
    /* 36 */ {'K', 'n', 'd', 'a'},
    /* 37 */ {'K', 'o', 'r', 'e'},
    /* 38 */ {'K', 't', 'h', 'i'},
    /* 39 */ {'L', 'a', 'n', 'a'},
    /* 40 */ {'L', 'a', 'o', 'o'},
    /* 41 */ {'L', 'a', 't', 'n'},
    /* 42 */ {'L', 'e', 'p', 'c'},
    /* 43 */ {'L', 'i', 'n', 'a'},
    /* 44 */ {'L', 'i', 's', 'u'},
    /* 45 */ {'L', 'y', 'c', 'i'},
    /* 46 */ {'L', 'y', 'd', 'i'},
    /* 47 */ {'M', 'a', 'n', 'd'},
    /* 48 */ {'M', 'a', 'n', 'i'},
    /* 49 */ {'M', 'e', 'r', 'c'},
    /* 50 */ {'M', 'l', 'y', 'm'},
    /* 51 */ {'M', 'o', 'n', 'g'},
    /* 52 */ {'M', 'r', 'o', 'o'},
    /* 53 */ {'M', 'y', 'm', 'r'},
    /* 54 */ {'N', 'a', 'r', 'b'},
    /* 55 */ {'N', 'k', 'o', 'o'},
    /* 56 */ {'O', 'g', 'a', 'm'},
    /* 57 */ {'O', 'r', 'k', 'h'},
    /* 58 */ {'O', 'r', 'y', 'a'},
    /* 59 */ {'P', 'a', 'u', 'c'},
    /* 60 */ {'P', 'h', 'l', 'i'},
    /* 61 */ {'P', 'h', 'n', 'x'},
    /* 62 */ {'P', 'l', 'r', 'd'},
    /* 63 */ {'P', 'r', 't', 'i'},
    /* 64 */ {'R', 'u', 'n', 'r'},
    /* 65 */ {'S', 'a', 'm', 'r'},
    /* 66 */ {'S', 'a', 'r', 'b'},
    /* 67 */ {'S', 'a', 'u', 'r'},
    /* 68 */ {'S', 'g', 'n', 'w'},
    /* 69 */ {'S', 'i', 'n', 'h'},
    /* 70 */ {'S', 'o', 'r', 'a'},
    /* 71 */ {'S', 'y', 'r', 'c'},
    /* 72 */ {'T', 'a', 'l', 'e'},
    /* 73 */ {'T', 'a', 'l', 'u'},
    /* 74 */ {'T', 'a', 'm', 'l'},
    /* 75 */ {'T', 'a', 'v', 't'},
    /* 76 */ {'T', 'e', 'l', 'u'},
    /* 77 */ {'T', 'f', 'n', 'g'},
    /* 78 */ {'T', 'h', 'a', 'a'},
    /* 79 */ {'T', 'h', 'a', 'i'},
    /* 80 */ {'T', 'i', 'b', 't'},
    /* 81 */ {'U', 'g', 'a', 'r'},
    /* 82 */ {'V', 'a', 'i', 'i'},
    /* 83 */ {'X', 'p', 'e', 'o'},
    /* 84 */ {'X', 's', 'u', 'x'},
    /* 85 */ {'Y', 'i', 'i', 'i'},
    /* 86 */ {'~', '~', '~', 'A'},
    /* 87 */ {'~', '~', '~', 'B'},
  };

  static final Map<Integer, Byte> LIKELY_SCRIPTS;

  static {
    int[][] entries = {
        {0x61610000, 41}, // aa -> Latn
        {0x61620000, 15}, // ab -> Cyrl
        {0xC4200000, 41}, // abr -> Latn
        {0x90400000, 41}, // ace -> Latn
        {0x9C400000, 41}, // ach -> Latn
        {0x80600000, 41}, // ada -> Latn
        {0xE0600000, 15}, // ady -> Cyrl
        {0x61650000, 4}, // ae -> Avst
        {0x84800000, 1}, // aeb -> Arab
        {0x61660000, 41}, // af -> Latn
        {0xC0C00000, 41}, // agq -> Latn
        {0xB8E00000, 0}, // aho -> Ahom
        {0x616B0000, 41}, // ak -> Latn
        {0xA9400000, 84}, // akk -> Xsux
        {0xB5600000, 41}, // aln -> Latn
        {0xCD600000, 15}, // alt -> Cyrl
        {0x616D0000, 18}, // am -> Ethi
        {0xB9800000, 41}, // amo -> Latn
        {0xE5C00000, 41}, // aoz -> Latn
        {0x61720000, 1}, // ar -> Arab
        {0x61725842, 87}, // ar-XB -> ~~~B
        {0x8A200000, 2}, // arc -> Armi
        {0xB6200000, 41}, // arn -> Latn
        {0xBA200000, 41}, // aro -> Latn
        {0xC2200000, 1}, // arq -> Arab
        {0xE2200000, 1}, // ary -> Arab
        {0xE6200000, 1}, // arz -> Arab
        {0x61730000, 7}, // as -> Beng
        {0x82400000, 41}, // asa -> Latn
        {0x92400000, 68}, // ase -> Sgnw
        {0xCE400000, 41}, // ast -> Latn
        {0xA6600000, 41}, // atj -> Latn
        {0x61760000, 15}, // av -> Cyrl
        {0x82C00000, 16}, // awa -> Deva
        {0x61790000, 41}, // ay -> Latn
        {0x617A0000, 41}, // az -> Latn
        {0x617A4951, 1}, // az-IQ -> Arab
        {0x617A4952, 1}, // az-IR -> Arab
        {0x617A5255, 15}, // az-RU -> Cyrl
        {0x62610000, 15}, // ba -> Cyrl
        {0xAC010000, 1}, // bal -> Arab
        {0xB4010000, 41}, // ban -> Latn
        {0xBC010000, 16}, // bap -> Deva
        {0xC4010000, 41}, // bar -> Latn
        {0xC8010000, 41}, // bas -> Latn
        {0xDC010000, 5}, // bax -> Bamu
        {0x88210000, 41}, // bbc -> Latn
        {0xA4210000, 41}, // bbj -> Latn
        {0xA0410000, 41}, // bci -> Latn
        {0x62650000, 15}, // be -> Cyrl
        {0xA4810000, 1}, // bej -> Arab
        {0xB0810000, 41}, // bem -> Latn
        {0xD8810000, 41}, // bew -> Latn
        {0xE4810000, 41}, // bez -> Latn
        {0x8CA10000, 41}, // bfd -> Latn
        {0xC0A10000, 74}, // bfq -> Taml
        {0xCCA10000, 1}, // bft -> Arab
        {0xE0A10000, 16}, // bfy -> Deva
        {0x62670000, 15}, // bg -> Cyrl
        {0x88C10000, 16}, // bgc -> Deva
        {0xB4C10000, 1}, // bgn -> Arab
        {0xDCC10000, 21}, // bgx -> Grek
        {0x62680000, 38}, // bh -> Kthi
        {0x84E10000, 16}, // bhb -> Deva
        {0xA0E10000, 16}, // bhi -> Deva
        {0xA8E10000, 41}, // bhk -> Latn
        {0xB8E10000, 16}, // bho -> Deva
        {0x62690000, 41}, // bi -> Latn
        {0xA9010000, 41}, // bik -> Latn
        {0xB5010000, 41}, // bin -> Latn
        {0xA5210000, 16}, // bjj -> Deva
        {0xB5210000, 41}, // bjn -> Latn
        {0xB1410000, 41}, // bkm -> Latn
        {0xD1410000, 41}, // bku -> Latn
        {0xCD610000, 75}, // blt -> Tavt
        {0x626D0000, 41}, // bm -> Latn
        {0xC1810000, 41}, // bmq -> Latn
        {0x626E0000, 7}, // bn -> Beng
        {0x626F0000, 80}, // bo -> Tibt
        {0xE1E10000, 7}, // bpy -> Beng
        {0xA2010000, 1}, // bqi -> Arab
        {0xD6010000, 41}, // bqv -> Latn
        {0x62720000, 41}, // br -> Latn
        {0x82210000, 16}, // bra -> Deva
        {0x9E210000, 1}, // brh -> Arab
        {0xDE210000, 16}, // brx -> Deva
        {0x62730000, 41}, // bs -> Latn
        {0xC2410000, 6}, // bsq -> Bass
        {0xCA410000, 41}, // bss -> Latn
        {0xBA610000, 41}, // bto -> Latn
        {0xD6610000, 16}, // btv -> Deva
        {0x82810000, 15}, // bua -> Cyrl
        {0x8A810000, 41}, // buc -> Latn
        {0x9A810000, 41}, // bug -> Latn
        {0xB2810000, 41}, // bum -> Latn
        {0x86A10000, 41}, // bvb -> Latn
        {0xB7010000, 18}, // byn -> Ethi
        {0xD7010000, 41}, // byv -> Latn
        {0x93210000, 41}, // bze -> Latn
        {0x63610000, 41}, // ca -> Latn
        {0x9C420000, 41}, // cch -> Latn
        {0xBC420000, 7}, // ccp -> Beng
        {0x63650000, 15}, // ce -> Cyrl
        {0x84820000, 41}, // ceb -> Latn
        {0x98C20000, 41}, // cgg -> Latn
        {0x63680000, 41}, // ch -> Latn
        {0xA8E20000, 41}, // chk -> Latn
        {0xB0E20000, 15}, // chm -> Cyrl
        {0xB8E20000, 41}, // cho -> Latn
        {0xBCE20000, 41}, // chp -> Latn
        {0xC4E20000, 12}, // chr -> Cher
        {0x81220000, 1}, // cja -> Arab
        {0xB1220000, 11}, // cjm -> Cham
        {0x85420000, 1}, // ckb -> Arab
        {0x636F0000, 41}, // co -> Latn
        {0xBDC20000, 13}, // cop -> Copt
        {0xC9E20000, 41}, // cps -> Latn
        {0x63720000, 9}, // cr -> Cans
        {0xA6220000, 9}, // crj -> Cans
        {0xAA220000, 9}, // crk -> Cans
        {0xAE220000, 9}, // crl -> Cans
        {0xB2220000, 9}, // crm -> Cans
        {0xCA220000, 41}, // crs -> Latn
        {0x63730000, 41}, // cs -> Latn
        {0x86420000, 41}, // csb -> Latn
        {0xDA420000, 9}, // csw -> Cans
        {0x8E620000, 59}, // ctd -> Pauc
        {0x63750000, 15}, // cu -> Cyrl
        {0x63760000, 15}, // cv -> Cyrl
        {0x63790000, 41}, // cy -> Latn
        {0x64610000, 41}, // da -> Latn
        {0xA8030000, 41}, // dak -> Latn
        {0xC4030000, 15}, // dar -> Cyrl
        {0xD4030000, 41}, // dav -> Latn
        {0x88430000, 1}, // dcc -> Arab
        {0x64650000, 41}, // de -> Latn
        {0xB4830000, 41}, // den -> Latn
        {0xC4C30000, 41}, // dgr -> Latn
        {0x91230000, 41}, // dje -> Latn
        {0xA5A30000, 41}, // dnj -> Latn
        {0xA1C30000, 1}, // doi -> Arab
        {0x86430000, 41}, // dsb -> Latn
        {0xB2630000, 41}, // dtm -> Latn
        {0xBE630000, 41}, // dtp -> Latn
        {0x82830000, 41}, // dua -> Latn
        {0x64760000, 78}, // dv -> Thaa
        {0xBB030000, 41}, // dyo -> Latn
        {0xD3030000, 41}, // dyu -> Latn
        {0x647A0000, 80}, // dz -> Tibt
        {0xD0240000, 41}, // ebu -> Latn
        {0x65650000, 41}, // ee -> Latn
        {0xA0A40000, 41}, // efi -> Latn
        {0xACC40000, 41}, // egl -> Latn
        {0xE0C40000, 17}, // egy -> Egyp
        {0xE1440000, 32}, // eky -> Kali
        {0x656C0000, 21}, // el -> Grek
        {0x656E0000, 41}, // en -> Latn
        {0x656E5841, 86}, // en-XA -> ~~~A
        {0x656F0000, 41}, // eo -> Latn
        {0x65730000, 41}, // es -> Latn
        {0xD2440000, 41}, // esu -> Latn
        {0x65740000, 41}, // et -> Latn
        {0xCE640000, 30}, // ett -> Ital
        {0x65750000, 41}, // eu -> Latn
        {0xBAC40000, 41}, // ewo -> Latn
        {0xCEE40000, 41}, // ext -> Latn
        {0x66610000, 1}, // fa -> Arab
        {0xB4050000, 41}, // fan -> Latn
        {0x66660000, 41}, // ff -> Latn
        {0xB0A50000, 41}, // ffm -> Latn
        {0x66690000, 41}, // fi -> Latn
        {0x81050000, 1}, // fia -> Arab
        {0xAD050000, 41}, // fil -> Latn
        {0xCD050000, 41}, // fit -> Latn
        {0x666A0000, 41}, // fj -> Latn
        {0x666F0000, 41}, // fo -> Latn
        {0xB5C50000, 41}, // fon -> Latn
        {0x66720000, 41}, // fr -> Latn
        {0x8A250000, 41}, // frc -> Latn
        {0xBE250000, 41}, // frp -> Latn
        {0xC6250000, 41}, // frr -> Latn
        {0xCA250000, 41}, // frs -> Latn
        {0x8E850000, 41}, // fud -> Latn
        {0xC2850000, 41}, // fuq -> Latn
        {0xC6850000, 41}, // fur -> Latn
        {0xD6850000, 41}, // fuv -> Latn
        {0xC6A50000, 41}, // fvr -> Latn
        {0x66790000, 41}, // fy -> Latn
        {0x67610000, 41}, // ga -> Latn
        {0x80060000, 41}, // gaa -> Latn
        {0x98060000, 41}, // gag -> Latn
        {0xB4060000, 24}, // gan -> Hans
        {0xE0060000, 41}, // gay -> Latn
        {0xB0260000, 16}, // gbm -> Deva
        {0xE4260000, 1}, // gbz -> Arab
        {0xC4460000, 41}, // gcr -> Latn
        {0x67640000, 41}, // gd -> Latn
        {0xE4860000, 18}, // gez -> Ethi
        {0xB4C60000, 16}, // ggn -> Deva
        {0xAD060000, 41}, // gil -> Latn
        {0xA9260000, 1}, // gjk -> Arab
        {0xD1260000, 1}, // gju -> Arab
        {0x676C0000, 41}, // gl -> Latn
        {0xA9660000, 1}, // glk -> Arab
        {0x676E0000, 41}, // gn -> Latn
        {0xB1C60000, 16}, // gom -> Deva
        {0xB5C60000, 76}, // gon -> Telu
        {0xC5C60000, 41}, // gor -> Latn
        {0xC9C60000, 41}, // gos -> Latn
        {0xCDC60000, 20}, // got -> Goth
        {0x8A260000, 14}, // grc -> Cprt
        {0xCE260000, 7}, // grt -> Beng
        {0xDA460000, 41}, // gsw -> Latn
        {0x67750000, 22}, // gu -> Gujr
        {0x86860000, 41}, // gub -> Latn
        {0x8A860000, 41}, // guc -> Latn
        {0xC6860000, 41}, // gur -> Latn
        {0xE6860000, 41}, // guz -> Latn
        {0x67760000, 41}, // gv -> Latn
        {0xC6A60000, 16}, // gvr -> Deva
        {0xA2C60000, 41}, // gwi -> Latn
        {0x68610000, 41}, // ha -> Latn
        {0x6861434D, 1}, // ha-CM -> Arab
        {0x68615344, 1}, // ha-SD -> Arab
        {0xA8070000, 24}, // hak -> Hans
        {0xD8070000, 41}, // haw -> Latn
        {0xE4070000, 1}, // haz -> Arab
        {0x68650000, 27}, // he -> Hebr
        {0x68690000, 16}, // hi -> Deva
        {0x95070000, 41}, // hif -> Latn
        {0xAD070000, 41}, // hil -> Latn
        {0xD1670000, 28}, // hlu -> Hluw
        {0x8D870000, 62}, // hmd -> Plrd
        {0x8DA70000, 1}, // hnd -> Arab
        {0x91A70000, 16}, // hne -> Deva
        {0xA5A70000, 29}, // hnj -> Hmng
        {0xB5A70000, 41}, // hnn -> Latn
        {0xB9A70000, 1}, // hno -> Arab
        {0x686F0000, 41}, // ho -> Latn
        {0x89C70000, 16}, // hoc -> Deva
        {0xA5C70000, 16}, // hoj -> Deva
        {0x68720000, 41}, // hr -> Latn
        {0x86470000, 41}, // hsb -> Latn
        {0xB6470000, 24}, // hsn -> Hans
        {0x68740000, 41}, // ht -> Latn
        {0x68750000, 41}, // hu -> Latn
        {0x68790000, 3}, // hy -> Armn
        {0x687A0000, 41}, // hz -> Latn
        {0x69610000, 41}, // ia -> Latn
        {0x80280000, 41}, // iba -> Latn
        {0x84280000, 41}, // ibb -> Latn
        {0x69640000, 41}, // id -> Latn
        {0x69670000, 41}, // ig -> Latn
        {0x69690000, 85}, // ii -> Yiii
        {0x696B0000, 41}, // ik -> Latn
        {0xCD480000, 41}, // ikt -> Latn
        {0xB9680000, 41}, // ilo -> Latn
        {0x696E0000, 41}, // in -> Latn
        {0x9DA80000, 15}, // inh -> Cyrl
        {0x69730000, 41}, // is -> Latn
        {0x69740000, 41}, // it -> Latn
        {0x69750000, 9}, // iu -> Cans
        {0x69770000, 27}, // iw -> Hebr
        {0x9F280000, 41}, // izh -> Latn
        {0x6A610000, 31}, // ja -> Jpan
        {0xB0090000, 41}, // jam -> Latn
        {0xB8C90000, 41}, // jgo -> Latn
        {0x6A690000, 27}, // ji -> Hebr
        {0x89890000, 41}, // jmc -> Latn
        {0xAD890000, 16}, // jml -> Deva
        {0xCE890000, 41}, // jut -> Latn
        {0x6A760000, 41}, // jv -> Latn
        {0x6A770000, 41}, // jw -> Latn
        {0x6B610000, 19}, // ka -> Geor
        {0x800A0000, 15}, // kaa -> Cyrl
        {0x840A0000, 41}, // kab -> Latn
        {0x880A0000, 41}, // kac -> Latn
        {0xA40A0000, 41}, // kaj -> Latn
        {0xB00A0000, 41}, // kam -> Latn
        {0xB80A0000, 41}, // kao -> Latn
        {0x8C2A0000, 15}, // kbd -> Cyrl
        {0x984A0000, 41}, // kcg -> Latn
        {0xA84A0000, 41}, // kck -> Latn
        {0x906A0000, 41}, // kde -> Latn
        {0xCC6A0000, 79}, // kdt -> Thai
        {0x808A0000, 41}, // kea -> Latn
        {0xB48A0000, 41}, // ken -> Latn
        {0xB8AA0000, 41}, // kfo -> Latn
        {0xC4AA0000, 16}, // kfr -> Deva
        {0xE0AA0000, 16}, // kfy -> Deva
        {0x6B670000, 41}, // kg -> Latn
        {0x90CA0000, 41}, // kge -> Latn
        {0xBCCA0000, 41}, // kgp -> Latn
        {0x80EA0000, 41}, // kha -> Latn
        {0x84EA0000, 73}, // khb -> Talu
        {0xB4EA0000, 16}, // khn -> Deva
        {0xC0EA0000, 41}, // khq -> Latn
        {0xCCEA0000, 53}, // kht -> Mymr
        {0xD8EA0000, 1}, // khw -> Arab
        {0x6B690000, 41}, // ki -> Latn
        {0xD10A0000, 41}, // kiu -> Latn
        {0x6B6A0000, 41}, // kj -> Latn
        {0x992A0000, 40}, // kjg -> Laoo
        {0x6B6B0000, 15}, // kk -> Cyrl
        {0x6B6B4146, 1}, // kk-AF -> Arab
        {0x6B6B434E, 1}, // kk-CN -> Arab
        {0x6B6B4952, 1}, // kk-IR -> Arab
        {0x6B6B4D4E, 1}, // kk-MN -> Arab
        {0xA54A0000, 41}, // kkj -> Latn
        {0x6B6C0000, 41}, // kl -> Latn
        {0xB56A0000, 41}, // kln -> Latn
        {0x6B6D0000, 35}, // km -> Khmr
        {0x858A0000, 41}, // kmb -> Latn
        {0x6B6E0000, 36}, // kn -> Knda
        {0x6B6F0000, 37}, // ko -> Kore
        {0xA1CA0000, 15}, // koi -> Cyrl
        {0xA9CA0000, 16}, // kok -> Deva
        {0xC9CA0000, 41}, // kos -> Latn
        {0x91EA0000, 41}, // kpe -> Latn
        {0x8A2A0000, 15}, // krc -> Cyrl
        {0xA22A0000, 41}, // kri -> Latn
        {0xA62A0000, 41}, // krj -> Latn
        {0xAE2A0000, 41}, // krl -> Latn
        {0xD22A0000, 16}, // kru -> Deva
        {0x6B730000, 1}, // ks -> Arab
        {0x864A0000, 41}, // ksb -> Latn
        {0x964A0000, 41}, // ksf -> Latn
        {0x9E4A0000, 41}, // ksh -> Latn
        {0x6B750000, 41}, // ku -> Latn
        {0x6B754952, 1}, // ku-IR -> Arab
        {0x6B754C42, 1}, // ku-LB -> Arab
        {0xB28A0000, 15}, // kum -> Cyrl
        {0x6B760000, 15}, // kv -> Cyrl
        {0xC6AA0000, 41}, // kvr -> Latn
        {0xDEAA0000, 1}, // kvx -> Arab
        {0x6B770000, 41}, // kw -> Latn
        {0xB2EA0000, 79}, // kxm -> Thai
        {0xBEEA0000, 1}, // kxp -> Arab
        {0x6B790000, 15}, // ky -> Cyrl
        {0x6B79434E, 1}, // ky-CN -> Arab
        {0x6B795452, 41}, // ky-TR -> Latn
        {0x6C610000, 41}, // la -> Latn
        {0x840B0000, 43}, // lab -> Lina
        {0x8C0B0000, 27}, // lad -> Hebr
        {0x980B0000, 41}, // lag -> Latn
        {0x9C0B0000, 1}, // lah -> Arab
        {0xA40B0000, 41}, // laj -> Latn
        {0x6C620000, 41}, // lb -> Latn
        {0x902B0000, 15}, // lbe -> Cyrl
        {0xD82B0000, 41}, // lbw -> Latn
        {0xBC4B0000, 79}, // lcp -> Thai
        {0xBC8B0000, 42}, // lep -> Lepc
        {0xE48B0000, 15}, // lez -> Cyrl
        {0x6C670000, 41}, // lg -> Latn
        {0x6C690000, 41}, // li -> Latn
        {0x950B0000, 16}, // lif -> Deva
        {0xA50B0000, 41}, // lij -> Latn
        {0xC90B0000, 44}, // lis -> Lisu
        {0xBD2B0000, 41}, // ljp -> Latn
        {0xA14B0000, 1}, // lki -> Arab
        {0xCD4B0000, 41}, // lkt -> Latn
        {0xB58B0000, 76}, // lmn -> Telu
        {0xB98B0000, 41}, // lmo -> Latn
        {0x6C6E0000, 41}, // ln -> Latn
        {0x6C6F0000, 40}, // lo -> Laoo
        {0xADCB0000, 41}, // lol -> Latn
        {0xE5CB0000, 41}, // loz -> Latn
        {0x8A2B0000, 1}, // lrc -> Arab
        {0x6C740000, 41}, // lt -> Latn
        {0x9A6B0000, 41}, // ltg -> Latn
        {0x6C750000, 41}, // lu -> Latn
        {0x828B0000, 41}, // lua -> Latn
        {0xBA8B0000, 41}, // luo -> Latn
        {0xE28B0000, 41}, // luy -> Latn
        {0xE68B0000, 1}, // luz -> Arab
        {0x6C760000, 41}, // lv -> Latn
        {0xAECB0000, 79}, // lwl -> Thai
        {0x9F2B0000, 24}, // lzh -> Hans
        {0xE72B0000, 41}, // lzz -> Latn
        {0x8C0C0000, 41}, // mad -> Latn
        {0x940C0000, 41}, // maf -> Latn
        {0x980C0000, 16}, // mag -> Deva
        {0xA00C0000, 16}, // mai -> Deva
        {0xA80C0000, 41}, // mak -> Latn
        {0xB40C0000, 41}, // man -> Latn
        {0xB40C474E, 55}, // man-GN -> Nkoo
        {0xC80C0000, 41}, // mas -> Latn
        {0xE40C0000, 41}, // maz -> Latn
        {0x946C0000, 15}, // mdf -> Cyrl
        {0x9C6C0000, 41}, // mdh -> Latn
        {0xC46C0000, 41}, // mdr -> Latn
        {0xB48C0000, 41}, // men -> Latn
        {0xC48C0000, 41}, // mer -> Latn
        {0x80AC0000, 1}, // mfa -> Arab
        {0x90AC0000, 41}, // mfe -> Latn
        {0x6D670000, 41}, // mg -> Latn
        {0x9CCC0000, 41}, // mgh -> Latn
        {0xB8CC0000, 41}, // mgo -> Latn
        {0xBCCC0000, 16}, // mgp -> Deva
        {0xE0CC0000, 41}, // mgy -> Latn
        {0x6D680000, 41}, // mh -> Latn
        {0x6D690000, 41}, // mi -> Latn
        {0xB50C0000, 41}, // min -> Latn
        {0xC90C0000, 26}, // mis -> Hatr
        {0x6D6B0000, 15}, // mk -> Cyrl
        {0x6D6C0000, 50}, // ml -> Mlym
        {0xC96C0000, 41}, // mls -> Latn
        {0x6D6E0000, 15}, // mn -> Cyrl
        {0x6D6E434E, 51}, // mn-CN -> Mong
        {0xA1AC0000, 7}, // mni -> Beng
        {0xD9AC0000, 53}, // mnw -> Mymr
        {0x91CC0000, 41}, // moe -> Latn
        {0x9DCC0000, 41}, // moh -> Latn
        {0xC9CC0000, 41}, // mos -> Latn
        {0x6D720000, 16}, // mr -> Deva
        {0x8E2C0000, 16}, // mrd -> Deva
        {0xA62C0000, 15}, // mrj -> Cyrl
        {0xD22C0000, 52}, // mru -> Mroo
        {0x6D730000, 41}, // ms -> Latn
        {0x6D734343, 1}, // ms-CC -> Arab
        {0x6D734944, 1}, // ms-ID -> Arab
        {0x6D740000, 41}, // mt -> Latn
        {0xC66C0000, 16}, // mtr -> Deva
        {0x828C0000, 41}, // mua -> Latn
        {0xCA8C0000, 41}, // mus -> Latn
        {0xE2AC0000, 1}, // mvy -> Arab
        {0xAACC0000, 41}, // mwk -> Latn
        {0xC6CC0000, 16}, // mwr -> Deva
        {0xD6CC0000, 41}, // mwv -> Latn
        {0x8AEC0000, 41}, // mxc -> Latn
        {0x6D790000, 53}, // my -> Mymr
        {0xD70C0000, 15}, // myv -> Cyrl
        {0xDF0C0000, 41}, // myx -> Latn
        {0xE70C0000, 47}, // myz -> Mand
        {0xB72C0000, 1}, // mzn -> Arab
        {0x6E610000, 41}, // na -> Latn
        {0xB40D0000, 24}, // nan -> Hans
        {0xBC0D0000, 41}, // nap -> Latn
        {0xC00D0000, 41}, // naq -> Latn
        {0x6E620000, 41}, // nb -> Latn
        {0x9C4D0000, 41}, // nch -> Latn
        {0x6E640000, 41}, // nd -> Latn
        {0x886D0000, 41}, // ndc -> Latn
        {0xC86D0000, 41}, // nds -> Latn
        {0x6E650000, 16}, // ne -> Deva
        {0xD88D0000, 16}, // new -> Deva
        {0x6E670000, 41}, // ng -> Latn
        {0xACCD0000, 41}, // ngl -> Latn
        {0x90ED0000, 41}, // nhe -> Latn
        {0xD8ED0000, 41}, // nhw -> Latn
        {0xA50D0000, 41}, // nij -> Latn
        {0xD10D0000, 41}, // niu -> Latn
        {0xB92D0000, 41}, // njo -> Latn
        {0x6E6C0000, 41}, // nl -> Latn
        {0x998D0000, 41}, // nmg -> Latn
        {0x6E6E0000, 41}, // nn -> Latn
        {0x9DAD0000, 41}, // nnh -> Latn
        {0x6E6F0000, 41}, // no -> Latn
        {0x8DCD0000, 39}, // nod -> Lana
        {0x91CD0000, 16}, // noe -> Deva
        {0xB5CD0000, 64}, // non -> Runr
        {0xBA0D0000, 55}, // nqo -> Nkoo
        {0x6E720000, 41}, // nr -> Latn
        {0xAA4D0000, 9}, // nsk -> Cans
        {0xBA4D0000, 41}, // nso -> Latn
        {0xCA8D0000, 41}, // nus -> Latn
        {0x6E760000, 41}, // nv -> Latn
        {0xC2ED0000, 41}, // nxq -> Latn
        {0x6E790000, 41}, // ny -> Latn
        {0xB30D0000, 41}, // nym -> Latn
        {0xB70D0000, 41}, // nyn -> Latn
        {0xA32D0000, 41}, // nzi -> Latn
        {0x6F630000, 41}, // oc -> Latn
        {0x6F6D0000, 41}, // om -> Latn
        {0x6F720000, 58}, // or -> Orya
        {0x6F730000, 15}, // os -> Cyrl
        {0xAA6E0000, 57}, // otk -> Orkh
        {0x70610000, 23}, // pa -> Guru
        {0x7061504B, 1}, // pa-PK -> Arab
        {0x980F0000, 41}, // pag -> Latn
        {0xAC0F0000, 60}, // pal -> Phli
        {0xB00F0000, 41}, // pam -> Latn
        {0xBC0F0000, 41}, // pap -> Latn
        {0xD00F0000, 41}, // pau -> Latn
        {0x8C4F0000, 41}, // pcd -> Latn
        {0xB04F0000, 41}, // pcm -> Latn
        {0x886F0000, 41}, // pdc -> Latn
        {0xCC6F0000, 41}, // pdt -> Latn
        {0xB88F0000, 83}, // peo -> Xpeo
        {0xACAF0000, 41}, // pfl -> Latn
        {0xB4EF0000, 61}, // phn -> Phnx
        {0x814F0000, 8}, // pka -> Brah
        {0xB94F0000, 41}, // pko -> Latn
        {0x706C0000, 41}, // pl -> Latn
        {0xC98F0000, 41}, // pms -> Latn
        {0xCDAF0000, 21}, // pnt -> Grek
        {0xB5CF0000, 41}, // pon -> Latn
        {0x822F0000, 34}, // pra -> Khar
        {0x8E2F0000, 1}, // prd -> Arab
        {0x9A2F0000, 41}, // prg -> Latn
        {0x70730000, 1}, // ps -> Arab
        {0x70740000, 41}, // pt -> Latn
        {0xD28F0000, 41}, // puu -> Latn
        {0x71750000, 41}, // qu -> Latn
        {0x8A900000, 41}, // quc -> Latn
        {0x9A900000, 41}, // qug -> Latn
        {0xA4110000, 16}, // raj -> Deva
        {0x94510000, 41}, // rcf -> Latn
        {0xA4910000, 41}, // rej -> Latn
        {0xB4D10000, 41}, // rgn -> Latn
        {0x81110000, 41}, // ria -> Latn
        {0x95110000, 77}, // rif -> Tfng
        {0x95114E4C, 41}, // rif-NL -> Latn
        {0xC9310000, 16}, // rjs -> Deva
        {0xCD510000, 7}, // rkt -> Beng
        {0x726D0000, 41}, // rm -> Latn
        {0x95910000, 41}, // rmf -> Latn
        {0xB9910000, 41}, // rmo -> Latn
        {0xCD910000, 1}, // rmt -> Arab
        {0xD1910000, 41}, // rmu -> Latn
        {0x726E0000, 41}, // rn -> Latn
        {0x99B10000, 41}, // rng -> Latn
        {0x726F0000, 41}, // ro -> Latn
        {0x85D10000, 41}, // rob -> Latn
        {0x95D10000, 41}, // rof -> Latn
        {0xB2710000, 41}, // rtm -> Latn
        {0x72750000, 15}, // ru -> Cyrl
        {0x92910000, 15}, // rue -> Cyrl
        {0x9A910000, 41}, // rug -> Latn
        {0x72770000, 41}, // rw -> Latn
        {0xAAD10000, 41}, // rwk -> Latn
        {0xD3110000, 33}, // ryu -> Kana
        {0x73610000, 16}, // sa -> Deva
        {0x94120000, 41}, // saf -> Latn
        {0x9C120000, 15}, // sah -> Cyrl
        {0xC0120000, 41}, // saq -> Latn
        {0xC8120000, 41}, // sas -> Latn
        {0xCC120000, 41}, // sat -> Latn
        {0xE4120000, 67}, // saz -> Saur
        {0xBC320000, 41}, // sbp -> Latn
        {0x73630000, 41}, // sc -> Latn
        {0xA8520000, 16}, // sck -> Deva
        {0xB4520000, 41}, // scn -> Latn
        {0xB8520000, 41}, // sco -> Latn
        {0xC8520000, 41}, // scs -> Latn
        {0x73640000, 1}, // sd -> Arab
        {0x88720000, 41}, // sdc -> Latn
        {0x9C720000, 1}, // sdh -> Arab
        {0x73650000, 41}, // se -> Latn
        {0x94920000, 41}, // sef -> Latn
        {0x9C920000, 41}, // seh -> Latn
        {0xA0920000, 41}, // sei -> Latn
        {0xC8920000, 41}, // ses -> Latn
        {0x73670000, 41}, // sg -> Latn
        {0x80D20000, 56}, // sga -> Ogam
        {0xC8D20000, 41}, // sgs -> Latn
        {0x73680000, 41}, // sh -> Latn
        {0xA0F20000, 77}, // shi -> Tfng
        {0xB4F20000, 53}, // shn -> Mymr
        {0x73690000, 69}, // si -> Sinh
        {0x8D120000, 41}, // sid -> Latn
        {0x736B0000, 41}, // sk -> Latn
        {0xC5520000, 1}, // skr -> Arab
        {0x736C0000, 41}, // sl -> Latn
        {0xA1720000, 41}, // sli -> Latn
        {0xE1720000, 41}, // sly -> Latn
        {0x736D0000, 41}, // sm -> Latn
        {0x81920000, 41}, // sma -> Latn
        {0xA5920000, 41}, // smj -> Latn
        {0xB5920000, 41}, // smn -> Latn
        {0xBD920000, 65}, // smp -> Samr
        {0xC9920000, 41}, // sms -> Latn
        {0x736E0000, 41}, // sn -> Latn
        {0xA9B20000, 41}, // snk -> Latn
        {0x736F0000, 41}, // so -> Latn
        {0xD1D20000, 79}, // sou -> Thai
        {0x73710000, 41}, // sq -> Latn
        {0x73720000, 15}, // sr -> Cyrl
        {0x73724D45, 41}, // sr-ME -> Latn
        {0x7372524F, 41}, // sr-RO -> Latn
        {0x73725255, 41}, // sr-RU -> Latn
        {0x73725452, 41}, // sr-TR -> Latn
        {0x86320000, 70}, // srb -> Sora
        {0xB6320000, 41}, // srn -> Latn
        {0xC6320000, 41}, // srr -> Latn
        {0xDE320000, 16}, // srx -> Deva
        {0x73730000, 41}, // ss -> Latn
        {0xE2520000, 41}, // ssy -> Latn
        {0x73740000, 41}, // st -> Latn
        {0xC2720000, 41}, // stq -> Latn
        {0x73750000, 41}, // su -> Latn
        {0xAA920000, 41}, // suk -> Latn
        {0xCA920000, 41}, // sus -> Latn
        {0x73760000, 41}, // sv -> Latn
        {0x73770000, 41}, // sw -> Latn
        {0x86D20000, 1}, // swb -> Arab
        {0x8AD20000, 41}, // swc -> Latn
        {0x9AD20000, 41}, // swg -> Latn
        {0xD6D20000, 16}, // swv -> Deva
        {0xB6F20000, 41}, // sxn -> Latn
        {0xAF120000, 7}, // syl -> Beng
        {0xC7120000, 71}, // syr -> Syrc
        {0xAF320000, 41}, // szl -> Latn
        {0x74610000, 74}, // ta -> Taml
        {0xA4130000, 16}, // taj -> Deva
        {0xD8330000, 41}, // tbw -> Latn
        {0xE0530000, 36}, // tcy -> Knda
        {0x8C730000, 72}, // tdd -> Tale
        {0x98730000, 16}, // tdg -> Deva
        {0x9C730000, 16}, // tdh -> Deva
        {0x74650000, 76}, // te -> Telu
        {0xB0930000, 41}, // tem -> Latn
        {0xB8930000, 41}, // teo -> Latn
        {0xCC930000, 41}, // tet -> Latn
        {0x74670000, 15}, // tg -> Cyrl
        {0x7467504B, 1}, // tg-PK -> Arab
        {0x74680000, 79}, // th -> Thai
        {0xACF30000, 16}, // thl -> Deva
        {0xC0F30000, 16}, // thq -> Deva
        {0xC4F30000, 16}, // thr -> Deva
        {0x74690000, 18}, // ti -> Ethi
        {0x99130000, 18}, // tig -> Ethi
        {0xD5130000, 41}, // tiv -> Latn
        {0x746B0000, 41}, // tk -> Latn
        {0xAD530000, 41}, // tkl -> Latn
        {0xC5530000, 41}, // tkr -> Latn
        {0xCD530000, 16}, // tkt -> Deva
        {0x746C0000, 41}, // tl -> Latn
        {0xE1730000, 41}, // tly -> Latn
        {0x9D930000, 41}, // tmh -> Latn
        {0x746E0000, 41}, // tn -> Latn
        {0x746F0000, 41}, // to -> Latn
        {0x99D30000, 41}, // tog -> Latn
        {0xA1F30000, 41}, // tpi -> Latn
        {0x74720000, 41}, // tr -> Latn
        {0xD2330000, 41}, // tru -> Latn
        {0xD6330000, 41}, // trv -> Latn
        {0x74730000, 41}, // ts -> Latn
        {0x8E530000, 21}, // tsd -> Grek
        {0x96530000, 16}, // tsf -> Deva
        {0x9A530000, 41}, // tsg -> Latn
        {0xA6530000, 80}, // tsj -> Tibt
        {0x74740000, 15}, // tt -> Cyrl
        {0xA6730000, 41}, // ttj -> Latn
        {0xCA730000, 79}, // tts -> Thai
        {0xCE730000, 41}, // ttt -> Latn
        {0xB2930000, 41}, // tum -> Latn
        {0xAEB30000, 41}, // tvl -> Latn
        {0xC2D30000, 41}, // twq -> Latn
        {0x74790000, 41}, // ty -> Latn
        {0xD7130000, 15}, // tyv -> Cyrl
        {0xB3330000, 41}, // tzm -> Latn
        {0xB0740000, 15}, // udm -> Cyrl
        {0x75670000, 1}, // ug -> Arab
        {0x75674B5A, 15}, // ug-KZ -> Cyrl
        {0x75674D4E, 15}, // ug-MN -> Cyrl
        {0x80D40000, 81}, // uga -> Ugar
        {0x756B0000, 15}, // uk -> Cyrl
        {0xA1740000, 41}, // uli -> Latn
        {0x85940000, 41}, // umb -> Latn
        {0xC5B40000, 7}, // unr -> Beng
        {0xC5B44E50, 16}, // unr-NP -> Deva
        {0xDDB40000, 7}, // unx -> Beng
        {0x75720000, 1}, // ur -> Arab
        {0x757A0000, 41}, // uz -> Latn
        {0x757A4146, 1}, // uz-AF -> Arab
        {0x757A434E, 15}, // uz-CN -> Cyrl
        {0xA0150000, 82}, // vai -> Vaii
        {0x76650000, 41}, // ve -> Latn
        {0x88950000, 41}, // vec -> Latn
        {0xBC950000, 41}, // vep -> Latn
        {0x76690000, 41}, // vi -> Latn
        {0x89150000, 41}, // vic -> Latn
        {0xC9750000, 41}, // vls -> Latn
        {0x95950000, 41}, // vmf -> Latn
        {0xD9950000, 41}, // vmw -> Latn
        {0x766F0000, 41}, // vo -> Latn
        {0xCDD50000, 41}, // vot -> Latn
        {0xBA350000, 41}, // vro -> Latn
        {0xB6950000, 41}, // vun -> Latn
        {0x77610000, 41}, // wa -> Latn
        {0x90160000, 41}, // wae -> Latn
        {0xAC160000, 18}, // wal -> Ethi
        {0xC4160000, 41}, // war -> Latn
        {0xBC360000, 41}, // wbp -> Latn
        {0xC0360000, 76}, // wbq -> Telu
        {0xC4360000, 16}, // wbr -> Deva
        {0xC9760000, 41}, // wls -> Latn
        {0xA1B60000, 1}, // wni -> Arab
        {0x776F0000, 41}, // wo -> Latn
        {0xB2760000, 16}, // wtm -> Deva
        {0xD2960000, 24}, // wuu -> Hans
        {0xD4170000, 41}, // xav -> Latn
        {0xC4570000, 10}, // xcr -> Cari
        {0x78680000, 41}, // xh -> Latn
        {0x89770000, 45}, // xlc -> Lyci
        {0x8D770000, 46}, // xld -> Lydi
        {0x95970000, 19}, // xmf -> Geor
        {0xB5970000, 48}, // xmn -> Mani
        {0xC5970000, 49}, // xmr -> Merc
        {0x81B70000, 54}, // xna -> Narb
        {0xC5B70000, 16}, // xnr -> Deva
        {0x99D70000, 41}, // xog -> Latn
        {0xC5F70000, 63}, // xpr -> Prti
        {0x82570000, 66}, // xsa -> Sarb
        {0xC6570000, 16}, // xsr -> Deva
        {0xB8180000, 41}, // yao -> Latn
        {0xBC180000, 41}, // yap -> Latn
        {0xD4180000, 41}, // yav -> Latn
        {0x84380000, 41}, // ybb -> Latn
        {0x79690000, 27}, // yi -> Hebr
        {0x796F0000, 41}, // yo -> Latn
        {0xAE380000, 41}, // yrl -> Latn
        {0x82980000, 41}, // yua -> Latn
        {0x7A610000, 41}, // za -> Latn
        {0x98190000, 41}, // zag -> Latn
        {0xA4790000, 1}, // zdj -> Arab
        {0x80990000, 41}, // zea -> Latn
        {0x9CD90000, 77}, // zgh -> Tfng
        {0x7A680000, 24}, // zh -> Hans
        {0x7A684155, 25}, // zh-AU -> Hant
        {0x7A68424E, 25}, // zh-BN -> Hant
        {0x7A684742, 25}, // zh-GB -> Hant
        {0x7A684746, 25}, // zh-GF -> Hant
        {0x7A68484B, 25}, // zh-HK -> Hant
        {0x7A684944, 25}, // zh-ID -> Hant
        {0x7A684D4F, 25}, // zh-MO -> Hant
        {0x7A684D59, 25}, // zh-MY -> Hant
        {0x7A685041, 25}, // zh-PA -> Hant
        {0x7A685046, 25}, // zh-PF -> Hant
        {0x7A685048, 25}, // zh-PH -> Hant
        {0x7A685352, 25}, // zh-SR -> Hant
        {0x7A685448, 25}, // zh-TH -> Hant
        {0x7A685457, 25}, // zh-TW -> Hant
        {0x7A685553, 25}, // zh-US -> Hant
        {0x7A68564E, 25}, // zh-VN -> Hant
        {0xA1990000, 41}, // zmi -> Latn
        {0x7A750000, 41}, // zu -> Latn
        {0x83390000, 41}, // zza -> Latn
    };

    Map<Integer, Byte> buildMap = new HashMap<>();
    for (int[] entry : entries) {
      buildMap.put(entry[0], (byte) entry[1]);
    }
    LIKELY_SCRIPTS = Collections.unmodifiableMap(buildMap);
  }

  static final Set<Long> REPRESENTATIVE_LOCALES;

  static {
    long[] entries = {
        0x616145544C61746EL, // aa_Latn_ET
        0x616247454379726CL, // ab_Cyrl_GE
        0xC42047484C61746EL, // abr_Latn_GH
        0x904049444C61746EL, // ace_Latn_ID
        0x9C4055474C61746EL, // ach_Latn_UG
        0x806047484C61746EL, // ada_Latn_GH
        0xE06052554379726CL, // ady_Cyrl_RU
        0x6165495241767374L, // ae_Avst_IR
        0x8480544E41726162L, // aeb_Arab_TN
        0x61665A414C61746EL, // af_Latn_ZA
        0xC0C0434D4C61746EL, // agq_Latn_CM
        0xB8E0494E41686F6DL, // aho_Ahom_IN
        0x616B47484C61746EL, // ak_Latn_GH
        0xA940495158737578L, // akk_Xsux_IQ
        0xB560584B4C61746EL, // aln_Latn_XK
        0xCD6052554379726CL, // alt_Cyrl_RU
        0x616D455445746869L, // am_Ethi_ET
        0xB9804E474C61746EL, // amo_Latn_NG
        0xE5C049444C61746EL, // aoz_Latn_ID
        0x6172454741726162L, // ar_Arab_EG
        0x8A20495241726D69L, // arc_Armi_IR
        0x8A204A4F4E626174L, // arc_Nbat_JO
        0x8A20535950616C6DL, // arc_Palm_SY
        0xB620434C4C61746EL, // arn_Latn_CL
        0xBA20424F4C61746EL, // aro_Latn_BO
        0xC220445A41726162L, // arq_Arab_DZ
        0xE2204D4141726162L, // ary_Arab_MA
        0xE620454741726162L, // arz_Arab_EG
        0x6173494E42656E67L, // as_Beng_IN
        0x8240545A4C61746EL, // asa_Latn_TZ
        0x9240555353676E77L, // ase_Sgnw_US
        0xCE4045534C61746EL, // ast_Latn_ES
        0xA66043414C61746EL, // atj_Latn_CA
        0x617652554379726CL, // av_Cyrl_RU
        0x82C0494E44657661L, // awa_Deva_IN
        0x6179424F4C61746EL, // ay_Latn_BO
        0x617A495241726162L, // az_Arab_IR
        0x617A415A4C61746EL, // az_Latn_AZ
        0x626152554379726CL, // ba_Cyrl_RU
        0xAC01504B41726162L, // bal_Arab_PK
        0xB40149444C61746EL, // ban_Latn_ID
        0xBC014E5044657661L, // bap_Deva_NP
        0xC40141544C61746EL, // bar_Latn_AT
        0xC801434D4C61746EL, // bas_Latn_CM
        0xDC01434D42616D75L, // bax_Bamu_CM
        0x882149444C61746EL, // bbc_Latn_ID
        0xA421434D4C61746EL, // bbj_Latn_CM
        0xA04143494C61746EL, // bci_Latn_CI
        0x626542594379726CL, // be_Cyrl_BY
        0xA481534441726162L, // bej_Arab_SD
        0xB0815A4D4C61746EL, // bem_Latn_ZM
        0xD88149444C61746EL, // bew_Latn_ID
        0xE481545A4C61746EL, // bez_Latn_TZ
        0x8CA1434D4C61746EL, // bfd_Latn_CM
        0xC0A1494E54616D6CL, // bfq_Taml_IN
        0xCCA1504B41726162L, // bft_Arab_PK
        0xE0A1494E44657661L, // bfy_Deva_IN
        0x626742474379726CL, // bg_Cyrl_BG
        0x88C1494E44657661L, // bgc_Deva_IN
        0xB4C1504B41726162L, // bgn_Arab_PK
        0xDCC154524772656BL, // bgx_Grek_TR
        0x6268494E4B746869L, // bh_Kthi_IN
        0x84E1494E44657661L, // bhb_Deva_IN
        0xA0E1494E44657661L, // bhi_Deva_IN
        0xA8E150484C61746EL, // bhk_Latn_PH
        0xB8E1494E44657661L, // bho_Deva_IN
        0x626956554C61746EL, // bi_Latn_VU
        0xA90150484C61746EL, // bik_Latn_PH
        0xB5014E474C61746EL, // bin_Latn_NG
        0xA521494E44657661L, // bjj_Deva_IN
        0xB52149444C61746EL, // bjn_Latn_ID
        0xB141434D4C61746EL, // bkm_Latn_CM
        0xD14150484C61746EL, // bku_Latn_PH
        0xCD61564E54617674L, // blt_Tavt_VN
        0x626D4D4C4C61746EL, // bm_Latn_ML
        0xC1814D4C4C61746EL, // bmq_Latn_ML
        0x626E424442656E67L, // bn_Beng_BD
        0x626F434E54696274L, // bo_Tibt_CN
        0xE1E1494E42656E67L, // bpy_Beng_IN
        0xA201495241726162L, // bqi_Arab_IR
        0xD60143494C61746EL, // bqv_Latn_CI
        0x627246524C61746EL, // br_Latn_FR
        0x8221494E44657661L, // bra_Deva_IN
        0x9E21504B41726162L, // brh_Arab_PK
        0xDE21494E44657661L, // brx_Deva_IN
        0x627342414C61746EL, // bs_Latn_BA
        0xC2414C5242617373L, // bsq_Bass_LR
        0xCA41434D4C61746EL, // bss_Latn_CM
        0xBA6150484C61746EL, // bto_Latn_PH
        0xD661504B44657661L, // btv_Deva_PK
        0x828152554379726CL, // bua_Cyrl_RU
        0x8A8159544C61746EL, // buc_Latn_YT
        0x9A8149444C61746EL, // bug_Latn_ID
        0xB281434D4C61746EL, // bum_Latn_CM
        0x86A147514C61746EL, // bvb_Latn_GQ
        0xB701455245746869L, // byn_Ethi_ER
        0xD701434D4C61746EL, // byv_Latn_CM
        0x93214D4C4C61746EL, // bze_Latn_ML
        0x636145534C61746EL, // ca_Latn_ES
        0x9C424E474C61746EL, // cch_Latn_NG
        0xBC42494E42656E67L, // ccp_Beng_IN
        0xBC42424443616B6DL, // ccp_Cakm_BD
        0x636552554379726CL, // ce_Cyrl_RU
        0x848250484C61746EL, // ceb_Latn_PH
        0x98C255474C61746EL, // cgg_Latn_UG
        0x636847554C61746EL, // ch_Latn_GU
        0xA8E2464D4C61746EL, // chk_Latn_FM
        0xB0E252554379726CL, // chm_Cyrl_RU
        0xB8E255534C61746EL, // cho_Latn_US
        0xBCE243414C61746EL, // chp_Latn_CA
        0xC4E2555343686572L, // chr_Cher_US
        0x81224B4841726162L, // cja_Arab_KH
        0xB122564E4368616DL, // cjm_Cham_VN
        0x8542495141726162L, // ckb_Arab_IQ
        0x636F46524C61746EL, // co_Latn_FR
        0xBDC24547436F7074L, // cop_Copt_EG
        0xC9E250484C61746EL, // cps_Latn_PH
        0x6372434143616E73L, // cr_Cans_CA
        0xA622434143616E73L, // crj_Cans_CA
        0xAA22434143616E73L, // crk_Cans_CA
        0xAE22434143616E73L, // crl_Cans_CA
        0xB222434143616E73L, // crm_Cans_CA
        0xCA2253434C61746EL, // crs_Latn_SC
        0x6373435A4C61746EL, // cs_Latn_CZ
        0x8642504C4C61746EL, // csb_Latn_PL
        0xDA42434143616E73L, // csw_Cans_CA
        0x8E624D4D50617563L, // ctd_Pauc_MM
        0x637552554379726CL, // cu_Cyrl_RU
        0x63754247476C6167L, // cu_Glag_BG
        0x637652554379726CL, // cv_Cyrl_RU
        0x637947424C61746EL, // cy_Latn_GB
        0x6461444B4C61746EL, // da_Latn_DK
        0xA80355534C61746EL, // dak_Latn_US
        0xC40352554379726CL, // dar_Cyrl_RU
        0xD4034B454C61746EL, // dav_Latn_KE
        0x8843494E41726162L, // dcc_Arab_IN
        0x646544454C61746EL, // de_Latn_DE
        0xB48343414C61746EL, // den_Latn_CA
        0xC4C343414C61746EL, // dgr_Latn_CA
        0x91234E454C61746EL, // dje_Latn_NE
        0xA5A343494C61746EL, // dnj_Latn_CI
        0xA1C3494E41726162L, // doi_Arab_IN
        0x864344454C61746EL, // dsb_Latn_DE
        0xB2634D4C4C61746EL, // dtm_Latn_ML
        0xBE634D594C61746EL, // dtp_Latn_MY
        0x8283434D4C61746EL, // dua_Latn_CM
        0x64764D5654686161L, // dv_Thaa_MV
        0xBB03534E4C61746EL, // dyo_Latn_SN
        0xD30342464C61746EL, // dyu_Latn_BF
        0x647A425454696274L, // dz_Tibt_BT
        0xD0244B454C61746EL, // ebu_Latn_KE
        0x656547484C61746EL, // ee_Latn_GH
        0xA0A44E474C61746EL, // efi_Latn_NG
        0xACC449544C61746EL, // egl_Latn_IT
        0xE0C4454745677970L, // egy_Egyp_EG
        0xE1444D4D4B616C69L, // eky_Kali_MM
        0x656C47524772656BL, // el_Grek_GR
        0x656E47424C61746EL, // en_Latn_GB
        0x656E55534C61746EL, // en_Latn_US
        0x656E474253686177L, // en_Shaw_GB
        0x657345534C61746EL, // es_Latn_ES
        0x65734D584C61746EL, // es_Latn_MX
        0x657355534C61746EL, // es_Latn_US
        0xD24455534C61746EL, // esu_Latn_US
        0x657445454C61746EL, // et_Latn_EE
        0xCE6449544974616CL, // ett_Ital_IT
        0x657545534C61746EL, // eu_Latn_ES
        0xBAC4434D4C61746EL, // ewo_Latn_CM
        0xCEE445534C61746EL, // ext_Latn_ES
        0x6661495241726162L, // fa_Arab_IR
        0xB40547514C61746EL, // fan_Latn_GQ
        0x6666534E4C61746EL, // ff_Latn_SN
        0xB0A54D4C4C61746EL, // ffm_Latn_ML
        0x666946494C61746EL, // fi_Latn_FI
        0x8105534441726162L, // fia_Arab_SD
        0xAD0550484C61746EL, // fil_Latn_PH
        0xCD0553454C61746EL, // fit_Latn_SE
        0x666A464A4C61746EL, // fj_Latn_FJ
        0x666F464F4C61746EL, // fo_Latn_FO
        0xB5C5424A4C61746EL, // fon_Latn_BJ
        0x667246524C61746EL, // fr_Latn_FR
        0x8A2555534C61746EL, // frc_Latn_US
        0xBE2546524C61746EL, // frp_Latn_FR
        0xC62544454C61746EL, // frr_Latn_DE
        0xCA2544454C61746EL, // frs_Latn_DE
        0x8E8557464C61746EL, // fud_Latn_WF
        0xC2854E454C61746EL, // fuq_Latn_NE
        0xC68549544C61746EL, // fur_Latn_IT
        0xD6854E474C61746EL, // fuv_Latn_NG
        0xC6A553444C61746EL, // fvr_Latn_SD
        0x66794E4C4C61746EL, // fy_Latn_NL
        0x676149454C61746EL, // ga_Latn_IE
        0x800647484C61746EL, // gaa_Latn_GH
        0x98064D444C61746EL, // gag_Latn_MD
        0xB406434E48616E73L, // gan_Hans_CN
        0xE00649444C61746EL, // gay_Latn_ID
        0xB026494E44657661L, // gbm_Deva_IN
        0xE426495241726162L, // gbz_Arab_IR
        0xC44647464C61746EL, // gcr_Latn_GF
        0x676447424C61746EL, // gd_Latn_GB
        0xE486455445746869L, // gez_Ethi_ET
        0xB4C64E5044657661L, // ggn_Deva_NP
        0xAD064B494C61746EL, // gil_Latn_KI
        0xA926504B41726162L, // gjk_Arab_PK
        0xD126504B41726162L, // gju_Arab_PK
        0x676C45534C61746EL, // gl_Latn_ES
        0xA966495241726162L, // glk_Arab_IR
        0x676E50594C61746EL, // gn_Latn_PY
        0xB1C6494E44657661L, // gom_Deva_IN
        0xB5C6494E54656C75L, // gon_Telu_IN
        0xC5C649444C61746EL, // gor_Latn_ID
        0xC9C64E4C4C61746EL, // gos_Latn_NL
        0xCDC65541476F7468L, // got_Goth_UA
        0x8A26435943707274L, // grc_Cprt_CY
        0x8A2647524C696E62L, // grc_Linb_GR
        0xCE26494E42656E67L, // grt_Beng_IN
        0xDA4643484C61746EL, // gsw_Latn_CH
        0x6775494E47756A72L, // gu_Gujr_IN
        0x868642524C61746EL, // gub_Latn_BR
        0x8A86434F4C61746EL, // guc_Latn_CO
        0xC68647484C61746EL, // gur_Latn_GH
        0xE6864B454C61746EL, // guz_Latn_KE
        0x6776494D4C61746EL, // gv_Latn_IM
        0xC6A64E5044657661L, // gvr_Deva_NP
        0xA2C643414C61746EL, // gwi_Latn_CA
        0x68614E474C61746EL, // ha_Latn_NG
        0xA807434E48616E73L, // hak_Hans_CN
        0xD80755534C61746EL, // haw_Latn_US
        0xE407414641726162L, // haz_Arab_AF
        0x6865494C48656272L, // he_Hebr_IL
        0x6869494E44657661L, // hi_Deva_IN
        0x9507464A4C61746EL, // hif_Latn_FJ
        0xAD0750484C61746EL, // hil_Latn_PH
        0xD1675452486C7577L, // hlu_Hluw_TR
        0x8D87434E506C7264L, // hmd_Plrd_CN
        0x8DA7504B41726162L, // hnd_Arab_PK
        0x91A7494E44657661L, // hne_Deva_IN
        0xA5A74C41486D6E67L, // hnj_Hmng_LA
        0xB5A750484C61746EL, // hnn_Latn_PH
        0xB9A7504B41726162L, // hno_Arab_PK
        0x686F50474C61746EL, // ho_Latn_PG
        0x89C7494E44657661L, // hoc_Deva_IN
        0xA5C7494E44657661L, // hoj_Deva_IN
        0x687248524C61746EL, // hr_Latn_HR
        0x864744454C61746EL, // hsb_Latn_DE
        0xB647434E48616E73L, // hsn_Hans_CN
        0x687448544C61746EL, // ht_Latn_HT
        0x687548554C61746EL, // hu_Latn_HU
        0x6879414D41726D6EL, // hy_Armn_AM
        0x687A4E414C61746EL, // hz_Latn_NA
        0x696146524C61746EL, // ia_Latn_FR
        0x80284D594C61746EL, // iba_Latn_MY
        0x84284E474C61746EL, // ibb_Latn_NG
        0x696449444C61746EL, // id_Latn_ID
        0x69674E474C61746EL, // ig_Latn_NG
        0x6969434E59696969L, // ii_Yiii_CN
        0x696B55534C61746EL, // ik_Latn_US
        0xCD4843414C61746EL, // ikt_Latn_CA
        0xB96850484C61746EL, // ilo_Latn_PH
        0x696E49444C61746EL, // in_Latn_ID
        0x9DA852554379726CL, // inh_Cyrl_RU
        0x697349534C61746EL, // is_Latn_IS
        0x697449544C61746EL, // it_Latn_IT
        0x6975434143616E73L, // iu_Cans_CA
        0x6977494C48656272L, // iw_Hebr_IL
        0x9F2852554C61746EL, // izh_Latn_RU
        0x6A614A504A70616EL, // ja_Jpan_JP
        0xB0094A4D4C61746EL, // jam_Latn_JM
        0xB8C9434D4C61746EL, // jgo_Latn_CM
        0x6A69554148656272L, // ji_Hebr_UA
        0x8989545A4C61746EL, // jmc_Latn_TZ
        0xAD894E5044657661L, // jml_Deva_NP
        0xCE89444B4C61746EL, // jut_Latn_DK
        0x6A7649444C61746EL, // jv_Latn_ID
        0x6A7749444C61746EL, // jw_Latn_ID
        0x6B61474547656F72L, // ka_Geor_GE
        0x800A555A4379726CL, // kaa_Cyrl_UZ
        0x840A445A4C61746EL, // kab_Latn_DZ
        0x880A4D4D4C61746EL, // kac_Latn_MM
        0xA40A4E474C61746EL, // kaj_Latn_NG
        0xB00A4B454C61746EL, // kam_Latn_KE
        0xB80A4D4C4C61746EL, // kao_Latn_ML
        0x8C2A52554379726CL, // kbd_Cyrl_RU
        0x984A4E474C61746EL, // kcg_Latn_NG
        0xA84A5A574C61746EL, // kck_Latn_ZW
        0x906A545A4C61746EL, // kde_Latn_TZ
        0xCC6A544854686169L, // kdt_Thai_TH
        0x808A43564C61746EL, // kea_Latn_CV
        0xB48A434D4C61746EL, // ken_Latn_CM
        0xB8AA43494C61746EL, // kfo_Latn_CI
        0xC4AA494E44657661L, // kfr_Deva_IN
        0xE0AA494E44657661L, // kfy_Deva_IN
        0x6B6743444C61746EL, // kg_Latn_CD
        0x90CA49444C61746EL, // kge_Latn_ID
        0xBCCA42524C61746EL, // kgp_Latn_BR
        0x80EA494E4C61746EL, // kha_Latn_IN
        0x84EA434E54616C75L, // khb_Talu_CN
        0xB4EA494E44657661L, // khn_Deva_IN
        0xC0EA4D4C4C61746EL, // khq_Latn_ML
        0xCCEA494E4D796D72L, // kht_Mymr_IN
        0xD8EA504B41726162L, // khw_Arab_PK
        0x6B694B454C61746EL, // ki_Latn_KE
        0xD10A54524C61746EL, // kiu_Latn_TR
        0x6B6A4E414C61746EL, // kj_Latn_NA
        0x992A4C414C616F6FL, // kjg_Laoo_LA
        0x6B6B434E41726162L, // kk_Arab_CN
        0x6B6B4B5A4379726CL, // kk_Cyrl_KZ
        0xA54A434D4C61746EL, // kkj_Latn_CM
        0x6B6C474C4C61746EL, // kl_Latn_GL
        0xB56A4B454C61746EL, // kln_Latn_KE
        0x6B6D4B484B686D72L, // km_Khmr_KH
        0x858A414F4C61746EL, // kmb_Latn_AO
        0x6B6E494E4B6E6461L, // kn_Knda_IN
        0x6B6F4B524B6F7265L, // ko_Kore_KR
        0xA1CA52554379726CL, // koi_Cyrl_RU
        0xA9CA494E44657661L, // kok_Deva_IN
        0xC9CA464D4C61746EL, // kos_Latn_FM
        0x91EA4C524C61746EL, // kpe_Latn_LR
        0x8A2A52554379726CL, // krc_Cyrl_RU
        0xA22A534C4C61746EL, // kri_Latn_SL
        0xA62A50484C61746EL, // krj_Latn_PH
        0xAE2A52554C61746EL, // krl_Latn_RU
        0xD22A494E44657661L, // kru_Deva_IN
        0x6B73494E41726162L, // ks_Arab_IN
        0x864A545A4C61746EL, // ksb_Latn_TZ
        0x964A434D4C61746EL, // ksf_Latn_CM
        0x9E4A44454C61746EL, // ksh_Latn_DE
        0x6B75495141726162L, // ku_Arab_IQ
        0x6B7554524C61746EL, // ku_Latn_TR
        0xB28A52554379726CL, // kum_Cyrl_RU
        0x6B7652554379726CL, // kv_Cyrl_RU
        0xC6AA49444C61746EL, // kvr_Latn_ID
        0xDEAA504B41726162L, // kvx_Arab_PK
        0x6B7747424C61746EL, // kw_Latn_GB
        0xB2EA544854686169L, // kxm_Thai_TH
        0xBEEA504B41726162L, // kxp_Arab_PK
        0x6B79434E41726162L, // ky_Arab_CN
        0x6B794B474379726CL, // ky_Cyrl_KG
        0x6B7954524C61746EL, // ky_Latn_TR
        0x6C6156414C61746EL, // la_Latn_VA
        0x840B47524C696E61L, // lab_Lina_GR
        0x8C0B494C48656272L, // lad_Hebr_IL
        0x980B545A4C61746EL, // lag_Latn_TZ
        0x9C0B504B41726162L, // lah_Arab_PK
        0xA40B55474C61746EL, // laj_Latn_UG
        0x6C624C554C61746EL, // lb_Latn_LU
        0x902B52554379726CL, // lbe_Cyrl_RU
        0xD82B49444C61746EL, // lbw_Latn_ID
        0xBC4B434E54686169L, // lcp_Thai_CN
        0xBC8B494E4C657063L, // lep_Lepc_IN
        0xE48B52554379726CL, // lez_Cyrl_RU
        0x6C6755474C61746EL, // lg_Latn_UG
        0x6C694E4C4C61746EL, // li_Latn_NL
        0x950B4E5044657661L, // lif_Deva_NP
        0x950B494E4C696D62L, // lif_Limb_IN
        0xA50B49544C61746EL, // lij_Latn_IT
        0xC90B434E4C697375L, // lis_Lisu_CN
        0xBD2B49444C61746EL, // ljp_Latn_ID
        0xA14B495241726162L, // lki_Arab_IR
        0xCD4B55534C61746EL, // lkt_Latn_US
        0xB58B494E54656C75L, // lmn_Telu_IN
        0xB98B49544C61746EL, // lmo_Latn_IT
        0x6C6E43444C61746EL, // ln_Latn_CD
        0x6C6F4C414C616F6FL, // lo_Laoo_LA
        0xADCB43444C61746EL, // lol_Latn_CD
        0xE5CB5A4D4C61746EL, // loz_Latn_ZM
        0x8A2B495241726162L, // lrc_Arab_IR
        0x6C744C544C61746EL, // lt_Latn_LT
        0x9A6B4C564C61746EL, // ltg_Latn_LV
        0x6C7543444C61746EL, // lu_Latn_CD
        0x828B43444C61746EL, // lua_Latn_CD
        0xBA8B4B454C61746EL, // luo_Latn_KE
        0xE28B4B454C61746EL, // luy_Latn_KE
        0xE68B495241726162L, // luz_Arab_IR
        0x6C764C564C61746EL, // lv_Latn_LV
        0xAECB544854686169L, // lwl_Thai_TH
        0x9F2B434E48616E73L, // lzh_Hans_CN
        0xE72B54524C61746EL, // lzz_Latn_TR
        0x8C0C49444C61746EL, // mad_Latn_ID
        0x940C434D4C61746EL, // maf_Latn_CM
        0x980C494E44657661L, // mag_Deva_IN
        0xA00C494E44657661L, // mai_Deva_IN
        0xA80C49444C61746EL, // mak_Latn_ID
        0xB40C474D4C61746EL, // man_Latn_GM
        0xB40C474E4E6B6F6FL, // man_Nkoo_GN
        0xC80C4B454C61746EL, // mas_Latn_KE
        0xE40C4D584C61746EL, // maz_Latn_MX
        0x946C52554379726CL, // mdf_Cyrl_RU
        0x9C6C50484C61746EL, // mdh_Latn_PH
        0xC46C49444C61746EL, // mdr_Latn_ID
        0xB48C534C4C61746EL, // men_Latn_SL
        0xC48C4B454C61746EL, // mer_Latn_KE
        0x80AC544841726162L, // mfa_Arab_TH
        0x90AC4D554C61746EL, // mfe_Latn_MU
        0x6D674D474C61746EL, // mg_Latn_MG
        0x9CCC4D5A4C61746EL, // mgh_Latn_MZ
        0xB8CC434D4C61746EL, // mgo_Latn_CM
        0xBCCC4E5044657661L, // mgp_Deva_NP
        0xE0CC545A4C61746EL, // mgy_Latn_TZ
        0x6D684D484C61746EL, // mh_Latn_MH
        0x6D694E5A4C61746EL, // mi_Latn_NZ
        0xB50C49444C61746EL, // min_Latn_ID
        0xC90C495148617472L, // mis_Hatr_IQ
        0x6D6B4D4B4379726CL, // mk_Cyrl_MK
        0x6D6C494E4D6C796DL, // ml_Mlym_IN
        0xC96C53444C61746EL, // mls_Latn_SD
        0x6D6E4D4E4379726CL, // mn_Cyrl_MN
        0x6D6E434E4D6F6E67L, // mn_Mong_CN
        0xA1AC494E42656E67L, // mni_Beng_IN
        0xD9AC4D4D4D796D72L, // mnw_Mymr_MM
        0x91CC43414C61746EL, // moe_Latn_CA
        0x9DCC43414C61746EL, // moh_Latn_CA
        0xC9CC42464C61746EL, // mos_Latn_BF
        0x6D72494E44657661L, // mr_Deva_IN
        0x8E2C4E5044657661L, // mrd_Deva_NP
        0xA62C52554379726CL, // mrj_Cyrl_RU
        0xD22C42444D726F6FL, // mru_Mroo_BD
        0x6D734D594C61746EL, // ms_Latn_MY
        0x6D744D544C61746EL, // mt_Latn_MT
        0xC66C494E44657661L, // mtr_Deva_IN
        0x828C434D4C61746EL, // mua_Latn_CM
        0xCA8C55534C61746EL, // mus_Latn_US
        0xE2AC504B41726162L, // mvy_Arab_PK
        0xAACC4D4C4C61746EL, // mwk_Latn_ML
        0xC6CC494E44657661L, // mwr_Deva_IN
        0xD6CC49444C61746EL, // mwv_Latn_ID
        0x8AEC5A574C61746EL, // mxc_Latn_ZW
        0x6D794D4D4D796D72L, // my_Mymr_MM
        0xD70C52554379726CL, // myv_Cyrl_RU
        0xDF0C55474C61746EL, // myx_Latn_UG
        0xE70C49524D616E64L, // myz_Mand_IR
        0xB72C495241726162L, // mzn_Arab_IR
        0x6E614E524C61746EL, // na_Latn_NR
        0xB40D434E48616E73L, // nan_Hans_CN
        0xBC0D49544C61746EL, // nap_Latn_IT
        0xC00D4E414C61746EL, // naq_Latn_NA
        0x6E624E4F4C61746EL, // nb_Latn_NO
        0x9C4D4D584C61746EL, // nch_Latn_MX
        0x6E645A574C61746EL, // nd_Latn_ZW
        0x886D4D5A4C61746EL, // ndc_Latn_MZ
        0xC86D44454C61746EL, // nds_Latn_DE
        0x6E654E5044657661L, // ne_Deva_NP
        0xD88D4E5044657661L, // new_Deva_NP
        0x6E674E414C61746EL, // ng_Latn_NA
        0xACCD4D5A4C61746EL, // ngl_Latn_MZ
        0x90ED4D584C61746EL, // nhe_Latn_MX
        0xD8ED4D584C61746EL, // nhw_Latn_MX
        0xA50D49444C61746EL, // nij_Latn_ID
        0xD10D4E554C61746EL, // niu_Latn_NU
        0xB92D494E4C61746EL, // njo_Latn_IN
        0x6E6C4E4C4C61746EL, // nl_Latn_NL
        0x998D434D4C61746EL, // nmg_Latn_CM
        0x6E6E4E4F4C61746EL, // nn_Latn_NO
        0x9DAD434D4C61746EL, // nnh_Latn_CM
        0x6E6F4E4F4C61746EL, // no_Latn_NO
        0x8DCD54484C616E61L, // nod_Lana_TH
        0x91CD494E44657661L, // noe_Deva_IN
        0xB5CD534552756E72L, // non_Runr_SE
        0xBA0D474E4E6B6F6FL, // nqo_Nkoo_GN
        0x6E725A414C61746EL, // nr_Latn_ZA
        0xAA4D434143616E73L, // nsk_Cans_CA
        0xBA4D5A414C61746EL, // nso_Latn_ZA
        0xCA8D53534C61746EL, // nus_Latn_SS
        0x6E7655534C61746EL, // nv_Latn_US
        0xC2ED434E4C61746EL, // nxq_Latn_CN
        0x6E794D574C61746EL, // ny_Latn_MW
        0xB30D545A4C61746EL, // nym_Latn_TZ
        0xB70D55474C61746EL, // nyn_Latn_UG
        0xA32D47484C61746EL, // nzi_Latn_GH
        0x6F6346524C61746EL, // oc_Latn_FR
        0x6F6D45544C61746EL, // om_Latn_ET
        0x6F72494E4F727961L, // or_Orya_IN
        0x6F7347454379726CL, // os_Cyrl_GE
        0xAA6E4D4E4F726B68L, // otk_Orkh_MN
        0x7061504B41726162L, // pa_Arab_PK
        0x7061494E47757275L, // pa_Guru_IN
        0x980F50484C61746EL, // pag_Latn_PH
        0xAC0F495250686C69L, // pal_Phli_IR
        0xAC0F434E50686C70L, // pal_Phlp_CN
        0xB00F50484C61746EL, // pam_Latn_PH
        0xBC0F41574C61746EL, // pap_Latn_AW
        0xD00F50574C61746EL, // pau_Latn_PW
        0x8C4F46524C61746EL, // pcd_Latn_FR
        0xB04F4E474C61746EL, // pcm_Latn_NG
        0x886F55534C61746EL, // pdc_Latn_US
        0xCC6F43414C61746EL, // pdt_Latn_CA
        0xB88F49525870656FL, // peo_Xpeo_IR
        0xACAF44454C61746EL, // pfl_Latn_DE
        0xB4EF4C4250686E78L, // phn_Phnx_LB
        0x814F494E42726168L, // pka_Brah_IN
        0xB94F4B454C61746EL, // pko_Latn_KE
        0x706C504C4C61746EL, // pl_Latn_PL
        0xC98F49544C61746EL, // pms_Latn_IT
        0xCDAF47524772656BL, // pnt_Grek_GR
        0xB5CF464D4C61746EL, // pon_Latn_FM
        0x822F504B4B686172L, // pra_Khar_PK
        0x8E2F495241726162L, // prd_Arab_IR
        0x7073414641726162L, // ps_Arab_AF
        0x707442524C61746EL, // pt_Latn_BR
        0xD28F47414C61746EL, // puu_Latn_GA
        0x717550454C61746EL, // qu_Latn_PE
        0x8A9047544C61746EL, // quc_Latn_GT
        0x9A9045434C61746EL, // qug_Latn_EC
        0xA411494E44657661L, // raj_Deva_IN
        0x945152454C61746EL, // rcf_Latn_RE
        0xA49149444C61746EL, // rej_Latn_ID
        0xB4D149544C61746EL, // rgn_Latn_IT
        0x8111494E4C61746EL, // ria_Latn_IN
        0x95114D4154666E67L, // rif_Tfng_MA
        0xC9314E5044657661L, // rjs_Deva_NP
        0xCD51424442656E67L, // rkt_Beng_BD
        0x726D43484C61746EL, // rm_Latn_CH
        0x959146494C61746EL, // rmf_Latn_FI
        0xB99143484C61746EL, // rmo_Latn_CH
        0xCD91495241726162L, // rmt_Arab_IR
        0xD19153454C61746EL, // rmu_Latn_SE
        0x726E42494C61746EL, // rn_Latn_BI
        0x99B14D5A4C61746EL, // rng_Latn_MZ
        0x726F524F4C61746EL, // ro_Latn_RO
        0x85D149444C61746EL, // rob_Latn_ID
        0x95D1545A4C61746EL, // rof_Latn_TZ
        0xB271464A4C61746EL, // rtm_Latn_FJ
        0x727552554379726CL, // ru_Cyrl_RU
        0x929155414379726CL, // rue_Cyrl_UA
        0x9A9153424C61746EL, // rug_Latn_SB
        0x727752574C61746EL, // rw_Latn_RW
        0xAAD1545A4C61746EL, // rwk_Latn_TZ
        0xD3114A504B616E61L, // ryu_Kana_JP
        0x7361494E44657661L, // sa_Deva_IN
        0x941247484C61746EL, // saf_Latn_GH
        0x9C1252554379726CL, // sah_Cyrl_RU
        0xC0124B454C61746EL, // saq_Latn_KE
        0xC81249444C61746EL, // sas_Latn_ID
        0xCC12494E4C61746EL, // sat_Latn_IN
        0xE412494E53617572L, // saz_Saur_IN
        0xBC32545A4C61746EL, // sbp_Latn_TZ
        0x736349544C61746EL, // sc_Latn_IT
        0xA852494E44657661L, // sck_Deva_IN
        0xB45249544C61746EL, // scn_Latn_IT
        0xB85247424C61746EL, // sco_Latn_GB
        0xC85243414C61746EL, // scs_Latn_CA
        0x7364504B41726162L, // sd_Arab_PK
        0x7364494E44657661L, // sd_Deva_IN
        0x7364494E4B686F6AL, // sd_Khoj_IN
        0x7364494E53696E64L, // sd_Sind_IN
        0x887249544C61746EL, // sdc_Latn_IT
        0x9C72495241726162L, // sdh_Arab_IR
        0x73654E4F4C61746EL, // se_Latn_NO
        0x949243494C61746EL, // sef_Latn_CI
        0x9C924D5A4C61746EL, // seh_Latn_MZ
        0xA0924D584C61746EL, // sei_Latn_MX
        0xC8924D4C4C61746EL, // ses_Latn_ML
        0x736743464C61746EL, // sg_Latn_CF
        0x80D249454F67616DL, // sga_Ogam_IE
        0xC8D24C544C61746EL, // sgs_Latn_LT
        0xA0F24D4154666E67L, // shi_Tfng_MA
        0xB4F24D4D4D796D72L, // shn_Mymr_MM
        0x73694C4B53696E68L, // si_Sinh_LK
        0x8D1245544C61746EL, // sid_Latn_ET
        0x736B534B4C61746EL, // sk_Latn_SK
        0xC552504B41726162L, // skr_Arab_PK
        0x736C53494C61746EL, // sl_Latn_SI
        0xA172504C4C61746EL, // sli_Latn_PL
        0xE17249444C61746EL, // sly_Latn_ID
        0x736D57534C61746EL, // sm_Latn_WS
        0x819253454C61746EL, // sma_Latn_SE
        0xA59253454C61746EL, // smj_Latn_SE
        0xB59246494C61746EL, // smn_Latn_FI
        0xBD92494C53616D72L, // smp_Samr_IL
        0xC99246494C61746EL, // sms_Latn_FI
        0x736E5A574C61746EL, // sn_Latn_ZW
        0xA9B24D4C4C61746EL, // snk_Latn_ML
        0x736F534F4C61746EL, // so_Latn_SO
        0xD1D2544854686169L, // sou_Thai_TH
        0x7371414C4C61746EL, // sq_Latn_AL
        0x737252534379726CL, // sr_Cyrl_RS
        0x737252534C61746EL, // sr_Latn_RS
        0x8632494E536F7261L, // srb_Sora_IN
        0xB63253524C61746EL, // srn_Latn_SR
        0xC632534E4C61746EL, // srr_Latn_SN
        0xDE32494E44657661L, // srx_Deva_IN
        0x73735A414C61746EL, // ss_Latn_ZA
        0xE25245524C61746EL, // ssy_Latn_ER
        0x73745A414C61746EL, // st_Latn_ZA
        0xC27244454C61746EL, // stq_Latn_DE
        0x737549444C61746EL, // su_Latn_ID
        0xAA92545A4C61746EL, // suk_Latn_TZ
        0xCA92474E4C61746EL, // sus_Latn_GN
        0x737653454C61746EL, // sv_Latn_SE
        0x7377545A4C61746EL, // sw_Latn_TZ
        0x86D2595441726162L, // swb_Arab_YT
        0x8AD243444C61746EL, // swc_Latn_CD
        0x9AD244454C61746EL, // swg_Latn_DE
        0xD6D2494E44657661L, // swv_Deva_IN
        0xB6F249444C61746EL, // sxn_Latn_ID
        0xAF12424442656E67L, // syl_Beng_BD
        0xC712495153797263L, // syr_Syrc_IQ
        0xAF32504C4C61746EL, // szl_Latn_PL
        0x7461494E54616D6CL, // ta_Taml_IN
        0xA4134E5044657661L, // taj_Deva_NP
        0xD83350484C61746EL, // tbw_Latn_PH
        0xE053494E4B6E6461L, // tcy_Knda_IN
        0x8C73434E54616C65L, // tdd_Tale_CN
        0x98734E5044657661L, // tdg_Deva_NP
        0x9C734E5044657661L, // tdh_Deva_NP
        0x7465494E54656C75L, // te_Telu_IN
        0xB093534C4C61746EL, // tem_Latn_SL
        0xB89355474C61746EL, // teo_Latn_UG
        0xCC93544C4C61746EL, // tet_Latn_TL
        0x7467504B41726162L, // tg_Arab_PK
        0x7467544A4379726CL, // tg_Cyrl_TJ
        0x7468544854686169L, // th_Thai_TH
        0xACF34E5044657661L, // thl_Deva_NP
        0xC0F34E5044657661L, // thq_Deva_NP
        0xC4F34E5044657661L, // thr_Deva_NP
        0x7469455445746869L, // ti_Ethi_ET
        0x9913455245746869L, // tig_Ethi_ER
        0xD5134E474C61746EL, // tiv_Latn_NG
        0x746B544D4C61746EL, // tk_Latn_TM
        0xAD53544B4C61746EL, // tkl_Latn_TK
        0xC553415A4C61746EL, // tkr_Latn_AZ
        0xCD534E5044657661L, // tkt_Deva_NP
        0x746C50484C61746EL, // tl_Latn_PH
        0xE173415A4C61746EL, // tly_Latn_AZ
        0x9D934E454C61746EL, // tmh_Latn_NE
        0x746E5A414C61746EL, // tn_Latn_ZA
        0x746F544F4C61746EL, // to_Latn_TO
        0x99D34D574C61746EL, // tog_Latn_MW
        0xA1F350474C61746EL, // tpi_Latn_PG
        0x747254524C61746EL, // tr_Latn_TR
        0xD23354524C61746EL, // tru_Latn_TR
        0xD63354574C61746EL, // trv_Latn_TW
        0x74735A414C61746EL, // ts_Latn_ZA
        0x8E5347524772656BL, // tsd_Grek_GR
        0x96534E5044657661L, // tsf_Deva_NP
        0x9A5350484C61746EL, // tsg_Latn_PH
        0xA653425454696274L, // tsj_Tibt_BT
        0x747452554379726CL, // tt_Cyrl_RU
        0xA67355474C61746EL, // ttj_Latn_UG
        0xCA73544854686169L, // tts_Thai_TH
        0xCE73415A4C61746EL, // ttt_Latn_AZ
        0xB2934D574C61746EL, // tum_Latn_MW
        0xAEB354564C61746EL, // tvl_Latn_TV
        0xC2D34E454C61746EL, // twq_Latn_NE
        0x747950464C61746EL, // ty_Latn_PF
        0xD71352554379726CL, // tyv_Cyrl_RU
        0xB3334D414C61746EL, // tzm_Latn_MA
        0xB07452554379726CL, // udm_Cyrl_RU
        0x7567434E41726162L, // ug_Arab_CN
        0x75674B5A4379726CL, // ug_Cyrl_KZ
        0x80D4535955676172L, // uga_Ugar_SY
        0x756B55414379726CL, // uk_Cyrl_UA
        0xA174464D4C61746EL, // uli_Latn_FM
        0x8594414F4C61746EL, // umb_Latn_AO
        0xC5B4494E42656E67L, // unr_Beng_IN
        0xC5B44E5044657661L, // unr_Deva_NP
        0xDDB4494E42656E67L, // unx_Beng_IN
        0x7572504B41726162L, // ur_Arab_PK
        0x757A414641726162L, // uz_Arab_AF
        0x757A555A4C61746EL, // uz_Latn_UZ
        0xA0154C5256616969L, // vai_Vaii_LR
        0x76655A414C61746EL, // ve_Latn_ZA
        0x889549544C61746EL, // vec_Latn_IT
        0xBC9552554C61746EL, // vep_Latn_RU
        0x7669564E4C61746EL, // vi_Latn_VN
        0x891553584C61746EL, // vic_Latn_SX
        0xC97542454C61746EL, // vls_Latn_BE
        0x959544454C61746EL, // vmf_Latn_DE
        0xD9954D5A4C61746EL, // vmw_Latn_MZ
        0xCDD552554C61746EL, // vot_Latn_RU
        0xBA3545454C61746EL, // vro_Latn_EE
        0xB695545A4C61746EL, // vun_Latn_TZ
        0x776142454C61746EL, // wa_Latn_BE
        0x901643484C61746EL, // wae_Latn_CH
        0xAC16455445746869L, // wal_Ethi_ET
        0xC41650484C61746EL, // war_Latn_PH
        0xBC3641554C61746EL, // wbp_Latn_AU
        0xC036494E54656C75L, // wbq_Telu_IN
        0xC436494E44657661L, // wbr_Deva_IN
        0xC97657464C61746EL, // wls_Latn_WF
        0xA1B64B4D41726162L, // wni_Arab_KM
        0x776F534E4C61746EL, // wo_Latn_SN
        0xB276494E44657661L, // wtm_Deva_IN
        0xD296434E48616E73L, // wuu_Hans_CN
        0xD41742524C61746EL, // xav_Latn_BR
        0xC457545243617269L, // xcr_Cari_TR
        0x78685A414C61746EL, // xh_Latn_ZA
        0x897754524C796369L, // xlc_Lyci_TR
        0x8D7754524C796469L, // xld_Lydi_TR
        0x9597474547656F72L, // xmf_Geor_GE
        0xB597434E4D616E69L, // xmn_Mani_CN
        0xC59753444D657263L, // xmr_Merc_SD
        0x81B753414E617262L, // xna_Narb_SA
        0xC5B7494E44657661L, // xnr_Deva_IN
        0x99D755474C61746EL, // xog_Latn_UG
        0xC5F7495250727469L, // xpr_Prti_IR
        0x8257594553617262L, // xsa_Sarb_YE
        0xC6574E5044657661L, // xsr_Deva_NP
        0xB8184D5A4C61746EL, // yao_Latn_MZ
        0xBC18464D4C61746EL, // yap_Latn_FM
        0xD418434D4C61746EL, // yav_Latn_CM
        0x8438434D4C61746EL, // ybb_Latn_CM
        0x796F4E474C61746EL, // yo_Latn_NG
        0xAE3842524C61746EL, // yrl_Latn_BR
        0x82984D584C61746EL, // yua_Latn_MX
        0x7A61434E4C61746EL, // za_Latn_CN
        0x981953444C61746EL, // zag_Latn_SD
        0xA4794B4D41726162L, // zdj_Arab_KM
        0x80994E4C4C61746EL, // zea_Latn_NL
        0x9CD94D4154666E67L, // zgh_Tfng_MA
        0x7A685457426F706FL, // zh_Bopo_TW
        0x7A68434E48616E73L, // zh_Hans_CN
        0x7A68545748616E74L, // zh_Hant_TW
        0xA1994D594C61746EL, // zmi_Latn_MY
        0x7A755A414C61746EL, // zu_Latn_ZA
        0x833954524C61746EL, // zza_Latn_TR
    };

    HashSet<Long> buildSet = new HashSet<>();
    for (long entry : entries) {
      buildSet.add(entry);
    }
    REPRESENTATIVE_LOCALES = Collections.unmodifiableSet(buildSet);
  }

  static final Map<Integer, Integer> ARAB_PARENTS;

  static {
    int[][] entries = {
        {0x6172445A, 0x61729420}, // ar-DZ -> ar-015
        {0x61724548, 0x61729420}, // ar-EH -> ar-015
        {0x61724C59, 0x61729420}, // ar-LY -> ar-015
        {0x61724D41, 0x61729420}, // ar-MA -> ar-015
        {0x6172544E, 0x61729420}, // ar-TN -> ar-015
    };

    Map<Integer, Integer> buildMap = new HashMap<>();
    for (int[] entry : entries) {
      buildMap.put(entry[0], entry[1]);
    }
    ARAB_PARENTS = Collections.unmodifiableMap(buildMap);
  }

  static final Map<Integer, Integer> HANT_PARENTS;

  static {
    int[][] entries = {
        {0x7A684D4F, 0x7A68484B}, // zh-Hant-MO -> zh-Hant-HK
    };

    Map<Integer, Integer> buildMap = new HashMap<>();
    for (int[] entry : entries) {
      buildMap.put(entry[0], entry[1]);
    }
    HANT_PARENTS = Collections.unmodifiableMap(buildMap);
  }

  static final Map<Integer, Integer> LATN_PARENTS;

  static {
    int[][] entries = {
        {0x656E80A1, 0x656E8400}, // en-150 -> en-001
        {0x656E4147, 0x656E8400}, // en-AG -> en-001
        {0x656E4149, 0x656E8400}, // en-AI -> en-001
        {0x656E4154, 0x656E80A1}, // en-AT -> en-150
        {0x656E4155, 0x656E8400}, // en-AU -> en-001
        {0x656E4242, 0x656E8400}, // en-BB -> en-001
        {0x656E4245, 0x656E8400}, // en-BE -> en-001
        {0x656E424D, 0x656E8400}, // en-BM -> en-001
        {0x656E4253, 0x656E8400}, // en-BS -> en-001
        {0x656E4257, 0x656E8400}, // en-BW -> en-001
        {0x656E425A, 0x656E8400}, // en-BZ -> en-001
        {0x656E4341, 0x656E8400}, // en-CA -> en-001
        {0x656E4343, 0x656E8400}, // en-CC -> en-001
        {0x656E4348, 0x656E80A1}, // en-CH -> en-150
        {0x656E434B, 0x656E8400}, // en-CK -> en-001
        {0x656E434D, 0x656E8400}, // en-CM -> en-001
        {0x656E4358, 0x656E8400}, // en-CX -> en-001
        {0x656E4359, 0x656E8400}, // en-CY -> en-001
        {0x656E4445, 0x656E80A1}, // en-DE -> en-150
        {0x656E4447, 0x656E8400}, // en-DG -> en-001
        {0x656E444B, 0x656E80A1}, // en-DK -> en-150
        {0x656E444D, 0x656E8400}, // en-DM -> en-001
        {0x656E4552, 0x656E8400}, // en-ER -> en-001
        {0x656E4649, 0x656E80A1}, // en-FI -> en-150
        {0x656E464A, 0x656E8400}, // en-FJ -> en-001
        {0x656E464B, 0x656E8400}, // en-FK -> en-001
        {0x656E464D, 0x656E8400}, // en-FM -> en-001
        {0x656E4742, 0x656E8400}, // en-GB -> en-001
        {0x656E4744, 0x656E8400}, // en-GD -> en-001
        {0x656E4747, 0x656E8400}, // en-GG -> en-001
        {0x656E4748, 0x656E8400}, // en-GH -> en-001
        {0x656E4749, 0x656E8400}, // en-GI -> en-001
        {0x656E474D, 0x656E8400}, // en-GM -> en-001
        {0x656E4759, 0x656E8400}, // en-GY -> en-001
        {0x656E484B, 0x656E8400}, // en-HK -> en-001
        {0x656E4945, 0x656E8400}, // en-IE -> en-001
        {0x656E494C, 0x656E8400}, // en-IL -> en-001
        {0x656E494D, 0x656E8400}, // en-IM -> en-001
        {0x656E494E, 0x656E8400}, // en-IN -> en-001
        {0x656E494F, 0x656E8400}, // en-IO -> en-001
        {0x656E4A45, 0x656E8400}, // en-JE -> en-001
        {0x656E4A4D, 0x656E8400}, // en-JM -> en-001
        {0x656E4B45, 0x656E8400}, // en-KE -> en-001
        {0x656E4B49, 0x656E8400}, // en-KI -> en-001
        {0x656E4B4E, 0x656E8400}, // en-KN -> en-001
        {0x656E4B59, 0x656E8400}, // en-KY -> en-001
        {0x656E4C43, 0x656E8400}, // en-LC -> en-001
        {0x656E4C52, 0x656E8400}, // en-LR -> en-001
        {0x656E4C53, 0x656E8400}, // en-LS -> en-001
        {0x656E4D47, 0x656E8400}, // en-MG -> en-001
        {0x656E4D4F, 0x656E8400}, // en-MO -> en-001
        {0x656E4D53, 0x656E8400}, // en-MS -> en-001
        {0x656E4D54, 0x656E8400}, // en-MT -> en-001
        {0x656E4D55, 0x656E8400}, // en-MU -> en-001
        {0x656E4D57, 0x656E8400}, // en-MW -> en-001
        {0x656E4D59, 0x656E8400}, // en-MY -> en-001
        {0x656E4E41, 0x656E8400}, // en-NA -> en-001
        {0x656E4E46, 0x656E8400}, // en-NF -> en-001
        {0x656E4E47, 0x656E8400}, // en-NG -> en-001
        {0x656E4E4C, 0x656E80A1}, // en-NL -> en-150
        {0x656E4E52, 0x656E8400}, // en-NR -> en-001
        {0x656E4E55, 0x656E8400}, // en-NU -> en-001
        {0x656E4E5A, 0x656E8400}, // en-NZ -> en-001
        {0x656E5047, 0x656E8400}, // en-PG -> en-001
        {0x656E5048, 0x656E8400}, // en-PH -> en-001
        {0x656E504B, 0x656E8400}, // en-PK -> en-001
        {0x656E504E, 0x656E8400}, // en-PN -> en-001
        {0x656E5057, 0x656E8400}, // en-PW -> en-001
        {0x656E5257, 0x656E8400}, // en-RW -> en-001
        {0x656E5342, 0x656E8400}, // en-SB -> en-001
        {0x656E5343, 0x656E8400}, // en-SC -> en-001
        {0x656E5344, 0x656E8400}, // en-SD -> en-001
        {0x656E5345, 0x656E80A1}, // en-SE -> en-150
        {0x656E5347, 0x656E8400}, // en-SG -> en-001
        {0x656E5348, 0x656E8400}, // en-SH -> en-001
        {0x656E5349, 0x656E80A1}, // en-SI -> en-150
        {0x656E534C, 0x656E8400}, // en-SL -> en-001
        {0x656E5353, 0x656E8400}, // en-SS -> en-001
        {0x656E5358, 0x656E8400}, // en-SX -> en-001
        {0x656E535A, 0x656E8400}, // en-SZ -> en-001
        {0x656E5443, 0x656E8400}, // en-TC -> en-001
        {0x656E544B, 0x656E8400}, // en-TK -> en-001
        {0x656E544F, 0x656E8400}, // en-TO -> en-001
        {0x656E5454, 0x656E8400}, // en-TT -> en-001
        {0x656E5456, 0x656E8400}, // en-TV -> en-001
        {0x656E545A, 0x656E8400}, // en-TZ -> en-001
        {0x656E5547, 0x656E8400}, // en-UG -> en-001
        {0x656E5643, 0x656E8400}, // en-VC -> en-001
        {0x656E5647, 0x656E8400}, // en-VG -> en-001
        {0x656E5655, 0x656E8400}, // en-VU -> en-001
        {0x656E5753, 0x656E8400}, // en-WS -> en-001
        {0x656E5A41, 0x656E8400}, // en-ZA -> en-001
        {0x656E5A4D, 0x656E8400}, // en-ZM -> en-001
        {0x656E5A57, 0x656E8400}, // en-ZW -> en-001
        {0x65734152, 0x6573A424}, // es-AR -> es-419
        {0x6573424F, 0x6573A424}, // es-BO -> es-419
        {0x6573434C, 0x6573A424}, // es-CL -> es-419
        {0x6573434F, 0x6573A424}, // es-CO -> es-419
        {0x65734352, 0x6573A424}, // es-CR -> es-419
        {0x65734355, 0x6573A424}, // es-CU -> es-419
        {0x6573444F, 0x6573A424}, // es-DO -> es-419
        {0x65734543, 0x6573A424}, // es-EC -> es-419
        {0x65734754, 0x6573A424}, // es-GT -> es-419
        {0x6573484E, 0x6573A424}, // es-HN -> es-419
        {0x65734D58, 0x6573A424}, // es-MX -> es-419
        {0x65734E49, 0x6573A424}, // es-NI -> es-419
        {0x65735041, 0x6573A424}, // es-PA -> es-419
        {0x65735045, 0x6573A424}, // es-PE -> es-419
        {0x65735052, 0x6573A424}, // es-PR -> es-419
        {0x65735059, 0x6573A424}, // es-PY -> es-419
        {0x65735356, 0x6573A424}, // es-SV -> es-419
        {0x65735553, 0x6573A424}, // es-US -> es-419
        {0x65735559, 0x6573A424}, // es-UY -> es-419
        {0x65735645, 0x6573A424}, // es-VE -> es-419
        {0x7074414F, 0x70745054}, // pt-AO -> pt-PT
        {0x70744356, 0x70745054}, // pt-CV -> pt-PT
        {0x70744757, 0x70745054}, // pt-GW -> pt-PT
        {0x70744D4F, 0x70745054}, // pt-MO -> pt-PT
        {0x70744D5A, 0x70745054}, // pt-MZ -> pt-PT
        {0x70745354, 0x70745054}, // pt-ST -> pt-PT
        {0x7074544C, 0x70745054}, // pt-TL -> pt-PT
    };
    Map<Integer, Integer> buildMap = new HashMap<>();
    for (int[] entry : entries) {
      buildMap.put(entry[0], entry[1]);
    }
    LATN_PARENTS = Collections.unmodifiableMap(buildMap);
  }

  static final Map<String, Map<Integer, Integer>> SCRIPT_PARENTS;

  static {
    Map<String, Map<Integer, Integer>> buildMap = new HashMap<>();
    buildMap.put("Arab", ARAB_PARENTS);
    buildMap.put("Hant", HANT_PARENTS);
    buildMap.put("Latn", LATN_PARENTS);
    SCRIPT_PARENTS = Collections.unmodifiableMap(buildMap);
  }

  static final int MAX_PARENT_DEPTH = 3;
}
