/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.dependency;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.zip.CRC32;
import org.robolectric.internal.dependency.DependencyJar;
import org.robolectric.internal.dependency.DependencyResolver;

public class CachedDependencyResolver
implements DependencyResolver {
    private static final String CACHE_PREFIX = "localArtifactUrl";
    private final DependencyResolver dependencyResolver;
    private final CacheNamingStrategy cacheNamingStrategy;
    private final CacheValidationStrategy cacheValidationStrategy;
    private final Cache cache;

    public CachedDependencyResolver(DependencyResolver dependencyResolver, File cacheDir, long cacheValidTime) {
        this(dependencyResolver, new FileCache(cacheDir, cacheValidTime), new DefaultCacheNamingStrategy(), new DefaultCacheValidationStrategy());
    }

    public CachedDependencyResolver(DependencyResolver dependencyResolver, Cache cache, CacheNamingStrategy cacheNamingStrategy, CacheValidationStrategy cacheValidationStrategy) {
        this.dependencyResolver = dependencyResolver;
        this.cache = cache;
        this.cacheNamingStrategy = cacheNamingStrategy;
        this.cacheValidationStrategy = cacheValidationStrategy;
    }

    public URL getLocalArtifactUrl(DependencyJar dependency) {
        String cacheName = this.cacheNamingStrategy.getName(CACHE_PREFIX, dependency);
        URL urlFromCache = this.cache.load(cacheName, URL.class);
        if (urlFromCache != null && this.cacheValidationStrategy.isValid(urlFromCache)) {
            return urlFromCache;
        }
        URL url = this.dependencyResolver.getLocalArtifactUrl(dependency);
        this.cache.write(cacheName, url);
        return url;
    }

    static class FileCache
    implements Cache {
        private final File dir;
        private final long validTime;

        FileCache(File dir, long validTime) {
            this.dir = dir;
            this.validTime = validTime;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T extends Serializable> T load(String id, Class<T> type) {
            try {
                File file = new File(this.dir, id);
                if (!file.exists()) return null;
                if (this.validTime > 0L && file.lastModified() < new Date().getTime() - this.validTime) {
                    return null;
                }
                try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
                    Object o = in.readObject();
                    Serializable serializable = o.getClass() == type ? (Serializable)o : null;
                    return (T)serializable;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                return null;
            }
        }

        @Override
        public <T extends Serializable> boolean write(String id, T object) {
            boolean bl;
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.dir, id)));
            try {
                out.writeObject(object);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            out.close();
            return bl;
        }
    }

    static interface Cache {
        public <T extends Serializable> T load(String var1, Class<T> var2);

        public <T extends Serializable> boolean write(String var1, T var2);
    }

    static class DefaultCacheNamingStrategy
    implements CacheNamingStrategy {
        DefaultCacheNamingStrategy() {
        }

        @Override
        public String getName(String prefix, DependencyJar ... dependencies) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append("#");
            for (DependencyJar dependency : dependencies) {
                sb.append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getVersion()).append(",");
            }
            CRC32 crc = new CRC32();
            crc.update(sb.toString().getBytes(StandardCharsets.UTF_8));
            long l = crc.getValue();
            return new StringBuilder(20).append(l).toString();
        }
    }

    static class DefaultCacheValidationStrategy
    implements CacheValidationStrategy {
        DefaultCacheValidationStrategy() {
        }

        @Override
        public boolean isValid(URL url) {
            return new File(url.getPath()).exists();
        }

        @Override
        public boolean isValid(URL[] urls) {
            for (URL url : urls) {
                if (this.isValid(url)) continue;
                return false;
            }
            return true;
        }
    }

    static interface CacheValidationStrategy {
        public boolean isValid(URL var1);

        public boolean isValid(URL[] var1);
    }

    static interface CacheNamingStrategy {
        public String getName(String var1, DependencyJar ... var2);
    }
}

