/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.versioning;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;

public final class AndroidVersions {
    private static boolean warnOnly;
    public static final AndroidRelease CURRENT;
    private static final SdkInformation information;

    private AndroidVersions() {
    }

    @Nullable
    public static AndroidRelease getReleaseForSdkInt(@Nullable Integer sdkInt) {
        if (sdkInt == null) {
            return null;
        }
        return AndroidVersions.information.sdkIntToAllReleases.get(sdkInt);
    }

    public static List<AndroidRelease> getReleases() {
        ArrayList<AndroidRelease> output = new ArrayList<AndroidRelease>();
        for (AndroidRelease release : AndroidVersions.information.allReleases) {
            if (!release.isReleased()) continue;
            output.add(release);
        }
        return output;
    }

    public static List<AndroidRelease> getUnreleased() {
        ArrayList<AndroidRelease> output = new ArrayList<AndroidRelease>();
        for (AndroidRelease release : AndroidVersions.information.allReleases) {
            if (release.isReleased()) continue;
            output.add(release);
        }
        return output;
    }

    static SdkInformation gatherStaticSdkInformationFromThisClass() {
        ArrayList<AndroidRelease> allReleases = new ArrayList<AndroidRelease>();
        ArrayList<Class<? extends AndroidRelease>> classesWithIllegalNames = new ArrayList<Class<? extends AndroidRelease>>();
        for (Class<?> clazz : AndroidVersions.class.getClasses()) {
            if (!AndroidRelease.class.isAssignableFrom(clazz) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || clazz == Unbound.class) continue;
            try {
                AndroidRelease rel = (AndroidRelease)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                allReleases.add(rel);
                if (rel.getClass().getSimpleName().equals(rel.getShortCode())) continue;
                classesWithIllegalNames.add(rel.getClass());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                AndroidVersions.errorMessage("Classes " + clazz.getName() + "should be accessible via " + AndroidVersions.class.getCanonicalName() + " and have a default public no-op constructor ", ex);
            }
        }
        Collections.sort(allReleases, AndroidRelease::compareTo);
        SdkInformation sdkInformation = new SdkInformation(allReleases, classesWithIllegalNames);
        sdkInformation.handleStaticErrors();
        return sdkInformation;
    }

    static AndroidRelease computeReleaseVersion(JarFile jarFile) throws IOException {
        ZipEntry buildProp = jarFile.getEntry("build.prop");
        Properties buildProps = new Properties();
        buildProps.load(jarFile.getInputStream(buildProp));
        return AndroidVersions.computeCurrentSdkFromBuildProps(buildProps);
    }

    static AndroidRelease computeCurrentSdkFromBuildProps(Properties buildProps) {
        String sdkVersionString = buildProps.getProperty("ro.build.version.sdk");
        int sdk = sdkVersionString == null ? 0 : Integer.parseInt(sdkVersionString);
        String release = buildProps.getProperty("ro.build.version.release");
        String codename = buildProps.getProperty("ro.build.version.codename");
        String codenames = buildProps.getProperty("ro.build.version.all_codenames");
        String[] allCodeNames = codenames == null ? new String[]{} : codenames.split(",");
        String[] activeCodeNames = allCodeNames.length > 0 && allCodeNames[0].equals("REL") ? new String[]{} : allCodeNames;
        return information.computeCurrentSdk(sdk, release, codename, Arrays.asList(activeCodeNames));
    }

    private static final void errorMessage(String errorMessage, @Nullable Exception ex) {
        if (!warnOnly) {
            throw new IllegalStateException(errorMessage, ex);
        }
        System.err.println(errorMessage);
    }

    static {
        String cmd = System.getProperty("sun.java.command");
        if (cmd.contains("-Aorg.robolectric.annotation.processing.")) {
            System.err.println("Robolectric's AndroidVersions is running in warning mode, no errors will be thrown.");
            warnOnly = true;
        } else {
            warnOnly = false;
        }
        AndroidRelease currentRelease = null;
        information = AndroidVersions.gatherStaticSdkInformationFromThisClass();
        try {
            InputStream is = AndroidVersions.class.getClassLoader().getResourceAsStream("build.prop");
            if (is != null) {
                Properties buildProps = new Properties();
                buildProps.load(is);
                currentRelease = AndroidVersions.computeCurrentSdkFromBuildProps(buildProps);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CURRENT = currentRelease;
    }

    static class SdkInformation {
        final List<AndroidRelease> allReleases;
        final List<Class<? extends AndroidRelease>> classesWithIllegalNames;
        final AndroidRelease latestRelease;
        final AndroidRelease earliestUnreleased;
        final Map<Integer, AndroidRelease> sdkIntToAllReleases = new HashMap<Integer, AndroidRelease>();
        final Map<String, AndroidRelease> shortCodeToAllReleases = new HashMap<String, AndroidRelease>();
        final List<Map.Entry<AndroidRelease, AndroidRelease>> sdkIntCollisions = new ArrayList<Map.Entry<AndroidRelease, AndroidRelease>>();
        Map.Entry<AndroidRelease, AndroidRelease> sdkApiMisordered = null;

        public SdkInformation(List<AndroidRelease> releases, List<Class<? extends AndroidRelease>> classesWithIllegalNames) {
            this.allReleases = releases;
            this.classesWithIllegalNames = classesWithIllegalNames;
            AndroidRelease latestRelease = null;
            AndroidRelease earliestUnreleased = null;
            for (AndroidRelease release : this.allReleases) {
                if (release.isReleased()) {
                    if (latestRelease != null && latestRelease.compareTo(release) <= 0) continue;
                    latestRelease = release;
                    continue;
                }
                if (earliestUnreleased != null && earliestUnreleased.compareTo(release) >= 0) continue;
                earliestUnreleased = release;
            }
            this.latestRelease = latestRelease;
            this.earliestUnreleased = earliestUnreleased;
            this.verifyStaticInformation();
        }

        private void verifyStaticInformation() {
            for (AndroidRelease release : this.allReleases) {
                AndroidRelease sdkCollision = this.sdkIntToAllReleases.put(release.getSdkInt(), release);
                if (sdkCollision != null) {
                    this.sdkIntCollisions.add(new AbstractMap.SimpleEntry<AndroidRelease, AndroidRelease>(release, sdkCollision));
                }
                this.shortCodeToAllReleases.put(release.getShortCode(), release);
            }
            if (this.earliestUnreleased != null && this.latestRelease != null && this.latestRelease.getSdkInt() >= this.earliestUnreleased.getSdkInt()) {
                this.sdkApiMisordered = new AbstractMap.SimpleEntry<AndroidRelease, AndroidRelease>(this.latestRelease, this.earliestUnreleased);
            }
        }

        private void handleStaticErrors() {
            StringBuilder errors = new StringBuilder();
            if (!this.classesWithIllegalNames.isEmpty()) {
                errors.append("The following classes do not follow the naming criteria for ").append("releases or do not have the short codes in ").append("their internal fields. Please correct them: ").append(this.classesWithIllegalNames).append("\n");
            }
            if (this.sdkApiMisordered != null) {
                errors.append("The latest released sdk ").append(this.sdkApiMisordered.getKey().getShortCode()).append(" has a sdkInt greater than the earliest unreleased sdk ").append(this.sdkApiMisordered.getValue().getShortCode()).append("this implies sdks were released out of order which is highly unlikely.\n");
            }
            if (!this.sdkIntCollisions.isEmpty()) {
                errors.append("The following sdks have different shortCodes, but identical sdkInt versions:\n");
                for (Map.Entry<AndroidRelease, AndroidRelease> entry : this.sdkIntCollisions) {
                    errors.append("Both ").append(entry.getKey().getShortCode()).append(" and ").append(entry.getValue().getShortCode()).append("have the same sdkInt value of ").append(entry.getKey().getSdkInt()).append("\n");
                }
            }
            if (errors.length() > 0) {
                AndroidVersions.errorMessage(errors.append("Please check the AndroidReleases defined ").append("in ").append(AndroidVersions.class.getName()).append("and ensure they are aligned with the versions of").append(" Android.").toString(), null);
            }
        }

        public AndroidRelease computeCurrentSdk(int reportedVersion, String releaseName, final String codename, List<String> activeCodeNames) {
            AndroidRelease current = null;
            if (Objects.equals(codename, "REL")) {
                current = this.sdkIntToAllReleases.get(reportedVersion);
                if (current != null && !current.isReleased()) {
                    AndroidVersions.errorMessage("The current sdk " + current.getShortCode() + " has been released. Please update the contents of " + AndroidVersions.class.getName() + " to mark sdk " + current.getShortCode() + " as released.", null);
                }
            } else {
                ArrayList<String> activeCodenameLetter = new ArrayList<String>();
                for (String name : activeCodeNames) {
                    activeCodenameLetter.add(name.toUpperCase(Locale.getDefault()).substring(0, 1));
                }
                if (codename != null) {
                    StringBuilder detectedProblems = new StringBuilder();
                    String foundCode = codename.toUpperCase(Locale.getDefault()).substring(0, 1);
                    int loc = activeCodenameLetter.indexOf(foundCode);
                    if (loc == -1) {
                        detectedProblems.append("The current codename's (").append(codename).append(") first letter (").append(foundCode).append(") is not in the list of active code's first letters: ").append(activeCodenameLetter).append("\n");
                    } else {
                        current = this.shortCodeToAllReleases.get(codename);
                        if (current == null) {
                            current = this.shortCodeToAllReleases.get(String.valueOf(foundCode));
                        }
                    }
                    if (current == null) {
                        detectedProblems.append("No known release is associated with the shortCode of \"").append(foundCode).append("\" or \"").append(codename).append("\"\n");
                    } else if (current.isReleased()) {
                        detectedProblems.append("The current sdk ").append(current.getShortCode()).append(" has been been marked as released. Please update the ").append("contents of current sdk jar to the released version.\n");
                    }
                    if (detectedProblems.length() > 0) {
                        AndroidVersions.errorMessage(detectedProblems.toString(), null);
                    }
                    if (current == null) {
                        current = new AndroidUnreleased(){

                            @Override
                            public int getSdkInt() {
                                return 10000;
                            }

                            @Override
                            public String getShortCode() {
                                return codename.toUpperCase(Locale.getDefault()).substring(0, 1);
                            }

                            @Override
                            public String getVersion() {
                                return "";
                            }
                        };
                    }
                }
            }
            return current;
        }
    }

    public static abstract class AndroidRelease
    implements Comparable<AndroidRelease> {
        public abstract int getSdkInt();

        public abstract String getShortCode();

        public abstract boolean isReleased();

        public abstract String getVersion();

        @Override
        public int compareTo(AndroidRelease other) {
            if (other == null) {
                throw new IllegalStateException("Only " + AndroidVersions.class.getName() + " should define Releases, illegal class " + other.getClass());
            }
            return Integer.compare(this.getSdkInt(), other.getSdkInt());
        }

        public String toString() {
            return "Android " + (this.isReleased() ? "" : "Future ") + "Release: " + this.getVersion() + " ( sdk: " + this.getSdkInt() + " code: " + this.getShortCode() + " )";
        }
    }

    public static final class Unbound
    extends AndroidUnreleased {
        public static final int SDK_INT = -1;
        public static final String SHORT_CODE = "_";
        public static final String VERSION = "_";

        @Override
        public int getSdkInt() {
            return -1;
        }

        @Override
        public String getShortCode() {
            return "_";
        }

        @Override
        public String getVersion() {
            return "_";
        }
    }

    public static final class V
    extends AndroidUnreleased {
        public static final int SDK_INT = 35;
        public static final String SHORT_CODE = "V";
        public static final String VERSION = "15";

        @Override
        public int getSdkInt() {
            return 35;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class U
    extends AndroidReleased {
        public static final int SDK_INT = 34;
        public static final String SHORT_CODE = "U";
        public static final String VERSION = "14.0";

        @Override
        public int getSdkInt() {
            return 34;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class T
    extends AndroidReleased {
        public static final int SDK_INT = 33;
        public static final String SHORT_CODE = "T";
        public static final String VERSION = "13.0";

        @Override
        public int getSdkInt() {
            return 33;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class Sv2
    extends AndroidReleased {
        public static final int SDK_INT = 32;
        public static final String SHORT_CODE = "Sv2";
        public static final String VERSION = "12.1";

        @Override
        public int getSdkInt() {
            return 32;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class S
    extends AndroidReleased {
        public static final int SDK_INT = 31;
        public static final String SHORT_CODE = "S";
        public static final String VERSION = "12.0";

        @Override
        public int getSdkInt() {
            return 31;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class R
    extends AndroidReleased {
        public static final int SDK_INT = 30;
        public static final String SHORT_CODE = "R";
        public static final String VERSION = "11.0";

        @Override
        public int getSdkInt() {
            return 30;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class Q
    extends AndroidReleased {
        public static final int SDK_INT = 29;
        public static final String SHORT_CODE = "Q";
        public static final String VERSION = "10.0";

        @Override
        public int getSdkInt() {
            return 29;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class P
    extends AndroidReleased {
        public static final int SDK_INT = 28;
        public static final String SHORT_CODE = "P";
        public static final String VERSION = "9.0";

        @Override
        public int getSdkInt() {
            return 28;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class OMR1
    extends AndroidReleased {
        public static final int SDK_INT = 27;
        public static final String SHORT_CODE = "OMR1";
        public static final String VERSION = "8.1";

        @Override
        public int getSdkInt() {
            return 27;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class O
    extends AndroidReleased {
        public static final int SDK_INT = 26;
        public static final String SHORT_CODE = "O";
        public static final String VERSION = "8.0";

        @Override
        public int getSdkInt() {
            return 26;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class NMR1
    extends AndroidReleased {
        public static final int SDK_INT = 25;
        public static final String SHORT_CODE = "NMR1";
        public static final String VERSION = "7.1";

        @Override
        public int getSdkInt() {
            return 25;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class N
    extends AndroidReleased {
        public static final int SDK_INT = 24;
        public static final String SHORT_CODE = "N";
        public static final String VERSION = "7.0";

        @Override
        public int getSdkInt() {
            return 24;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class M
    extends AndroidReleased {
        public static final int SDK_INT = 23;
        public static final String SHORT_CODE = "M";
        public static final String VERSION = "6.0";

        @Override
        public int getSdkInt() {
            return 23;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class LMR1
    extends AndroidReleased {
        public static final int SDK_INT = 22;
        public static final String SHORT_CODE = "LMR1";
        public static final String VERSION = "5.1";

        @Override
        public int getSdkInt() {
            return 22;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class L
    extends AndroidReleased {
        public static final int SDK_INT = 21;
        public static final String SHORT_CODE = "L";
        public static final String VERSION = "5.0";

        @Override
        public int getSdkInt() {
            return 21;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class K
    extends AndroidReleased {
        public static final int SDK_INT = 19;
        public static final String SHORT_CODE = "K";
        public static final String VERSION = "4.4";

        @Override
        public int getSdkInt() {
            return 19;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class JMR2
    extends AndroidReleased {
        public static final int SDK_INT = 18;
        public static final String SHORT_CODE = "JMR2";
        public static final String VERSION = "4.3";

        @Override
        public int getSdkInt() {
            return 18;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class JMR1
    extends AndroidReleased {
        public static final int SDK_INT = 17;
        public static final String SHORT_CODE = "JMR1";
        public static final String VERSION = "4.2";

        @Override
        public int getSdkInt() {
            return 17;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static final class J
    extends AndroidReleased {
        public static final int SDK_INT = 16;
        public static final String SHORT_CODE = "J";
        public static final String VERSION = "4.1";

        @Override
        public int getSdkInt() {
            return 16;
        }

        @Override
        public String getShortCode() {
            return SHORT_CODE;
        }

        @Override
        public String getVersion() {
            return VERSION;
        }
    }

    public static abstract class AndroidUnreleased
    extends AndroidRelease {
        @Override
        public boolean isReleased() {
            return false;
        }
    }

    public static abstract class AndroidReleased
    extends AndroidRelease {
        @Override
        public boolean isReleased() {
            return true;
        }
    }
}

