/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Objects;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class SuccinctRank {
    private static final int SMALL_BITMAP_THRESHOLD = 16;
    private static final int KEY_SPACE = 65536;
    private static final int BITS_PER_WORD = 64;
    private static final int WORDS_PER_SUPERBLOCK = 8;
    private static final int SUPERBLOCK_COUNT = 128;
    private static final int WORDS_PER_BLOCK = 4;
    private static final int BLOCKS_PER_CONTAINER = 256;
    private static final int BITS_PER_PACKED_BLOCK = 9;
    private static final long BLOCK_MASK = 511L;
    private static final int[] WORD_INDEX = new int[65536];
    private static final int[] CUMULATIVE_RANK_INDEX = new int[65536];
    private static final long[] RANK_BIT_MASK = new long[65536];
    private final RoaringBitmap bitmap;
    private final long[] highBits;
    private final long[] highRankCount;
    private final long[] cumulativePerContainer;
    private final char[][] containerCumulativeRanks;

    private SuccinctRank(RoaringBitmap bitmap, long[] highBits, long[] highRankCount, long[] cumulativePerContainer, char[][] containerCumulativeRanks) {
        this.bitmap = bitmap;
        this.highBits = highBits;
        this.highRankCount = highRankCount;
        this.cumulativePerContainer = cumulativePerContainer;
        this.containerCumulativeRanks = containerCumulativeRanks;
    }

    public static SuccinctRank build(RoaringBitmap source) {
        Objects.requireNonNull(source, "source bitmap must not be null");
        RoaringArray ra = source.highLowContainer;
        int containerCount = ra.size();
        long[] cumulativePerContainer = new long[containerCount + 1];
        char[][] containerCumulativeRanks = new char[containerCount][];
        long acc = 0L;
        for (int i = 0; i < containerCount; ++i) {
            Container container = ra.getContainerAtIndex(i);
            cumulativePerContainer[i + 1] = acc += (long)container.getCardinality();
            if (!(container instanceof BitmapContainer)) continue;
            containerCumulativeRanks[i] = SuccinctRank.buildCumulativeRanks((BitmapContainer)container);
        }
        if (containerCount <= 16) {
            return new SuccinctRank(source, null, null, cumulativePerContainer, containerCumulativeRanks);
        }
        long[] highBits = new long[1024];
        for (int i = 0; i < containerCount; ++i) {
            int key = Util.lowbitsAsInteger(ra.getKeyAtIndex(i));
            int n = key >>> 6;
            highBits[n] = highBits[n] | 1L << (key & 0x3F);
        }
        long[] highRankCount = SuccinctRank.buildHighKeyRankIndex(highBits);
        return new SuccinctRank(source, highBits, highRankCount, cumulativePerContainer, containerCumulativeRanks);
    }

    private static long[] buildHighKeyRankIndex(long[] highBits) {
        long[] count = new long[256];
        long cumulative = 0L;
        int countPos = 0;
        for (int wordIdx = 0; wordIdx < highBits.length; wordIdx += 8) {
            count[countPos] = cumulative;
            long packed = 0L;
            long blockCumulative = Long.bitCount(highBits[wordIdx]);
            int superblockLimit = Math.min(8, highBits.length - wordIdx);
            for (int j = 1; j < superblockLimit; ++j) {
                packed |= (blockCumulative & 0x1FFL) << 9 * (j - 1);
                blockCumulative += (long)Long.bitCount(highBits[wordIdx + j]);
            }
            count[countPos + 1] = packed;
            cumulative += blockCumulative;
            countPos += 2;
        }
        return count;
    }

    private static char[] buildCumulativeRanks(BitmapContainer bc) {
        long[] bitmap = bc.bitmap;
        char[] cumulativeRanks = new char[256];
        int cumulative = 0;
        for (int block = 0; block < 256; ++block) {
            cumulativeRanks[block] = (char)cumulative;
            int baseWord = block * 4;
            cumulative += Long.bitCount(bitmap[baseWord]);
            cumulative += Long.bitCount(bitmap[baseWord + 1]);
            cumulative += Long.bitCount(bitmap[baseWord + 2]);
            cumulative += Long.bitCount(bitmap[baseWord + 3]);
        }
        return cumulativeRanks;
    }

    public long rank(int x) {
        int containerIndex;
        if (this.containerCount() == 0) {
            return 0L;
        }
        char hi = Util.highbits(x);
        char lo = Util.lowbits(x);
        int n = containerIndex = this.highBits == null ? this.findContainerLinear(hi) : this.rank1High(hi) - 1;
        if (containerIndex < 0) {
            return 0L;
        }
        RoaringArray ra = this.bitmap.highLowContainer;
        int actualHi = Util.lowbitsAsInteger(ra.getKeyAtIndex(containerIndex));
        if (actualHi < hi) {
            return this.cumulativePerContainer[containerIndex + 1];
        }
        int containerRank = this.containerRank(containerIndex, lo);
        return this.cumulativePerContainer[containerIndex] + (long)containerRank;
    }

    private int findContainerLinear(int hi) {
        RoaringArray ra = this.bitmap.highLowContainer;
        int lastSmaller = -1;
        int i = 0;
        while (i < ra.size()) {
            int key = Util.lowbitsAsInteger(ra.getKeyAtIndex(i));
            if (key == hi) {
                return i;
            }
            if (key >= hi) break;
            lastSmaller = i++;
        }
        return lastSmaller;
    }

    private int rank1High(int h) {
        if (h < 0) {
            return 0;
        }
        if (h >= 65536) {
            h = 65535;
        }
        int wordIndex = h >>> 6;
        int bitInWord = h & 0x3F;
        int superblockIndex = wordIndex >>> 3;
        int wordInSuperblock = wordIndex & 7;
        long rank = this.highRankCount[superblockIndex * 2];
        if (wordInSuperblock > 0) {
            long packed = this.highRankCount[superblockIndex * 2 + 1];
            rank += packed >>> 9 * (wordInSuperblock - 1) & 0x1FFL;
        }
        long mask = -1L >>> 63 - bitInWord;
        return (int)(rank += (long)Long.bitCount(this.highBits[wordIndex] & mask));
    }

    private int containerRank(int containerIndex, char lowKey) {
        char[] cumulativeRanks = this.containerCumulativeRanks[containerIndex];
        if (cumulativeRanks != null) {
            return this.bitmapContainerFastRank(containerIndex, cumulativeRanks, lowKey);
        }
        return this.bitmap.highLowContainer.getContainerAtIndex(containerIndex).rank(lowKey);
    }

    private int bitmapContainerFastRank(int containerIndex, char[] cumulativeRanks, char lo) {
        int loInt = Util.lowbitsAsInteger(lo);
        int wordIndex = WORD_INDEX[loInt];
        BitmapContainer bc = (BitmapContainer)this.bitmap.highLowContainer.getContainerAtIndex(containerIndex);
        long[] words = bc.bitmap;
        int rank = cumulativeRanks[CUMULATIVE_RANK_INDEX[loInt]];
        int mod4 = wordIndex & 3;
        int blockBase = wordIndex - mod4;
        switch (mod4) {
            case 3: {
                rank += Long.bitCount(words[blockBase + 2]);
            }
            case 2: {
                rank += Long.bitCount(words[blockBase + 1]);
            }
            case 1: {
                rank += Long.bitCount(words[blockBase]);
            }
        }
        long lastWord = words[wordIndex] & RANK_BIT_MASK[loInt];
        if (lastWord != 0L) {
            rank += Long.bitCount(lastWord);
        }
        return rank;
    }

    public long cardinality() {
        return this.cumulativePerContainer[this.containerCount()];
    }

    public RoaringBitmap getUnderlyingBitmap() {
        return this.bitmap;
    }

    public boolean usesLinearScan() {
        return this.highBits == null;
    }

    public int containerCount() {
        return this.bitmap.highLowContainer.size();
    }

    static {
        for (int low = 0; low < 65536; ++low) {
            SuccinctRank.WORD_INDEX[low] = low >>> 6;
            SuccinctRank.CUMULATIVE_RANK_INDEX[low] = low >>> 8;
            int bitInWord = low & 0x3F;
            SuccinctRank.RANK_BIT_MASK[low] = bitInWord == 63 ? -1L : (1L << bitInWord + 1) - 1L;
        }
    }
}

