/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.roaringbitmap.Container;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;

public abstract class MappeableContainer
implements Iterable<Short>,
Cloneable,
Externalizable {
    public static String[] ContainerNames = new String[]{"mappeablebitmap", "mappeablearray", "mappeablerun"};

    public static MappeableContainer rangeOfOnes(int start, int last) {
        int arrayContainerOverRunThreshold = 2;
        int cardinality = last - start;
        if (cardinality <= 2) {
            return new MappeableArrayContainer(start, last);
        }
        return new MappeableRunContainer(start, last);
    }

    public abstract MappeableContainer add(int var1, int var2);

    public abstract MappeableContainer add(short var1);

    public abstract boolean isEmpty();

    public abstract MappeableContainer and(MappeableArrayContainer var1);

    public abstract MappeableContainer and(MappeableBitmapContainer var1);

    protected MappeableContainer and(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.and((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.and((MappeableRunContainer)x);
        }
        return this.and((MappeableBitmapContainer)x);
    }

    protected abstract int andCardinality(MappeableArrayContainer var1);

    protected abstract int andCardinality(MappeableBitmapContainer var1);

    protected abstract int andCardinality(MappeableRunContainer var1);

    public int xorCardinality(MappeableContainer other) {
        return this.getCardinality() + other.getCardinality() - 2 * this.andCardinality(other);
    }

    public int andCardinality(MappeableContainer x) {
        if (this.getCardinality() == 0) {
            return 0;
        }
        if (x.getCardinality() == 0) {
            return 0;
        }
        if (x instanceof MappeableArrayContainer) {
            return this.andCardinality((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return this.andCardinality((MappeableBitmapContainer)x);
        }
        return this.andCardinality((MappeableRunContainer)x);
    }

    public abstract MappeableContainer and(MappeableRunContainer var1);

    public abstract MappeableContainer andNot(MappeableArrayContainer var1);

    public abstract MappeableContainer andNot(MappeableBitmapContainer var1);

    protected MappeableContainer andNot(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.andNot((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.andNot((MappeableRunContainer)x);
        }
        return this.andNot((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer andNot(MappeableRunContainer var1);

    public abstract void clear();

    public abstract MappeableContainer clone();

    public abstract boolean contains(short var1);

    public boolean contains(MappeableContainer subset) {
        if (subset instanceof MappeableRunContainer) {
            return this.contains((MappeableRunContainer)subset);
        }
        if (subset instanceof MappeableArrayContainer) {
            return this.contains((MappeableArrayContainer)subset);
        }
        if (subset instanceof MappeableBitmapContainer) {
            return this.contains((MappeableBitmapContainer)subset);
        }
        return false;
    }

    protected abstract boolean contains(MappeableRunContainer var1);

    protected abstract boolean contains(MappeableArrayContainer var1);

    protected abstract boolean contains(MappeableBitmapContainer var1);

    public abstract void fillLeastSignificant16bits(int[] var1, int var2, int var3);

    public abstract MappeableContainer flip(short var1);

    protected abstract int getArraySizeInBytes();

    public abstract int getCardinality();

    public String getContainerName() {
        if (this instanceof MappeableBitmapContainer) {
            return ContainerNames[0];
        }
        if (this instanceof MappeableArrayContainer) {
            return ContainerNames[1];
        }
        return ContainerNames[2];
    }

    public abstract ShortIterator getReverseShortIterator();

    public abstract PeekableShortIterator getShortIterator();

    public abstract void forEach(short var1, IntConsumer var2);

    public abstract int getSizeInBytes();

    public abstract MappeableContainer iadd(int var1, int var2);

    public abstract MappeableContainer iand(MappeableArrayContainer var1);

    public abstract MappeableContainer iand(MappeableBitmapContainer var1);

    protected MappeableContainer iand(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.iand((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.iand((MappeableRunContainer)x);
        }
        return this.iand((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer iand(MappeableRunContainer var1);

    public abstract MappeableContainer iandNot(MappeableArrayContainer var1);

    public abstract MappeableContainer iandNot(MappeableBitmapContainer var1);

    protected MappeableContainer iandNot(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.iandNot((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.iandNot((MappeableRunContainer)x);
        }
        return this.iandNot((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer iandNot(MappeableRunContainer var1);

    public abstract MappeableContainer inot(int var1, int var2);

    public abstract boolean intersects(MappeableArrayContainer var1);

    public abstract boolean intersects(MappeableBitmapContainer var1);

    public boolean intersects(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.intersects((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return this.intersects((MappeableBitmapContainer)x);
        }
        return this.intersects((MappeableRunContainer)x);
    }

    public abstract boolean intersects(MappeableRunContainer var1);

    public abstract MappeableContainer ior(MappeableArrayContainer var1);

    public abstract MappeableContainer ior(MappeableBitmapContainer var1);

    protected MappeableContainer ior(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.ior((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.ior((MappeableRunContainer)x);
        }
        return this.ior((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer ior(MappeableRunContainer var1);

    public abstract MappeableContainer iremove(int var1, int var2);

    protected abstract boolean isArrayBacked();

    public abstract MappeableContainer ixor(MappeableArrayContainer var1);

    public abstract MappeableContainer ixor(MappeableBitmapContainer var1);

    protected MappeableContainer ixor(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.ixor((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.ixor((MappeableRunContainer)x);
        }
        return this.ixor((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer ixor(MappeableRunContainer var1);

    public MappeableContainer lazyIOR(MappeableContainer x) {
        if (this instanceof MappeableArrayContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableArrayContainer)this).lazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableArrayContainer)this);
            }
            return ((MappeableRunContainer)x).lazyor((MappeableArrayContainer)this);
        }
        if (this instanceof MappeableRunContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableRunContainer)this).ilazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableRunContainer)this);
            }
            return this.ior((MappeableRunContainer)x);
        }
        if (x instanceof MappeableArrayContainer) {
            return ((MappeableBitmapContainer)this).ilazyor((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return ((MappeableBitmapContainer)this).ilazyor((MappeableBitmapContainer)x);
        }
        return ((MappeableBitmapContainer)this).ilazyor((MappeableRunContainer)x);
    }

    public MappeableContainer lazyOR(MappeableContainer x) {
        if (this instanceof MappeableArrayContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableArrayContainer)this).lazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableArrayContainer)this);
            }
            return ((MappeableRunContainer)x).lazyor((MappeableArrayContainer)this);
        }
        if (this instanceof MappeableRunContainer) {
            if (x instanceof MappeableArrayContainer) {
                return ((MappeableRunContainer)this).lazyor((MappeableArrayContainer)x);
            }
            if (x instanceof MappeableBitmapContainer) {
                return ((MappeableBitmapContainer)x).lazyor((MappeableRunContainer)this);
            }
            return this.or((MappeableRunContainer)x);
        }
        if (x instanceof MappeableArrayContainer) {
            return ((MappeableBitmapContainer)this).lazyor((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableBitmapContainer) {
            return ((MappeableBitmapContainer)this).lazyor((MappeableBitmapContainer)x);
        }
        return ((MappeableBitmapContainer)this).lazyor((MappeableRunContainer)x);
    }

    public abstract MappeableContainer limit(int var1);

    public abstract MappeableContainer not(int var1, int var2);

    abstract int numberOfRuns();

    public abstract MappeableContainer or(MappeableArrayContainer var1);

    public abstract MappeableContainer or(MappeableBitmapContainer var1);

    protected MappeableContainer or(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.or((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.or((MappeableRunContainer)x);
        }
        return this.or((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer or(MappeableRunContainer var1);

    public abstract int rank(short var1);

    public abstract MappeableContainer remove(int var1, int var2);

    public abstract MappeableContainer remove(short var1);

    public abstract MappeableContainer repairAfterLazy();

    public abstract MappeableContainer runOptimize();

    public abstract short select(int var1);

    public abstract int serializedSizeInBytes();

    public abstract Container toContainer();

    public abstract void trim();

    protected abstract void writeArray(DataOutput var1) throws IOException;

    public abstract MappeableContainer xor(MappeableArrayContainer var1);

    public abstract MappeableContainer xor(MappeableBitmapContainer var1);

    protected MappeableContainer xor(MappeableContainer x) {
        if (x instanceof MappeableArrayContainer) {
            return this.xor((MappeableArrayContainer)x);
        }
        if (x instanceof MappeableRunContainer) {
            return this.xor((MappeableRunContainer)x);
        }
        return this.xor((MappeableBitmapContainer)x);
    }

    public abstract MappeableContainer xor(MappeableRunContainer var1);

    public abstract MappeableBitmapContainer toBitmapContainer();

    public abstract int first();

    public abstract int last();

    protected void assertNonEmpty(boolean condition) {
        if (condition) {
            throw new NoSuchElementException("Empty " + this.getContainerName());
        }
    }
}

