/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;

final class RawArrayContainerShortIterator
implements PeekableShortIterator {
    int pos;
    MappeableArrayContainer parent;
    short[] content;

    RawArrayContainerShortIterator(MappeableArrayContainer p) {
        this.parent = p;
        if (!p.isArrayBacked()) {
            throw new RuntimeException("internal bug");
        }
        this.content = p.content.array();
        this.pos = 0;
    }

    @Override
    public void advanceIfNeeded(short minval) {
        this.pos = Util.advanceUntil(this.content, this.pos - 1, this.parent.cardinality, minval);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public short next() {
        return this.content[this.pos++];
    }

    @Override
    public int nextAsInt() {
        return BufferUtil.toIntUnsigned(this.content[this.pos++]);
    }

    @Override
    public short peekNext() {
        return this.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.removeAtIndex(this.pos - 1);
        --this.pos;
    }
}

