/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.nio.ShortBuffer;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;

public class ArrayBatchIterator
implements ContainerBatchIterator {
    private int index = 0;
    private final MappeableArrayContainer array;

    public ArrayBatchIterator(MappeableArrayContainer array) {
        this.array = array;
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        ShortBuffer data = this.array.content;
        while (consumed < buffer.length && this.index < this.array.getCardinality()) {
            buffer[consumed++] = key + BufferUtil.toIntUnsigned(data.get(this.index++));
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }
}

