/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainerShortIterator;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.RawArrayContainerShortIterator;
import org.roaringbitmap.buffer.RawReverseArrayContainerShortIterator;
import org.roaringbitmap.buffer.ReverseMappeableArrayContainerShortIterator;

public final class MappeableArrayContainer
extends MappeableContainer
implements Cloneable {
    private static final int DEFAULT_INIT_SIZE = 4;
    protected static final int DEFAULT_MAX_SIZE = 4096;
    private static final long serialVersionUID = 1L;
    protected int cardinality = 0;
    protected ShortBuffer content;

    protected static int getArraySizeInBytes(int cardinality) {
        return cardinality * 2;
    }

    protected static int serializedSizeInBytes(int cardinality) {
        return cardinality * 2 + 2;
    }

    public MappeableArrayContainer() {
        this(4);
    }

    public MappeableArrayContainer(ArrayContainer bc) {
        this.cardinality = bc.getCardinality();
        this.content = bc.toShortBuffer();
    }

    public MappeableArrayContainer(int capacity) {
        this.content = ShortBuffer.allocate(capacity);
    }

    public MappeableArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun;
        this.content = ShortBuffer.allocate(valuesInRange);
        short[] sarray = this.content.array();
        for (int i = 0; i < valuesInRange; ++i) {
            sarray[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private MappeableArrayContainer(int newCard, ShortBuffer newContent) {
        this.cardinality = newCard;
        ShortBuffer tmp = newContent.duplicate();
        this.content = ShortBuffer.allocate(Math.max(newCard, tmp.limit()));
        tmp.rewind();
        this.content.put(tmp);
    }

    public MappeableArrayContainer(ShortBuffer array, int cardinality) {
        if (array.limit() != cardinality) {
            throw new RuntimeException("Mismatch between buffer and cardinality");
        }
        this.cardinality = cardinality;
        this.content = array;
    }

    @Override
    public MappeableContainer add(int begin, int end) {
        int indexend;
        int indexstart = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            MappeableBitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(newcardinality, this.content);
        if (!BufferUtil.isBackedBySimpleArray(answer.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        BufferUtil.arraycopy(this.content, indexend, answer.content, indexstart + rangelength, this.cardinality - indexend);
        short[] answerarray = answer.content.array();
        for (int k = 0; k < rangelength; ++k) {
            answerarray[k + indexstart] = (short)(begin + k);
        }
        answer.cardinality = newcardinality;
        return answer;
    }

    @Override
    public MappeableContainer add(short x) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] sarray = this.content.array();
            int loc = Util.unsignedBinarySearch(sarray, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= sarray.length) {
                    this.increaseCapacity();
                    sarray = this.content.array();
                }
                System.arraycopy(sarray, -loc - 1, sarray, -loc, this.cardinality + loc + 1);
                sarray[-loc - 1] = x;
                ++this.cardinality;
            }
        } else {
            int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= this.content.limit()) {
                    this.increaseCapacity();
                }
                for (int k = this.cardinality; k > -loc - 1; --k) {
                    this.content.put(k, this.content.get(k - 1));
                }
                this.content.put(-loc - 1, x);
                ++this.cardinality;
            }
        }
        return this;
    }

    private int advance(ShortIterator it) {
        if (it.hasNext()) {
            return BufferUtil.toIntUnsigned(it.next());
        }
        return -1;
    }

    @Override
    public MappeableArrayContainer and(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        MappeableArrayContainer answer = new MappeableArrayContainer(desiredCapacity);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedIntersect2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer x) {
        return x.and(this);
    }

    @Override
    public MappeableContainer and(MappeableRunContainer value2) {
        return value2.and(this);
    }

    @Override
    public MappeableArrayContainer andNot(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        MappeableArrayContainer answer = new MappeableArrayContainer(desiredCapacity);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedDifference(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableArrayContainer andNot(MappeableBitmapContainer value2) {
        MappeableArrayContainer answer = new MappeableArrayContainer(this.content.limit());
        int pos = 0;
        short[] sarray = answer.content.array();
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                short v = c[k];
                if (value2.contains(v)) continue;
                sarray[pos++] = v;
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                short v = this.content.get(k);
                if (value2.contains(v)) continue;
                sarray[pos++] = v;
            }
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableRunContainer x) {
        int writeLocation = 0;
        if (x.nbrruns == 0) {
            return this.clone();
        }
        ShortBuffer buffer = ShortBuffer.allocate(this.cardinality);
        int runStart = BufferUtil.toIntUnsigned(x.getValue(0));
        int runEnd = runStart + BufferUtil.toIntUnsigned(x.getLength(0));
        int whichRun = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            short val = this.content.get(i);
            int valInt = BufferUtil.toIntUnsigned(val);
            if (valInt < runStart) {
                buffer.put(writeLocation++, val);
                continue;
            }
            if (valInt <= runEnd) continue;
            do {
                if (whichRun + 1 < x.nbrruns) {
                    runStart = BufferUtil.toIntUnsigned(x.getValue(++whichRun));
                    runEnd = runStart + BufferUtil.toIntUnsigned(x.getLength(whichRun));
                    continue;
                }
                runEnd = 65537;
                runStart = 65537;
            } while (valInt > runEnd);
            --i;
        }
        return new MappeableArrayContainer(writeLocation, buffer);
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public MappeableArrayContainer clone() {
        return new MappeableArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(short x) {
        return BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    private void emit(short val) {
        if (this.cardinality == this.content.limit()) {
            this.increaseCapacity(true);
        }
        this.content.put(this.cardinality++, val);
    }

    public boolean equals(Object o) {
        if (o instanceof MappeableArrayContainer) {
            MappeableArrayContainer srb = (MappeableArrayContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(srb.content)) {
                short[] t = this.content.array();
                short[] sr = srb.content.array();
                for (int i = 0; i < this.cardinality; ++i) {
                    if (t[i] == sr[i]) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < this.cardinality; ++i) {
                    if (this.content.get(i) == srb.content.get(i)) continue;
                    return false;
                }
            }
            return true;
        }
        if (o instanceof MappeableRunContainer) {
            return o.equals(this);
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                x[k + i] = BufferUtil.toIntUnsigned(c[k]) | mask;
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                x[k + i] = BufferUtil.toIntUnsigned(this.content.get(k)) | mask;
            }
        }
    }

    @Override
    public MappeableContainer flip(short x) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] sarray = this.content.array();
            int loc = Util.unsignedBinarySearch(sarray, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= sarray.length) {
                    this.increaseCapacity();
                    sarray = this.content.array();
                }
                System.arraycopy(sarray, -loc - 1, sarray, -loc, this.cardinality + loc + 1);
                sarray[-loc - 1] = x;
                ++this.cardinality;
            } else {
                System.arraycopy(sarray, loc + 1, sarray, loc, this.cardinality - loc - 1);
                --this.cardinality;
            }
            return this;
        }
        int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4096) {
                MappeableBitmapContainer a = this.toBitmapContainer();
                a.add(x);
                return a;
            }
            if (this.cardinality >= this.content.limit()) {
                this.increaseCapacity();
            }
            for (int k = this.cardinality; k > -loc - 1; --k) {
                this.content.put(k, this.content.get(k - 1));
            }
            this.content.put(-loc - 1, x);
            ++this.cardinality;
        } else {
            for (int k = loc + 1; k < this.cardinality; --k) {
                this.content.put(k - 1, this.content.get(k));
            }
            --this.cardinality;
        }
        return this;
    }

    @Override
    protected int getArraySizeInBytes() {
        return MappeableArrayContainer.getArraySizeInBytes(this.cardinality);
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        if (this.isArrayBacked()) {
            return new RawReverseArrayContainerShortIterator(this);
        }
        return new ReverseMappeableArrayContainerShortIterator(this);
    }

    @Override
    public ShortIterator getShortIterator() {
        if (this.isArrayBacked()) {
            return new RawArrayContainerShortIterator(this);
        }
        return new MappeableArrayContainerShortIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * hash + this.content.get(k);
        }
        return hash;
    }

    @Override
    public MappeableContainer iadd(int begin, int end) {
        int indexend;
        int indexstart = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            MappeableBitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        if (newcardinality >= this.content.limit()) {
            this.increaseCapacity(newcardinality);
        }
        BufferUtil.arraycopy(this.content, indexend, this.content, indexstart + rangelength, this.cardinality - indexend);
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] contentarray = this.content.array();
            for (int k = 0; k < rangelength; ++k) {
                contentarray[k + indexstart] = (short)(begin + k);
            }
        } else {
            for (int k = 0; k < rangelength; ++k) {
                this.content.put(k + indexstart, (short)(begin + k));
            }
        }
        this.cardinality = newcardinality;
        return this;
    }

    @Override
    public MappeableArrayContainer iand(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        if (!BufferUtil.isBackedBySimpleArray(value1.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        value1.cardinality = BufferUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content.array());
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            short v = this.content.get(k);
            if (!value2.contains(v)) continue;
            this.content.put(pos++, v);
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableRunContainer value2) {
        return value2.and(this);
    }

    @Override
    public MappeableArrayContainer iandNot(MappeableArrayContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        this.cardinality = BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedDifference(this.content.array(), this.getCardinality(), value2.content.array(), value2.getCardinality(), this.content.array()) : BufferUtil.unsignedDifference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content.array());
        return this;
    }

    @Override
    public MappeableArrayContainer iandNot(MappeableBitmapContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        short[] c = this.content.array();
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            short v = c[k];
            if (value2.contains(v)) continue;
            c[pos++] = v;
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public MappeableContainer iandNot(MappeableRunContainer value2) {
        return this.andNot(value2);
    }

    private void increaseCapacity() {
        this.increaseCapacity(false);
    }

    private void increaseCapacity(boolean allowIllegalSize) {
        int newCapacity;
        int len = this.content.limit();
        int n = len == 0 ? 4 : (len < 64 ? len * 2 : (newCapacity = this.content.limit() < 1067 ? len * 3 / 2 : len * 5 / 4));
        if (newCapacity > 4096 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        ShortBuffer newContent = ShortBuffer.allocate(newCapacity);
        this.content.rewind();
        newContent.put(this.content);
        this.content = newContent;
    }

    private void increaseCapacity(int min) {
        int newCapacity;
        int len = this.content.limit();
        int n = len == 0 ? 4 : (len < 64 ? len * 2 : (newCapacity = len < 1024 ? len * 3 / 2 : len * 5 / 4));
        if (newCapacity < min) {
            newCapacity = min;
        }
        if (newCapacity > 4096) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840) {
            newCapacity = 4096;
        }
        ShortBuffer newContent = ShortBuffer.allocate(newCapacity);
        this.content.rewind();
        newContent.put(this.content);
        this.content = newContent;
    }

    @Override
    public MappeableContainer inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        ShortBuffer buffer = ShortBuffer.allocate(newValuesInRange);
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.limit()) {
                if (newCardinality > 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                ShortBuffer co = ShortBuffer.allocate(newCardinality);
                this.content.rewind();
                co.put(this.content);
                this.content = co;
            }
            for (int pos = this.cardinality - 1; pos > lastIndex; --pos) {
                this.content.put(pos + cardinalityChange, this.content.get(pos));
            }
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                for (int i = startIndex + newValuesInRange; i < newCardinality; ++i) {
                    this.content.put(i, this.content.get(i - cardinalityChange));
                }
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public boolean intersects(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        return BufferUtil.unsignedIntersects(value1.content, value1.getCardinality(), value2.content, value2.getCardinality());
    }

    @Override
    public boolean intersects(MappeableBitmapContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(MappeableRunContainer x) {
        return x.intersects(this);
    }

    @Override
    public MappeableContainer ior(MappeableArrayContainer value2) {
        return this.or(value2);
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer x) {
        return x.or(this);
    }

    @Override
    public MappeableContainer ior(MappeableRunContainer value2) {
        return value2.or(this);
    }

    @Override
    public MappeableContainer iremove(int begin, int end) {
        int indexend;
        int indexstart = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        BufferUtil.arraycopy(this.content, indexstart + rangelength, this.content, indexstart, this.cardinality - indexstart - rangelength);
        this.cardinality -= rangelength;
        return this;
    }

    @Override
    protected boolean isArrayBacked() {
        return BufferUtil.isBackedBySimpleArray(this.content);
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < MappeableArrayContainer.this.cardinality;
            }

            @Override
            public Short next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return MappeableArrayContainer.this.content.get(s);
            }

            @Override
            public void remove() {
                MappeableArrayContainer.this.remove((short)(this.pos - 1));
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public MappeableContainer ixor(MappeableArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public MappeableContainer ixor(MappeableBitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public MappeableContainer ixor(MappeableRunContainer value2) {
        return value2.xor(this);
    }

    @Override
    public MappeableContainer limit(int maxcardinality) {
        if (maxcardinality < this.getCardinality()) {
            return new MappeableArrayContainer(maxcardinality, this.content);
        }
        return this.clone();
    }

    protected void loadData(MappeableBitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        if (!BufferUtil.isBackedBySimpleArray(this.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        bitmapContainer.fillArray(this.content.array());
    }

    private void negateRange(ShortBuffer buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange < lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content.get(inPos)) {
                buffer.put(outPos++, (short)valInRange);
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastRange) {
            buffer.put(outPos++, (short)valInRange);
            ++valInRange;
        }
        if (outPos != buffer.limit()) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.limit());
        }
        assert (outPos == buffer.limit());
        int i = startIndex;
        int len = buffer.limit();
        for (int k = 0; k < len; ++k) {
            short item = buffer.get(k);
            this.content.put(i++, item);
        }
    }

    @Override
    public MappeableContainer not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange >= lastOfRange) {
            return this.clone();
        }
        int startIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) > 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(newCardinality);
        if (!BufferUtil.isBackedBySimpleArray(answer.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        short[] sarray = answer.content.array();
        for (int i = 0; i < startIndex; ++i) {
            sarray[i] = this.content.get(i);
        }
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange < lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content.get(inPos)) {
                sarray[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastOfRange) {
            answer.content.put(outPos++, (short)valInRange);
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content.put(outPos++, this.content.get(i));
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    int numberOfRuns() {
        if (this.cardinality == 0) {
            return 0;
        }
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] c = this.content.array();
            int numRuns = 1;
            int oldv = BufferUtil.toIntUnsigned(c[0]);
            for (int i = 1; i < this.cardinality; ++i) {
                int newv = BufferUtil.toIntUnsigned(c[i]);
                if (oldv + 1 != newv) {
                    ++numRuns;
                }
                oldv = newv;
            }
            return numRuns;
        }
        int numRuns = 0;
        int previous = BufferUtil.toIntUnsigned(this.content.get(0));
        for (int i = 1; i < this.cardinality; ++i) {
            int val = BufferUtil.toIntUnsigned(this.content.get(i));
            if (val != previous + 1) {
                ++numRuns;
            }
            previous = val;
        }
        return numRuns;
    }

    @Override
    public MappeableContainer or(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int i2;
            short v;
            int k;
            short[] sarray;
            MappeableBitmapContainer bc = new MappeableBitmapContainer();
            if (!BufferUtil.isBackedBySimpleArray(bc.bitmap)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            long[] bitArray = bc.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(value2.content)) {
                sarray = value2.content.array();
                for (k = 0; k < value2.cardinality; ++k) {
                    v = sarray[k];
                    int n = i2 = BufferUtil.toIntUnsigned(v) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << v;
                }
            } else {
                for (int k2 = 0; k2 < value2.cardinality; ++k2) {
                    short v2 = value2.content.get(k2);
                    int n = i = BufferUtil.toIntUnsigned(v2) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << v2;
                }
            }
            if (BufferUtil.isBackedBySimpleArray(this.content)) {
                sarray = this.content.array();
                for (k = 0; k < this.cardinality; ++k) {
                    v = sarray[k];
                    int n = i2 = BufferUtil.toIntUnsigned(v) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << v;
                }
            } else {
                for (int k3 = 0; k3 < this.cardinality; ++k3) {
                    short v2 = this.content.get(k3);
                    int n = i = BufferUtil.toIntUnsigned(v2) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << v2;
                }
            }
            bc.cardinality = 0;
            int len = bc.bitmap.limit();
            for (int index = 0; index < len; ++index) {
                bc.cardinality += Long.bitCount(bitArray[index]);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(totalCardinality);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedUnion2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer x) {
        return x.or(this);
    }

    @Override
    public MappeableContainer or(MappeableRunContainer value2) {
        return value2.or(this);
    }

    protected MappeableContainer or(ShortIterator it) {
        return this.or(it, false);
    }

    private MappeableContainer or(ShortIterator it, boolean exclusive) {
        MappeableArrayContainer ac = new MappeableArrayContainer();
        int myItPos = 0;
        ac.cardinality = 0;
        int myHead = myItPos == this.cardinality ? -1 : BufferUtil.toIntUnsigned(this.content.get(myItPos++));
        int hisHead = this.advance(it);
        while (myHead != -1 && hisHead != -1) {
            if (myHead < hisHead) {
                ac.emit((short)myHead);
                myHead = myItPos == this.cardinality ? -1 : BufferUtil.toIntUnsigned(this.content.get(myItPos++));
                continue;
            }
            if (myHead > hisHead) {
                ac.emit((short)hisHead);
                hisHead = this.advance(it);
                continue;
            }
            if (!exclusive) {
                ac.emit((short)hisHead);
            }
            hisHead = this.advance(it);
            myHead = myItPos == this.cardinality ? -1 : BufferUtil.toIntUnsigned(this.content.get(myItPos++));
        }
        while (myHead != -1) {
            ac.emit((short)myHead);
            myHead = myItPos == this.cardinality ? -1 : BufferUtil.toIntUnsigned(this.content.get(myItPos++));
        }
        while (hisHead != -1) {
            ac.emit((short)hisHead);
            hisHead = this.advance(it);
        }
        if (ac.cardinality > 4096) {
            return ac.toBitmapContainer();
        }
        return ac;
    }

    @Override
    public int rank(short lowbits) {
        int answer = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, lowbits);
        if (answer >= 0) {
            return answer + 1;
        }
        return -answer - 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cardinality = 0xFFFF & Short.reverseBytes(in.readShort());
        if (this.content.limit() < this.cardinality) {
            this.content = ShortBuffer.allocate(this.cardinality);
        }
        for (int k = 0; k < this.cardinality; ++k) {
            this.content.put(k, Short.reverseBytes(in.readShort()));
        }
    }

    @Override
    public MappeableContainer remove(int begin, int end) {
        int indexend;
        int indexstart = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        MappeableArrayContainer answer = this.clone();
        BufferUtil.arraycopy(this.content, indexstart + rangelength, answer.content, indexstart, this.cardinality - indexstart - rangelength);
        answer.cardinality = this.cardinality - rangelength;
        return answer;
    }

    @Override
    public MappeableContainer remove(short x) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            int loc = Util.unsignedBinarySearch(this.content.array(), 0, this.cardinality, x);
            if (loc >= 0) {
                System.arraycopy(this.content.array(), loc + 1, this.content.array(), loc, this.cardinality - loc - 1);
                --this.cardinality;
            }
            return this;
        }
        int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            for (int k = loc + 1; k < this.cardinality; --k) {
                this.content.put(k - 1, this.content.get(k));
            }
            --this.cardinality;
        }
        return this;
    }

    @Override
    public MappeableContainer repairAfterLazy() {
        return this;
    }

    @Override
    public MappeableContainer runOptimize() {
        int numRuns = this.numberOfRuns();
        int sizeAsRunContainer = MappeableRunContainer.getArraySizeInBytes(numRuns);
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new MappeableRunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public short select(int j) {
        return this.content.get(j);
    }

    @Override
    public int serializedSizeInBytes() {
        return MappeableArrayContainer.serializedSizeInBytes(this.cardinality);
    }

    public MappeableBitmapContainer toBitmapContainer() {
        MappeableBitmapContainer bc = new MappeableBitmapContainer();
        bc.loadData(this);
        return bc;
    }

    @Override
    public Container toContainer() {
        return new ArrayContainer(this);
    }

    public short[] toShortArray() {
        short[] answer = new short[this.cardinality];
        this.content.rewind();
        this.content.get(answer);
        return answer;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append(this.content.get(i));
            sb.append(",");
        }
        sb.append(this.content.get(this.cardinality - 1));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.content.limit() == this.cardinality) {
            return;
        }
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            this.content = ShortBuffer.wrap(Arrays.copyOf(this.content.array(), this.cardinality));
        } else {
            ShortBuffer co = ShortBuffer.allocate(this.cardinality);
            short[] x = co.array();
            for (int k = 0; k < this.cardinality; ++k) {
                x[k] = this.content.get(k);
            }
            this.content = co;
        }
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] a = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                out.writeShort(Short.reverseBytes(a[k]));
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                out.writeShort(Short.reverseBytes(this.content.get(k)));
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.cardinality & 0xFF);
        out.write(this.cardinality >>> 8 & 0xFF);
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] a = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                out.writeShort(Short.reverseBytes(a[k]));
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                out.writeShort(Short.reverseBytes(this.content.get(k)));
            }
        }
    }

    @Override
    public MappeableContainer xor(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int i2;
            short v;
            int k;
            short[] sarray;
            MappeableBitmapContainer bc = new MappeableBitmapContainer();
            if (!BufferUtil.isBackedBySimpleArray(bc.bitmap)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            long[] bitArray = bc.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(value2.content)) {
                sarray = value2.content.array();
                for (k = 0; k < value2.cardinality; ++k) {
                    v = sarray[k];
                    int n = i2 = BufferUtil.toIntUnsigned(v) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << v;
                }
            } else {
                for (int k2 = 0; k2 < value2.cardinality; ++k2) {
                    short v2 = value2.content.get(k2);
                    int n = i = BufferUtil.toIntUnsigned(v2) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << v2;
                }
            }
            if (BufferUtil.isBackedBySimpleArray(this.content)) {
                sarray = this.content.array();
                for (k = 0; k < this.cardinality; ++k) {
                    v = sarray[k];
                    int n = i2 = BufferUtil.toIntUnsigned(v) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << v;
                }
            } else {
                for (int k3 = 0; k3 < this.cardinality; ++k3) {
                    short v2 = this.content.get(k3);
                    int n = i = BufferUtil.toIntUnsigned(v2) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << v2;
                }
            }
            bc.cardinality = 0;
            int len = bc.bitmap.limit();
            for (int index = 0; index < len; ++index) {
                bc.cardinality += Long.bitCount(bitArray[index]);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(totalCardinality);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedExclusiveUnion2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedExclusiveUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer xor(MappeableBitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public MappeableContainer xor(MappeableRunContainer value2) {
        return value2.xor(this);
    }

    protected MappeableContainer xor(ShortIterator it) {
        return this.or(it, true);
    }
}

