/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringArray;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.PointableRoaringArray;

public class ImmutableRoaringBitmap
implements Iterable<Integer>,
Cloneable,
ImmutableBitmapDataProvider {
    PointableRoaringArray highLowContainer = null;

    public static MutableRoaringBitmap and(Iterator bitmaps, long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        Iterator<ImmutableRoaringBitmap> bitmapsIterator = ImmutableRoaringBitmap.selectRangeWithoutCopy(bitmaps, rangeStart, rangeEnd);
        return BufferFastAggregation.and(bitmapsIterator);
    }

    @Deprecated
    public static MutableRoaringBitmap and(Iterator bitmaps, int rangeStart, int rangeEnd) {
        return ImmutableRoaringBitmap.and(bitmaps, (long)rangeStart, (long)rangeEnd);
    }

    public static MutableRoaringBitmap and(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c2;
                MappeableContainer c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                MappeableContainer c = c1.and(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.getMappeableRoaringArray().append(s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public static int andCardinality(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        int answer = 0;
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                MappeableContainer c2 = x2.highLowContainer.getContainerAtIndex(pos2);
                answer += c1.andCardinality(c2);
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return answer;
    }

    public static MutableRoaringBitmap andNot(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2, long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        MutableRoaringBitmap rb1 = ImmutableRoaringBitmap.selectRangeWithoutCopy(x1, rangeStart, rangeEnd);
        MutableRoaringBitmap rb2 = ImmutableRoaringBitmap.selectRangeWithoutCopy(x2, rangeStart, rangeEnd);
        return ImmutableRoaringBitmap.andNot(rb1, rb2);
    }

    @Deprecated
    public static MutableRoaringBitmap andNot(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2, int rangeStart, int rangeEnd) {
        return ImmutableRoaringBitmap.andNot(x1, x2, (long)rangeStart, (long)rangeEnd);
    }

    public static MutableRoaringBitmap andNot(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c2;
                MappeableContainer c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                MappeableContainer c = c1.andNot(c2 = x2.highLowContainer.getContainerAtIndex(pos2));
                if (c.getCardinality() > 0) {
                    answer.getMappeableRoaringArray().append(s1, c);
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                int nextPos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                answer.getMappeableRoaringArray().appendCopy(x1.highLowContainer, pos1, nextPos1);
                pos1 = nextPos1;
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        if (pos2 == length2) {
            answer.getMappeableRoaringArray().appendCopy(x1.highLowContainer, pos1, length1);
        }
        return answer;
    }

    public static ImmutableRoaringBitmap bitmapOf(int ... data) {
        return MutableRoaringBitmap.bitmapOf(data);
    }

    public static MutableRoaringBitmap flip(ImmutableRoaringBitmap bm, long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        if (rangeStart >= rangeEnd) {
            throw new RuntimeException("Invalid range " + rangeStart + " -- " + rangeEnd);
        }
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        short hbStart = BufferUtil.highbits(rangeStart);
        short lbStart = BufferUtil.lowbits(rangeStart);
        short hbLast = BufferUtil.highbits(rangeEnd - 1L);
        short lbLast = BufferUtil.lowbits(rangeEnd - 1L);
        answer.getMappeableRoaringArray().appendCopiesUntil(bm.highLowContainer, hbStart);
        int max = BufferUtil.toIntUnsigned(BufferUtil.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? BufferUtil.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? BufferUtil.toIntUnsigned(lbLast) : max;
            int i = bm.highLowContainer.getIndex(hb);
            int j = answer.getMappeableRoaringArray().getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                MappeableContainer c = bm.highLowContainer.getContainerAtIndex(i).not(containerStart, containerLast + 1);
                if (c.getCardinality() <= 0) continue;
                answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, hb, MappeableContainer.rangeOfOnes(containerStart, containerLast + 1));
        }
        answer.getMappeableRoaringArray().appendCopiesAfter(bm.highLowContainer, hbLast);
        return answer;
    }

    @Deprecated
    public static MutableRoaringBitmap flip(ImmutableRoaringBitmap bm, int rangeStart, int rangeEnd) {
        if (rangeStart >= 0) {
            return ImmutableRoaringBitmap.flip(bm, (long)rangeStart, (long)rangeEnd);
        }
        return ImmutableRoaringBitmap.flip(bm, (long)rangeStart & 0xFFFFFFFFL, (long)rangeEnd & 0xFFFFFFFFL);
    }

    private static Iterator<ImmutableRoaringBitmap> selectRangeWithoutCopy(final Iterator bitmaps, final long rangeStart, final long rangeEnd) {
        Iterator<ImmutableRoaringBitmap> bitmapsIterator = new Iterator<ImmutableRoaringBitmap>(){

            @Override
            public boolean hasNext() {
                return bitmaps.hasNext();
            }

            @Override
            public ImmutableRoaringBitmap next() {
                ImmutableRoaringBitmap next = (ImmutableRoaringBitmap)bitmaps.next();
                return ImmutableRoaringBitmap.selectRangeWithoutCopy(next, rangeStart, rangeEnd);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
        return bitmapsIterator;
    }

    private static MutableRoaringBitmap selectRangeWithoutCopy(ImmutableRoaringBitmap rb, long rangeStart, long rangeEnd) {
        MappeableContainer c;
        int hbStart = BufferUtil.toIntUnsigned(BufferUtil.highbits(rangeStart));
        int lbStart = BufferUtil.toIntUnsigned(BufferUtil.lowbits(rangeStart));
        int hbLast = BufferUtil.toIntUnsigned(BufferUtil.highbits(rangeEnd - 1L));
        int lbLast = BufferUtil.toIntUnsigned(BufferUtil.lowbits(rangeEnd - 1L));
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (rangeEnd <= rangeStart) {
            return answer;
        }
        if (hbStart == hbLast) {
            MappeableContainer c2;
            int i = rb.highLowContainer.getIndex((short)hbStart);
            if (i >= 0 && (c2 = rb.highLowContainer.getContainerAtIndex(i).remove(0, lbStart).iremove(lbLast + 1, BufferUtil.maxLowBitAsInteger() + 1)).getCardinality() > 0) {
                ((MutableRoaringArray)answer.highLowContainer).append((short)hbStart, c2);
            }
            return answer;
        }
        int ifirst = rb.highLowContainer.getIndex((short)hbStart);
        int ilast = rb.highLowContainer.getIndex((short)hbLast);
        if (ifirst >= 0 && (c = rb.highLowContainer.getContainerAtIndex(ifirst).remove(0, lbStart)).getCardinality() > 0) {
            ((MutableRoaringArray)answer.highLowContainer).append((short)hbStart, c);
        }
        for (int hb = hbStart + 1; hb <= hbLast - 1; ++hb) {
            int i = rb.highLowContainer.getIndex((short)hb);
            int j = answer.getMappeableRoaringArray().getIndex((short)hb);
            assert (j < 0);
            if (i < 0) continue;
            MappeableContainer c3 = rb.highLowContainer.getContainerAtIndex(i);
            answer.getMappeableRoaringArray().insertNewKeyValueAt(-j - 1, (short)hb, c3);
        }
        if (ilast >= 0 && (c = rb.highLowContainer.getContainerAtIndex(ilast).remove(lbLast + 1, BufferUtil.maxLowBitAsInteger() + 1)).getCardinality() > 0) {
            ((MutableRoaringArray)answer.highLowContainer).append((short)hbLast, c);
        }
        return answer;
    }

    public static boolean intersects(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highLowContainer.size();
        int length2 = x2.highLowContainer.size();
        while (pos1 < length1 && pos2 < length2) {
            short s2;
            short s1 = x1.highLowContainer.getKeyAtIndex(pos1);
            if (s1 == (s2 = x2.highLowContainer.getKeyAtIndex(pos2))) {
                MappeableContainer c2;
                MappeableContainer c1 = x1.highLowContainer.getContainerAtIndex(pos1);
                if (c1.intersects(c2 = x2.highLowContainer.getContainerAtIndex(pos2))) {
                    return true;
                }
                ++pos1;
                ++pos2;
                continue;
            }
            if (Util.compareUnsigned(s1, s2) < 0) {
                pos1 = x1.highLowContainer.advanceUntil(s2, pos1);
                continue;
            }
            pos2 = x2.highLowContainer.advanceUntil(s1, pos2);
        }
        return false;
    }

    protected static MutableRoaringBitmap lazyor(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer;
        block7: {
            MappeableContainerPointer i2;
            MappeableContainerPointer i1;
            block6: {
                answer = new MutableRoaringBitmap();
                i1 = x1.highLowContainer.getContainerPointer();
                i2 = x2.highLowContainer.getContainerPointer();
                if (i1.hasContainer() && i2.hasContainer()) {
                    while (true) {
                        if (i1.key() == i2.key()) {
                            answer.getMappeableRoaringArray().append(i1.key(), i1.getContainer().lazyOR(i2.getContainer()));
                            i1.advance();
                            i2.advance();
                            if (i1.hasContainer() && i2.hasContainer()) continue;
                            break;
                        }
                        if (Util.compareUnsigned(i1.key(), i2.key()) < 0) {
                            answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                            i1.advance();
                            if (i1.hasContainer()) continue;
                            break;
                        }
                        answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                        i2.advance();
                        if (!i2.hasContainer()) break;
                    }
                }
                if (i1.hasContainer()) break block6;
                while (i2.hasContainer()) {
                    answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                    i2.advance();
                }
                break block7;
            }
            if (i2.hasContainer()) break block7;
            while (i1.hasContainer()) {
                answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                i1.advance();
            }
        }
        return answer;
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.or(bitmaps);
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer;
        block7: {
            MappeableContainerPointer i2;
            MappeableContainerPointer i1;
            block6: {
                answer = new MutableRoaringBitmap();
                i1 = x1.highLowContainer.getContainerPointer();
                i2 = x2.highLowContainer.getContainerPointer();
                if (i1.hasContainer() && i2.hasContainer()) {
                    while (true) {
                        if (i1.key() == i2.key()) {
                            answer.getMappeableRoaringArray().append(i1.key(), i1.getContainer().or(i2.getContainer()));
                            i1.advance();
                            i2.advance();
                            if (i1.hasContainer() && i2.hasContainer()) continue;
                            break;
                        }
                        if (Util.compareUnsigned(i1.key(), i2.key()) < 0) {
                            answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                            i1.advance();
                            if (i1.hasContainer()) continue;
                            break;
                        }
                        answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                        i2.advance();
                        if (!i2.hasContainer()) break;
                    }
                }
                if (i1.hasContainer()) break block6;
                while (i2.hasContainer()) {
                    answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                    i2.advance();
                }
                break block7;
            }
            if (i2.hasContainer()) break block7;
            while (i1.hasContainer()) {
                answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                i1.advance();
            }
        }
        return answer;
    }

    public static MutableRoaringBitmap or(Iterator bitmaps) {
        return BufferFastAggregation.or(bitmaps);
    }

    public static MutableRoaringBitmap or(Iterator bitmaps, long rangeStart, long rangeEnd) {
        MutableRoaringBitmap.rangeSanityCheck(rangeStart, rangeEnd);
        Iterator<ImmutableRoaringBitmap> bitmapsIterator = ImmutableRoaringBitmap.selectRangeWithoutCopy(bitmaps, rangeStart, rangeEnd);
        return ImmutableRoaringBitmap.or(bitmapsIterator);
    }

    @Deprecated
    public static MutableRoaringBitmap or(Iterator bitmaps, int rangeStart, int rangeEnd) {
        return ImmutableRoaringBitmap.or(bitmaps, (long)rangeStart, (long)rangeEnd);
    }

    public static int orCardinality(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        int answer;
        block7: {
            MappeableContainerPointer i2;
            MappeableContainerPointer i1;
            block6: {
                answer = 0;
                i1 = x1.highLowContainer.getContainerPointer();
                i2 = x2.highLowContainer.getContainerPointer();
                if (i1.hasContainer() && i2.hasContainer()) {
                    while (true) {
                        if (i1.key() == i2.key()) {
                            answer += i1.getContainer().or(i2.getContainer()).getCardinality();
                            i1.advance();
                            i2.advance();
                            if (i1.hasContainer() && i2.hasContainer()) continue;
                            break;
                        }
                        if (Util.compareUnsigned(i1.key(), i2.key()) < 0) {
                            answer += i1.getCardinality();
                            i1.advance();
                            if (i1.hasContainer()) continue;
                            break;
                        }
                        answer += i2.getCardinality();
                        i2.advance();
                        if (!i2.hasContainer()) break;
                    }
                }
                if (i1.hasContainer()) break block6;
                while (i2.hasContainer()) {
                    answer += i2.getCardinality();
                    i2.advance();
                }
                break block7;
            }
            if (i2.hasContainer()) break block7;
            while (i1.hasContainer()) {
                answer += i1.getCardinality();
                i1.advance();
            }
        }
        return answer;
    }

    public static MutableRoaringBitmap xor(Iterator bitmaps, long rangeStart, long rangeEnd) {
        Iterator<ImmutableRoaringBitmap> bitmapsIterator = ImmutableRoaringBitmap.selectRangeWithoutCopy(bitmaps, rangeStart, rangeEnd);
        return BufferFastAggregation.xor(bitmapsIterator);
    }

    @Deprecated
    public static MutableRoaringBitmap xor(Iterator bitmaps, int rangeStart, int rangeEnd) {
        return ImmutableRoaringBitmap.xor(bitmaps, (long)rangeStart, (long)rangeEnd);
    }

    public static MutableRoaringBitmap xor(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        MutableRoaringBitmap answer;
        block8: {
            MappeableContainerPointer i2;
            MappeableContainerPointer i1;
            block7: {
                answer = new MutableRoaringBitmap();
                i1 = x1.highLowContainer.getContainerPointer();
                i2 = x2.highLowContainer.getContainerPointer();
                if (i1.hasContainer() && i2.hasContainer()) {
                    while (true) {
                        if (i1.key() == i2.key()) {
                            MappeableContainer c = i1.getContainer().xor(i2.getContainer());
                            if (c.getCardinality() > 0) {
                                answer.getMappeableRoaringArray().append(i1.key(), c);
                            }
                            i1.advance();
                            i2.advance();
                            if (i1.hasContainer() && i2.hasContainer()) continue;
                            break;
                        }
                        if (Util.compareUnsigned(i1.key(), i2.key()) < 0) {
                            answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                            i1.advance();
                            if (i1.hasContainer()) continue;
                            break;
                        }
                        answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                        i2.advance();
                        if (!i2.hasContainer()) break;
                    }
                }
                if (i1.hasContainer()) break block7;
                while (i2.hasContainer()) {
                    answer.getMappeableRoaringArray().appendCopy(i2.key(), i2.getContainer());
                    i2.advance();
                }
                break block8;
            }
            if (i2.hasContainer()) break block8;
            while (i1.hasContainer()) {
                answer.getMappeableRoaringArray().appendCopy(i1.key(), i1.getContainer());
                i1.advance();
            }
        }
        return answer;
    }

    protected ImmutableRoaringBitmap() {
    }

    public ImmutableRoaringBitmap(ByteBuffer b) {
        this.highLowContainer = new ImmutableRoaringArray(b);
    }

    public ImmutableRoaringBitmap clone() {
        try {
            ImmutableRoaringBitmap x = (ImmutableRoaringBitmap)super.clone();
            x.highLowContainer = this.highLowContainer.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("shouldn't happen with clone", e);
        }
    }

    @Override
    public boolean contains(int x) {
        short hb = BufferUtil.highbits(x);
        MappeableContainer c = this.highLowContainer.getContainer(hb);
        return c != null && c.contains(BufferUtil.lowbits(x));
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringBitmap) {
            if (this.highLowContainer.size() != ((ImmutableRoaringBitmap)o).highLowContainer.size()) {
                return false;
            }
            MappeableContainerPointer mp1 = this.highLowContainer.getContainerPointer();
            MappeableContainerPointer mp2 = ((ImmutableRoaringBitmap)o).highLowContainer.getContainerPointer();
            while (mp1.hasContainer()) {
                if (mp1.key() != mp2.key()) {
                    return false;
                }
                if (mp1.getCardinality() != mp2.getCardinality()) {
                    return false;
                }
                if (!mp1.getContainer().equals(mp2.getContainer())) {
                    return false;
                }
                mp1.advance();
                mp2.advance();
            }
            return true;
        }
        return false;
    }

    @Override
    public long getLongCardinality() {
        long size = 0L;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            size += (long)this.highLowContainer.getCardinality(i);
        }
        return size;
    }

    @Override
    public int getCardinality() {
        return (int)this.getLongCardinality();
    }

    @Override
    public void forEach(IntConsumer ic) {
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            this.highLowContainer.getContainerAtIndex(i).forEach(this.highLowContainer.getKeyAtIndex(i), ic);
        }
    }

    public MappeableContainerPointer getContainerPointer() {
        return this.highLowContainer.getContainerPointer();
    }

    @Override
    public PeekableIntIterator getIntIterator() {
        return new ImmutableRoaringIntIterator();
    }

    @Override
    public IntIterator getReverseIntIterator() {
        return new ImmutableRoaringReverseIntIterator();
    }

    @Override
    public long getLongSizeInBytes() {
        long size = 4L;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            if (this.highLowContainer.getContainerAtIndex(i) instanceof MappeableRunContainer) {
                MappeableRunContainer thisRunContainer = (MappeableRunContainer)this.highLowContainer.getContainerAtIndex(i);
                size += (long)(4 + BufferUtil.getSizeInBytesFromCardinalityEtc(0, thisRunContainer.nbrruns, true));
                continue;
            }
            size += (long)(4 + BufferUtil.getSizeInBytesFromCardinalityEtc(this.highLowContainer.getCardinality(i), 0, false));
        }
        return size;
    }

    @Override
    public int getSizeInBytes() {
        return (int)this.getLongSizeInBytes();
    }

    public int hashCode() {
        return this.highLowContainer.hashCode();
    }

    public boolean hasRunCompression() {
        return this.highLowContainer.hasRunCompression();
    }

    @Override
    public boolean isEmpty() {
        return this.highLowContainer.size() == 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            ShortIterator iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < ImmutableRoaringBitmap.this.highLowContainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < ImmutableRoaringBitmap.this.highLowContainer.size()) {
                    this.iter = ImmutableRoaringBitmap.this.highLowContainer.getContainerAtIndex(this.pos).getShortIterator();
                    this.hs = BufferUtil.toIntUnsigned(ImmutableRoaringBitmap.this.highLowContainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = this.iter.nextAsInt() | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot modify.");
            }
        }.init();
    }

    @Override
    public MutableRoaringBitmap limit(int maxcardinality) {
        MappeableContainer c;
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        int currentcardinality = 0;
        for (int i = 0; currentcardinality < maxcardinality && i < this.highLowContainer.size(); currentcardinality += c.getCardinality(), ++i) {
            c = this.highLowContainer.getContainerAtIndex(i);
            if (c.getCardinality() + currentcardinality <= maxcardinality) {
                ((MutableRoaringArray)answer.highLowContainer).append(this.highLowContainer.getKeyAtIndex(i), c.clone());
                continue;
            }
            int leftover = maxcardinality - currentcardinality;
            MappeableContainer limited = c.limit(leftover);
            ((MutableRoaringArray)answer.highLowContainer).append(this.highLowContainer.getKeyAtIndex(i), limited);
            break;
        }
        return answer;
    }

    @Override
    public long rankLong(int x) {
        long size = 0L;
        short xhigh = BufferUtil.highbits(x);
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            short key = this.highLowContainer.getKeyAtIndex(i);
            if (Util.compareUnsigned(key, xhigh) < 0) {
                size += (long)this.highLowContainer.getCardinality(i);
                continue;
            }
            return size + (long)this.highLowContainer.getContainerAtIndex(i).rank(BufferUtil.lowbits(x));
        }
        return size;
    }

    @Override
    public int rank(int x) {
        return (int)this.rankLong(x);
    }

    @Override
    public int select(int j) {
        int leftover = j;
        for (int i = 0; i < this.highLowContainer.size(); ++i) {
            int thiscard = this.highLowContainer.getCardinality(i);
            if (thiscard > leftover) {
                int keycontrib = this.highLowContainer.getKeyAtIndex(i) << 16;
                MappeableContainer c = this.highLowContainer.getContainerAtIndex(i);
                int lowcontrib = BufferUtil.toIntUnsigned(c.select(leftover));
                return lowcontrib + keycontrib;
            }
            leftover -= thiscard;
        }
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getCardinality());
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.highLowContainer.serialize(out);
    }

    @Override
    public int serializedSizeInBytes() {
        return this.highLowContainer.serializedSizeInBytes();
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highLowContainer.size()) {
            int hs = BufferUtil.toIntUnsigned(this.highLowContainer.getKeyAtIndex(pos)) << 16;
            MappeableContainer c = this.highLowContainer.getContainerAtIndex(pos++);
            c.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += c.getCardinality();
        }
        return array;
    }

    public MutableRoaringBitmap toMutableRoaringBitmap() {
        MutableRoaringBitmap c = new MutableRoaringBitmap();
        MappeableContainerPointer mcp = this.highLowContainer.getContainerPointer();
        while (mcp.hasContainer()) {
            c.getMappeableRoaringArray().appendCopy(mcp.key(), mcp.getContainer());
            mcp.advance();
        }
        return c;
    }

    public RoaringBitmap toRoaringBitmap() {
        return new RoaringBitmap(this);
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        PeekableIntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            if (answer.length() > 524288) {
                answer.append("...");
                break;
            }
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    private final class ImmutableRoaringReverseIntIterator
    implements IntIterator {
        private MappeableContainerPointer cp;
        private int hs;
        private ShortIterator iter;
        private boolean ok;

        public ImmutableRoaringReverseIntIterator() {
            this.cp = ImmutableRoaringBitmap.this.highLowContainer.getContainerPointer(ImmutableRoaringBitmap.this.highLowContainer.size() - 1);
            this.hs = 0;
            this.nextContainer();
        }

        @Override
        public IntIterator clone() {
            try {
                ImmutableRoaringReverseIntIterator x = (ImmutableRoaringReverseIntIterator)super.clone();
                x.iter = this.iter.clone();
                x.cp = this.cp.clone();
                return x;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.ok;
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                this.cp.previous();
                this.nextContainer();
            }
            return x;
        }

        private void nextContainer() {
            this.ok = this.cp.hasContainer();
            if (this.ok) {
                this.iter = this.cp.getContainer().getReverseShortIterator();
                this.hs = BufferUtil.toIntUnsigned(this.cp.key()) << 16;
            }
        }
    }

    private final class ImmutableRoaringIntIterator
    implements PeekableIntIterator {
        private MappeableContainerPointer cp;
        private int hs;
        private PeekableShortIterator iter;
        private boolean ok;

        public ImmutableRoaringIntIterator() {
            this.cp = ImmutableRoaringBitmap.this.highLowContainer.getContainerPointer();
            this.hs = 0;
            this.nextContainer();
        }

        @Override
        public PeekableIntIterator clone() {
            try {
                ImmutableRoaringIntIterator x = (ImmutableRoaringIntIterator)super.clone();
                x.iter = this.iter.clone();
                x.cp = this.cp.clone();
                return x;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.ok;
        }

        @Override
        public int next() {
            int x = this.iter.nextAsInt() | this.hs;
            if (!this.iter.hasNext()) {
                this.cp.advance();
                this.nextContainer();
            }
            return x;
        }

        private void nextContainer() {
            this.ok = this.cp.hasContainer();
            if (this.ok) {
                this.iter = this.cp.getContainer().getShortIterator();
                this.hs = BufferUtil.toIntUnsigned(this.cp.key()) << 16;
            }
        }

        @Override
        public void advanceIfNeeded(int minval) {
            while ((0xFFFF & this.hs >>> 16) < (0xFFFF & minval >>> 16)) {
                this.cp.advance();
                this.nextContainer();
            }
            if (this.ok) {
                this.iter.advanceIfNeeded(BufferUtil.lowbits(minval));
                if (!this.iter.hasNext()) {
                    this.cp.advance();
                    this.nextContainer();
                }
            }
        }

        @Override
        public int peekNext() {
            return BufferUtil.toIntUnsigned(this.iter.peekNext()) | this.hs;
        }
    }
}

