/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class MutableRoaringArray
implements Cloneable,
Externalizable,
PointableRoaringArray {
    protected static final int INITIAL_CAPACITY = 4;
    protected static final short SERIAL_COOKIE_NO_RUNCONTAINER = 12346;
    protected static final short SERIAL_COOKIE = 12347;
    protected static final int NO_OFFSET_THRESHOLD = 4;
    private static final long serialVersionUID = 5L;
    protected boolean mayHaveRunContainers = false;
    short[] keys = new short[4];
    MappeableContainer[] values = new MappeableContainer[4];
    int size = 0;

    protected MutableRoaringArray() {
    }

    protected void append(short key, MappeableContainer value) {
        this.extendArray(1);
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
    }

    protected void appendCopiesAfter(PointableRoaringArray highLowContainer, short beforeStart) {
        int startLocation = highLowContainer.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(highLowContainer.size() - startLocation);
        for (int i = startLocation; i < highLowContainer.size(); ++i) {
            this.keys[this.size] = highLowContainer.getKeyAtIndex(i);
            this.values[this.size] = highLowContainer.getContainerAtIndex(i).clone();
            ++this.size;
        }
    }

    protected void appendCopiesUntil(PointableRoaringArray highLowContainer, short stoppingKey) {
        int stopKey = BufferUtil.toIntUnsigned(stoppingKey);
        MappeableContainerPointer cp = highLowContainer.getContainerPointer();
        while (cp.hasContainer() && BufferUtil.toIntUnsigned(cp.key()) < stopKey) {
            this.extendArray(1);
            this.keys[this.size] = cp.key();
            this.values[this.size] = cp.getContainer().clone();
            ++this.size;
            cp.advance();
        }
    }

    protected void appendCopy(PointableRoaringArray highLowContainer, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.keys[this.size] = highLowContainer.getKeyAtIndex(i);
            this.values[this.size] = highLowContainer.getContainerAtIndex(i).clone();
            ++this.size;
        }
    }

    protected void appendCopy(short key, MappeableContainer value) {
        this.extendArray(1);
        this.keys[this.size] = key;
        this.values[this.size] = value.clone();
        ++this.size;
    }

    private int binarySearch(int begin, int end, short key) {
        return Util.unsignedBinarySearch(this.keys, begin, end, key);
    }

    protected void clear() {
        this.keys = null;
        this.values = null;
        this.size = 0;
    }

    @Override
    public MutableRoaringArray clone() {
        try {
            MutableRoaringArray sa = (MutableRoaringArray)super.clone();
            sa.keys = Arrays.copyOf(this.keys, this.size);
            sa.values = Arrays.copyOf(this.values, this.size);
            for (int k = 0; k < this.size; ++k) {
                sa.values[k] = sa.values[k].clone();
            }
            sa.size = this.size;
            return sa;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        boolean hasrun;
        this.clear();
        int cookie = Integer.reverseBytes(in.readInt());
        if ((cookie & 0xFFFF) != 12347 && cookie != 12346) {
            throw new IOException("I failed to find the one of the right cookies.");
        }
        int n = this.size = (cookie & 0xFFFF) == 12347 ? (cookie >>> 16) + 1 : Integer.reverseBytes(in.readInt());
        if (this.keys == null || this.keys.length < this.size) {
            this.keys = new short[this.size];
            this.values = new MappeableContainer[this.size];
        }
        byte[] bitmapOfRunContainers = null;
        boolean bl = hasrun = (cookie & 0xFFFF) == 12347;
        if (hasrun) {
            bitmapOfRunContainers = new byte[(this.size + 7) / 8];
            in.readFully(bitmapOfRunContainers);
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = Short.reverseBytes(in.readShort());
            cardinalities[k] = 1 + (0xFFFF & Short.reverseBytes(in.readShort()));
            boolean bl2 = isBitmap[k] = cardinalities[k] > 4096;
            if (bitmapOfRunContainers == null || (bitmapOfRunContainers[k / 8] & 1 << k % 8) == 0) continue;
            isBitmap[k] = false;
        }
        if (!hasrun || this.size >= 4) {
            in.skipBytes(this.size * 4);
        }
        for (k = 0; k < this.size; ++k) {
            MappeableContainer val;
            int l;
            if (isBitmap[k]) {
                LongBuffer bitmapArray = LongBuffer.allocate(1024);
                for (l = 0; l < bitmapArray.limit(); ++l) {
                    bitmapArray.put(l, Long.reverseBytes(in.readLong()));
                }
                val = new MappeableBitmapContainer(bitmapArray, cardinalities[k]);
            } else if (bitmapOfRunContainers != null && (bitmapOfRunContainers[k / 8] & 1 << k % 8) != 0) {
                int nbrruns = BufferUtil.toIntUnsigned(Short.reverseBytes(in.readShort()));
                ShortBuffer shortArray = ShortBuffer.allocate(2 * nbrruns);
                for (int l2 = 0; l2 < shortArray.limit(); ++l2) {
                    shortArray.put(l2, Short.reverseBytes(in.readShort()));
                }
                val = new MappeableRunContainer(shortArray, nbrruns);
            } else {
                ShortBuffer shortArray = ShortBuffer.allocate(cardinalities[k]);
                for (l = 0; l < shortArray.limit(); ++l) {
                    shortArray.put(l, Short.reverseBytes(in.readShort()));
                }
                val = new MappeableArrayContainer(shortArray, cardinalities[k]);
            }
            this.keys[k] = keys[k];
            this.values[k] = val;
        }
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.keys.length) {
            int newCapacity = this.keys.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.keys = Arrays.copyOf(this.keys, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
    }

    @Override
    public MappeableContainer getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.values[i];
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        return this.values[i];
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        return new MappeableContainerPointer(){
            int k;
            {
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public void previous() {
                --this.k;
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return BufferUtil.toIntUnsigned(this.key()) - BufferUtil.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return this.getContainer().getCardinality();
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= MutableRoaringArray.this.size) {
                    return null;
                }
                return MutableRoaringArray.this.values[this.k];
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k & this.k < MutableRoaringArray.this.size;
            }

            @Override
            public short key() {
                return MutableRoaringArray.this.keys[this.k];
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public boolean isBitmapContainer() {
                return this.getContainer() instanceof MappeableBitmapContainer;
            }

            @Override
            public boolean isRunContainer() {
                return this.getContainer() instanceof MappeableRunContainer;
            }

            @Override
            public int getSizeInBytes() {
                return this.getContainer().getArraySizeInBytes();
            }
        };
    }

    @Override
    public int getIndex(short x) {
        if (this.size == 0 || this.keys[this.size - 1] == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    @Override
    public short getKeyAtIndex(int i) {
        return this.keys[i];
    }

    @Override
    public int advanceUntil(short x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || BufferUtil.toIntUnsigned(this.keys[lower]) >= BufferUtil.toIntUnsigned(x)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && BufferUtil.toIntUnsigned(this.keys[lower + spansize]) < BufferUtil.toIntUnsigned(x)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.keys[upper] == x) {
            return upper;
        }
        if (BufferUtil.toIntUnsigned(this.keys[upper]) < BufferUtil.toIntUnsigned(x)) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.keys[mid] == x) {
                return mid;
            }
            if (BufferUtil.toIntUnsigned(this.keys[mid]) < BufferUtil.toIntUnsigned(x)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public int hashCode() {
        int hashvalue = 0;
        for (int k = 0; k < this.size; ++k) {
            hashvalue = 31 * hashvalue + this.keys[k] * 0xF0F0F0 + this.values[k].hashCode();
        }
        return hashvalue;
    }

    protected void insertNewKeyValueAt(int i, short key, MappeableContainer value) {
        this.extendArray(1);
        System.arraycopy(this.keys, i, this.keys, i + 1, this.size - i);
        System.arraycopy(this.values, i, this.values, i + 1, this.size - i);
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.keys, i + 1, this.keys, i, this.size - i - 1);
        this.keys[this.size - 1] = 0;
        System.arraycopy(this.values, i + 1, this.values, i, this.size - i - 1);
        this.values[this.size - 1] = null;
        --this.size;
    }

    protected void removeIndexRange(int begin, int end) {
        if (end <= begin) {
            return;
        }
        int range = end - begin;
        System.arraycopy(this.keys, end, this.keys, begin, this.size - end);
        System.arraycopy(this.values, end, this.values, begin, this.size - end);
        for (int i = 1; i <= range; ++i) {
            this.keys[this.size - i] = 0;
            this.values[this.size - i] = null;
        }
        this.size -= range;
    }

    protected void resize(int newLength) {
        Arrays.fill(this.keys, newLength, this.size, (short)0);
        Arrays.fill(this.values, newLength, this.size, null);
        this.size = newLength;
    }

    protected void copyRange(int begin, int end, int newBegin) {
        int range = end - begin;
        System.arraycopy(this.keys, begin, this.keys, newBegin, range);
        System.arraycopy(this.values, begin, this.values, newBegin, range);
    }

    @Override
    public boolean hasRunCompression() {
        for (int k = 0; k < this.size; ++k) {
            MappeableContainer ck = this.values[k];
            if (!(ck instanceof MappeableRunContainer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        int k;
        int startOffset = 0;
        boolean hasrun = this.hasRunCompression();
        if (hasrun) {
            out.writeInt(Integer.reverseBytes(0x303B | this.size - 1 << 16));
            byte[] bitmapOfRunContainers = new byte[(this.size + 7) / 8];
            for (int i = 0; i < this.size; ++i) {
                if (!(this.values[i] instanceof MappeableRunContainer)) continue;
                int n = i / 8;
                bitmapOfRunContainers[n] = (byte)(bitmapOfRunContainers[n] | 1 << i % 8);
            }
            out.write(bitmapOfRunContainers);
            startOffset = this.size < 4 ? 4 + 4 * this.size + bitmapOfRunContainers.length : 4 + 8 * this.size + bitmapOfRunContainers.length;
        } else {
            out.writeInt(Integer.reverseBytes(12346));
            out.writeInt(Integer.reverseBytes(this.size));
            startOffset = 8 + this.size * 4 + this.size * 4;
        }
        for (k = 0; k < this.size; ++k) {
            out.writeShort(Short.reverseBytes(this.keys[k]));
            out.writeShort(Short.reverseBytes((short)(this.values[k].getCardinality() - 1)));
        }
        if (!hasrun || this.size >= 4) {
            for (k = 0; k < this.size; ++k) {
                out.writeInt(Integer.reverseBytes(startOffset));
                startOffset += this.values[k].getArraySizeInBytes();
            }
        }
        for (k = 0; k < this.size; ++k) {
            this.values[k].writeArray(out);
        }
    }

    @Override
    public int serializedSizeInBytes() {
        int count = this.headerSize();
        for (int k = 0; k < this.size; ++k) {
            count += this.values[k].getArraySizeInBytes();
        }
        return count;
    }

    protected int headerSize() {
        if (this.hasRunCompression()) {
            if (this.size < 4) {
                return 4 + (this.size + 7) / 8 + 4 * this.size;
            }
            return 4 + (this.size + 7) / 8 + 8 * this.size;
        }
        return 8 + 8 * this.size;
    }

    protected void setContainerAtIndex(int i, MappeableContainer c) {
        this.values[i] = c;
    }

    protected void replaceKeyAndContainerAtIndex(int i, short key, MappeableContainer c) {
        this.keys[i] = key;
        this.values[i] = c;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public int getCardinality(int i) {
        return this.getContainerAtIndex(i).getCardinality();
    }
}

