/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;

final class MappeableArrayContainerShortIterator
implements PeekableShortIterator {
    int pos;
    MappeableArrayContainer parent;

    MappeableArrayContainerShortIterator() {
    }

    MappeableArrayContainerShortIterator(MappeableArrayContainer p) {
        this.wrap(p);
    }

    void wrap(MappeableArrayContainer p) {
        this.parent = p;
        this.pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public short next() {
        return this.parent.content.get(this.pos++);
    }

    @Override
    public int nextAsInt() {
        return BufferUtil.toIntUnsigned(this.parent.content.get(this.pos++));
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void remove() {
        this.parent.remove((short)(this.pos - 1));
        --this.pos;
    }

    @Override
    public short peekNext() {
        return this.parent.content.get(this.pos);
    }

    @Override
    public void advanceIfNeeded(short minval) {
        this.pos = BufferUtil.advanceUntil(this.parent.content, this.pos - 1, this.parent.cardinality, minval);
    }
}

