/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerPointer;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.Util;

public final class RoaringArray
implements Cloneable,
Externalizable {
    protected static final short SERIAL_COOKIE_NO_RUNCONTAINER = 12346;
    protected static final short SERIAL_COOKIE = 12347;
    protected static final int NO_OFFSET_THRESHOLD = 4;
    private static final long serialVersionUID = 8L;
    short[] keys = new short[4];
    Container[] values = new Container[4];
    int size = 0;
    static final int INITIAL_CAPACITY = 4;

    protected RoaringArray() {
    }

    protected void append(short key, Container value) {
        this.extendArray(1);
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
    }

    protected void appendCopy(RoaringArray sa, int index) {
        this.extendArray(1);
        this.keys[this.size] = sa.keys[index];
        this.values[this.size] = sa.values[index].clone();
        ++this.size;
    }

    protected void appendCopy(RoaringArray sa, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.keys[this.size] = sa.keys[i];
            this.values[this.size] = sa.values[i].clone();
            ++this.size;
        }
    }

    protected void appendCopiesUntil(RoaringArray sourceArray, short stoppingKey) {
        int stopKey = Util.toIntUnsigned(stoppingKey);
        for (int i = 0; i < sourceArray.size && Util.toIntUnsigned(sourceArray.keys[i]) < stopKey; ++i) {
            this.extendArray(1);
            this.keys[this.size] = sourceArray.keys[i];
            this.values[this.size] = sourceArray.values[i].clone();
            ++this.size;
        }
    }

    protected void appendCopiesAfter(RoaringArray sa, short beforeStart) {
        int startLocation = sa.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(sa.size - startLocation);
        for (int i = startLocation; i < sa.size; ++i) {
            this.keys[this.size] = sa.keys[i];
            this.values[this.size] = sa.values[i].clone();
            ++this.size;
        }
    }

    protected void clear() {
        this.keys = null;
        this.values = null;
        this.size = 0;
    }

    public RoaringArray clone() throws CloneNotSupportedException {
        RoaringArray sa = (RoaringArray)super.clone();
        sa.keys = Arrays.copyOf(this.keys, this.size);
        sa.values = Arrays.copyOf(this.values, this.size);
        for (int k = 0; k < this.size; ++k) {
            sa.values[k] = sa.values[k].clone();
        }
        sa.size = this.size;
        return sa;
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringArray) {
            RoaringArray srb = (RoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                if (this.keys[i] == srb.keys[i] && this.values[i].equals(srb.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.keys.length) {
            int newCapacity = this.keys.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.keys = Arrays.copyOf(this.keys, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
    }

    protected Container getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.values[i];
    }

    protected Container getContainerAtIndex(int i) {
        return this.values[i];
    }

    protected int getIndex(short x) {
        if (this.size == 0 || this.keys[this.size - 1] == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    protected int advanceUntil(short x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || Util.toIntUnsigned(this.keys[lower]) >= Util.toIntUnsigned(x)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && Util.toIntUnsigned(this.keys[lower + spansize]) < Util.toIntUnsigned(x)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.keys[upper] == x) {
            return upper;
        }
        if (Util.toIntUnsigned(this.keys[upper]) < Util.toIntUnsigned(x)) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.keys[mid] == x) {
                return mid;
            }
            if (Util.toIntUnsigned(this.keys[mid]) < Util.toIntUnsigned(x)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    protected short getKeyAtIndex(int i) {
        return this.keys[i];
    }

    public int hashCode() {
        int hashvalue = 0;
        for (int k = 0; k < this.size; ++k) {
            hashvalue = 31 * hashvalue + this.keys[k] * 0xF0F0F0 + this.values[k].hashCode();
        }
        return hashvalue;
    }

    protected void insertNewKeyValueAt(int i, short key, Container value) {
        this.extendArray(1);
        System.arraycopy(this.keys, i, this.keys, i + 1, this.size - i);
        this.keys[i] = key;
        System.arraycopy(this.values, i, this.values, i + 1, this.size - i);
        this.values[i] = value;
        ++this.size;
    }

    protected void resize(int newLength) {
        Arrays.fill(this.keys, newLength, this.size, (short)0);
        Arrays.fill(this.values, newLength, this.size, null);
        this.size = newLength;
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.keys, i + 1, this.keys, i, this.size - i - 1);
        this.keys[this.size - 1] = 0;
        System.arraycopy(this.values, i + 1, this.values, i, this.size - i - 1);
        this.values[this.size - 1] = null;
        --this.size;
    }

    protected void removeIndexRange(int begin, int end) {
        if (end <= begin) {
            return;
        }
        int range = end - begin;
        System.arraycopy(this.keys, end, this.keys, begin, this.size - end);
        System.arraycopy(this.values, end, this.values, begin, this.size - end);
        for (int i = 1; i <= range; ++i) {
            this.keys[this.size - i] = 0;
            this.values[this.size - i] = null;
        }
        this.size -= range;
    }

    protected void copyRange(int begin, int end, int newBegin) {
        int range = end - begin;
        System.arraycopy(this.keys, begin, this.keys, newBegin, range);
        System.arraycopy(this.values, begin, this.values, newBegin, range);
    }

    protected void setContainerAtIndex(int i, Container c) {
        this.values[i] = c;
    }

    protected void replaceKeyAndContainerAtIndex(int i, short key, Container c) {
        this.keys[i] = key;
        this.values[i] = c;
    }

    protected int size() {
        return this.size;
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = Util.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(this.keys[middleIndex]);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    boolean hasRunContainer() {
        for (int k = 0; k < this.size; ++k) {
            Container ck = this.values[k];
            if (!(ck instanceof RunContainer)) continue;
            return true;
        }
        return false;
    }

    public void serialize(DataOutput out) throws IOException {
        int k;
        int startOffset = 0;
        boolean hasrun = this.hasRunContainer();
        if (hasrun) {
            out.writeInt(Integer.reverseBytes(0x303B | this.size - 1 << 16));
            byte[] bitmapOfRunContainers = new byte[(this.size + 7) / 8];
            for (int i = 0; i < this.size; ++i) {
                if (!(this.values[i] instanceof RunContainer)) continue;
                int n = i / 8;
                bitmapOfRunContainers[n] = (byte)(bitmapOfRunContainers[n] | 1 << i % 8);
            }
            out.write(bitmapOfRunContainers);
            startOffset = this.size < 4 ? 4 + 4 * this.size + bitmapOfRunContainers.length : 4 + 8 * this.size + bitmapOfRunContainers.length;
        } else {
            out.writeInt(Integer.reverseBytes(12346));
            out.writeInt(Integer.reverseBytes(this.size));
            startOffset = 8 + 4 * this.size + 4 * this.size;
        }
        for (k = 0; k < this.size; ++k) {
            out.writeShort(Short.reverseBytes(this.keys[k]));
            out.writeShort(Short.reverseBytes((short)(this.values[k].getCardinality() - 1)));
        }
        if (!hasrun || this.size >= 4) {
            for (k = 0; k < this.size; ++k) {
                out.writeInt(Integer.reverseBytes(startOffset));
                startOffset += this.values[k].getArraySizeInBytes();
            }
        }
        for (k = 0; k < this.size; ++k) {
            this.values[k].writeArray(out);
        }
    }

    public int serializedSizeInBytes() {
        int count = this.headerSize();
        for (int k = 0; k < this.size; ++k) {
            count += this.values[k].getArraySizeInBytes();
        }
        return count;
    }

    protected int headerSize() {
        if (this.hasRunContainer()) {
            if (this.size < 4) {
                return 4 + (this.size + 7) / 8 + 4 * this.size;
            }
            return 4 + (this.size + 7) / 8 + 8 * this.size;
        }
        return 8 + 8 * this.size;
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        boolean hasrun;
        this.clear();
        int cookie = Integer.reverseBytes(in.readInt());
        if ((cookie & 0xFFFF) != 12347 && cookie != 12346) {
            throw new IOException("I failed to find one of the right cookies.");
        }
        int n = this.size = (cookie & 0xFFFF) == 12347 ? (cookie >>> 16) + 1 : Integer.reverseBytes(in.readInt());
        if (this.keys == null || this.keys.length < this.size) {
            this.keys = new short[this.size];
            this.values = new Container[this.size];
        }
        byte[] bitmapOfRunContainers = null;
        boolean bl = hasrun = (cookie & 0xFFFF) == 12347;
        if (hasrun) {
            bitmapOfRunContainers = new byte[(this.size + 7) / 8];
            in.readFully(bitmapOfRunContainers);
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = Short.reverseBytes(in.readShort());
            cardinalities[k] = 1 + (0xFFFF & Short.reverseBytes(in.readShort()));
            boolean bl2 = isBitmap[k] = cardinalities[k] > 4096;
            if (bitmapOfRunContainers == null || (bitmapOfRunContainers[k / 8] & 1 << k % 8) == 0) continue;
            isBitmap[k] = false;
        }
        if (!hasrun || this.size >= 4) {
            in.skipBytes(this.size * 4);
        }
        for (k = 0; k < this.size; ++k) {
            Container val;
            int l;
            if (isBitmap[k]) {
                long[] bitmapArray = new long[1024];
                for (l = 0; l < bitmapArray.length; ++l) {
                    bitmapArray[l] = Long.reverseBytes(in.readLong());
                }
                val = new BitmapContainer(bitmapArray, cardinalities[k]);
            } else if (bitmapOfRunContainers != null && (bitmapOfRunContainers[k / 8] & 1 << k % 8) != 0) {
                int nbrruns = Util.toIntUnsigned(Short.reverseBytes(in.readShort()));
                short[] lengthsAndValues = new short[2 * nbrruns];
                for (int j = 0; j < 2 * nbrruns; ++j) {
                    lengthsAndValues[j] = Short.reverseBytes(in.readShort());
                }
                val = new RunContainer(lengthsAndValues, nbrruns);
            } else {
                short[] shortArray = new short[cardinalities[k]];
                for (l = 0; l < shortArray.length; ++l) {
                    shortArray[l] = Short.reverseBytes(in.readShort());
                }
                val = new ArrayContainer(shortArray);
            }
            this.keys[k] = keys[k];
            this.values[k] = val;
        }
    }

    protected ContainerPointer getContainerPointer() {
        return new ContainerPointer(){
            int k = 0;

            @Override
            public Container getContainer() {
                if (this.k >= RoaringArray.this.size) {
                    return null;
                }
                return RoaringArray.this.values[this.k];
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public short key() {
                return RoaringArray.this.keys[this.k];
            }

            @Override
            public boolean isBitmapContainer() {
                return this.getContainer() instanceof BitmapContainer;
            }

            @Override
            public boolean isRunContainer() {
                return this.getContainer() instanceof RunContainer;
            }

            @Override
            public int getCardinality() {
                return this.getContainer().getCardinality();
            }

            @Override
            public int compareTo(ContainerPointer o) {
                if (this.key() != o.key()) {
                    return Util.toIntUnsigned(this.key()) - Util.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }
        };
    }
}

