/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.LongBuffer;
import java.util.Iterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableContainer;

public final class MappeableBitmapContainer
extends MappeableContainer
implements Cloneable,
Serializable {
    protected static final int MAX_CAPACITY = 65536;
    private static final long serialVersionUID = 2L;
    private static boolean USE_IN_PLACE = true;
    LongBuffer bitmap;
    int cardinality;

    public MappeableBitmapContainer() {
        this.cardinality = 0;
        this.bitmap = LongBuffer.allocate(1024);
    }

    public MappeableBitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun + 1;
        this.bitmap = LongBuffer.allocate(1024);
        if (this.cardinality == 65536) {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                this.bitmap.put(k, -1L);
            }
        } else {
            int firstWord = firstOfRun / 64;
            int lastWord = lastOfRun / 64;
            int zeroPrefixLength = firstOfRun & 0x3F;
            int zeroSuffixLength = 63 - (lastOfRun & 0x3F);
            for (int k = firstWord; k < lastWord + 1; ++k) {
                this.bitmap.put(k, -1L);
            }
            this.bitmap.put(firstWord, this.bitmap.get(firstWord) ^ (1L << zeroPrefixLength) - 1L);
            long blockOfOnes = (1L << zeroSuffixLength) - 1L;
            long maskOnLeft = blockOfOnes << 64 - zeroSuffixLength;
            this.bitmap.put(lastWord, this.bitmap.get(lastWord) ^ maskOnLeft);
        }
    }

    MappeableBitmapContainer(int newCardinality, LongBuffer newBitmap) {
        this.cardinality = newCardinality;
        this.bitmap = LongBuffer.allocate(newBitmap.limit());
        newBitmap.rewind();
        this.bitmap.put(newBitmap);
    }

    public MappeableBitmapContainer(LongBuffer array, int initCardinality) {
        if (array.limit() != 1024) {
            throw new RuntimeException("Mismatch between buffer and storage requirements: " + array.limit() + " vs. " + 1024);
        }
        this.cardinality = initCardinality;
        this.bitmap = array;
    }

    @Override
    public MappeableContainer add(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        long previous = this.bitmap.get(x / 64);
        this.bitmap.put(x / 64, previous | 1L << x);
        this.cardinality = (int)((long)this.cardinality + ((previous ^ this.bitmap.get(x / 64)) >>> x));
        return this;
    }

    @Override
    public MappeableArrayContainer and(MappeableArrayContainer value2) {
        MappeableArrayContainer answer = new MappeableArrayContainer(value2.content.limit());
        short[] sarray = answer.content.array();
        if (value2.content.hasArray()) {
            short[] c = value2.content.array();
            for (int k = 0; k < value2.getCardinality(); ++k) {
                if (!this.contains(c[k])) continue;
                sarray[answer.cardinality++] = c[k];
            }
        } else {
            for (int k = 0; k < value2.getCardinality(); ++k) {
                if (!this.contains(value2.content.get(k))) continue;
                sarray[answer.cardinality++] = value2.content.get(k);
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer value2) {
        int k;
        int newCardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] tb = this.bitmap.array();
            long[] v2b = value2.bitmap.array();
            for (k = 0; k < this.bitmap.limit(); ++k) {
                newCardinality += Long.bitCount(tb[k] & v2b[k]);
            }
        } else {
            for (int k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) & value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            long[] bitArray = answer.bitmap.array();
            if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
                long[] tb = this.bitmap.array();
                long[] v2b = value2.bitmap.array();
                for (int k3 = 0; k3 < answer.bitmap.limit(); ++k3) {
                    bitArray[k3] = tb[k3] & v2b[k3];
                }
            } else {
                for (k = 0; k < answer.bitmap.limit(); ++k) {
                    bitArray[k] = this.bitmap.get(k) & value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            Util.fillArrayAND(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer andNot(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        long[] bitArray = answer.bitmap.array();
        if (value2.content.hasArray() && this.bitmap.hasArray()) {
            short[] v2 = value2.content.array();
            long[] ba = this.bitmap.array();
            for (int k = 0; k < value2.cardinality; ++k) {
                int i;
                int n = i = BufferUtil.toIntUnsigned(v2[k]) >>> 6;
                bitArray[n] = bitArray[n] & (1L << v2[k] ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((bitArray[i] ^ ba[i]) >>> v2[k]));
            }
        } else {
            for (int k = 0; k < value2.cardinality; ++k) {
                int i;
                int n = i = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
                bitArray[n] = bitArray[n] & (1L << value2.content.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((bitArray[i] ^ this.bitmap.get(i)) >>> value2.content.get(k)));
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableBitmapContainer value2) {
        int k;
        int newCardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            for (k = 0; k < this.bitmap.limit(); ++k) {
                newCardinality += Long.bitCount(b[k] & (v2[k] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        } else {
            for (int k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) & (value2.bitmap.get(k2) ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            long[] bitArray = answer.bitmap.array();
            if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                for (int k3 = 0; k3 < answer.bitmap.limit(); ++k3) {
                    bitArray[k3] = b[k3] & (v2[k3] ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                for (k = 0; k < answer.bitmap.limit(); ++k) {
                    bitArray[k] = this.bitmap.get(k) & (value2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            Util.fillArrayANDNOT(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayANDNOT(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                this.bitmap.put(k, 0L);
            }
        }
    }

    @Override
    public MappeableBitmapContainer clone() {
        return new MappeableBitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean contains(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        return (this.bitmap.get(x / 64) & 1L << x) != 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof MappeableBitmapContainer) {
            MappeableBitmapContainer srb = (MappeableBitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (this.bitmap.hasArray() && srb.bitmap.hasArray()) {
                long[] b = this.bitmap.array();
                long[] s = srb.bitmap.array();
                for (int k = 0; k < this.bitmap.limit(); ++k) {
                    if (b[k] == s[k]) continue;
                    return false;
                }
            } else {
                for (int k = 0; k < this.bitmap.limit(); ++k) {
                    if (this.bitmap.get(k) == srb.bitmap.get(k)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        if (this.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = b[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    array[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        } else {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    array[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        if (this.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = b[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    x[pos++] = k * 64 + Long.bitCount(t - 1L) | mask;
                }
            }
        } else {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    x[pos++] = k * 64 + Long.bitCount(t - 1L) | mask;
                }
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ShortIterator(){
            int i;
            int max;
            int j;
            {
                this.i = MappeableBitmapContainer.this.nextSetBit(0);
                this.max = MappeableBitmapContainer.this.bitmap.limit() * 64 - 1;
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public short next() {
                this.j = this.i;
                this.i = this.i < this.max ? MappeableBitmapContainer.this.nextSetBit(this.i + 1) : -1;
                return (short)this.j;
            }

            @Override
            public ShortIterator clone() {
                try {
                    return (ShortIterator)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ShortIterator(){
            int i;
            int j;
            {
                this.i = MappeableBitmapContainer.this.prevSetBit(64 * MappeableBitmapContainer.this.bitmap.limit() - 1);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public short next() {
                this.j = this.i;
                this.i = this.i > 0 ? MappeableBitmapContainer.this.prevSetBit(this.i - 1) : -1;
                return (short)this.j;
            }

            @Override
            public ShortIterator clone() {
                try {
                    return (ShortIterator)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.limit() * 8;
    }

    public int hashCode() {
        long hash = 0L;
        for (int k = 0; k < this.bitmap.limit(); ++k) {
            hash += 31L * hash + this.bitmap.get(k);
        }
        return (int)hash;
    }

    @Override
    public MappeableContainer iand(MappeableArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.limit(); ++k) {
            newCardinality += Long.bitCount(this.bitmap.get(k) & b2.bitmap.get(k));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.limit(); ++k) {
                this.bitmap.put(k, this.bitmap.get(k) & b2.bitmap.get(k));
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer iandNot(MappeableArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content.get(k));
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer iandNot(MappeableBitmapContainer b2) {
        int k;
        int newCardinality = 0;
        long[] b = this.bitmap.array();
        if (b2.bitmap.hasArray()) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newCardinality += Long.bitCount(b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                    this.bitmap.put(k2, b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            Util.fillArrayANDNOT(ac.content.array(), b, b2Arr);
            ac.cardinality = newCardinality;
            return ac;
        }
        for (k = 0; k < this.bitmap.limit(); ++k) {
            newCardinality += Long.bitCount(b[k] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.limit(); ++k) {
                int n = k;
                b[n] = b[n] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayANDNOT(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer inot(int firstOfRange, int lastOfRange) {
        return this.not(this, firstOfRange, lastOfRange);
    }

    @Override
    public MappeableBitmapContainer ior(MappeableArrayContainer value2) {
        long[] b = this.bitmap.array();
        if (value2.content.hasArray()) {
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.cardinality; ++k) {
                int i = BufferUtil.toIntUnsigned(v2[k]) >>> 6;
                this.cardinality = (int)((long)this.cardinality + (((b[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content.get(k)) >>> v2[k]));
                int n = i;
                b[n] = b[n] | 1L << v2[k];
            }
            return this;
        }
        for (int k = 0; k < value2.cardinality; ++k) {
            int i = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
            this.cardinality = (int)((long)this.cardinality + (((b[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content.get(k)) >>> value2.content.get(k)));
            int n = i;
            b[n] = b[n] | 1L << value2.content.get(k);
        }
        return this;
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer b2) {
        long[] b = this.bitmap.array();
        this.cardinality = 0;
        if (b2.bitmap.hasArray()) {
            long[] b2Arr = b2.bitmap.array();
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                int n = k;
                b[n] = b[n] | b2Arr[k];
                this.cardinality += Long.bitCount(b[k]);
            }
            return this;
        }
        for (int k = 0; k < this.bitmap.limit(); ++k) {
            int n = k;
            b[n] = b[n] | b2.bitmap.get(k);
            this.cardinality += Long.bitCount(b[k]);
        }
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            final ShortIterator si;
            {
                this.si = MappeableBitmapContainer.this.getShortIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Short next() {
                return this.si.next();
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public MappeableContainer ixor(MappeableArrayContainer value2) {
        long[] b = this.bitmap.array();
        if (value2.content.hasArray()) {
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = BufferUtil.toIntUnsigned(v2[k]) >>> 6;
                this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((b[index] & 1L << v2[k]) >>> v2[k])));
                int n = index;
                b[n] = b[n] ^ 1L << v2[k];
            }
        } else {
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
                this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((b[index] & 1L << value2.content.get(k)) >>> value2.content.get(k))));
                int n = index;
                b[n] = b[n] ^ 1L << value2.content.get(k);
            }
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer ixor(MappeableBitmapContainer b2) {
        int k;
        long[] b = this.bitmap.array();
        if (b2.bitmap.hasArray()) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            int newCardinality = 0;
            for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newCardinality += Long.bitCount(b[k2] ^ b2Arr[k2]);
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                    int n = k2;
                    b[n] = b[n] ^ b2Arr[k2];
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            Util.fillArrayXOR(ac.content.array(), b, b2Arr);
            ac.cardinality = newCardinality;
            return ac;
        }
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.limit(); ++k) {
            newCardinality += Long.bitCount(b[k] ^ b2.bitmap.get(k));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.limit(); ++k) {
                int n = k;
                b[n] = b[n] ^ b2.bitmap.get(k);
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayXOR(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    protected void loadData(MappeableArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        long[] bitArray = this.bitmap.array();
        if (this.bitmap.hasArray() && arrayContainer.content.hasArray()) {
            long[] b = this.bitmap.array();
            short[] ac = arrayContainer.content.array();
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                short x = ac[k];
                bitArray[BufferUtil.toIntUnsigned((short)x) / 64] = b[BufferUtil.toIntUnsigned(x) / 64] | 1L << x;
            }
        } else {
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                short x = arrayContainer.content.get(k);
                bitArray[BufferUtil.toIntUnsigned((short)x) / 64] = this.bitmap.get(BufferUtil.toIntUnsigned(x) / 64) | 1L << x;
            }
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x);
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.limit()) {
            if (this.bitmap.get(x) != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap.get(x));
            }
            ++x;
        }
        return -1;
    }

    public int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x);
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            if (this.bitmap.get(x) != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(this.bitmap.get(x));
            }
            --x;
        }
        return -1;
    }

    public short nextUnsetBit(int i) {
        int x = i / 64;
        long w = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return (short)(i + Long.numberOfTrailingZeros(w));
        }
        ++x;
        while (x < this.bitmap.limit()) {
            if (this.bitmap.get(x) != -1L) {
                return (short)(x * 64 + Long.numberOfTrailingZeros(this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            ++x;
        }
        return -1;
    }

    @Override
    public MappeableContainer not(int firstOfRange, int lastOfRange) {
        return this.not(new MappeableBitmapContainer(), firstOfRange, lastOfRange);
    }

    private MappeableContainer not(MappeableBitmapContainer answer, int firstOfRange, int lastOfRange) {
        assert (this.bitmap.limit() == 1024);
        if (lastOfRange - firstOfRange + 1 == 65536) {
            int newCardinality = 65536 - this.cardinality;
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                answer.bitmap.put(k, this.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            if (newCardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        int cardinalityChange = 0;
        int rangeFirstWord = firstOfRange / 64;
        int rangeFirstBitPos = firstOfRange & 0x3F;
        int rangeLastWord = lastOfRange / 64;
        long rangeLastBitPos = lastOfRange & 0x3F;
        if (answer != this) {
            int i;
            for (i = 0; i < rangeFirstWord; ++i) {
                answer.bitmap.put(i, this.bitmap.get(i));
            }
            for (i = rangeLastWord + 1; i < this.bitmap.limit(); ++i) {
                answer.bitmap.put(i, this.bitmap.get(i));
            }
        }
        long maskOnLeft = rangeLastBitPos == 63L ? -1L : (1L << (int)(rangeLastBitPos + 1L)) - 1L;
        long mask = -1L;
        mask ^= (1L << rangeFirstBitPos) - 1L;
        if (rangeFirstWord == rangeLastWord) {
            cardinalityChange = -Long.bitCount(this.bitmap.get(rangeFirstWord));
            answer.bitmap.put(rangeFirstWord, this.bitmap.get(rangeFirstWord) ^ (mask &= maskOnLeft));
            answer.cardinality = this.cardinality + (cardinalityChange += Long.bitCount(answer.bitmap.get(rangeFirstWord)));
            if (answer.cardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        cardinalityChange += -Long.bitCount(this.bitmap.get(rangeFirstWord));
        answer.bitmap.put(rangeFirstWord, this.bitmap.get(rangeFirstWord) ^ mask);
        cardinalityChange += Long.bitCount(answer.bitmap.get(rangeFirstWord));
        cardinalityChange += -Long.bitCount(this.bitmap.get(rangeLastWord));
        answer.bitmap.put(rangeLastWord, this.bitmap.get(rangeLastWord) ^ maskOnLeft);
        cardinalityChange += Long.bitCount(answer.bitmap.get(rangeLastWord));
        for (int i = rangeFirstWord + 1; i < rangeLastWord; ++i) {
            cardinalityChange += 64 - 2 * Long.bitCount(this.bitmap.get(i));
            answer.bitmap.put(i, this.bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        answer.cardinality = this.cardinality + cardinalityChange;
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableBitmapContainer or(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        long[] bitArray = answer.bitmap.array();
        if (answer.bitmap.hasArray() && value2.content.hasArray()) {
            long[] ab = answer.bitmap.array();
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.cardinality; ++k) {
                int i = BufferUtil.toIntUnsigned(v2[k]) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (((ab[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << v2[k]) >>> v2[k]));
                int n = i;
                bitArray[n] = bitArray[n] | 1L << value2.content.get(k);
            }
        } else {
            for (int k = 0; k < value2.cardinality; ++k) {
                int i = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (((answer.bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content.get(k)) >>> value2.content.get(k)));
                int n = i;
                bitArray[n] = bitArray[n] | 1L << value2.content.get(k);
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer value2) {
        if (USE_IN_PLACE) {
            MappeableBitmapContainer value1 = this.clone();
            return value1.ior(value2);
        }
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        long[] bitArray = answer.bitmap.array();
        answer.cardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            for (int k = 0; k < answer.bitmap.limit(); ++k) {
                bitArray[k] = b[k] | v2[k];
                answer.cardinality += Long.bitCount(bitArray[k]);
            }
        } else {
            for (int k = 0; k < answer.bitmap.limit(); ++k) {
                bitArray[k] = this.bitmap.get(k) | value2.bitmap.get(k);
                answer.cardinality += Long.bitCount(bitArray[k]);
            }
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[8];
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.limit(); ++k) {
            in.readFully(buffer);
            this.bitmap.put(k, ((long)buffer[7] << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + (long)((buffer[2] & 0xFF) << 16) + (long)((buffer[1] & 0xFF) << 8) + (long)(buffer[0] & 0xFF));
            this.cardinality += Long.bitCount(this.bitmap.get(k));
        }
    }

    @Override
    public MappeableContainer remove(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        if (this.cardinality == 4097 && (this.bitmap.get(x / 64) & 1L << x) != 0L) {
            --this.cardinality;
            this.bitmap.put(x / 64, this.bitmap.get(x / 64) & (1L << x ^ 0xFFFFFFFFFFFFFFFFL));
            return this.toArrayContainer();
        }
        this.cardinality = (int)((long)this.cardinality - ((this.bitmap.get(x / 64) & 1L << x) >>> x));
        this.bitmap.put(x / 64, this.bitmap.get(x / 64) & (1L << x ^ 0xFFFFFFFFFFFFFFFFL));
        return this;
    }

    public MappeableArrayContainer toArrayContainer() {
        MappeableArrayContainer ac = new MappeableArrayContainer(this.cardinality);
        ac.loadData(this);
        return ac;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ShortIterator i = this.getShortIterator();
        sb.append("{");
        while (i.hasNext()) {
            sb.append(i);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        byte[] buffer = new byte[8];
        for (int k = 0; k < 1024; ++k) {
            long w = this.bitmap.get(k);
            buffer[0] = (byte)w;
            buffer[1] = (byte)(w >>> 8);
            buffer[2] = (byte)(w >>> 16);
            buffer[3] = (byte)(w >>> 24);
            buffer[4] = (byte)(w >>> 32);
            buffer[5] = (byte)(w >>> 40);
            buffer[6] = (byte)(w >>> 48);
            buffer[7] = (byte)(w >>> 56);
            out.write(buffer, 0, 8);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeArray(out);
    }

    @Override
    public MappeableContainer xor(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        long[] bitArray = answer.bitmap.array();
        if (value2.content.hasArray()) {
            short[] v2 = value2.content.array();
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = BufferUtil.toIntUnsigned(v2[k]) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((bitArray[index] & 1L << v2[k]) >>> v2[k])));
                int n = index;
                bitArray[n] = bitArray[n] ^ 1L << v2[k];
            }
        } else {
            for (int k = 0; k < value2.getCardinality(); ++k) {
                int index = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
                answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((bitArray[index] & 1L << value2.content.get(k)) >>> value2.content.get(k))));
                int n = index;
                bitArray[n] = bitArray[n] ^ 1L << value2.content.get(k);
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer xor(MappeableBitmapContainer value2) {
        int k;
        int newCardinality = 0;
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            for (k = 0; k < this.bitmap.limit(); ++k) {
                newCardinality += Long.bitCount(b[k] ^ v2[k]);
            }
        } else {
            for (int k2 = 0; k2 < this.bitmap.limit(); ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) ^ value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            long[] bitArray = answer.bitmap.array();
            if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                for (int k3 = 0; k3 < answer.bitmap.limit(); ++k3) {
                    bitArray[k3] = b[k3] ^ v2[k3];
                }
            } else {
                for (k = 0; k < answer.bitmap.limit(); ++k) {
                    bitArray[k] = this.bitmap.get(k) ^ value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (this.bitmap.hasArray() && value2.bitmap.hasArray()) {
            Util.fillArrayXOR(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayXOR(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    protected MappeableContainer ilazyor(MappeableArrayContainer value2) {
        this.cardinality = -1;
        long[] b = this.bitmap.array();
        for (int k = 0; k < value2.cardinality; ++k) {
            int i;
            int n = i = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
            b[n] = b[n] | 1L << value2.content.get(k);
        }
        return this;
    }

    protected MappeableContainer ilazyor(MappeableBitmapContainer x) {
        this.cardinality = -1;
        long[] b = this.bitmap.array();
        if (x.bitmap.hasArray()) {
            long[] b2 = x.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                int n = k;
                b[n] = b[n] | b2[k];
            }
        } else {
            for (int k = 0; k < b.length; ++k) {
                int n = k;
                b[n] = b[n] | x.bitmap.get(k);
            }
        }
        return this;
    }

    protected MappeableContainer lazyor(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        answer.cardinality = -1;
        long[] b = answer.bitmap.array();
        for (int k = 0; k < value2.cardinality; ++k) {
            int i;
            int n = i = BufferUtil.toIntUnsigned(value2.content.get(k)) >>> 6;
            b[n] = b[n] | 1L << value2.content.get(k);
        }
        return answer;
    }

    protected MappeableContainer lazyor(MappeableBitmapContainer x) {
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        answer.cardinality = -1;
        long[] b = answer.bitmap.array();
        for (int k = 0; k < b.length; ++k) {
            b[k] = this.bitmap.get(k) | x.bitmap.get(k);
        }
        return answer;
    }

    protected void computeCardinality() {
        this.cardinality = 0;
        long[] b = this.bitmap.array();
        for (int k = 0; k < b.length; ++k) {
            this.cardinality += Long.bitCount(b[k]);
        }
    }

    @Override
    public int rank(short lowbits) {
        int x = BufferUtil.toIntUnsigned(lowbits);
        int leftover = x + 1 & 0x3F;
        int answer = 0;
        if (this.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < (x + 1) / 64; ++k) {
                answer += Long.bitCount(b[k]);
            }
            if (leftover != 0) {
                answer += Long.bitCount(b[(x + 1) / 64] << 64 - leftover);
            }
        } else {
            for (int k = 0; k < (x + 1) / 64; ++k) {
                answer += Long.bitCount(this.bitmap.get(k));
            }
            if (leftover != 0) {
                answer += Long.bitCount(this.bitmap.get((x + 1) / 64) << 64 - leftover);
            }
        }
        return answer;
    }

    @Override
    public short select(int j) {
        int leftover = j;
        if (this.bitmap.hasArray()) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                int w = Long.bitCount(b[k]);
                if (w > leftover) {
                    return (short)(k * 64 + Util.select(b[k], leftover));
                }
                leftover -= w;
            }
        } else {
            for (int k = 0; k < this.bitmap.limit(); ++k) {
                int w = Long.bitCount(this.bitmap.get(k));
                if (w > leftover) {
                    return (short)(k * 64 + Util.select(this.bitmap.get(k), leftover));
                }
                leftover -= w;
            }
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public MappeableContainer limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 65536) {
            MappeableArrayContainer ac = new MappeableArrayContainer(maxcardinality);
            int pos = 0;
            short[] cont = ac.content.array();
            for (int k = 0; ac.cardinality < maxcardinality && k < this.bitmap.limit(); ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); ac.cardinality < maxcardinality && bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    cont[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        MappeableBitmapContainer bc = new MappeableBitmapContainer(maxcardinality, this.bitmap);
        int s = BufferUtil.toIntUnsigned(this.select(maxcardinality));
        int usedwords = (s + 63) / 64;
        int todelete = this.bitmap.limit() - usedwords;
        for (int k = 0; k < todelete; ++k) {
            bc.bitmap.put(bc.bitmap.limit() - 1 - k, 0L);
        }
        int lastword = s % 64;
        if (lastword != 0) {
            bc.bitmap.put(s / 64, bc.bitmap.get(s / 64) << 64 - lastword >> 64 - lastword);
        }
        return bc;
    }
}

