/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitmapContainer
extends Container
implements Cloneable,
Serializable {
    protected static int maxcapacity = 65536;
    private static final long serialVersionUID = 2L;
    private static boolean USEINPLACE = true;
    long[] bitmap;
    int cardinality;

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = new long[maxcapacity / 64];
    }

    public BitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun + 1;
        this.bitmap = new long[maxcapacity / 64];
        if (this.cardinality == maxcapacity) {
            Arrays.fill(this.bitmap, -1L);
        } else {
            int firstWord = firstOfRun / 64;
            int lastWord = lastOfRun / 64;
            int zeroPrefixLength = firstOfRun & 0x3F;
            int zeroSuffixLength = 63 - (lastOfRun & 0x3F);
            Arrays.fill(this.bitmap, firstWord, lastWord + 1, -1L);
            int n = firstWord;
            this.bitmap[n] = this.bitmap[n] ^ (1L << zeroPrefixLength) - 1L;
            long blockOfOnes = (1L << zeroSuffixLength) - 1L;
            long maskOnLeft = blockOfOnes << 64 - zeroSuffixLength;
            int n2 = lastWord;
            this.bitmap[n2] = this.bitmap[n2] ^ maskOnLeft;
        }
    }

    private BitmapContainer(int newcardinality, long[] newbitmap) {
        this.cardinality = newcardinality;
        this.bitmap = Arrays.copyOf(newbitmap, newbitmap.length);
    }

    protected BitmapContainer(long[] newbitmap, int newcardinality) {
        this.cardinality = newcardinality;
        this.bitmap = newbitmap;
    }

    @Override
    public Container add(short i) {
        int x = Util.toIntUnsigned(i);
        long previous = this.bitmap[x / 64];
        int n = x / 64;
        this.bitmap[n] = this.bitmap[n] | 1L << x;
        this.cardinality = (int)((long)this.cardinality + ((previous ^ this.bitmap[x / 64]) >>> x));
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.length);
        for (int k = 0; k < value2.getCardinality(); ++k) {
            if (!this.contains(value2.content[k])) continue;
            answer.content[answer.cardinality++] = value2.content[k];
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        int newcardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newcardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        if (newcardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & value2.bitmap[k];
            }
            answer.cardinality = newcardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayAND(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        for (int k = 0; k < value2.cardinality; ++k) {
            int i = Util.toIntUnsigned(value2.content[k]) >>> 6;
            answer.bitmap[i] = answer.bitmap[i] & (1L << value2.content[k] ^ 0xFFFFFFFFFFFFFFFFL);
            answer.cardinality = (int)((long)answer.cardinality - ((answer.bitmap[i] ^ this.bitmap[i]) >>> value2.content[k]));
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        int newcardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newcardinality += Long.bitCount(this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newcardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newcardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            Arrays.fill(this.bitmap, 0L);
        }
    }

    @Override
    public BitmapContainer clone() {
        return new BitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean contains(short i) {
        int x = Util.toIntUnsigned(i);
        return (this.bitmap[x / 64] & 1L << x) != 0L;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        byte[] buffer = new byte[8];
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            in.readFully(buffer);
            this.bitmap[k] = ((long)buffer[7] << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + (long)((buffer[2] & 0xFF) << 16) + (long)((buffer[1] & 0xFF) << 8) + (long)((buffer[0] & 0xFF) << 0);
            this.cardinality += Long.bitCount(this.bitmap[k]);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BitmapContainer) {
            BitmapContainer srb = (BitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            return Arrays.equals(this.bitmap, srb.bitmap);
        }
        return false;
    }

    protected void fillArray(int[] array) {
        int pos = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                array[pos++] = k * 64 + Long.bitCount(t - 1L);
            }
        }
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                array[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                x[pos++] = k * 64 + Long.bitCount(t - 1L) | mask;
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return maxcapacity / 8;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ShortIterator(){
            int i;
            int j;
            {
                this.i = BitmapContainer.this.nextSetBit(0);
            }

            public boolean hasNext() {
                return this.i >= 0;
            }

            public short next() {
                this.j = this.i;
                this.i = BitmapContainer.this.nextSetBit(this.i + 1);
                return (short)this.j;
            }

            public void remove() {
                BitmapContainer.this.remove((short)this.j);
            }
        };
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.length * 8;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitmap);
    }

    @Override
    public Container iand(ArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public Container iand(BitmapContainer B2) {
        int k;
        int newcardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newcardinality += Long.bitCount(this.bitmap[k] & B2.bitmap[k]);
        }
        if (newcardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & B2.bitmap[k];
            }
            this.cardinality = newcardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayAND(ac.content, this.bitmap, B2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content[k]);
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        int k;
        int newcardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newcardinality += Long.bitCount(this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newcardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newcardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        return this.not(this, firstOfRange, lastOfRange);
    }

    @Override
    public BitmapContainer ior(ArrayContainer value2) {
        for (int k = 0; k < value2.cardinality; ++k) {
            int i = Util.toIntUnsigned(value2.content[k]) >>> 6;
            this.cardinality = (int)((long)this.cardinality + (((this.bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content[k]) >>> value2.content[k]));
            int n = i;
            this.bitmap[n] = this.bitmap[n] | 1L << value2.content[k];
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] | b2.bitmap[k];
            this.cardinality += Long.bitCount(this.bitmap[k]);
        }
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            int i;
            int j;
            {
                this.i = BitmapContainer.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Short next() {
                this.j = this.i;
                this.i = BitmapContainer.this.nextSetBit(this.i + 1);
                return (short)this.j;
            }

            @Override
            public void remove() {
                BitmapContainer.this.remove((short)this.j);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        for (int k = 0; k < value2.getCardinality(); ++k) {
            int index = Util.toIntUnsigned(value2.content[k]) >>> 6;
            this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((this.bitmap[index] & 1L << value2.content[k]) >>> value2.content[k])));
            int n = index;
            this.bitmap[n] = this.bitmap[n] ^ 1L << value2.content[k];
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container ixor(BitmapContainer b2) {
        int k;
        int newcardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newcardinality += Long.bitCount(this.bitmap[k] ^ b2.bitmap[k]);
        }
        if (newcardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] ^ b2.bitmap[k];
            }
            this.cardinality = newcardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }

    protected void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        for (int k = 0; k < arrayContainer.cardinality; ++k) {
            short x = arrayContainer.content[k];
            int n = Util.toIntUnsigned(x) / 64;
            this.bitmap[n] = this.bitmap[n] | 1L << x;
        }
    }

    public int nextSetBit(int i) {
        int x = i / 64;
        if (x >= this.bitmap.length) {
            return -1;
        }
        long w = this.bitmap[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap[x]);
            }
            ++x;
        }
        return -1;
    }

    public short nextUnsetBit(int i) {
        int x = i / 64;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return (short)(i + Long.numberOfTrailingZeros(w));
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != -1L) {
                return (short)(x * 64 + Long.numberOfTrailingZeros(this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            ++x;
        }
        return -1;
    }

    private Container not(BitmapContainer answer, int firstOfRange, int lastOfRange) {
        assert (this.bitmap.length == maxcapacity / 64);
        if (lastOfRange - firstOfRange + 1 == maxcapacity) {
            int newCardinality = maxcapacity - this.cardinality;
            for (int k = 0; k < this.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            answer.cardinality = newCardinality;
            if (newCardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        int cardinalityChange = 0;
        int rangeFirstWord = firstOfRange / 64;
        int rangeFirstBitPos = firstOfRange & 0x3F;
        int rangeLastWord = lastOfRange / 64;
        long rangeLastBitPos = lastOfRange & 0x3F;
        if (answer != this) {
            int i;
            for (i = 0; i < rangeFirstWord; ++i) {
                answer.bitmap[i] = this.bitmap[i];
            }
            for (i = rangeLastWord + 1; i < this.bitmap.length; ++i) {
                answer.bitmap[i] = this.bitmap[i];
            }
        }
        long maskOnLeft = rangeLastBitPos == 63L ? -1L : (1L << (int)(rangeLastBitPos + 1L)) - 1L;
        long mask = -1L;
        mask ^= (1L << rangeFirstBitPos) - 1L;
        if (rangeFirstWord == rangeLastWord) {
            cardinalityChange = -Long.bitCount(this.bitmap[rangeFirstWord]);
            answer.bitmap[rangeFirstWord] = this.bitmap[rangeFirstWord] ^ (mask &= maskOnLeft);
            answer.cardinality = this.cardinality + (cardinalityChange += Long.bitCount(answer.bitmap[rangeFirstWord]));
            if (answer.cardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        cardinalityChange += -Long.bitCount(this.bitmap[rangeFirstWord]);
        answer.bitmap[rangeFirstWord] = this.bitmap[rangeFirstWord] ^ mask;
        cardinalityChange += Long.bitCount(answer.bitmap[rangeFirstWord]);
        cardinalityChange += -Long.bitCount(this.bitmap[rangeLastWord]);
        answer.bitmap[rangeLastWord] = this.bitmap[rangeLastWord] ^ maskOnLeft;
        cardinalityChange += Long.bitCount(answer.bitmap[rangeLastWord]);
        for (int i = rangeFirstWord + 1; i < rangeLastWord; ++i) {
            cardinalityChange += 64 - 2 * Long.bitCount(this.bitmap[i]);
            answer.bitmap[i] = this.bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        answer.cardinality = this.cardinality + cardinalityChange;
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        return this.not(new BitmapContainer(), firstOfRange, lastOfRange);
    }

    @Override
    public BitmapContainer or(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        for (int k = 0; k < value2.cardinality; ++k) {
            int i = Util.toIntUnsigned(value2.content[k]) >>> 6;
            answer.cardinality = (int)((long)answer.cardinality + (((answer.bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << value2.content[k]) >>> value2.content[k]));
            answer.bitmap[i] = answer.bitmap[i] | 1L << value2.content[k];
        }
        return answer;
    }

    @Override
    public Container or(BitmapContainer value2) {
        if (USEINPLACE) {
            BitmapContainer value1 = this.clone();
            return value1.ior(value2);
        }
        BitmapContainer answer = new BitmapContainer();
        answer.cardinality = 0;
        for (int k = 0; k < answer.bitmap.length; ++k) {
            answer.bitmap[k] = this.bitmap[k] | value2.bitmap[k];
            answer.cardinality += Long.bitCount(answer.bitmap[k]);
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public Container remove(short i) {
        int x = Util.toIntUnsigned(i);
        if (this.cardinality == 4096 && (this.bitmap[x / 64] & 1L << x) != 0L) {
            --this.cardinality;
            int n = x / 64;
            this.bitmap[n] = this.bitmap[n] & (1L << x ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        this.cardinality = (int)((long)this.cardinality - ((this.bitmap[x / 64] & 1L << x) >>> x));
        int n = x / 64;
        this.bitmap[n] = this.bitmap[n] & (1L << x ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        byte[] buffer = new byte[8];
        for (long w : this.bitmap) {
            buffer[0] = (byte)(w >>> 0);
            buffer[1] = (byte)(w >>> 8);
            buffer[2] = (byte)(w >>> 16);
            buffer[3] = (byte)(w >>> 24);
            buffer[4] = (byte)(w >>> 32);
            buffer[5] = (byte)(w >>> 40);
            buffer[6] = (byte)(w >>> 48);
            buffer[7] = (byte)(w >>> 56);
            out.write(buffer, 0, 8);
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return maxcapacity / 8;
    }

    public ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        ac.loadData(this);
        return ac;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int i = this.nextSetBit(0);
        while (i >= 0) {
            sb.append(i);
            if ((i = this.nextSetBit(i + 1)) < 0) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        byte[] buffer = new byte[8];
        for (int k = 0; k < maxcapacity / 64; ++k) {
            long w = this.bitmap[k];
            buffer[0] = (byte)(w >>> 0);
            buffer[1] = (byte)(w >>> 8);
            buffer[2] = (byte)(w >>> 16);
            buffer[3] = (byte)(w >>> 24);
            buffer[4] = (byte)(w >>> 32);
            buffer[5] = (byte)(w >>> 40);
            buffer[6] = (byte)(w >>> 48);
            buffer[7] = (byte)(w >>> 56);
            out.write(buffer, 0, 8);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        for (int k = 0; k < value2.getCardinality(); ++k) {
            int index = Util.toIntUnsigned(value2.content[k]) >>> 6;
            answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((answer.bitmap[index] & 1L << value2.content[k]) >>> value2.content[k])));
            answer.bitmap[index] = answer.bitmap[index] ^ 1L << value2.content[k];
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container xor(BitmapContainer value2) {
        int newcardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newcardinality += Long.bitCount(this.bitmap[k] ^ value2.bitmap[k]);
        }
        if (newcardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ value2.bitmap[k];
            }
            answer.cardinality = newcardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newcardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newcardinality;
        return ac;
    }
}

