/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ShortBuffer;
import java.util.Iterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.BitmapContainer;
import org.roaringbitmap.buffer.Container;
import org.roaringbitmap.buffer.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayContainer
extends Container
implements Cloneable,
Serializable {
    private static final int DEFAULTINITSIZE = 4;
    protected static final int DEFAULTMAXSIZE = 4096;
    private static final long serialVersionUID = 1L;
    protected int cardinality = 0;
    protected ShortBuffer content;

    public ArrayContainer() {
        this(4);
    }

    public ArrayContainer(int capacity) {
        this.content = ShortBuffer.allocate(capacity);
    }

    public ArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun + 1;
        this.content = ShortBuffer.allocate(valuesInRange);
        short[] sarray = this.content.array();
        for (int i = 0; i < valuesInRange; ++i) {
            sarray[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private ArrayContainer(int newcard, ShortBuffer newcontent) {
        this.cardinality = newcard;
        this.content = ShortBuffer.allocate(newcontent.limit());
        newcontent.rewind();
        this.content.put(newcontent);
    }

    public ArrayContainer(ShortBuffer array, int cardinality) {
        if (array.limit() != cardinality) {
            throw new RuntimeException("Mismatch between buffer and cardinality");
        }
        this.cardinality = cardinality;
        this.content = array;
    }

    @Override
    public Container add(short x) {
        if (this.cardinality >= 4096) {
            BitmapContainer a = this.toBitmapContainer();
            a.add(x);
            return a;
        }
        if (this.cardinality == 0 || Util.toIntUnsigned(x) > Util.toIntUnsigned(this.content.get(this.cardinality - 1))) {
            if (this.cardinality >= this.content.limit()) {
                this.increaseCapacity();
            }
            this.content.put(this.cardinality++, x);
            return this;
        }
        if (this.content.hasArray()) {
            short[] sarray = this.content.array();
            int loc = Util.unsigned_binarySearch(this.content, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= sarray.length) {
                    this.increaseCapacity();
                    sarray = this.content.array();
                }
                System.arraycopy(sarray, -loc - 1, sarray, -loc, this.cardinality + loc + 1);
                sarray[-loc - 1] = x;
                ++this.cardinality;
            }
        } else {
            int loc = Util.unsigned_binarySearch(this.content, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= this.content.limit()) {
                    this.increaseCapacity();
                }
                for (int k = this.cardinality; k > -loc - 1; --k) {
                    this.content.put(k, this.content.get(k - 1));
                }
                this.content.put(-loc - 1, x);
                ++this.cardinality;
            }
        }
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredcapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = this.content.hasArray() && value2.content.hasArray() ? org.roaringbitmap.Util.unsigned_intersect2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : Util.unsigned_intersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public Container and(BitmapContainer x) {
        return x.and(this);
    }

    @Override
    public ArrayContainer andNot(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredcapacity = value1.getCardinality();
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = value1.content.hasArray() && value2.content.hasArray() ? org.roaringbitmap.Util.unsigned_difference(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : Util.unsigned_difference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public ArrayContainer andNot(BitmapContainer value2) {
        ArrayContainer answer = new ArrayContainer(this.content.limit());
        int pos = 0;
        short[] sarray = answer.content.array();
        if (this.content.hasArray()) {
            short[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                if (value2.contains(c[k])) continue;
                sarray[pos++] = c[k];
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                if (value2.contains(this.content.get(k))) continue;
                sarray[pos++] = this.content.get(k);
            }
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public ArrayContainer clone() {
        return new ArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(short x) {
        return Util.unsigned_binarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayContainer) {
            ArrayContainer srb = (ArrayContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (this.content.hasArray() && srb.content.hasArray()) {
                short[] t = this.content.array();
                short[] sr = srb.content.array();
                for (int i = 0; i < this.cardinality; ++i) {
                    if (t[i] == sr[i]) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < this.cardinality; ++i) {
                    if (this.content.get(i) == srb.content.get(i)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        if (this.content.hasArray()) {
            short[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                x[k + i] = Util.toIntUnsigned(c[k]) | mask;
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                x[k + i] = Util.toIntUnsigned(this.content.get(k)) | mask;
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return this.cardinality * 2;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ShortIterator(){
            int pos = 0;

            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            public short next() {
                return ArrayContainer.this.content.get(this.pos++);
            }

            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                --this.pos;
            }
        };
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * this.content.get(k);
        }
        return hash;
    }

    @Override
    public ArrayContainer iand(ArrayContainer value2) {
        ArrayContainer value1 = this;
        value1.cardinality = Util.unsigned_intersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content.array());
        return this;
    }

    @Override
    public Container iand(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (!value2.contains(this.content.get(k))) continue;
            this.content.put(pos++, this.content.get(k));
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public ArrayContainer iandNot(ArrayContainer value2) {
        this.cardinality = value2.content.hasArray() ? org.roaringbitmap.Util.unsigned_difference(this.content.array(), this.getCardinality(), value2.content.array(), value2.getCardinality(), this.content.array()) : Util.unsigned_difference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content.array());
        return this;
    }

    @Override
    public ArrayContainer iandNot(BitmapContainer value2) {
        short[] c = this.content.array();
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (value2.contains(c[k])) continue;
            c[pos++] = c[k];
        }
        this.cardinality = pos;
        return this;
    }

    private void increaseCapacity() {
        int newcapacity;
        int n = this.content.limit() < 64 ? this.content.limit() * 2 : (newcapacity = this.content.limit() < 1024 ? this.content.limit() * 3 / 2 : this.content.limit() * 5 / 4);
        if (newcapacity > 4096) {
            newcapacity = 4096;
        }
        ShortBuffer newcontent = ShortBuffer.allocate(newcapacity);
        this.content.rewind();
        newcontent.put(this.content);
        this.content = newcontent;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange + 1;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        ShortBuffer buffer = ShortBuffer.allocate(newValuesInRange);
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.limit()) {
                if (newCardinality >= 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                ShortBuffer co = ShortBuffer.allocate(newCardinality);
                this.content.rewind();
                co.put(this.content);
                this.content = co;
            }
            for (int pos = this.cardinality - 1; pos > lastIndex; --pos) {
                this.content.put(pos + cardinalityChange, this.content.get(pos));
            }
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                for (int i = startIndex + newValuesInRange; i < newCardinality; ++i) {
                    this.content.put(i, this.content.get(i - cardinalityChange));
                }
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public Container ior(ArrayContainer value2) {
        return this.or(value2);
    }

    @Override
    public Container ior(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            @Override
            public Short next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return new Short(ArrayContainer.this.content.get(s));
            }

            @Override
            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return x.xor(this);
    }

    protected void loadData(BitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        bitmapContainer.fillArray(this.content.array());
    }

    private void negateRange(ShortBuffer buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange <= lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content.get(inPos)) {
                buffer.put(outPos++, (short)valInRange);
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastRange) {
            buffer.put(outPos++, (short)valInRange);
            ++valInRange;
        }
        if (outPos != buffer.limit()) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.limit());
        }
        assert (outPos == buffer.limit());
        int i = startIndex;
        for (int k = 0; k < buffer.limit(); ++k) {
            short item = buffer.get(k);
            this.content.put(i++, item);
        }
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange > lastOfRange) {
            return this.clone();
        }
        int startIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsigned_binarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange + 1) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) >= 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        ArrayContainer answer = new ArrayContainer(newCardinality);
        short[] sarray = answer.content.array();
        for (int i = 0; i < startIndex; ++i) {
            sarray[i] = this.content.get(i);
        }
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange <= lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content.get(inPos)) {
                sarray[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastOfRange) {
            answer.content.put(outPos++, (short)valInRange);
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content.put(outPos++, this.content.get(i));
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    public Container or(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int i2;
            int k;
            short[] sarray;
            BitmapContainer bc = new BitmapContainer();
            long[] bitarray = bc.bitmap.array();
            if (value2.content.hasArray()) {
                sarray = value2.content.array();
                for (k = 0; k < value2.cardinality; ++k) {
                    int n = i2 = Util.toIntUnsigned(sarray[k]) >>> 6;
                    bitarray[n] = bitarray[n] | 1L << sarray[k];
                }
            } else {
                for (int k2 = 0; k2 < value2.cardinality; ++k2) {
                    int n = i = Util.toIntUnsigned(value2.content.get(k2)) >>> 6;
                    bitarray[n] = bitarray[n] | 1L << value2.content.get(k2);
                }
            }
            if (this.content.hasArray()) {
                sarray = this.content.array();
                for (k = 0; k < this.cardinality; ++k) {
                    int n = i2 = Util.toIntUnsigned(sarray[k]) >>> 6;
                    bitarray[n] = bitarray[n] | 1L << sarray[k];
                }
            } else {
                for (int k3 = 0; k3 < this.cardinality; ++k3) {
                    int n = i = Util.toIntUnsigned(this.content.get(k3)) >>> 6;
                    bitarray[n] = bitarray[n] | 1L << this.content.get(k3);
                }
            }
            bc.cardinality = 0;
            for (int index = 0; index < bc.bitmap.limit(); ++index) {
                bc.cardinality += Long.bitCount(bitarray[index]);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredcapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = value1.content.hasArray() && value2.content.hasArray() ? org.roaringbitmap.Util.unsigned_union2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : Util.unsigned_union2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[2];
        in.readFully(buffer);
        this.cardinality = buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
        if (this.content.limit() < this.cardinality) {
            this.content = ShortBuffer.allocate(this.cardinality);
        }
        for (int k = 0; k < this.cardinality; ++k) {
            in.readFully(buffer);
            this.content.put(k, (short)((buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF));
        }
    }

    @Override
    public Container remove(short x) {
        int loc = Util.unsigned_binarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            System.arraycopy(this.content.array(), loc + 1, this.content.array(), loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.loadData(this);
        return bc;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append(this.content.get(i));
            sb.append(",");
        }
        sb.append(this.content.get(this.cardinality - 1));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
        ShortBuffer co = ShortBuffer.allocate(this.cardinality);
        for (int k = 0; k < this.cardinality; ++k) {
            co.put(this.content.get(k));
        }
        this.content = co;
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content.get(k) >>> 0 & 0xFF);
            out.write(this.content.get(k) >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.cardinality >>> 0 & 0xFF);
        out.write(this.cardinality >>> 8 & 0xFF);
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content.get(k) >>> 0 & 0xFF);
            out.write(this.content.get(k) >>> 8 & 0xFF);
        }
    }

    @Override
    public Container xor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int i2;
            int k;
            short[] sarray;
            BitmapContainer bc = new BitmapContainer();
            long[] bitarray = bc.bitmap.array();
            if (value2.content.hasArray()) {
                sarray = value2.content.array();
                for (k = 0; k < value2.cardinality; ++k) {
                    int n = i2 = Util.toIntUnsigned(sarray[k]) >>> 6;
                    bitarray[n] = bitarray[n] ^ 1L << sarray[k];
                }
            } else {
                for (int k2 = 0; k2 < value2.cardinality; ++k2) {
                    int n = i = Util.toIntUnsigned(value2.content.get(k2)) >>> 6;
                    bitarray[n] = bitarray[n] ^ 1L << value2.content.get(k2);
                }
            }
            if (this.content.hasArray()) {
                sarray = this.content.array();
                for (k = 0; k < this.cardinality; ++k) {
                    int n = i2 = Util.toIntUnsigned(sarray[k]) >>> 6;
                    bitarray[n] = bitarray[n] ^ 1L << sarray[k];
                }
            } else {
                for (int k3 = 0; k3 < this.cardinality; ++k3) {
                    int n = i = Util.toIntUnsigned(this.content.get(k3)) >>> 6;
                    bitarray[n] = bitarray[n] ^ 1L << this.content.get(k3);
                }
            }
            bc.cardinality = 0;
            for (int index = 0; index < bc.bitmap.limit(); ++index) {
                bc.cardinality += Long.bitCount(bitarray[index]);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredcapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredcapacity);
        answer.cardinality = value1.content.hasArray() && value2.content.hasArray() ? org.roaringbitmap.Util.unsigned_exclusiveunion2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : Util.unsigned_exclusiveunion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.xor(this);
    }
}

