/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.ArrayContainer;
import org.roaringbitmap.buffer.BitmapContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Container
implements Iterable<Short>,
Cloneable,
Externalizable {
    public abstract Container add(short var1);

    public abstract Container and(ArrayContainer var1);

    public abstract Container and(BitmapContainer var1);

    public Container and(Container x) {
        if (x instanceof ArrayContainer) {
            return this.and((ArrayContainer)x);
        }
        return this.and((BitmapContainer)x);
    }

    public abstract Container andNot(ArrayContainer var1);

    public abstract Container andNot(BitmapContainer var1);

    public Container andNot(Container x) {
        if (x instanceof ArrayContainer) {
            return this.andNot((ArrayContainer)x);
        }
        return this.andNot((BitmapContainer)x);
    }

    public abstract void clear();

    public abstract Container clone();

    public abstract boolean contains(short var1);

    public abstract void fillLeastSignificant16bits(int[] var1, int var2, int var3);

    public abstract int getCardinality();

    public abstract ShortIterator getShortIterator();

    public abstract int getSizeInBytes();

    public abstract Container iand(ArrayContainer var1);

    public abstract Container iand(BitmapContainer var1);

    public Container iand(Container x) {
        if (x instanceof ArrayContainer) {
            return this.iand((ArrayContainer)x);
        }
        return this.iand((BitmapContainer)x);
    }

    public abstract Container iandNot(ArrayContainer var1);

    public abstract Container iandNot(BitmapContainer var1);

    public Container iandNot(Container x) {
        if (x instanceof ArrayContainer) {
            return this.iandNot((ArrayContainer)x);
        }
        return this.iandNot((BitmapContainer)x);
    }

    public abstract Container inot(int var1, int var2);

    public abstract Container ior(ArrayContainer var1);

    public abstract Container ior(BitmapContainer var1);

    public Container ior(Container x) {
        if (x instanceof ArrayContainer) {
            return this.ior((ArrayContainer)x);
        }
        return this.ior((BitmapContainer)x);
    }

    public abstract Container ixor(ArrayContainer var1);

    public abstract Container ixor(BitmapContainer var1);

    public Container ixor(Container x) {
        if (x instanceof ArrayContainer) {
            return this.ixor((ArrayContainer)x);
        }
        return this.ixor((BitmapContainer)x);
    }

    public abstract Container not(int var1, int var2);

    public abstract Container or(ArrayContainer var1);

    public abstract Container or(BitmapContainer var1);

    public Container or(Container x) {
        if (x instanceof ArrayContainer) {
            return this.or((ArrayContainer)x);
        }
        return this.or((BitmapContainer)x);
    }

    public abstract Container remove(short var1);

    public abstract void trim();

    public abstract Container xor(ArrayContainer var1);

    public abstract Container xor(BitmapContainer var1);

    public Container xor(Container x) {
        if (x instanceof ArrayContainer) {
            return this.xor((ArrayContainer)x);
        }
        return this.xor((BitmapContainer)x);
    }

    protected abstract void writeArray(DataOutput var1) throws IOException;

    public static Container rangeOfOnes(int start, int last) {
        if (last - start + 1 > 4096) {
            return new BitmapContainer(start, last);
        }
        return new ArrayContainer(start, last);
    }
}

