/*
 * Decompiled with CFR 0.152.
 */
package org.rm3l.maoni.common.model;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.net.Uri;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.rm3l.maoni.common.model.DeviceInfo;

public class Feedback {
    public final CharSequence id;
    public final DeviceInfo deviceInfo;
    public final App appInfo;
    public final CharSequence userComment;
    public final boolean includeLogs;
    public final Uri logsFileUri;
    public final File logsFile;
    public final boolean includeScreenshot;
    public final Uri screenshotFileUri;
    public final File screenshotFile;
    private final Map<CharSequence, Object> additionalData = new HashMap<CharSequence, Object>();

    public Feedback(CharSequence id, Activity activity, App appInfo, CharSequence userComment, boolean includeScreenshot, Uri screenshotFileUri, File screenshotFile, boolean includeLogs, Uri logsFileUri, File logsFile) {
        this.id = id;
        this.deviceInfo = new DeviceInfo(activity);
        this.appInfo = appInfo;
        this.userComment = userComment;
        this.includeLogs = includeLogs;
        if (this.includeLogs) {
            this.logsFile = logsFile;
            this.logsFileUri = logsFileUri;
        } else {
            this.logsFile = null;
            this.logsFileUri = null;
        }
        this.includeScreenshot = includeScreenshot;
        if (this.includeScreenshot) {
            this.screenshotFile = screenshotFile;
            this.screenshotFileUri = screenshotFileUri;
        } else {
            this.screenshotFileUri = null;
            this.screenshotFile = null;
        }
    }

    public CharSequence getId() {
        return this.id;
    }

    public void put(CharSequence key, Object value) {
        this.additionalData.put(key, value);
    }

    public Object get(CharSequence key) {
        return this.additionalData.get(key);
    }

    public Map<CharSequence, Object> getAdditionalData() {
        return Collections.unmodifiableMap(this.additionalData);
    }

    public Object get(CharSequence key, Object defaultValue) {
        if (!this.additionalData.containsKey(key)) {
            return defaultValue;
        }
        return this.get(key);
    }

    @SuppressLint(value={"DefaultLocale"})
    public Map<String, Object> getDeviceAndAppInfoAsHumanReadableMap() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        if (this.appInfo != null) {
            output.put("Application ID", this.appInfo.applicationId);
            output.put("Version code", this.appInfo.versionCode);
            output.put("Version name", this.appInfo.versionName);
        }
        output.put("Android version", String.format("Android %s (SDK %d)", this.deviceInfo.androidReleaseVersion, this.deviceInfo.sdkVersion));
        output.put("Device", this.deviceInfo.model);
        output.put("Manufacturer", this.deviceInfo.manufacturer);
        output.put("Device Type", this.deviceInfo.isTablet ? "Tablet" : "Phone");
        output.put("Screen density", this.deviceInfo.densityDpi + " dpi");
        output.put("Screen size", this.deviceInfo.resolution);
        output.put("Native platform", Arrays.toString(this.deviceInfo.supportedAbis));
        if (this.deviceInfo.openGlVersion != null && !"".equals(this.deviceInfo.openGlVersion.trim())) {
            output.put("OpenGL ES version", this.deviceInfo.openGlVersion);
        }
        output.put("Device language", this.deviceInfo.language);
        return Collections.unmodifiableMap(output);
    }

    public static class App {
        public final CharSequence caller;
        public final Boolean debug;
        public final CharSequence applicationId;
        public final Integer versionCode;
        public final CharSequence flavor;
        public final CharSequence buildType;
        public final CharSequence versionName;

        public App(CharSequence caller, Boolean debug, CharSequence applicationId, Integer versionCode, CharSequence flavor, CharSequence buildType, CharSequence versionName) {
            this.caller = caller;
            this.debug = debug;
            this.applicationId = applicationId;
            this.versionCode = versionCode;
            this.flavor = flavor;
            this.buildType = buildType;
            this.versionName = versionName;
        }
    }
}

