/*
 * Decompiled with CFR 0.152.
 */
package org.rm3l.maoni.common.model;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.opengl.GLES10;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class DeviceInfo {
    private static final String GET_MOBILE_DATA_ENABLED = "getMobileDataEnabled";
    public final int sdkVersion = Build.VERSION.SDK_INT;
    public final String board = Build.BOARD;
    public final String brand = Build.BRAND;
    public final String device = Build.DEVICE;
    public final String model = Build.MODEL;
    public final String product = Build.PRODUCT;
    public final String tags = Build.TAGS;
    public final String linuxVersion = System.getProperty("os.version");
    public final String manufacturer = Build.MANUFACTURER;
    public final String hardware = Build.HARDWARE;
    public final String cpuAbi = Build.CPU_ABI;
    public final String cpuAbi2 = Build.CPU_ABI2;
    public final String[] supportedAbis = new String[]{this.cpuAbi, this.cpuAbi2};
    public final boolean isTablet;
    public final String androidReleaseVersion = Build.VERSION.RELEASE;
    public final String buildVersion = Build.VERSION.INCREMENTAL;
    public final String buildDisplay = Build.DISPLAY;
    public final String buildFingerprint = Build.FINGERPRINT;
    public final String buildId = Build.ID;
    public final long buildTime = Build.TIME;
    public final String buildType = Build.TYPE;
    public final String buildUser = Build.USER;
    public final String language = Locale.getDefault().getDisplayName();
    public final String openGlVersion = GLES10.glGetString((int)7938);
    public final float density;
    public final int densityDpi;
    public final float scaledDensity;
    public final float xdpi;
    public final float ydpi;
    public final int heightPixels;
    public final int widthPixels;
    public final String resolution;
    public final Boolean gpsEnabled;
    public final SupplicantState supplicantState;
    public final Boolean mobileDataEnabled;

    @SuppressLint(value={"DefaultLocale"})
    public DeviceInfo(Activity activity) {
        this.isTablet = (activity.getResources().getConfiguration().screenLayout & 0xF) >= 3;
        SupplicantState supplicantState = null;
        try {
            WifiManager wifiManager = (WifiManager)activity.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            supplicantState = wifiInfo.getSupplicantState();
        }
        catch (Exception wifiManager) {
            // empty catch block
        }
        this.supplicantState = supplicantState;
        ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
        Boolean mobileDataEnabled = null;
        try {
            Class<?> cmClass = Class.forName(cm.getClass().getName());
            Method method = cmClass.getDeclaredMethod(GET_MOBILE_DATA_ENABLED, new Class[0]);
            method.setAccessible(true);
            mobileDataEnabled = (Boolean)method.invoke((Object)cm, new Object[0]);
        }
        catch (Exception cmClass) {
            // empty catch block
        }
        this.mobileDataEnabled = mobileDataEnabled;
        Boolean gpsEnabled = null;
        try {
            LocationManager manager = (LocationManager)activity.getSystemService("location");
            gpsEnabled = manager.isProviderEnabled("gps");
        }
        catch (Exception manager) {
            // empty catch block
        }
        this.gpsEnabled = gpsEnabled;
        WindowManager windowManager = activity.getWindowManager();
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        this.density = metrics.density;
        this.densityDpi = metrics.densityDpi;
        this.scaledDensity = metrics.scaledDensity;
        this.xdpi = metrics.xdpi;
        this.ydpi = metrics.ydpi;
        this.heightPixels = metrics.heightPixels;
        this.widthPixels = metrics.widthPixels;
        this.resolution = String.format("%d x %d", this.widthPixels, this.heightPixels);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> rawMap = this.toRawMap();
        for (Map.Entry<String, Object> entry : rawMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            stringBuilder.append(String.format("- %s=%s\n", entry.getKey(), value instanceof String[] ? Arrays.toString((String[])value) : value));
        }
        return stringBuilder.toString();
    }

    public Map<String, Object> toRawMap() {
        Field[] fields;
        TreeMap<String, Object> output = new TreeMap<String, Object>();
        for (Field field : fields = DeviceInfo.class.getFields()) {
            Object fieldValue;
            try {
                fieldValue = field.get(this);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (fieldValue == null) continue;
            output.put(field.getName(), fieldValue);
        }
        return Collections.unmodifiableMap(output);
    }
}

