/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.modal;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.modal.AbstractModal;
import org.richfaces.bootstrap.ui.modal.ModalRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

public class ModalRenderer
extends ModalRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES1 = RenderKitUtils.attributes().generic("style", "style", new String[0]).generic("title", "title", new String[0]);

    public void renderCloseButton(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractModal component = (AbstractModal)uiComponent;
        String clientId = component.getClientId(facesContext);
        if (component.isCloseable()) {
            responseWriter.startElement("button", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"close", null);
            responseWriter.writeAttribute("data-dismiss", (Object)"modal", null);
            responseWriter.writeAttribute("type", (Object)"button", null);
            responseWriter.writeText((Object)"\u00d7", null);
            responseWriter.endElement("button");
        }
    }

    private static boolean convertToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf(object.toString());
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    public void renderHeader(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractModal component = (AbstractModal)uiComponent;
        String clientId = component.getClientId(facesContext);
        if (!ModalRenderer.isEmpty(component.getHeader()) || ModalRenderer.convertToBoolean(RenderKitUtils.hasFacet((UIComponent)component, (String)"header"))) {
            responseWriter.startElement("div", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"modal-header", null);
            this.renderCloseButton(responseWriter, facesContext, (UIComponent)component);
            if (component.getFacet("header") != null) {
                component.getFacet("header").encodeAll(facesContext);
            } else {
                responseWriter.startElement("h3", (UIComponent)component);
                String text = component.getHeader();
                if (text != null) {
                    responseWriter.writeText((Object)text, null);
                }
                responseWriter.endElement("h3");
            }
            responseWriter.endElement("div");
        } else {
            this.renderCloseButton(responseWriter, facesContext, (UIComponent)component);
        }
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void doEncodeBegin(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractModal component = (AbstractModal)uiComponent;
        String clientId = component.getClientId(facesContext);
        String nbsp = "\u00a0";
        Boolean closeable = component.isCloseable();
        responseWriter.startElement("div", (UIComponent)component);
        String value = "modal hide " + ModalRenderer.convertToString(component.getEffect()) + " " + ModalRenderer.convertToString(component.getStyleClass());
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        String string = value = closeable != false ? "true" : "static";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("data-backdrop", (Object)value, null);
        }
        if (null != (value = closeable.toString()) && value.length() > 0) {
            responseWriter.writeAttribute("data-keyboard", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES1);
        responseWriter.startElement("div", (UIComponent)component);
        value = ModalRenderer.convertToString(clientId) + "Content";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        this.renderHeader(responseWriter, facesContext, (UIComponent)component);
        this.encodeBeginBody(facesContext, (UIComponent)component);
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractModal component = (AbstractModal)uiComponent;
        String clientId = component.getClientId(facesContext);
        this.encodeEndBody(facesContext, (UIComponent)component);
        if (ModalRenderer.convertToBoolean(RenderKitUtils.hasFacet((UIComponent)component, (String)"footer"))) {
            responseWriter.startElement("div", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"modal-footer", null);
            if (component.getFacet("footer") != null) {
                component.getFacet("footer").encodeAll(facesContext);
            }
            responseWriter.endElement("div");
        }
        responseWriter.endElement("div");
        responseWriter.endElement("div");
    }
}

