/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public final class VersionBean {
    public static final Version VERSION = new Version();

    public String getVendor() {
        return VERSION.getImplementationVendor();
    }

    public String getTitle() {
        return VERSION.getImplementationTitle();
    }

    public String getTimestamp() {
        return VERSION.getScmTimestamp();
    }

    public Version getVersion() {
        return VERSION;
    }

    public String toString() {
        return VERSION.toString();
    }

    public static class Version {
        private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
        private static final String UNKNOWN = "";
        private String implementationVendor = "";
        private String implementationVersion = "4.5.2.Final";
        private String implementationTitle = "";
        private String scmTimestamp = "";
        private String fullVersionString = "";
        private boolean containsDataFromManifest = false;

        public Version() {
            this.initialize();
        }

        private String getAttributeValueOrDefault(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        private void initialize() {
            Manifest manifest = null;
            try {
                manifest = this.readManifest();
            }
            catch (Exception e) {
                LOGGER.error(MessageFormat.format("Error reading project metadata: {0}", e.getMessage()), e);
            }
            if (manifest != null) {
                this.initializePropertiesFromManifest(manifest);
                this.initializeDerivativeProperties();
            }
        }

        private void initializePropertiesFromManifest(Manifest manifest) {
            this.containsDataFromManifest = true;
            Attributes attributes = manifest.getMainAttributes();
            this.implementationVendor = this.getAttributeValueOrDefault(attributes, "Implementation-Vendor");
            this.implementationVersion = this.getAttributeValueOrDefault(attributes, "Implementation-Version");
            this.implementationTitle = this.getAttributeValueOrDefault(attributes, "Implementation-Title");
            this.scmTimestamp = this.getAttributeValueOrDefault(attributes, "SCM-Timestamp");
        }

        private void initializeDerivativeProperties() {
            this.fullVersionString = MessageFormat.format("{0}", this.implementationVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private Manifest readManifest() {
            domain = VersionBean.class.getProtectionDomain();
            if (domain != null && (codeSource = domain.getCodeSource()) != null && (url = codeSource.getLocation()) != null) {
                block40: {
                    block38: {
                        block39: {
                            block37: {
                                manifestStream = null;
                                if ("vfs".equals(url.getProtocol())) {
                                    manifestFile = String.format("%s/%s", new Object[]{url.toExternalForm(), "META-INF/MANIFEST.MF"});
                                    manifestFileUrl = new URL((String)manifestFile);
                                } else {
                                    manifestFileUrl = new URL(url, "META-INF/MANIFEST.MF");
                                }
                                manifestStream = URLToStreamHelper.urlToStream(manifestFileUrl);
                                manifestFile = new Manifest(manifestStream);
                                if (manifestStream == null) break block37;
                                try {
                                    manifestStream.close();
                                }
                                catch (IOException e) {
                                    Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                                }
                            }
                            return manifestFile;
                            catch (MalformedURLException e1) {
                                if (Version.LOGGER.isDebugEnabled()) {
                                    Version.LOGGER.debug(e1.getMessage(), e1);
                                }
                                ** if (manifestStream == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (IOException e) {
                                        Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                                    }
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                            }
                            catch (IOException e) {
                                if (Version.LOGGER.isDebugEnabled()) {
                                    Version.LOGGER.debug(e.getMessage(), e);
                                }
                                ** if (manifestStream == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        manifestStream.close();
                                    }
                                    catch (IOException e) {
                                        Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                                    }
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                                {
                                    catch (Throwable var8_18) {
                                        if (manifestStream != null) {
                                            try {
                                                manifestStream.close();
                                            }
                                            catch (IOException e) {
                                                Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                                            }
                                        }
                                        throw var8_18;
                                    }
                                }
                            }
                            jis = null;
                            urlConnection = url.openConnection();
                            urlConnection.setUseCaches(false);
                            if (!(urlConnection instanceof JarURLConnection)) break block38;
                            jarUrlConnection = (JarURLConnection)urlConnection;
                            var8_19 = jarUrlConnection.getManifest();
                            if (jis == null) break block39;
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                            }
                        }
                        return var8_19;
                    }
                    jis = new JarInputStream(urlConnection.getInputStream());
                    var7_17 = jis.getManifest();
                    if (jis == null) break block40;
                    try {
                        jis.close();
                    }
                    catch (IOException e) {
                        Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                    }
                }
                return var7_17;
                catch (IOException e) {
                    try {
                        Version.LOGGER.error(MessageFormat.format("Error reading META-INF/MANIFEST.MF file: {0}", new Object[]{e.getMessage()}), e);
                        ** if (jis == null) goto lbl-1000
                    }
                    catch (Throwable var10_23) {
                        if (jis != null) {
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                            }
                        }
                        throw var10_23;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            jis.close();
                        }
                        catch (IOException e) {
                            Version.LOGGER.error(MessageFormat.format("Error closing stream: {0}", new Object[]{e.getMessage()}), e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
            return null;
        }

        boolean containsDataFromManifest() {
            return this.containsDataFromManifest;
        }

        public String getVersion() {
            return this.fullVersionString;
        }

        public String getImplementationTitle() {
            return this.implementationTitle;
        }

        public String getImplementationVendor() {
            return this.implementationVendor;
        }

        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        public String getScmTimestamp() {
            return this.scmTimestamp;
        }

        public String toString() {
            if (this.containsDataFromManifest()) {
                return this.getImplementationTitle() + " by " + this.getImplementationVendor() + ", version " + this.getVersion();
            }
            return this.getVersion();
        }
    }
}

