/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.faces.context.FacesContext;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.application.push.DestroyableSession;
import org.richfaces.application.push.MessageData;
import org.richfaces.application.push.Request;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionManager;
import org.richfaces.application.push.SessionSubscriptionEvent;
import org.richfaces.application.push.SessionUnsubscriptionEvent;
import org.richfaces.application.push.SubscriptionFailureException;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class SessionImpl
implements Session,
DestroyableSession {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private final int maxInactiveInterval;
    private final String id;
    private final SessionManager sessionManager;
    private volatile long lastAccessedTime;
    private volatile Request request;
    private volatile boolean active = true;
    private final Queue<MessageData> messagesQueue = new ConcurrentLinkedQueue<MessageData>();
    private final Set<TopicKey> successfulSubscriptions = Sets.newHashSet();
    private final Map<TopicKey, String> failedSubscriptions = Maps.newHashMap();
    private TopicsContext topicsContext;
    private AtomicLong sequenceCounter = new AtomicLong();

    public SessionImpl(String id, SessionManager sessionManager, TopicsContext topicsContext) {
        this.id = id;
        this.sessionManager = sessionManager;
        this.topicsContext = topicsContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.maxInactiveInterval = ConfigurationServiceHelper.getIntConfigurationValue(facesContext, CoreConfiguration.Items.pushSessionMaxInactiveInterval);
        this.resetLastAccessedTimeToCurrent();
    }

    private void resetLastAccessedTimeToCurrent() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void connect(Request request) throws Exception {
        this.releaseRequest();
        if (this.active) {
            this.processConnect(request);
        } else {
            request.resume();
        }
    }

    protected Request getRequest() {
        return this.request;
    }

    protected void processConnect(Request request) throws Exception {
        this.request = request;
        this.sessionManager.requeue(this);
        request.postMessages();
    }

    private void releaseRequest() {
        Request localRequestCopy = this.request;
        if (localRequestCopy != null) {
            this.resetLastAccessedTimeToCurrent();
            this.request = null;
            localRequestCopy.resume();
        }
    }

    @Override
    public synchronized void disconnect() throws Exception {
        this.releaseRequest();
    }

    @Override
    public long getLastAccessedTime() {
        if (!this.active) {
            return -1L;
        }
        if (this.request != null) {
            return System.currentTimeMillis();
        }
        return this.lastAccessedTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void invalidate() {
        this.active = false;
        this.sessionManager.requeue(this);
    }

    @Override
    public synchronized void destroy() {
        this.active = false;
        for (TopicKey key : this.successfulSubscriptions) {
            Topic topic = this.topicsContext.getTopic(key);
            topic.publishEvent(new SessionUnsubscriptionEvent(topic, key, this));
        }
        try {
            this.disconnect();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    public Map<TopicKey, String> getFailedSubscriptions() {
        return this.failedSubscriptions;
    }

    @Override
    public Collection<TopicKey> getSuccessfulSubscriptions() {
        return this.successfulSubscriptions;
    }

    @Override
    public void subscribe(String[] topics) {
        Iterable topicKeys = Iterables.transform((Iterable)Lists.newLinkedList(Arrays.asList(topics)), TopicKey.factory());
        this.createSubscriptions(topicKeys);
    }

    private void createSubscriptions(Iterable<TopicKey> topicKeys) {
        for (TopicKey topicKey : topicKeys) {
            Topic pushTopic = this.topicsContext.getOrCreateTopic(topicKey);
            String errorMessage = null;
            if (pushTopic == null) {
                errorMessage = MessageFormat.format("Topic ''{0}'' is not configured", topicKey.getTopicAddress());
            } else {
                try {
                    pushTopic.checkSubscription(topicKey, this);
                }
                catch (SubscriptionFailureException e) {
                    errorMessage = e.getMessage() != null ? e.getMessage() : MessageFormat.format("Unknown error connecting to ''{0}'' topic", topicKey.getTopicAddress());
                }
            }
            if (errorMessage != null) {
                this.failedSubscriptions.put(topicKey, errorMessage);
                continue;
            }
            pushTopic.publishEvent(new SessionSubscriptionEvent(pushTopic, topicKey, this));
            this.successfulSubscriptions.add(topicKey);
        }
    }

    @Override
    public Collection<MessageData> getMessages() {
        return this.messagesQueue;
    }

    @Override
    public void clearBroadcastedMessages(long sequenceNumber) {
        MessageData message;
        Queue<MessageData> queue = this.messagesQueue;
        while ((message = queue.peek()) != null && sequenceNumber >= message.getSequenceNumber()) {
            queue.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(TopicKey topicKey, String serializedData) {
        MessageData serializedMessage = new MessageData(topicKey, serializedData, this.sequenceCounter.getAndIncrement());
        this.messagesQueue.add(serializedMessage);
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this.request != null) {
                this.request.postMessages();
            }
        }
    }
}

