/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxOutput;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.context.ActivatorComponentExecuteCallback;
import org.richfaces.context.ActivatorComponentRenderCallback;
import org.richfaces.context.AjaxOutputTracker;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.context.PartialResponseWriterWrapper;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.ScriptsHolder;
import org.richfaces.renderkit.AjaxDataSerializer;
import org.richfaces.util.FastJoiner;

public class ExtendedPartialViewContext
extends PartialViewContextWrapper {
    private static final String EXTENSION_ID = "org.richfaces.extension";
    private static final String BEFOREDOMUPDATE_ELEMENT_NAME = "beforedomupdate";
    private static final String COMPLETE_ELEMENT_NAME = "complete";
    private static final String RENDER_ELEMENT_NAME = "render";
    private static final String DATA_ELEMENT_NAME = "data";
    private static final String COMPONENT_DATA_ELEMENT_NAME = "componentData";
    private static final FastJoiner SPACE_JOINER = FastJoiner.on(' ');
    private static final String ATTRIBUTE_NAME = ExtendedPartialViewContext.class.getName();
    private FacesContext facesContext;
    private PartialViewContext wrappedViewContext;
    private PartialResponseWriter partialResponseWriter;
    private boolean released = false;
    private ContextMode contextMode = null;
    private String activatorComponentId = null;
    private String behaviorEvent = null;
    private Collection<String> executeIds = null;
    private Collection<String> renderIds = null;
    private Boolean renderAll = null;
    private Collection<String> componentRenderIds = null;
    private String onbeforedomupdate;
    private String oncomplete;
    private Object responseData;
    private boolean limitRender = false;
    private Map<String, Object> responseComponentDataMap = Maps.newHashMap();
    private StringBuilder beforedomupdateHandler = new StringBuilder();
    private StringBuilder completeHandler = new StringBuilder();
    private Stack<ExtendedVisitContextMode> visitMode = new Stack();

    public ExtendedPartialViewContext(PartialViewContext wrappedViewContext, FacesContext facesContext) {
        this.wrappedViewContext = wrappedViewContext;
        this.facesContext = facesContext;
        ExtendedPartialViewContext.setInstance(facesContext, this);
    }

    public PartialViewContext getWrapped() {
        return this.wrappedViewContext;
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.getWrapped().setPartialRequest(isPartialRequest);
    }

    protected FacesContext getFacesContext() {
        return this.facesContext;
    }

    public static ExtendedPartialViewContext getInstance(FacesContext facesContext) {
        return (ExtendedPartialViewContext)((Object)facesContext.getAttributes().get(ATTRIBUTE_NAME));
    }

    private static void setInstance(FacesContext facesContext, ExtendedPartialViewContext instance) {
        facesContext.getAttributes().put(ATTRIBUTE_NAME, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPartial(PhaseId phaseId) {
        this.initializeContext();
        try {
            if (this.isProcessedExecutePhase(phaseId)) {
                this.setVisitMode(ExtendedVisitContextMode.EXECUTE);
            } else {
                this.setVisitMode(ExtendedVisitContextMode.RENDER);
            }
            this.wrappedViewContext.processPartial(phaseId);
        }
        finally {
            this.resetVisitMode();
        }
    }

    private boolean isProcessedExecutePhase(PhaseId phaseId) {
        return phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES;
    }

    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.EXTENDED) {
            if (this.executeIds == null) {
                this.executeIds = new LinkedHashSet<String>();
                this.visitActivatorAtExecute();
            }
            return this.executeIds;
        }
        return this.wrappedViewContext.getExecuteIds();
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.EXTENDED) {
            PhaseId currenPhaseId = this.facesContext.getCurrentPhaseId();
            if (this.renderIds == null) {
                this.renderIds = new LinkedHashSet<String>();
            }
            if (currenPhaseId == PhaseId.RENDER_RESPONSE) {
                this.visitActivatorAtRender();
            }
            return this.renderIds;
        }
        return this.wrappedViewContext.getRenderIds();
    }

    public boolean isExecuteAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.EXTENDED) {
            return this.getExecuteIds().contains("@all");
        }
        return this.wrappedViewContext.isExecuteAll();
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.EXTENDED) {
            if (this.renderAll == null) {
                this.setRenderAll(this.detectRenderAll());
            }
            return this.renderAll;
        }
        return this.wrappedViewContext.isRenderAll();
    }

    private boolean detectRenderAll() {
        if (this.renderIds == null) {
            this.renderIds = new LinkedHashSet<String>();
            ActivatorComponentRenderCallback callback = new ActivatorComponentRenderCallback(this.getFacesContext(), this.behaviorEvent);
            if (this.visitActivatorComponent(this.activatorComponentId, callback, EnumSet.noneOf(VisitHint.class))) {
                this.setupRenderCallbackData(callback);
            }
            if (this.componentRenderIds != null) {
                this.renderIds.addAll(this.componentRenderIds);
            }
            if (!this.isRenderAll()) {
                this.addImplicitRenderIds(this.renderIds);
            }
        }
        return Boolean.TRUE.equals(this.renderAll) || this.renderIds.contains("@all");
    }

    public void setRenderAll(final boolean renderAll) {
        this.assertNotReleased();
        this.renderAll = renderAll;
        this.visitPatentContexts(new Function<PartialViewContext, Void>(){

            public Void apply(PartialViewContext pvc) {
                if (pvc != ExtendedPartialViewContext.this) {
                    pvc.setRenderAll(renderAll);
                }
                return null;
            }
        });
    }

    public Object getResponseData() {
        return this.responseData;
    }

    public Map<String, Object> getResponseComponentDataMap() {
        return this.responseComponentDataMap;
    }

    public void setResponseData(Object responseData) {
        this.responseData = responseData;
    }

    public void appendOncomplete(Object handler) {
        if (handler != null) {
            this.completeHandler.append(handler.toString());
            this.completeHandler.append(';');
        }
    }

    public void prependOncomplete(Object handler) {
        if (handler != null) {
            this.completeHandler.insert(0, ';');
            this.completeHandler.insert(0, handler.toString());
        }
    }

    public Object getOncomplete() {
        return this.completeHandler.toString();
    }

    public void appendOnbeforedomupdate(Object handler) {
        if (handler != null) {
            this.beforedomupdateHandler.append(handler.toString());
            this.beforedomupdateHandler.append(';');
        }
    }

    public void prependOnbeforedomupdate(Object handler) {
        if (handler != null) {
            this.beforedomupdateHandler.insert(0, handler.toString());
            this.beforedomupdateHandler.insert(0, ';');
        }
    }

    public Object getOnbeforedomupdate() {
        return this.beforedomupdateHandler.toString();
    }

    public boolean isLimitRender() {
        return this.limitRender;
    }

    public ExtendedVisitContextMode getVisitMode() {
        if (this.visitMode.isEmpty()) {
            return null;
        }
        return this.visitMode.peek();
    }

    private void setVisitMode(ExtendedVisitContextMode visitMode) {
        this.visitMode.add(visitMode);
    }

    private void resetVisitMode() {
        this.visitMode.pop();
    }

    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this.partialResponseWriter == null) {
            this.partialResponseWriter = new ExtensionWritingPartialResponseWriter(this.wrappedViewContext.getPartialResponseWriter());
        }
        return this.partialResponseWriter;
    }

    private void visitActivatorAtExecute() {
        ActivatorComponentExecuteCallback callback;
        if (this.detectContextMode() == ContextMode.EXTENDED && this.visitActivatorComponent(this.activatorComponentId, callback = new ActivatorComponentExecuteCallback(this.getFacesContext(), this.behaviorEvent), EnumSet.noneOf(VisitHint.class))) {
            this.executeIds.addAll(callback.getExecuteIds());
            this.setupRenderCallbackData(callback);
            if (!this.executeIds.contains("@all")) {
                this.addImplicitExecuteIds(this.executeIds);
            }
        }
    }

    private void setupRenderCallbackData(ActivatorComponentRenderCallback callback) {
        this.componentRenderIds = callback.getRenderIds();
        this.onbeforedomupdate = callback.getOnbeforedomupdate();
        this.oncomplete = callback.getOncomplete();
        this.responseData = callback.getData();
        this.limitRender = callback.isLimitRender();
    }

    private void visitActivatorAtRender() {
        if (this.detectContextMode() == ContextMode.EXTENDED) {
            ActivatorComponentRenderCallback callback = new ActivatorComponentRenderCallback(this.getFacesContext(), this.behaviorEvent);
            if (this.visitActivatorComponent(this.activatorComponentId, callback, EnumSet.noneOf(VisitHint.class))) {
                this.setupRenderCallbackData(callback);
            }
            if (this.componentRenderIds != null) {
                this.renderIds.addAll(this.componentRenderIds);
            }
            if (!this.isRenderAll()) {
                this.addImplicitRenderIds(this.renderIds);
                this.appendOnbeforedomupdate(this.onbeforedomupdate);
                this.appendOncomplete(this.oncomplete);
                this.setResponseData(this.responseData);
            }
        }
    }

    public void release() {
        this.assertNotReleased();
        super.release();
        if (this.facesContext != null && !this.facesContext.isReleased()) {
            ExtendedPartialViewContext.setInstance(this.facesContext, null);
        }
        this.facesContext = null;
        this.released = true;
        this.wrappedViewContext.release();
        this.wrappedViewContext = null;
        this.renderAll = null;
        this.executeIds = null;
        this.renderIds = null;
        this.limitRender = false;
        this.activatorComponentId = null;
        this.behaviorEvent = null;
        this.contextMode = null;
    }

    protected void addImplicitExecuteIds(Collection<String> executeIds) {
        UIViewRoot root;
        if (!executeIds.isEmpty() && (root = this.getFacesContext().getViewRoot()).getFacetCount() > 0 && root.getFacet("javax_faces_metadata") != null) {
            executeIds.add("javax_faces_metadata");
        }
    }

    protected void addImplicitRenderIds(Collection<String> renderIds) {
        if (!this.limitRender) {
            FacesContext facesContext = this.getFacesContext();
            Collection<UIComponent> ajaxOutputs = AjaxOutputTracker.getAjaxOutputs(facesContext, (UIComponent)facesContext.getViewRoot());
            for (UIComponent component : ajaxOutputs) {
                if (!(component instanceof AjaxOutput) || !((AjaxOutput)component).isAjaxRendered()) continue;
                renderIds.add(component.getClientId(facesContext));
            }
        }
    }

    protected void addJavaScriptServicePageScripts(FacesContext context) {
        ScriptsHolder scriptsHolder = ServiceTracker.getService(JavaScriptService.class).getScriptsHolder(context);
        StringBuilder scripts = new StringBuilder();
        for (Object script : scriptsHolder.getScripts()) {
            scripts.append(ScriptUtils.toScript(script));
            scripts.append(";");
        }
        for (Object script : scriptsHolder.getPageReadyScripts()) {
            scripts.append(ScriptUtils.toScript(script));
            scripts.append(";");
        }
        if (scripts.length() > 0) {
            scripts.append("RichFaces.javascriptServiceComplete();");
            this.prependOncomplete(scripts.toString());
        }
    }

    protected void renderExtensions(FacesContext context, UIComponent component) throws IOException {
        Map<String, Object> responseComponentDataMap;
        Object responseData;
        String string;
        Object oncomplete;
        String string2;
        Map<String, String> attributes = Collections.singletonMap("id", context.getExternalContext().encodeNamespace(EXTENSION_ID));
        PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
        boolean[] writingState = new boolean[]{false};
        Object onbeforedomupdate = this.getOnbeforedomupdate();
        if (onbeforedomupdate != null && (string2 = onbeforedomupdate.toString()).length() != 0) {
            ExtendedPartialViewContext.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(BEFOREDOMUPDATE_ELEMENT_NAME, component);
            writer.writeText(onbeforedomupdate, null);
            writer.endElement(BEFOREDOMUPDATE_ELEMENT_NAME);
        }
        if ((oncomplete = this.getOncomplete()) != null && (string = oncomplete.toString()).length() != 0) {
            ExtendedPartialViewContext.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPLETE_ELEMENT_NAME, component);
            writer.writeText(oncomplete, null);
            writer.endElement(COMPLETE_ELEMENT_NAME);
        }
        if (!this.getRenderIds().isEmpty()) {
            String renderIds = SPACE_JOINER.join(this.getRenderIds());
            ExtendedPartialViewContext.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(RENDER_ELEMENT_NAME, component);
            writer.writeText((Object)renderIds, null);
            writer.endElement(RENDER_ELEMENT_NAME);
        }
        if ((responseData = this.getResponseData()) != null) {
            ExtendedPartialViewContext.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(DATA_ELEMENT_NAME, component);
            AjaxDataSerializer serializer = ServiceTracker.getService(context, AjaxDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseData), null);
            writer.endElement(DATA_ELEMENT_NAME);
        }
        if ((responseComponentDataMap = this.getResponseComponentDataMap()) != null && !responseComponentDataMap.isEmpty()) {
            ExtendedPartialViewContext.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPONENT_DATA_ELEMENT_NAME, component);
            AjaxDataSerializer serializer = ServiceTracker.getService(context, AjaxDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseComponentDataMap), null);
            writer.endElement(COMPONENT_DATA_ELEMENT_NAME);
        }
        ExtendedPartialViewContext.endExtensionElementIfNecessary(writer, writingState);
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException("PartialViewContext already released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitActivatorComponent(String componentActivatorId, VisitCallback visitCallback, Set<VisitHint> visitHints) {
        FacesContext facesContext = this.getFacesContext();
        try {
            Set<String> idsToVisit = Collections.singleton(componentActivatorId);
            this.setVisitMode(ExtendedVisitContextMode.EXECUTE);
            VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
            VisitContext visitContext = visitContextFactory.getVisitContext(facesContext, idsToVisit, visitHints);
            boolean bl = facesContext.getViewRoot().visitTree(visitContext, visitCallback);
            return bl;
        }
        finally {
            this.resetVisitMode();
        }
    }

    protected ContextMode detectContextMode() {
        this.initializeContext();
        return this.contextMode;
    }

    protected void initializeContext() {
        if (this.contextMode == null) {
            Map requestParameterMap = this.getFacesContext().getExternalContext().getRequestParameterMap();
            this.activatorComponentId = (String)requestParameterMap.get("org.richfaces.ajax.component");
            if (this.activatorComponentId != null) {
                this.contextMode = ContextMode.EXTENDED;
                this.behaviorEvent = (String)requestParameterMap.get("javax.faces.behavior.event");
            } else {
                this.contextMode = ContextMode.WRAPPED;
            }
        }
    }

    private static void startExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, Map<String, String> attributes, boolean[] writingState) throws IOException {
        if (!writingState[0]) {
            writingState[0] = true;
            partialResponseWriter.startExtension(attributes);
        }
    }

    private static void endExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, boolean[] writingState) throws IOException {
        if (writingState[0]) {
            writingState[0] = false;
            partialResponseWriter.endExtension();
        }
    }

    private void visitPatentContexts(Function<PartialViewContext, Void> function) {
        ExtendedPartialViewContext pvc = this;
        do {
            pvc = ((PartialViewContextWrapper)pvc).getWrapped();
            function.apply((Object)pvc);
        } while (pvc instanceof PartialViewContextWrapper);
    }

    private class ExtensionWritingPartialResponseWriter
    extends PartialResponseWriterWrapper {
        public ExtensionWritingPartialResponseWriter(PartialResponseWriter wrapped) {
            super(wrapped);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endDocument() throws IOException {
            try {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                UIViewRoot viewRoot = facesContext.getViewRoot();
                ExtendedPartialViewContext.this.addJavaScriptServicePageScripts(facesContext);
                ExtendedPartialViewContext.this.renderExtensions(facesContext, (UIComponent)viewRoot);
            }
            finally {
                super.endDocument();
            }
        }
    }

    private static enum ContextMode {
        WRAPPED,
        EXTENDED;

    }
}

