/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.arquillian.container.installation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.richfaces.arquillian.configuration.FundamentalTestConfiguration;
import org.richfaces.arquillian.configuration.FundamentalTestConfigurationContext;
import org.richfaces.arquillian.container.installation.ConfigureContainer;
import org.richfaces.arquillian.container.installation.InstallContainer;
import org.richfaces.arquillian.container.installation.UninstallContainer;

public class ContainerInstaller {
    private Logger log = Logger.getLogger(ContainerInstaller.class.getName());
    private FundamentalTestConfiguration configuration = FundamentalTestConfigurationContext.getProxy();

    public void unpackContainerDistribution(@Observes InstallContainer event) {
        InputStream inputStream;
        Validate.notNull((Object)this.configuration, (String)"fundamental test configuration is not setup");
        String distribution = this.configuration.getContainerDistribution();
        if (distribution == null || distribution.isEmpty()) {
            return;
        }
        File containerHome = new File(this.configuration.getContainerHome());
        Validate.notNull((Object)containerHome, (String)"container home must be set");
        if (containerHome.exists()) {
            this.log.info(String.format("The container is already installed in '%s'", containerHome));
            return;
        }
        File unpackDestination = containerHome.getParentFile();
        try {
            URL distributionUrl = new URL(distribution);
            this.log.info(String.format("The container distribution will be resolved from URL '%s'", distribution));
            inputStream = distributionUrl.openStream();
        }
        catch (MalformedURLException e) {
            this.log.info(String.format("The container distribution will be resolved from Maven artifact '%s'", distribution));
            inputStream = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(distribution)).withoutTransitivity()).asSingleInputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to resolve the container distribution", e);
        }
        this.unzip(inputStream, unpackDestination, false);
        this.log.info(String.format("The container distribution '%s' was installed into '%s'", distribution, unpackDestination.getAbsolutePath()));
        if (!containerHome.exists()) {
            throw new IllegalStateException(String.format("The container distribution was unpacked but the containerHome (%s) still doesn't exist", containerHome));
        }
        this.configuration.setContainerInstalledFromDistribution(true);
    }

    public void unpackContainerConfigurationFiles(@Observes ConfigureContainer event) {
        Validate.notNull((Object)this.configuration, (String)"fundamental test configuration is not setup");
        String configurationFiles = this.configuration.getContainerConfiguration();
        if (configurationFiles == null || configurationFiles.isEmpty()) {
            return;
        }
        Validate.notNull((Object)this.configuration.getContainerHome(), (String)"container home must be set");
        File containerHome = new File(this.configuration.getContainerHome());
        InputStream artifactStream = ((MavenFormatStage)((MavenStrategyStage)((MavenStrategyStage)Maven.resolver().resolve(configurationFiles)).withClassPathResolution(false)).withoutTransitivity()).asSingleInputStream();
        this.unzip(artifactStream, containerHome, true);
        this.log.info(String.format("The container configuration '%s' was unpacked into '%s'", configurationFiles, containerHome.getAbsolutePath()));
    }

    public void uninstallContainer(@Observes UninstallContainer event) {
        Validate.notNull((Object)this.configuration, (String)"fundamental test configuration is not setup");
        if (this.configuration.containerShouldBeUninstalled()) {
            File containerHome = new File(this.configuration.getContainerHome());
            this.log.info(String.format("The container will be uninstalled from '%s'", containerHome.getAbsolutePath()));
            if (containerHome.exists()) {
                FileUtils.deleteQuietly((File)containerHome);
            }
        }
    }

    private void unzip(InputStream inputStream, File destination, boolean overwrite) {
        try {
            byte[] buf = new byte[1024];
            ZipInputStream zipinputstream = null;
            zipinputstream = new ZipInputStream(inputStream);
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                int n;
                File newFile = new File(destination, zipentry.getName());
                if (zipentry.isDirectory()) {
                    newFile.mkdirs();
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                if (newFile.exists() && overwrite) {
                    this.log.info("Overwriting " + newFile);
                    newFile.delete();
                }
                FileOutputStream fileoutputstream = new FileOutputStream(newFile);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't unzip input stream", e);
        }
    }
}

