/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.arquillian.browser;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.spi.DroneInstanceEnhancer;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;

public class PageLoader
implements DroneInstanceEnhancer<WebDriver> {
    private static final int DEFAULT_NUMBER_OF_REPEATS = 3;
    private static final String GET_METHOD_NAME = "get";
    private static final Logger LOG = Logger.getLogger(PageLoader.class.getName());
    private static final Interceptor interceptor = new PageLoadInterceptor();

    public boolean canEnhance(InstanceOrCallableInstance instance, Class<?> droneType, Class<? extends Annotation> qualifier) {
        return WebDriver.class.isAssignableFrom(droneType);
    }

    public WebDriver deenhance(WebDriver instance, Class<? extends Annotation> qualifier) {
        if (GrapheneProxy.isProxyInstance((Object)instance)) {
            GrapheneProxyInstance proxy = (GrapheneProxyInstance)instance;
            proxy.unregisterInterceptor(interceptor);
        }
        return instance;
    }

    public WebDriver enhance(WebDriver instance, Class<? extends Annotation> qualifier) {
        if (GrapheneProxy.isProxyInstance((Object)instance)) {
            GrapheneProxyInstance proxy = (GrapheneProxyInstance)instance;
            proxy.registerInterceptor(interceptor);
        }
        return instance;
    }

    public int getPrecedence() {
        return -101;
    }

    private static final class PageLoadInterceptor
    implements Interceptor {
        private PageLoadInterceptor() {
        }

        public int getPrecedence() {
            return 10;
        }

        public Object intercept(InvocationContext context) throws Throwable {
            if (context.getMethod().getName().equals(PageLoader.GET_METHOD_NAME)) {
                this.tryToLoadPage((WebDriver)context.getTarget(), String.valueOf(context.getArguments()[0]));
                return null;
            }
            return context.invoke();
        }

        private void tryToLoadPage(WebDriver webDriver, String url) {
            for (int i = 1; i <= 3; ++i) {
                try {
                    webDriver.get(url);
                    return;
                }
                catch (TimeoutException e) {
                    if (i == 3) {
                        throw e;
                    }
                    LOG.log(Level.INFO, "Page was not loaded within timeout. Trying to load it again, attempt #{0}", i + 1);
                    continue;
                }
            }
        }
    }
}

