/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NumericDataInputStream {
    static final int BYTES_IN_INT = 4;
    static final int BYTES_IN_SHORT = 2;
    static final int BYTES_IN_COLOR = 3;
    static final int MAX_BYTES = 4;
    static final ByteOrder BUFFER_BYTES_ORDER = ByteOrder.LITTLE_ENDIAN;
    private ByteArrayInputStream byteArrayStream;
    private byte[] bytes = new byte[4];
    private ByteBuffer buffer = ByteBuffer.wrap(this.bytes).order(BUFFER_BYTES_ORDER);

    public NumericDataInputStream(byte[] buf, int offset, int length) {
        this.byteArrayStream = new ByteArrayInputStream(buf, offset, length);
    }

    public NumericDataInputStream(byte[] buf) {
        this.byteArrayStream = new ByteArrayInputStream(buf);
    }

    public byte readByte() {
        int read = this.byteArrayStream.read();
        if (read >= 0) {
            return (byte)read;
        }
        throw new IllegalStateException("Data is invalid or corrupted");
    }

    public short readShort() {
        int read = this.byteArrayStream.read(this.bytes, 0, 2);
        if (read == 2) {
            this.buffer.rewind();
            return this.buffer.asShortBuffer().get();
        }
        throw new IllegalStateException("Data is invalid or corrupted");
    }

    public int readInt() {
        int read = this.byteArrayStream.read(this.bytes, 0, 4);
        if (read == 4) {
            this.buffer.rewind();
            return this.buffer.asIntBuffer().get();
        }
        throw new IllegalStateException("Data is invalid or corrupted");
    }

    public int readIntColor() {
        int read = this.byteArrayStream.read(this.bytes, 0, 3);
        if (read == 3) {
            this.buffer.rewind();
            return this.buffer.asIntBuffer().get() & 0xFFFFFF;
        }
        throw new IllegalStateException("Data is invalid or corrupted");
    }

    public Color readColor() {
        return new Color(this.readIntColor());
    }
}

