/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSMin;
import org.ajax4jsf.resource.CompressedScriptRenderer;
import org.ajax4jsf.resource.CountingOutputStream;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceContext;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class ScriptRenderer
extends CompressedScriptRenderer {
    private static final String COMPRESS_SCRIPTS_PARAMETER = "org.ajax4jsf.COMPRESS_SCRIPT";
    private static final Logger _log = RichfacesLogger.RESOURCE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(InternetResource base, ResourceContext context) throws IOException {
        InputStream in = base.getResourceAsStream(context);
        if (null == in) {
            String message = Messages.getMessage((String)"NO_INPUT_STREAM_ERROR", (Object)base.getKey());
            throw new IOException(message);
        }
        OutputStream out = context.getOutputStream();
        if (!"false".equalsIgnoreCase(context.getInitParameter(COMPRESS_SCRIPTS_PARAMETER))) {
            CountingOutputStream countingStream = new CountingOutputStream(out);
            JSMin jsmin = new JSMin(in, countingStream);
            try {
                jsmin.jsmin();
            }
            catch (Exception e) {
                _log.error("Error send script to client for resource " + base.getKey(), (Throwable)e);
            }
            finally {
                in.close();
                countingStream.flush();
                countingStream.close();
            }
            int written = countingStream.getWritten();
            if (_log.isDebugEnabled()) {
                _log.debug("Send " + written + " bytes to client for JavaScript resource " + base.getKey());
            }
            return written;
        }
        return this.sendStream(in, out);
    }
}

