/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.event;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.context.AjaxContext;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.skin.SkinFactory;
import org.slf4j.Logger;

public class AjaxPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -4087936963051339868L;
    public static final String VIEW_BEAN_PREFIX = "org.ajax4jsf.viewbean:";
    private static final Logger log = RichfacesLogger.APPLICATION.getLogger();
    public static final String AJAX_BEAN_PREFIX = "org.ajax4jsf.ajaxviewbean:";

    public void afterPhase(PhaseEvent event) {
        UIViewRoot viewRoot;
        PhaseId phaseId = event.getPhaseId();
        if (log.isDebugEnabled()) {
            log.debug("Process after phase " + phaseId.toString());
        }
        FacesContext context = event.getFacesContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (phaseId == PhaseId.RESTORE_VIEW && null != (viewRoot = context.getViewRoot())) {
            boolean isAjax = ajaxContext.isAjaxRequest();
            Map attributes = viewRoot.getAttributes();
            for (String stringKey : attributes.keySet()) {
                if (stringKey.startsWith(VIEW_BEAN_PREFIX)) {
                    requestMap.put(stringKey.substring(VIEW_BEAN_PREFIX.length()), attributes.get(stringKey));
                    continue;
                }
                if (!isAjax || !stringKey.startsWith(AJAX_BEAN_PREFIX)) continue;
                requestMap.put(stringKey.substring(AJAX_BEAN_PREFIX.length()), attributes.get(stringKey));
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (log.isDebugEnabled()) {
            log.debug("Process before phase " + phaseId.toString());
        }
        FacesContext context = event.getFacesContext();
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            AjaxContext.getCurrentInstance((FacesContext)context).setViewIdHolder(null);
            UIViewRoot root = context.getViewRoot();
            if (null != root) {
                log.debug(Messages.getMessage((String)"ENTER_BEFORE_RENDER_VIEW_PHASE", (Object)root.getViewId(), (Object)root.getRenderKitId()));
                String renderKitId = null;
                try {
                    renderKitId = SkinFactory.getInstance().getSkin(context).getRenderKitId(context);
                }
                catch (Exception e) {
                    log.error("Exception on get current Skin ", (Throwable)e);
                }
                if (null != renderKitId) {
                    log.debug(Messages.getMessage((String)"SET_RENDER_KIT_ID_INFO", (Object)renderKitId));
                    root.setRenderKitId(renderKitId);
                }
            }
        } else if (phaseId == PhaseId.RESTORE_VIEW) {
            // empty if block
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

