/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.application.ViewHandlerWrapper;
import org.ajax4jsf.component.AjaxViewRoot;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.webapp.FilterServletResponseWrapper;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class AjaxViewHandler
extends ViewHandlerWrapper {
    public static final String STATE_MARKER_KEY = "org.ajax4jsf.view.state";
    public static final String SERIALIZED_STATE_KEY = "org.ajax4jsf.view.serializedstate";
    private static final Logger _log = RichfacesLogger.APPLICATION.getLogger();
    public static final String VIEW_EXPIRED = "org.ajax4jsf.view.EXPIRED";
    public static final String VIEW_ID_KEY = "org.ajax4jsf.VIEW_ID";

    public AjaxViewHandler(ViewHandler parent) {
        super(parent);
        if (_log.isDebugEnabled()) {
            _log.debug("Create instance of Ajax ViewHandler");
        }
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot riRoot;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
        ViewIdHolder viewIdHolder = ajaxContext.getViewIdHolder();
        if (null != viewIdHolder && viewIdHolder.skipNavigation(viewId)) {
            viewIdHolder.setViewId(viewId);
            riRoot = facesContext.getViewRoot();
        } else {
            riRoot = super.createView(facesContext, viewId);
            if (null != facesContext.getViewRoot()) {
                ajaxContext.setAjaxRequest(false);
            }
        }
        return riRoot;
    }

    public void writeState(FacesContext context) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (ajaxContext.isAjaxRequest() && ajaxContext.isSelfRender()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)STATE_MARKER_KEY, null);
            writer.writeAttribute("name", (Object)STATE_MARKER_KEY, null);
            writer.endElement("span");
        } else {
            super.writeState(context);
        }
    }

    public String getResourceURL(FacesContext context, String url) {
        if (url.startsWith("resource://")) {
            String resourceURL;
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            Resource resource = resourceHandler.createResource(resourceURL = url.substring(InternetResource.RESOURCE_URI_PREFIX_LENGTH));
            if (resource != null) {
                return resource.getRequestPath();
            }
            return super.getResourceURL(context, resourceURL);
        }
        return super.getResourceURL(context, url);
    }

    public void renderView(FacesContext context, UIViewRoot root) throws IOException, FacesException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (root instanceof AjaxViewRoot) {
            AjaxViewRoot ajaxRoot = (AjaxViewRoot)root;
            if (ajaxContext.isAjaxRequest()) {
                this.processAjaxEvents(context, ajaxRoot);
                if (ajaxContext.isSelfRender()) {
                    ajaxContext.renderAjax(context);
                }
            }
            if (!context.getResponseComplete()) {
                super.renderView(context, root);
            }
        } else {
            super.renderView(context, root);
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        FilterServletResponseWrapper filterServletResponseWrapper = (FilterServletResponseWrapper)((Object)requestMap.get("com.exade.vcp.Filter.ResponseWrapper"));
        if (null != filterServletResponseWrapper) {
            requestMap.put(VIEW_ID_KEY, context.getViewRoot().getViewId());
        }
    }

    private void processAjaxEvents(FacesContext context, AjaxViewRoot ajaxRoot) {
        if (_log.isDebugEnabled()) {
            _log.debug(Messages.getMessage((String)"PROCESS_AJAX_EVENTS_INFO"));
        }
        ajaxRoot.broadcastAjaxEvents(context);
    }
}

