/**
 * @author Maksim Kaszynski
 *	@classDescription
 * Base class for drop zones
 */
DnD.Dropzone = function(){};

DnD.Dropzone.DROP_TARGET_ID = "dropTargetId";
DnD.Dropzone.prototype = {

	getElement: function() {
		return $(this.id);
	},

	getDropzoneOptions: function() {
		return null;
	},

	getDnDDefaultParams: function() {
		return DnD.getDnDDefaultParams(this.getElement());
	},

	getDnDDropParams: function() {
		return DnD.getDnDDropParams(this.getElement());
	},

	/**
	 *
	 * @param {Object} drag
	 * @return
	 */
	accept: function(drag) {
		return this.getAcceptedTypes().indexOf(drag.type) > -1 ;
	},
	getAcceptedTypes: function() {
		return [];
	},
	getTypeMapping: function() {
		return {};
	},
	drop: function(event, drag){
	},

	getIconCodeForType: function(type) {
		var types = this.getTypeMapping();
		if (type && types) {
			return types[type];
		}
		return null;
	},

	/**
	 * implementations call this method when mouse over them
	 * @param {Object} drag
	 */
	dragEnter: function(event) {
		var drag = window.drag;
		drag.dropzone = this;
		var indicator = drag.indicator;

		if (indicator) {
			var icon = this.getIconCodeForType(drag.type);

			var dndParams = drag.source.getDnDDragParams();
			if (dndParams) {
				Object.extend(dndParams, this.getDnDDropParams());
			} else {
				dndParams = this.getDnDDropParams();
			}

			if (dndParams) {
				if (icon) {
					dndParams['marker'] = dndParams[icon];
				} else {
					dndParams['marker'] = null;
				}
			}

            var accepts = this.accept(drag);
			var markerType = accepts ? "accept" : "reject";

			DnD.setDefaultDnDParams(dndParams);

            if (drag.source.getDraggableItems && drag.source.getDraggableItems() > 1) {
	            indicator.setContent(markerType, false, dndParams);
            } else {
	            indicator.setContent(markerType, true, dndParams);
            }

			if (accepts) {
				indicator.accept();
			} else {
				indicator.reject();
			}
		}
		
		var opts = this.getDropzoneOptions();
		if (opts && opts.ondragenter) {
			opts.ondragenter.call(event);
		}

	},


	/**
	 * Implementations call this method when mouse exits them
	 * @param {Object} drag
	 */
	dragLeave: function(event) {
		var drag = window.drag;
		drag.dropzone = null;

		drag.source.setIndicator(event);

		var indicator = drag.indicator;
		if (indicator) {
			indicator.leave();
		}

		var opts = this.getDropzoneOptions();
		if (opts && opts.ondragexit) {
			opts.ondragexit(event);
		}
	},

	dragUp: function(event) {
        this.ondropend(event);

		var options = this.getDropzoneOptions();
		if (options && options.ondropend) {
			options.ondropend();
		}
	},


	ondropend: function(event) {
	},

	onafterdrag: function(event) {
	},

	onbeforedrag: function(event, drag){
	},

	ondragenter: function(event) {

	},
	ondragexit : function(event) {

	}

};

