/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.Skin;

public abstract class SkinFactory {
    private static Map instances = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog((Class)(class$org$richfaces$skin$SkinFactory == null ? (class$org$richfaces$skin$SkinFactory = SkinFactory.class$("org.richfaces.skin.SkinFactory")) : class$org$richfaces$skin$SkinFactory));
    public static final String SERVICE_RESOURCE = "META-INF/services/" + (class$org$richfaces$skin$SkinFactory == null ? (class$org$richfaces$skin$SkinFactory = SkinFactory.class$("org.richfaces.skin.SkinFactory")) : class$org$richfaces$skin$SkinFactory).getName();
    public static final String SKIN_PARAMETER = "org.richfaces.SKIN";
    public static final String BASE_SKIN_PARAMETER = "org.richfaces.BASE_SKIN";
    static /* synthetic */ Class class$org$richfaces$skin$SkinFactory;

    public static void reset() {
        instances = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SkinFactory getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        SkinFactory instance = (SkinFactory)instances.get(loader);
        if (instance == null) {
            InputStream input = null;
            input = loader.getResourceAsStream(SERVICE_RESOURCE);
            if (input != null) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    String factoryClassName = reader.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("SET_SKIN_FACTORY_INFO", factoryClassName));
                    }
                    Class<?> clazz = Class.forName(factoryClassName, false, loader);
                    try {
                        Constructor<?> factoryConstructor = clazz.getConstructor(class$org$richfaces$skin$SkinFactory == null ? (class$org$richfaces$skin$SkinFactory = SkinFactory.class$("org.richfaces.skin.SkinFactory")) : class$org$richfaces$skin$SkinFactory);
                        instance = (SkinFactory)factoryConstructor.newInstance(instance);
                    }
                    catch (NoSuchMethodException e) {
                        instance = (SkinFactory)clazz.newInstance();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)Messages.getMessage("CREATING_SKIN_FACTORY_ERROR"), (Throwable)e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (instance == null) {
                // empty if block
            }
            instances.put(loader, instance);
        }
        return instance;
    }

    public abstract Skin getDefaultSkin(FacesContext var1);

    public abstract Skin getSkin(FacesContext var1);

    public abstract Skin getBaseSkin(FacesContext var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

