/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.event;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

/**
 * Wrapper for bind DrolListener to EL expression.
 * @author shura
 *
 */
public class DropListenerBinding implements DropListener, StateHolder {

	private ValueBinding _binding;
	
	private String _dragType;
	
	private ValueBinding _dragTypeBinding;
	
	private boolean _transient = false;
	
	public DropListenerBinding() {
	}

	/**
	 * @param binding
	 */
	public DropListenerBinding(ValueBinding binding) {
		super();
		_binding = binding;
	}

	private DropListener getHandler(FacesContext context) {
		return (DropListener) _binding.getValue(context);
	}

	public void processDrop(DropEvent event) {
		DropListener handler = getHandler(FacesContext.getCurrentInstance());
		handler.processDrop(event);
	}

	public boolean isTransient() {
		// TODO Auto-generated method stub
		return _transient;
	}

	public void restoreState(FacesContext context, Object state) {
		_binding = (ValueBinding) UIComponentBase.restoreAttachedState(context, state);

	}

	public Object saveState(FacesContext context) {
		return UIComponentBase.saveAttachedState(context, _binding);
	}

	public void setTransient(boolean newTransientValue) {
		_transient = newTransientValue;

	}

	/**
	 * @return the dragType
	 */
	public String getDragType() {
		return _dragType;
	}

	/**
	 * @param dragType the dragType to set
	 */
	public void setDragType(String dragType) {
		_dragType = dragType;
	}

	/**
	 * @param dragTypeBinding the dragTypeBinding to set
	 */
	public void setDragTypeBinding(ValueBinding dragTypeBinding) {
		_dragTypeBinding = dragTypeBinding;
	}

}
