/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.IntRange;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import org.jetbrains.annotations.NotNull;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsDeviceConnector;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsLiveControllerService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u001c2\b\b\u0001\u0010 \u001a\u00020\bJ\u0010\u0010#\u001a\u00020\u001c2\b\b\u0001\u0010 \u001a\u00020\bJ\u0006\u0010$\u001a\u00020\u001cJ\u0006\u0010%\u001a\u00020\u001cJ\u0010\u0010&\u001a\u00020\u001c2\b\b\u0001\u0010\u0019\u001a\u00020\bJ\u0010\u0010'\u001a\u00020\u001c2\b\b\u0001\u0010\u001a\u001a\u00020\bJ\u0015\u0010(\u001a\u00020\b*\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0082\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsLiveControllerService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "deviceConnector", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "buttonByte", "", "counter", "", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "setHandler", "(Landroid/os/Handler;)V", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "x", "y", "disconnect", "", "generateMessage", "", "getMaskBasedOnIndex", "buttonIndex", "incrementCounter", "onButtonPressed", "onButtonReleased", "start", "stop", "updateXDirection", "updateYDirection", "pow", "exponent", "Companion", "bluetooth-android_release"})
public final class RoboticsLiveControllerService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private byte x;
    private byte y;
    private byte buttonByte;
    private int counter;
    @NotNull
    private Handler handler;
    private boolean running;
    @NotNull
    public static final String SERVICE_ID = "d2d5558c-5b9d-11e9-8647-d663bd873d93";
    @NotNull
    private static final UUID CHARACTERISTIC_ID;
    public static final long DELAY_TIME_IN_MILLIS = 100L;
    public static final int COUNTER_MAX = 16;
    public static final int POSITION_KEEP_ALIVE = 1;
    public static final int POSITION_X_COORD = 1;
    public static final int POSITION_Y_COORD = 2;
    public static final int POSITION_BUTTON = 11;
    public static final int MESSAGE_LENGTH = 20;
    public static final byte MAX_BYTE_MASK = -1;
    public static final byte DEFAULT_COORDINATE = 127;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    public final void setHandler(@NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"<set-?>");
        this.handler = handler;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    public void disconnect() {
        this.stop();
        this.setService(null);
        super.disconnect();
    }

    public final void start() {
        this.stop();
        this.counter = 0;
        this.running = true;
        this.handler.post(new Runnable(this){
            final /* synthetic */ RoboticsLiveControllerService this$0;

            public void run() {
                block0: {
                    RoboticsLiveControllerService.access$incrementCounter(this.this$0);
                    long start2 = System.currentTimeMillis();
                    BluetoothGattService bluetoothGattService = this.this$0.getService();
                    if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(RoboticsLiveControllerService.Companion.getCHARACTERISTIC_ID())) == null) break block0;
                    BluetoothGattService bluetoothGattService2 = bluetoothGattService;
                    boolean bl = false;
                    boolean bl2 = false;
                    BluetoothGattService characteristic = bluetoothGattService2;
                    boolean bl3 = false;
                    this.this$0.getDeviceConnector().writeCharacteristic((BluetoothGattCharacteristic)characteristic, RoboticsLiveControllerService.access$generateMessage(this.this$0, RoboticsLiveControllerService.access$getCounter$p(this.this$0))).done(new SuccessCallback(this, start2){
                        final /* synthetic */ start.1 this$0;
                        final /* synthetic */ long $start$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$start$inlined = l;
                        }

                        public final void onRequestCompleted(@NotNull BluetoothDevice it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            long delay = System.currentTimeMillis() - this.$start$inlined;
                            Log.d((String)"Controller", (String)("Controller state sent in " + delay + " ms"));
                            if (this.this$0.this$0.getRunning()) {
                                if (delay < 100L) {
                                    this.this$0.this$0.getHandler().postDelayed((Runnable)this.this$0, 100L - delay);
                                } else {
                                    this.this$0.this$0.getHandler().post((Runnable)this.this$0);
                                }
                            }
                        }
                    }).enqueue();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void stop() {
        this.buttonByte = (byte)0;
        this.running = false;
    }

    private final void incrementCounter() {
        int n = this.counter;
        this.counter = n + 1;
        if (this.counter == 16) {
            this.counter = 0;
        }
    }

    public final void updateXDirection(@IntRange(from=0L, to=255L) int x) {
        this.x = (byte)x;
    }

    public final void updateYDirection(@IntRange(from=0L, to=255L) int y) {
        this.y = (byte)y;
    }

    public final void onButtonPressed(@IntRange(from=0L, to=8L) int buttonIndex) {
        byte by;
        byte by2 = this.buttonByte;
        byte by3 = this.getMaskBasedOnIndex(buttonIndex);
        RoboticsLiveControllerService roboticsLiveControllerService = this;
        boolean bl = false;
        roboticsLiveControllerService.buttonByte = by = (byte)(by2 | by3);
    }

    public final void onButtonReleased(@IntRange(from=0L, to=8L) int buttonIndex) {
        byte by;
        byte by2 = this.buttonByte;
        byte by3 = this.getMaskBasedOnIndex(buttonIndex);
        RoboticsLiveControllerService roboticsLiveControllerService = this;
        boolean bl = false;
        by3 = by = (byte)(~by3);
        bl = false;
        roboticsLiveControllerService.buttonByte = by = (byte)(by2 & by3);
    }

    private final byte getMaskBasedOnIndex(int buttonIndex) {
        return (byte)this.pow(2, buttonIndex);
    }

    private final byte[] generateMessage(int counter) {
        byte[] byArray = new byte[20];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        $this$apply[1] = (byte)counter;
        $this$apply[1] = this.x;
        $this$apply[2] = this.y;
        $this$apply[11] = this.buttonByte;
        return byArray;
    }

    private final int pow(int $this$pow, int exponent) {
        int res = 1;
        int n = CollectionsKt.count((Iterable)((Iterable)RangesKt.downTo((int)exponent, (int)1)));
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            res *= $this$pow;
        }
        return res;
    }

    public RoboticsLiveControllerService(@NotNull RoboticsDeviceConnector deviceConnector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)deviceConnector), (String)"deviceConnector");
        super(deviceConnector);
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        this.x = (byte)127;
        this.y = (byte)127;
        this.handler = new Handler(Looper.getMainLooper());
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("7486bec3-bb6b-4abd-a9ca-20adc281a0a4");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"7486bec\u2026-4abd-a9ca-20adc281a0a4\")");
        CHARACTERISTIC_ID = uUID;
    }

    public static final /* synthetic */ void access$incrementCounter(RoboticsLiveControllerService $this) {
        $this.incrementCounter();
    }

    public static final /* synthetic */ byte[] access$generateMessage(RoboticsLiveControllerService $this, int counter) {
        return $this.generateMessage(counter);
    }

    public static final /* synthetic */ int access$getCounter$p(RoboticsLiveControllerService $this) {
        return $this.counter;
    }

    public static final /* synthetic */ void access$setCounter$p(RoboticsLiveControllerService $this, int n) {
        $this.counter = n;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsLiveControllerService$Companion;", "", "()V", "CHARACTERISTIC_ID", "Ljava/util/UUID;", "getCHARACTERISTIC_ID", "()Ljava/util/UUID;", "COUNTER_MAX", "", "DEFAULT_COORDINATE", "", "DELAY_TIME_IN_MILLIS", "", "MAX_BYTE_MASK", "MESSAGE_LENGTH", "POSITION_BUTTON", "POSITION_KEEP_ALIVE", "POSITION_X_COORD", "POSITION_Y_COORD", "SERVICE_ID", "", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getCHARACTERISTIC_ID() {
            return CHARACTERISTIC_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

