/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.discover;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.ParcelUuid;
import androidx.annotation.RequiresPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.revolutionrobotics.bluetooth.android.domain.Device;
import org.revolutionrobotics.bluetooth.android.exception.BLEScanFailedException;
import org.revolutionrobotics.bluetooth.android.extensions.ContextExtensionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006H\u0007J\u0016\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0006\u0010\u0018\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/revolutionrobotics/bluetooth/android/discover/RoboticsDeviceDiscoverer;", "Landroid/bluetooth/le/ScanCallback;", "()V", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "scanResultListener", "Lkotlin/Function1;", "", "Lorg/revolutionrobotics/bluetooth/android/domain/Device;", "", "discoverRobots", "context", "Landroid/content/Context;", "listener", "onBatchScanResults", "results", "", "Landroid/bluetooth/le/ScanResult;", "onScanFailed", "errorCode", "", "onScanResult", "callbackType", "result", "stopDiscovering", "Companion", "bluetooth-android_release"})
public final class RoboticsDeviceDiscoverer
extends ScanCallback {
    private BluetoothAdapter bluetoothAdapter;
    private Function1<? super List<Device>, Unit> scanResultListener;
    @NotNull
    private static final UUID SERVICE_ID_LIVE;
    @NotNull
    private static final UUID SERVICE_ID_DEVICE_INFO;
    public static final Companion Companion;

    @RequiresPermission(allOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.BLUETOOTH"})
    public final void discoverRobots(@NotNull Context context, @NotNull Function1<? super List<Device>, Unit> listener) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
            this.bluetoothAdapter = ContextExtensionsKt.getBLEManager(context).getAdapter();
            this.scanResultListener = listener;
            BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
            if (bluetoothAdapter == null || (bluetoothAdapter = bluetoothAdapter.getBluetoothLeScanner()) == null) break block0;
            bluetoothAdapter.startScan(CollectionsKt.listOf((Object[])new ScanFilter[]{new ScanFilter.Builder().setServiceUuid(new ParcelUuid(SERVICE_ID_LIVE)).build(), new ScanFilter.Builder().setServiceUuid(new ParcelUuid(SERVICE_ID_DEVICE_INFO)).build()}), new ScanSettings.Builder().build(), (ScanCallback)this);
        }
    }

    public final void stopDiscovering() {
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        if (bluetoothAdapter != null && (bluetoothAdapter = bluetoothAdapter.getBluetoothLeScanner()) != null) {
            bluetoothAdapter.stopScan((ScanCallback)this);
        }
        this.bluetoothAdapter = null;
        this.scanResultListener = null;
    }

    public void onScanFailed(int errorCode) {
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        if (bluetoothAdapter != null && (bluetoothAdapter = bluetoothAdapter.getBluetoothLeScanner()) != null) {
            bluetoothAdapter.stopScan((ScanCallback)this);
        }
        this.stopDiscovering();
        throw (Throwable)new BLEScanFailedException(errorCode);
    }

    /*
     * WARNING - void declaration
     */
    public void onBatchScanResults(@NotNull List<ScanResult> results) {
        block1: {
            Collection<Device> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            Function1<? super List<Device>, Unit> function1 = this.scanResultListener;
            if (function1 == null) break block1;
            Iterable iterable = results;
            Function1<? super List<Device>, Unit> function12 = function1;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ScanResult scanResult = (ScanResult)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                BluetoothDevice bluetoothDevice = it.getDevice();
                Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice, (String)"it.device");
                String string = bluetoothDevice.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.device.name");
                BluetoothDevice bluetoothDevice2 = it.getDevice();
                Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice2, (String)"it.device");
                String string2 = bluetoothDevice2.getAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.device.address");
                BluetoothDevice bluetoothDevice3 = it.getDevice();
                Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice3, (String)"it.device");
                Device device = new Device(string, string2, bluetoothDevice3);
                collection.add(device);
            }
            collection = (List)destination$iv$iv;
            Unit cfr_ignored_0 = (Unit)function12.invoke((Object)collection);
        }
    }

    public void onScanResult(int callbackType, @NotNull ScanResult result) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            Function1<? super List<Device>, Unit> function1 = this.scanResultListener;
            if (function1 == null) break block0;
            BluetoothDevice bluetoothDevice = result.getDevice();
            Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice, (String)"result.device");
            String string = bluetoothDevice.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.name");
            BluetoothDevice bluetoothDevice2 = result.getDevice();
            Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice2, (String)"result.device");
            String string2 = bluetoothDevice2.getAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.device.address");
            BluetoothDevice bluetoothDevice3 = result.getDevice();
            Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice3, (String)"result.device");
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)CollectionsKt.listOf((Object)new Device(string, string2, bluetoothDevice3)));
        }
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("d2d5558c-5b9d-11e9-8647-d663bd873d93");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"d2d5558\u2026-11e9-8647-d663bd873d93\")");
        SERVICE_ID_LIVE = uUID;
        UUID uUID2 = UUID.fromString("F000180A-0451-4000-B000-000000000000");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"F000180\u2026-4000-B000-000000000000\")");
        SERVICE_ID_DEVICE_INFO = uUID2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/revolutionrobotics/bluetooth/android/discover/RoboticsDeviceDiscoverer$Companion;", "", "()V", "SERVICE_ID_DEVICE_INFO", "Ljava/util/UUID;", "getSERVICE_ID_DEVICE_INFO", "()Ljava/util/UUID;", "SERVICE_ID_LIVE", "getSERVICE_ID_LIVE", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getSERVICE_ID_LIVE() {
            return SERVICE_ID_LIVE;
        }

        @NotNull
        public final UUID getSERVICE_ID_DEVICE_INFO() {
            return SERVICE_ID_DEVICE_INFO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

