/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.data.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsDeviceConnector;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.MotorInfo;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JE\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "deviceConnector", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "read", "", "motor", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService$Motor;", "onComplete", "Lkotlin/Function1;", "", "onError", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "Companion", "Motor", "bluetooth-android_release"})
public final class RoboticsMotorService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    @NotNull
    public static final String SERVICE_ID = "d2d5558c-5b9d-11e9-8647-d663bd873d93";
    public static final int MOTOR_MESSAGE_SIZE = 9;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    public final void read(@NotNull Motor motor, @NotNull Function1<? super byte[], Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)motor), (String)"motor");
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(motor.getCharacteristic())) == null) break block0;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            this.getDeviceConnector().readCharacteristic((BluetoothGattCharacteristic)characteristic).with(new DataReceivedCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsMotorService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsMotorService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onDataReceived(@NotNull BluetoothDevice $noName_0, @NotNull Data data) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    byte[] byArray = data.getValue();
                    if (byArray == null) {
                        byArray = new byte[]{};
                    }
                    this.$onComplete$inlined.invoke((Object)byArray);
                }
            }).fail(new FailCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsMotorService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsMotorService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onRequestFailed(@NotNull BluetoothDevice $noName_0, int status) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    this.$onError$inlined.invoke((Object)new BLEConnectionException(status));
                }
            }).enqueue();
        }
    }

    public RoboticsMotorService(@NotNull RoboticsDeviceConnector deviceConnector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)deviceConnector), (String)"deviceConnector");
        super(deviceConnector);
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService$Motor;", "", "characteristic", "Ljava/util/UUID;", "(Ljava/lang/String;ILjava/util/UUID;)V", "getCharacteristic", "()Ljava/util/UUID;", "M1", "M2", "M3", "M4", "M5", "M6", "bluetooth-android_release"})
    public static final class Motor
    extends Enum<Motor> {
        public static final /* enum */ Motor M1;
        public static final /* enum */ Motor M2;
        public static final /* enum */ Motor M3;
        public static final /* enum */ Motor M4;
        public static final /* enum */ Motor M5;
        public static final /* enum */ Motor M6;
        private static final /* synthetic */ Motor[] $VALUES;
        @NotNull
        private final UUID characteristic;

        static {
            Motor[] motorArray = new Motor[6];
            Motor[] motorArray2 = motorArray;
            UUID uUID = UUID.fromString("4bdfb409-93cc-433a-83bd-7f4f8e7eaf54");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"4bdfb40\u2026-433a-83bd-7f4f8e7eaf54\")");
            motorArray[0] = M1 = new Motor(uUID);
            UUID uUID2 = UUID.fromString("454885b9-c9d1-4988-9893-a0437d5e6e9f");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"454885b\u2026-4988-9893-a0437d5e6e9f\")");
            motorArray[1] = M2 = new Motor(uUID2);
            UUID uUID3 = UUID.fromString("00fcd93b-0c3c-4940-aac1-b4c21fac3420");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(\"00fcd93\u2026-4940-aac1-b4c21fac3420\")");
            motorArray[2] = M3 = new Motor(uUID3);
            UUID uUID4 = UUID.fromString("49aaeaa4-bb74-4f84-aa8f-acf46e5cf922");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID4, (String)"UUID.fromString(\"49aaeaa\u2026-4f84-aa8f-acf46e5cf922\")");
            motorArray[3] = M4 = new Motor(uUID4);
            UUID uUID5 = UUID.fromString("ceea8e45-5ff9-4325-be13-48cf40c0e0c3");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID5, (String)"UUID.fromString(\"ceea8e4\u2026-4325-be13-48cf40c0e0c3\")");
            motorArray[4] = M5 = new Motor(uUID5);
            UUID uUID6 = UUID.fromString("8e4c474f-188e-4d2a-910a-cf66f674f569");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID6, (String)"UUID.fromString(\"8e4c474\u2026-4d2a-910a-cf66f674f569\")");
            motorArray[5] = M6 = new Motor(uUID6);
            $VALUES = motorArray;
        }

        @NotNull
        public final UUID getCharacteristic() {
            return this.characteristic;
        }

        private Motor(UUID characteristic) {
            this.characteristic = characteristic;
        }

        public static Motor[] values() {
            return (Motor[])$VALUES.clone();
        }

        public static Motor valueOf(String string) {
            return Enum.valueOf(Motor.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsMotorService$Companion;", "", "()V", "MOTOR_MESSAGE_SIZE", "", "SERVICE_ID", "", "getMotorInfoFromBytes", "Lorg/revolutionrobotics/bluetooth/android/service/MotorInfo;", "bytes", "", "bluetooth-android_release"})
    public static final class Companion {
        @ExperimentalUnsignedTypes
        @Nullable
        public final MotorInfo getMotorInfoFromBytes(@NotNull byte[] bytes) {
            MotorInfo motorInfo;
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            if (bytes.length >= 9) {
                int n;
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                int n2 = buffer.get();
                int n3 = buffer.getInt();
                float f = byteBuffer.getFloat();
                boolean bl = false;
                n2 = n = UByte.constructor-impl((byte)n2);
                bl = false;
                int n4 = n = n2 & 0xFF;
                int n5 = n3;
                float f2 = f;
                motorInfo = new MotorInfo(f2, n5, n4);
            } else {
                motorInfo = null;
            }
            return motorInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

