/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.data.Data;
import org.jetbrains.annotations.NotNull;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsDeviceConnector;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0013\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0014\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0015\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0016\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0017\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0018\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJG\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsDeviceService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "deviceConnector", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "getFirmwareRevision", "", "onCompleted", "Lkotlin/Function1;", "", "onError", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "getHardwareRevision", "getManufacturerName", "getModelNumber", "getSerialNumber", "getSoftwareRevision", "getSystemId", "readCharacteristic", "uuid", "Companion", "bluetooth-android_release"})
public final class RoboticsDeviceService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    @NotNull
    public static final String SERVICE_ID = "0000180a-0000-1000-8000-00805f9b34fb";
    @NotNull
    private static final UUID SERIAL_NUMBER_CHARACTERISTIC;
    @NotNull
    private static final UUID MANUFACTURER_CHARACTERISTIC;
    @NotNull
    private static final UUID HW_REVISION_CHARACTERISTIC;
    @NotNull
    private static final UUID SW_REVISION_CHARACTERISTIC;
    @NotNull
    private static final UUID FW_REVISION_CHARACTERISTIC;
    @NotNull
    private static final UUID SYSTEM_ID_CHARACTERISTIC;
    @NotNull
    private static final UUID MODEL_NUMBER_CHARACTERISTIC;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    public final void getSerialNumber(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(SERIAL_NUMBER_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getManufacturerName(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(MANUFACTURER_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getHardwareRevision(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(HW_REVISION_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getSoftwareRevision(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(SW_REVISION_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getFirmwareRevision(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(FW_REVISION_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getSystemId(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(SYSTEM_ID_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getModelNumber(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(MODEL_NUMBER_CHARACTERISTIC, onCompleted, onError);
    }

    private final void readCharacteristic(UUID uuid, Function1<? super String, Unit> onCompleted, Function1<? super BLEException, Unit> onError) {
        block0: {
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null) break block0;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService service = bluetoothGattService2;
            boolean bl3 = false;
            this.getDeviceConnector().readCharacteristic(service.getCharacteristic(uuid)).with(new DataReceivedCallback(this, uuid, onCompleted, onError){
                final /* synthetic */ RoboticsDeviceService this$0;
                final /* synthetic */ UUID $uuid$inlined;
                final /* synthetic */ Function1 $onCompleted$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsDeviceService;
                    this.$uuid$inlined = uUID;
                    this.$onCompleted$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onDataReceived(@NotNull BluetoothDevice $noName_0, @NotNull Data data) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    String string = data.getStringValue(0);
                    if (string == null) {
                        string = "";
                    }
                    this.$onCompleted$inlined.invoke((Object)string);
                }
            }).fail(new FailCallback(this, uuid, onCompleted, onError){
                final /* synthetic */ RoboticsDeviceService this$0;
                final /* synthetic */ UUID $uuid$inlined;
                final /* synthetic */ Function1 $onCompleted$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsDeviceService;
                    this.$uuid$inlined = uUID;
                    this.$onCompleted$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onRequestFailed(@NotNull BluetoothDevice $noName_0, int status) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    this.$onError$inlined.invoke((Object)new BLEConnectionException(status));
                }
            }).enqueue();
        }
    }

    public RoboticsDeviceService(@NotNull RoboticsDeviceConnector deviceConnector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)deviceConnector), (String)"deviceConnector");
        super(deviceConnector);
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("00002a25-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        SERIAL_NUMBER_CHARACTERISTIC = uUID;
        UUID uUID2 = UUID.fromString("00002a29-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        MANUFACTURER_CHARACTERISTIC = uUID2;
        UUID uUID3 = UUID.fromString("00002a27-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        HW_REVISION_CHARACTERISTIC = uUID3;
        UUID uUID4 = UUID.fromString("00002a28-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID4, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        SW_REVISION_CHARACTERISTIC = uUID4;
        UUID uUID5 = UUID.fromString("00002a26-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID5, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        FW_REVISION_CHARACTERISTIC = uUID5;
        UUID uUID6 = UUID.fromString("00002a23-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID6, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        SYSTEM_ID_CHARACTERISTIC = uUID6;
        UUID uUID7 = UUID.fromString("00002a24-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID7, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        MODEL_NUMBER_CHARACTERISTIC = uUID7;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsDeviceService$Companion;", "", "()V", "FW_REVISION_CHARACTERISTIC", "Ljava/util/UUID;", "getFW_REVISION_CHARACTERISTIC", "()Ljava/util/UUID;", "HW_REVISION_CHARACTERISTIC", "getHW_REVISION_CHARACTERISTIC", "MANUFACTURER_CHARACTERISTIC", "getMANUFACTURER_CHARACTERISTIC", "MODEL_NUMBER_CHARACTERISTIC", "getMODEL_NUMBER_CHARACTERISTIC", "SERIAL_NUMBER_CHARACTERISTIC", "getSERIAL_NUMBER_CHARACTERISTIC", "SERVICE_ID", "", "SW_REVISION_CHARACTERISTIC", "getSW_REVISION_CHARACTERISTIC", "SYSTEM_ID_CHARACTERISTIC", "getSYSTEM_ID_CHARACTERISTIC", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getSERIAL_NUMBER_CHARACTERISTIC() {
            return SERIAL_NUMBER_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getMANUFACTURER_CHARACTERISTIC() {
            return MANUFACTURER_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getHW_REVISION_CHARACTERISTIC() {
            return HW_REVISION_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getSW_REVISION_CHARACTERISTIC() {
            return SW_REVISION_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getFW_REVISION_CHARACTERISTIC() {
            return FW_REVISION_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getSYSTEM_ID_CHARACTERISTIC() {
            return SYSTEM_ID_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getMODEL_NUMBER_CHARACTERISTIC() {
            return MODEL_NUMBER_CHARACTERISTIC;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

