/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.data.Data;
import org.jetbrains.annotations.NotNull;
import org.revolutionrobotics.bluetooth.android.communication.RoboticsDeviceConnector;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fJ=\u0010\u0013\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBatteryService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "deviceConnector", "Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;", "(Lorg/revolutionrobotics/bluetooth/android/communication/RoboticsDeviceConnector;)V", "serviceId", "Ljava/util/UUID;", "getServiceId", "()Ljava/util/UUID;", "getMotorBattery", "", "onComplete", "Lkotlin/Function1;", "", "onError", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "getPrimaryBattery", "Companion", "bluetooth-android_release"})
public final class RoboticsBatteryService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    @NotNull
    public static final String SERVICE_ID = "0000180f-0000-1000-8000-00805f9b34fb";
    @NotNull
    private static final UUID CHARACTERISTIC_PRIMARY_BATTERY;
    @NotNull
    private static final UUID CHARACTERISTIC_MOTOR_BATTERY;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    public final void getPrimaryBattery(@NotNull Function1<? super Integer, Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block0: {
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(CHARACTERISTIC_PRIMARY_BATTERY)) == null) break block0;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            this.getDeviceConnector().readCharacteristic((BluetoothGattCharacteristic)characteristic).with(new DataReceivedCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsBatteryService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsBatteryService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onDataReceived(@NotNull BluetoothDevice $noName_0, @NotNull Data data) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    byte[] byArray = data.getValue();
                    this.$onComplete$inlined.invoke((Object)(byArray != null ? byArray[0] : (byte)0));
                }
            }).fail(new FailCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsBatteryService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsBatteryService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onRequestFailed(@NotNull BluetoothDevice $noName_0, int status) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    this.$onError$inlined.invoke((Object)new BLEConnectionException(status));
                }
            }).enqueue();
        }
    }

    public final void getMotorBattery(@NotNull Function1<? super Integer, Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block0: {
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(CHARACTERISTIC_MOTOR_BATTERY)) == null) break block0;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            this.getDeviceConnector().readCharacteristic((BluetoothGattCharacteristic)characteristic).with(new DataReceivedCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsBatteryService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsBatteryService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onDataReceived(@NotNull BluetoothDevice $noName_0, @NotNull Data data) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    byte[] byArray = data.getValue();
                    this.$onComplete$inlined.invoke((Object)(byArray != null ? byArray[0] : (byte)0));
                }
            }).fail(new FailCallback(this, onComplete, onError){
                final /* synthetic */ RoboticsBatteryService this$0;
                final /* synthetic */ Function1 $onComplete$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                {
                    this.this$0 = roboticsBatteryService;
                    this.$onComplete$inlined = function1;
                    this.$onError$inlined = function12;
                }

                public final void onRequestFailed(@NotNull BluetoothDevice $noName_0, int status) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    this.$onError$inlined.invoke((Object)new BLEConnectionException(status));
                }
            }).enqueue();
        }
    }

    public RoboticsBatteryService(@NotNull RoboticsDeviceConnector deviceConnector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)deviceConnector), (String)"deviceConnector");
        super(deviceConnector);
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("00002a19-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"00002a1\u2026-1000-8000-00805f9b34fb\")");
        CHARACTERISTIC_PRIMARY_BATTERY = uUID;
        UUID uUID2 = UUID.fromString("00002a19-0000-1000-8000-00805f9b34fa");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"00002a1\u2026-1000-8000-00805f9b34fa\")");
        CHARACTERISTIC_MOTOR_BATTERY = uUID2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBatteryService$Companion;", "", "()V", "CHARACTERISTIC_MOTOR_BATTERY", "Ljava/util/UUID;", "getCHARACTERISTIC_MOTOR_BATTERY", "()Ljava/util/UUID;", "CHARACTERISTIC_PRIMARY_BATTERY", "getCHARACTERISTIC_PRIMARY_BATTERY", "SERVICE_ID", "", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getCHARACTERISTIC_PRIMARY_BATTERY() {
            return CHARACTERISTIC_PRIMARY_BATTERY;
        }

        @NotNull
        public final UUID getCHARACTERISTIC_MOTOR_BATTERY() {
            return CHARACTERISTIC_MOTOR_BATTERY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

