/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsEventSerializer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J=\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u0017\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u001a\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u001b\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J\u001a\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\"\u0010!\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\"\u0010$\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016JG\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006H\u0002R`\u0010\u0003\u001aT\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j)\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRB\u0010\u0010\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsDeviceService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "()V", "errorCallbackMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lkotlin/Function1;", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "", "Lkotlin/collections/HashMap;", "serviceId", "getServiceId", "()Ljava/util/UUID;", "successCallbackMap", "", "disconnect", "getFirmwareRevision", "onCompleted", "onError", "getHardwareRevision", "getManufacturerName", "getModelNumber", "getSerialNumber", "getSoftwareRevision", "getSystemId", "onCharacteristicChanged", "gatt", "Landroid/bluetooth/BluetoothGatt;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "onCharacteristicRead", "status", "", "onCharacteristicWrite", "readCharacteristic", "uuid", "Companion", "bluetooth-android_release"})
public final class RoboticsDeviceService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private final HashMap<UUID, Function1<String, Unit>> successCallbackMap;
    private final HashMap<UUID, Function1<BLEException, Unit>> errorCallbackMap;
    @NotNull
    public static final String SERVICE_ID = "0000180a-0000-1000-8000-00805f9b34fb";
    @NotNull
    private static final UUID SERIAL_NUMBER_CHARACTERISTIC;
    @NotNull
    private static final UUID MANUFACTURER_CHARACTERISTIC;
    @NotNull
    private static final UUID HW_REVISION_CHARACTERISTIC;
    @NotNull
    private static final UUID SW_REVISION_CHARACTERISTIC;
    @NotNull
    private static final UUID FW_REVISION_CHARACTERISTIC;
    @NotNull
    private static final UUID SYSTEM_ID_CHARACTERISTIC;
    @NotNull
    private static final UUID MODEL_NUMBER_CHARACTERISTIC;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public void disconnect() {
        this.successCallbackMap.clear();
        this.errorCallbackMap.clear();
        super.disconnect();
    }

    @Override
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
                if (status != 0) break block0;
                Function1<String, Unit> function1 = this.successCallbackMap.get(characteristic.getUuid());
                if (function1 == null) break block1;
                Function1<String, Unit> function12 = function1;
                boolean bl = false;
                boolean bl2 = false;
                Function1<String, Unit> callback = function12;
                boolean bl3 = false;
                String string = characteristic.getStringValue(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"characteristic.getStringValue(0)");
                callback.invoke((Object)string);
                this.successCallbackMap.remove(characteristic.getUuid());
                this.errorCallbackMap.remove(characteristic.getUuid());
                break block1;
            }
            Function1<BLEException, Unit> function1 = this.errorCallbackMap.get(characteristic.getUuid());
            if (function1 == null) break block1;
            Function1<BLEException, Unit> function13 = function1;
            boolean bl = false;
            boolean bl4 = false;
            Function1<BLEException, Unit> callback = function13;
            boolean bl5 = false;
            callback.invoke((Object)new BLEConnectionException(status));
            this.successCallbackMap.remove(characteristic.getUuid());
            this.errorCallbackMap.remove(characteristic.getUuid());
        }
    }

    public final void getSerialNumber(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(SERIAL_NUMBER_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getManufacturerName(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(MANUFACTURER_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getHardwareRevision(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(HW_REVISION_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getSoftwareRevision(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(SW_REVISION_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getFirmwareRevision(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(FW_REVISION_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getSystemId(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(SYSTEM_ID_CHARACTERISTIC, onCompleted, onError);
    }

    public final void getModelNumber(@NotNull Function1<? super String, Unit> onCompleted, @NotNull Function1<? super BLEException, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onCompleted, (String)"onCompleted");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.readCharacteristic(MODEL_NUMBER_CHARACTERISTIC, onCompleted, onError);
    }

    @Override
    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    @Override
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    private final void readCharacteristic(UUID uuid, Function1<? super String, Unit> onCompleted, Function1<? super BLEException, Unit> onError) {
        block2: {
            ((Map)this.successCallbackMap).put(uuid, onCompleted);
            ((Map)this.errorCallbackMap).put(uuid, onError);
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            if (bluetoothGatt == null) break block2;
            BluetoothGatt bluetoothGatt2 = bluetoothGatt;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGatt gatt = bluetoothGatt2;
            boolean bl3 = false;
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService != null) {
                BluetoothGattService bluetoothGattService2 = bluetoothGattService;
                boolean bl4 = false;
                boolean bl5 = false;
                BluetoothGattService service = bluetoothGattService2;
                boolean bl6 = false;
                RoboticsEventSerializer roboticsEventSerializer = this.getEventSerializer();
                if (roboticsEventSerializer != null) {
                    roboticsEventSerializer.registerEvent((Function0<Boolean>)((Function0)new Function0<Boolean>(service, gatt, this, uuid){
                        final /* synthetic */ BluetoothGattService $service;
                        final /* synthetic */ BluetoothGatt $gatt$inlined;
                        final /* synthetic */ RoboticsDeviceService this$0;
                        final /* synthetic */ UUID $uuid$inlined;
                        {
                            this.$service = bluetoothGattService;
                            this.$gatt$inlined = bluetoothGatt;
                            this.this$0 = roboticsDeviceService;
                            this.$uuid$inlined = uUID;
                            super(0);
                        }

                        public final boolean invoke() {
                            return this.$gatt$inlined.readCharacteristic(this.$service.getCharacteristic(this.$uuid$inlined));
                        }
                    }));
                }
            }
        }
    }

    public RoboticsDeviceService() {
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        RoboticsDeviceService roboticsDeviceService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        roboticsDeviceService.successCallbackMap = hashMap;
        roboticsDeviceService = this;
        bl = false;
        hashMap = new HashMap();
        roboticsDeviceService.errorCallbackMap = hashMap;
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("00002a25-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        SERIAL_NUMBER_CHARACTERISTIC = uUID;
        UUID uUID2 = UUID.fromString("00002a29-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        MANUFACTURER_CHARACTERISTIC = uUID2;
        UUID uUID3 = UUID.fromString("00002a27-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        HW_REVISION_CHARACTERISTIC = uUID3;
        UUID uUID4 = UUID.fromString("00002a28-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID4, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        SW_REVISION_CHARACTERISTIC = uUID4;
        UUID uUID5 = UUID.fromString("00002a26-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID5, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        FW_REVISION_CHARACTERISTIC = uUID5;
        UUID uUID6 = UUID.fromString("00002a23-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID6, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        SYSTEM_ID_CHARACTERISTIC = uUID6;
        UUID uUID7 = UUID.fromString("00002a24-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID7, (String)"UUID.fromString(\"00002a2\u2026-1000-8000-00805f9b34fb\")");
        MODEL_NUMBER_CHARACTERISTIC = uUID7;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsDeviceService$Companion;", "", "()V", "FW_REVISION_CHARACTERISTIC", "Ljava/util/UUID;", "getFW_REVISION_CHARACTERISTIC", "()Ljava/util/UUID;", "HW_REVISION_CHARACTERISTIC", "getHW_REVISION_CHARACTERISTIC", "MANUFACTURER_CHARACTERISTIC", "getMANUFACTURER_CHARACTERISTIC", "MODEL_NUMBER_CHARACTERISTIC", "getMODEL_NUMBER_CHARACTERISTIC", "SERIAL_NUMBER_CHARACTERISTIC", "getSERIAL_NUMBER_CHARACTERISTIC", "SERVICE_ID", "", "SW_REVISION_CHARACTERISTIC", "getSW_REVISION_CHARACTERISTIC", "SYSTEM_ID_CHARACTERISTIC", "getSYSTEM_ID_CHARACTERISTIC", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getSERIAL_NUMBER_CHARACTERISTIC() {
            return SERIAL_NUMBER_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getMANUFACTURER_CHARACTERISTIC() {
            return MANUFACTURER_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getHW_REVISION_CHARACTERISTIC() {
            return HW_REVISION_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getSW_REVISION_CHARACTERISTIC() {
            return SW_REVISION_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getFW_REVISION_CHARACTERISTIC() {
            return FW_REVISION_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getSYSTEM_ID_CHARACTERISTIC() {
            return SYSTEM_ID_CHARACTERISTIC;
        }

        @NotNull
        public final UUID getMODEL_NUMBER_CHARACTERISTIC() {
            return MODEL_NUMBER_CHARACTERISTIC;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

