/*
 * Decompiled with CFR 0.152.
 */
package org.revolutionrobotics.bluetooth.android.service;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.revolutionrobotics.bluetooth.android.exception.BLEConnectionException;
import org.revolutionrobotics.bluetooth.android.exception.BLEException;
import org.revolutionrobotics.bluetooth.android.service.RoboticsBLEService;
import org.revolutionrobotics.bluetooth.android.service.RoboticsEventSerializer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J=\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J=\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006J\u001a\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\"\u0010\u001e\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016R`\u0010\u0003\u001aT\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j)\u0012\u0004\u0012\u00020\u0005\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRB\u0010\u0010\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00060\u0004j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBatteryService;", "Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBLEService;", "()V", "errorCallbackMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lkotlin/Function1;", "Lorg/revolutionrobotics/bluetooth/android/exception/BLEException;", "Lkotlin/ParameterName;", "name", "exception", "", "Lkotlin/collections/HashMap;", "serviceId", "getServiceId", "()Ljava/util/UUID;", "successCallbackMap", "", "disconnect", "getMotorBattery", "onComplete", "onError", "getPrimaryBattery", "onCharacteristicChanged", "gatt", "Landroid/bluetooth/BluetoothGatt;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "onCharacteristicRead", "status", "onCharacteristicWrite", "Companion", "bluetooth-android_release"})
public final class RoboticsBatteryService
extends RoboticsBLEService {
    @NotNull
    private final UUID serviceId;
    private final HashMap<UUID, Function1<Integer, Unit>> successCallbackMap;
    private final HashMap<UUID, Function1<BLEException, Unit>> errorCallbackMap;
    @NotNull
    public static final String SERVICE_ID = "0000180f-0000-1000-8000-00805f9b34fb";
    @NotNull
    private static final UUID CHARACTERISTIC_PRIMARY_BATTERY;
    @NotNull
    private static final UUID CHARACTERISTIC_MOTOR_BATTERY;
    public static final Companion Companion;

    @Override
    @NotNull
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public void disconnect() {
        this.successCallbackMap.clear();
        this.errorCallbackMap.clear();
        super.disconnect();
    }

    @Override
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
                if (status != 0) break block0;
                Function1<Integer, Unit> function1 = this.successCallbackMap.get(characteristic.getUuid());
                if (function1 == null) break block1;
                Function1<Integer, Unit> function12 = function1;
                boolean bl = false;
                boolean bl2 = false;
                Function1<Integer, Unit> callback = function12;
                boolean bl3 = false;
                callback.invoke((Object)characteristic.getValue()[0]);
                this.errorCallbackMap.remove(characteristic.getUuid());
                this.successCallbackMap.remove(characteristic.getUuid());
                break block1;
            }
            Function1<BLEException, Unit> function1 = this.errorCallbackMap.get(characteristic.getUuid());
            if (function1 == null) break block1;
            Function1<BLEException, Unit> function13 = function1;
            boolean bl = false;
            boolean bl4 = false;
            Function1<BLEException, Unit> callback = function13;
            boolean bl5 = false;
            callback.invoke((Object)new BLEConnectionException(status));
            this.successCallbackMap.remove(characteristic.getUuid());
            this.errorCallbackMap.remove(characteristic.getUuid());
        }
    }

    public final void getPrimaryBattery(@NotNull Function1<? super Integer, Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block2: {
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(CHARACTERISTIC_PRIMARY_BATTERY)) == null) break block2;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            if (bluetoothGatt != null) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                boolean bl4 = false;
                boolean bl5 = false;
                BluetoothGatt bluetoothGatt3 = bluetoothGatt2;
                boolean bl6 = false;
                ((Map)this.successCallbackMap).put(CHARACTERISTIC_PRIMARY_BATTERY, onComplete);
                ((Map)this.errorCallbackMap).put(CHARACTERISTIC_PRIMARY_BATTERY, onError);
                RoboticsEventSerializer roboticsEventSerializer = this.getEventSerializer();
                if (roboticsEventSerializer != null) {
                    roboticsEventSerializer.registerEvent((Function0<Boolean>)((Function0)new Function0<Boolean>(bluetoothGatt3, (BluetoothGattCharacteristic)characteristic, this, onComplete, onError){
                        final /* synthetic */ BluetoothGatt $bluetoothGatt;
                        final /* synthetic */ BluetoothGattCharacteristic $characteristic$inlined;
                        final /* synthetic */ RoboticsBatteryService this$0;
                        final /* synthetic */ Function1 $onComplete$inlined;
                        final /* synthetic */ Function1 $onError$inlined;
                        {
                            this.$bluetoothGatt = bluetoothGatt;
                            this.$characteristic$inlined = bluetoothGattCharacteristic;
                            this.this$0 = roboticsBatteryService;
                            this.$onComplete$inlined = function1;
                            this.$onError$inlined = function12;
                            super(0);
                        }

                        public final boolean invoke() {
                            return this.$bluetoothGatt.readCharacteristic(this.$characteristic$inlined);
                        }
                    }));
                }
            }
        }
    }

    public final void getMotorBattery(@NotNull Function1<? super Integer, Unit> onComplete, @NotNull Function1<? super BLEException, Unit> onError) {
        block2: {
            Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            BluetoothGattService bluetoothGattService = this.getService();
            if (bluetoothGattService == null || (bluetoothGattService = bluetoothGattService.getCharacteristic(CHARACTERISTIC_MOTOR_BATTERY)) == null) break block2;
            BluetoothGattService bluetoothGattService2 = bluetoothGattService;
            boolean bl = false;
            boolean bl2 = false;
            BluetoothGattService characteristic = bluetoothGattService2;
            boolean bl3 = false;
            BluetoothGatt bluetoothGatt = this.getBluetoothGatt();
            if (bluetoothGatt != null) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                boolean bl4 = false;
                boolean bl5 = false;
                BluetoothGatt bluetoothGatt3 = bluetoothGatt2;
                boolean bl6 = false;
                ((Map)this.successCallbackMap).put(CHARACTERISTIC_MOTOR_BATTERY, onComplete);
                ((Map)this.errorCallbackMap).put(CHARACTERISTIC_MOTOR_BATTERY, onError);
                RoboticsEventSerializer roboticsEventSerializer = this.getEventSerializer();
                if (roboticsEventSerializer != null) {
                    roboticsEventSerializer.registerEvent((Function0<Boolean>)((Function0)new Function0<Boolean>(bluetoothGatt3, (BluetoothGattCharacteristic)characteristic, this, onComplete, onError){
                        final /* synthetic */ BluetoothGatt $bluetoothGatt;
                        final /* synthetic */ BluetoothGattCharacteristic $characteristic$inlined;
                        final /* synthetic */ RoboticsBatteryService this$0;
                        final /* synthetic */ Function1 $onComplete$inlined;
                        final /* synthetic */ Function1 $onError$inlined;
                        {
                            this.$bluetoothGatt = bluetoothGatt;
                            this.$characteristic$inlined = bluetoothGattCharacteristic;
                            this.this$0 = roboticsBatteryService;
                            this.$onComplete$inlined = function1;
                            this.$onError$inlined = function12;
                            super(0);
                        }

                        public final boolean invoke() {
                            return this.$bluetoothGatt.readCharacteristic(this.$characteristic$inlined);
                        }
                    }));
                }
            }
        }
    }

    @Override
    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, int status) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    @Override
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkParameterIsNotNull((Object)characteristic, (String)"characteristic");
    }

    public RoboticsBatteryService() {
        UUID uUID = UUID.fromString(SERVICE_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(SERVICE_ID)");
        this.serviceId = uUID;
        RoboticsBatteryService roboticsBatteryService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        roboticsBatteryService.successCallbackMap = hashMap;
        roboticsBatteryService = this;
        bl = false;
        hashMap = new HashMap();
        roboticsBatteryService.errorCallbackMap = hashMap;
    }

    static {
        Companion = new Companion(null);
        UUID uUID = UUID.fromString("00002a19-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"00002a1\u2026-1000-8000-00805f9b34fb\")");
        CHARACTERISTIC_PRIMARY_BATTERY = uUID;
        UUID uUID2 = UUID.fromString("00002a19-0000-1000-8000-00805f9b34fa");
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.fromString(\"00002a1\u2026-1000-8000-00805f9b34fa\")");
        CHARACTERISTIC_MOTOR_BATTERY = uUID2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/revolutionrobotics/bluetooth/android/service/RoboticsBatteryService$Companion;", "", "()V", "CHARACTERISTIC_MOTOR_BATTERY", "Ljava/util/UUID;", "getCHARACTERISTIC_MOTOR_BATTERY", "()Ljava/util/UUID;", "CHARACTERISTIC_PRIMARY_BATTERY", "getCHARACTERISTIC_PRIMARY_BATTERY", "SERVICE_ID", "", "bluetooth-android_release"})
    public static final class Companion {
        @NotNull
        public final UUID getCHARACTERISTIC_PRIMARY_BATTERY() {
            return CHARACTERISTIC_PRIMARY_BATTERY;
        }

        @NotNull
        public final UUID getCHARACTERISTIC_MOTOR_BATTERY() {
            return CHARACTERISTIC_MOTOR_BATTERY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

