/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.model.Model;
import org.apache.maven.model.interpolation.MavenBuildTimestamp;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;

public final class PropertyValueResolver {
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("project.", "pom.");
    private static final Pattern VAR_DETECTOR = Pattern.compile("\\$\\{.+}");
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;
    private final List<ValueSource> valueSources;

    public PropertyValueResolver(Properties props) {
        this(Collections.singletonList(new PropertiesBasedValueSource(props)));
    }

    public PropertyValueResolver(List<ValueSource> valueSources) {
        this.valueSources = valueSources;
    }

    public PropertyValueResolver(MavenProject project) {
        this.valueSources = new ArrayList<ValueSource>(8);
        final MavenBuildTimestamp now = new MavenBuildTimestamp();
        Model model = project.getModel();
        Properties modelProperties = model.getProperties();
        final File projectDir = project.getBasedir();
        PrefixedObjectValueSource prefixedProjectValues = new PrefixedObjectValueSource(PROJECT_PREFIXES, (Object)model, false);
        this.valueSources.add((ValueSource)prefixedProjectValues);
        ObjectBasedValueSource unprefixedProjectValues = new ObjectBasedValueSource((Object)model);
        this.valueSources.add((ValueSource)unprefixedProjectValues);
        PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("basedir".equals(expression)) {
                    return projectDir.getAbsolutePath();
                }
                return null;
            }
        }, PROJECT_PREFIXES, true);
        this.valueSources.add((ValueSource)basedirValueSource);
        PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("baseUri".equals(expression)) {
                    return projectDir.getAbsoluteFile().toURI().toString();
                }
                return null;
            }
        }, PROJECT_PREFIXES, false);
        this.valueSources.add((ValueSource)baseUriValueSource);
        PrefixedValueSourceWrapper buildTimeStampValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("build.timestamp".equals(expression)) {
                    return now.formattedTimestamp();
                }
                return null;
            }
        }, Collections.singletonList("maven."), true);
        this.valueSources.add((ValueSource)buildTimeStampValueSource);
        this.valueSources.add((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
        this.valueSources.add((ValueSource)new MapBasedValueSource((Map)modelProperties));
        try {
            this.valueSources.add((ValueSource)new EnvarBasedValueSource(false));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not construct environment variable value source for property interpolation.");
        }
    }

    public boolean containsVariables(CharSequence expression) {
        return VAR_DETECTOR.matcher(expression).find();
    }

    public String resolve(CharSequence expression) {
        String expr = expression.toString();
        StringBuilder builder = new StringBuilder();
        int len = expr.length();
        int state = 0;
        int start = -1;
        int nest = 0;
        int nameStart = -1;
        int i = 0;
        while (i < len) {
            int ch = expr.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    builder.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            builder.appendCodePoint(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            nameStart = start = i + 1;
                            state = 2;
                            break block0;
                        }
                    }
                    builder.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 123: {
                            ++nest;
                            break;
                        }
                        case 58: {
                            if (nameStart == i) break;
                        }
                        case 44: 
                        case 125: {
                            if (nest > 0) {
                                if (ch != 125) break block0;
                                --nest;
                                break;
                            }
                            String val = this.findValue(expr.substring(nameStart, i).trim());
                            if (val != null && !val.equals(expr)) {
                                builder.append(val);
                                state = ch == 125 ? 0 : 3;
                                break;
                            }
                            if (ch == 44) {
                                nameStart = i + 1;
                                break;
                            }
                            if (ch == 58) {
                                start = i + 1;
                                state = 4;
                                break;
                            }
                            throw new IllegalStateException("Failed to resolve expression: " + expr.substring(start - 2, i + 1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (ch == 123) {
                        ++nest;
                        break;
                    }
                    if (ch != 125) break;
                    if (nest > 0) {
                        --nest;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch == 123) {
                        ++nest;
                        break;
                    }
                    if (ch != 125) break;
                    if (nest > 0) {
                        --nest;
                        break;
                    }
                    state = 0;
                    builder.append(expr, start, i);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected char seen: " + ch);
                }
            }
            i = expr.offsetByCodePoints(i, 1);
        }
        switch (state) {
            case 1: {
                builder.append('$');
                break;
            }
            case 4: {
                builder.append(expr, start - 2, expr.length());
                break;
            }
            case 2: {
                throw new IllegalStateException("Incomplete expression: " + builder.toString());
            }
        }
        return builder.toString();
    }

    @Nullable
    private String findValue(String name) {
        return this.valueSources.stream().map(s -> s.getValue(name)).filter(Objects::nonNull).map(Object::toString).findFirst().orElse(null);
    }
}

