/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Status;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.HttpServerInboundWay;
import org.restlet.engine.connector.ServerOutboundWay;
import org.restlet.engine.io.IoState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerOutboundWay
extends ServerOutboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpServerOutboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    protected void handle(Response response) {
        this.getMessages().add(response);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    @Override
    public void onCompleted(boolean endDetected) throws IOException {
        Queue<Response> inboundMessages;
        Response inboundMessage;
        this.getMessages().remove(this.getMessage());
        if (!this.getMessage().getStatus().isInformational() && (inboundMessage = (inboundMessages = ((HttpServerInboundWay)this.getConnection().getInboundWay()).getMessages()).peek()).getRequest() == this.getMessage().getRequest()) {
            inboundMessages.remove(inboundMessage);
        }
        super.onCompleted(endDetected);
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    public void onTimeOut() {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onOutboundError(Status.CONNECTOR_ERROR_COMMUNICATION, rsp);
        }
        super.onTimeOut();
    }

    @Override
    public void updateState() {
        if (this.getIoState() == IoState.IDLE && !this.isEmpty() && this.getMessage() == null) {
            this.setIoState(IoState.INTEREST);
            this.setMessage(this.getMessages().peek());
        }
        super.updateState();
    }
}

