/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Connector;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.ReadableSocketChannel;
import org.restlet.engine.io.ReadableTraceChannel;
import org.restlet.engine.io.WritableSelectionChannel;
import org.restlet.engine.io.WritableSocketChannel;
import org.restlet.engine.io.WritableTraceChannel;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection<T extends Connector>
implements SelectionListener {
    private final ConnectionHelper<T> helper;
    private final InboundWay inboundWay;
    private volatile long lastActivity;
    private volatile int maxIoIdleTimeMs;
    private final OutboundWay outboundWay;
    private volatile boolean persistent;
    private volatile boolean pipelining;
    private volatile ReadableSelectionChannel readableSelectionChannel;
    private volatile SelectionRegistration registration;
    private volatile SocketAddress socketAddress;
    private volatile SocketChannel socketChannel;
    private volatile ConnectionState state;
    private volatile WritableSelectionChannel writableSelectionChannel;

    public Connection(ConnectionHelper<T> helper, SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress, int inboundBufferSize, int outboundBufferSize) throws IOException {
        this.helper = helper;
        this.inboundWay = helper.createInboundWay(this, inboundBufferSize);
        this.outboundWay = helper.createOutboundWay(this, outboundBufferSize);
        this.init(socketChannel, controller, socketAddress);
    }

    public void clear() {
        this.inboundWay.clear();
        this.outboundWay.clear();
        this.readableSelectionChannel = null;
        this.socketChannel = null;
        this.registration = null;
        this.state = ConnectionState.CLOSED;
        this.writableSelectionChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean graceful) {
        if (graceful) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Closing connection to " + this.getSocketAddress() + " gracefully");
            }
            this.setState(ConnectionState.CLOSING);
        } else {
            Socket socket;
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Closing connection to " + this.getSocketAddress() + " immediately");
            }
            try {
                socket = this.getSocket();
                if (socket != null && !socket.isClosed()) {
                    this.shutdown(socket);
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.FINEST, "Unable to properly shutdown socket", ex);
            }
            try {
                socket = this.getSocket();
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.FINEST, "Unable to properly close socket", ex);
            }
            finally {
                this.getInboundWay().onClosed();
                this.getOutboundWay().onClosed();
                this.setState(ConnectionState.CLOSED);
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "Connection to " + this.getSocketAddress() + " is now closed");
                }
            }
        }
    }

    public void commit(Response response) {
        this.getHelper().getOutboundMessages().add(response);
        this.getHelper().getController().wakeup();
    }

    protected ReadableSelectionChannel createReadableSelectionChannel() {
        return new ReadableSocketChannel(this.getSocketChannel(), this.getRegistration()){

            public int read(ByteBuffer dst) throws IOException {
                Connection.this.onActivity();
                return super.read(dst);
            }
        };
    }

    protected WritableSelectionChannel createWritableSelectionChannel() {
        return new WritableSocketChannel(this.getSocketChannel(), this.getRegistration()){

            public int write(ByteBuffer src) throws IOException {
                Connection.this.onActivity();
                return super.write(src);
            }
        };
    }

    public String getAddress() {
        return this.getSocket() == null ? null : (this.getSocket().getInetAddress() == null ? null : this.getSocket().getInetAddress().getHostAddress());
    }

    public ConnectionHelper<T> getHelper() {
        return this.helper;
    }

    public int getInboundBufferSize() {
        return this.getHelper().getInboundBufferSize();
    }

    public InboundWay getInboundWay() {
        return this.inboundWay;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public int getLoadScore() {
        return this.getInboundWay().getLoadScore() + this.getOutboundWay().getLoadScore();
    }

    public Logger getLogger() {
        return this.getHelper().getLogger();
    }

    public int getMaxIoIdleTimeMs() {
        return this.maxIoIdleTimeMs;
    }

    public int getOutboundBufferSize() {
        return this.getHelper().getOutboundBufferSize();
    }

    public OutboundWay getOutboundWay() {
        return this.outboundWay;
    }

    public int getPort() {
        return this.getSocket() == null ? -1 : this.getSocket().getPort();
    }

    public ReadableSelectionChannel getReadableSelectionChannel() {
        return this.readableSelectionChannel;
    }

    public SelectionRegistration getRegistration() {
        return this.registration;
    }

    public Socket getSocket() {
        return this.getSocketChannel() == null ? null : this.getSocketChannel().socket();
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public WritableSelectionChannel getWritableSelectionChannel() {
        return this.writableSelectionChannel;
    }

    public boolean hasTimedOut() {
        return this.getMaxIoIdleTimeMs() > 0 && System.currentTimeMillis() - this.getLastActivity() >= (long)this.getMaxIoIdleTimeMs();
    }

    public void init(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        this.persistent = this.helper.isPersistingConnections();
        this.pipelining = this.helper.isPipeliningConnections();
        this.maxIoIdleTimeMs = this.helper.getMaxIoIdleTimeMs();
        this.state = ConnectionState.OPENING;
        this.socketChannel = socketChannel;
        this.socketAddress = socketAddress;
        if (controller != null && socketChannel != null && socketAddress != null) {
            this.registration = controller == null ? null : controller.register(socketChannel, 0, this);
            this.readableSelectionChannel = this.createReadableSelectionChannel();
            this.writableSelectionChannel = this.createWritableSelectionChannel();
            if (this.getHelper().isTracing()) {
                this.readableSelectionChannel = new ReadableTraceChannel(this.readableSelectionChannel);
                this.writableSelectionChannel = new WritableTraceChannel(this.writableSelectionChannel);
            }
            this.getInboundWay().getRegistration().setWakeupListener(controller);
            this.getOutboundWay().getRegistration().setWakeupListener(controller);
        }
        this.onActivity();
    }

    public boolean isAvailable() {
        return this.isPersistent() && this.getState().equals((Object)ConnectionState.OPEN) && this.isEmpty() && this.getInboundWay().isAvailable() && this.getOutboundWay().isAvailable();
    }

    public boolean isClientSide() {
        return this.getHelper().isClientSide();
    }

    public boolean isEmpty() {
        return this.getInboundWay().isEmpty() && this.getOutboundWay().isEmpty();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public boolean isServerSide() {
        return this.getHelper().isServerSide();
    }

    public void onActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public void onError(String message, Throwable throwable, Status status) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, message, throwable);
        } else if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, message);
        }
        status = new Status(status, throwable, message);
        this.getInboundWay().onError(status);
        this.getOutboundWay().onError(status);
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelected(SelectionRegistration selectionRegistration) throws IOException {
        try {
            boolean readyFound;
            Object trace;
            this.onActivity();
            if (this.getLogger().isLoggable(Level.FINER)) {
                trace = null;
                trace = this.isClientSide() ? "Client " : "Server ";
                this.getLogger().finer((String)trace + "connection (state | inbound | outbound): " + this.toString());
                if (this.registration != null) {
                    this.getLogger().finer((String)trace + "NIO selection (interest | ready | cancelled): " + this.registration.toString());
                }
            }
            if (this.registration == null) {
                this.getLogger().warning("Connection with no registration selected: " + this);
            } else {
                if (this.registration.isReadable()) {
                    trace = this.getInboundWay().getBuffer().getLock();
                    synchronized (trace) {
                        this.getInboundWay().getRegistration().onSelected(this.registration.getReadyOperations());
                    }
                }
                if (this.registration.isWritable()) {
                    trace = this.getOutboundWay().getBuffer().getLock();
                    synchronized (trace) {
                        this.getOutboundWay().getRegistration().onSelected(this.registration.getReadyOperations());
                    }
                }
                if (this.registration.isConnectable()) {
                    try {
                        if (this.getSocketChannel().finishConnect()) {
                            this.open();
                        } else {
                            this.onError("Unable to establish a connection to " + this.getSocketAddress(), null, Status.CONNECTOR_ERROR_CONNECTION);
                        }
                    }
                    catch (IOException e) {
                        this.onError("Unable to establish a connection to " + this.getSocketAddress(), e, Status.CONNECTOR_ERROR_CONNECTION);
                    }
                }
            }
            do {
                readyFound = false;
                Object object = this.getInboundWay().getBuffer().getLock();
                synchronized (object) {
                    if (this.getInboundWay().getIoState() == IoState.READY) {
                        readyFound = true;
                        this.getInboundWay().onSelected(this.getInboundWay().getRegistration());
                    }
                }
                object = this.getOutboundWay().getBuffer().getLock();
                synchronized (object) {
                    if (this.getInboundWay().getIoState() == IoState.READY) {
                        readyFound = true;
                        this.getOutboundWay().onSelected(this.getOutboundWay().getRegistration());
                    }
                }
            } while (readyFound);
        }
        catch (Throwable t) {
            this.onError("Unexpected error detected. Closing the connection.", t, Status.CONNECTOR_ERROR_INTERNAL);
        }
    }

    public void onTimeOut() {
        if (this.getHelper().getLogger().isLoggable(Level.FINE)) {
            this.getHelper().getLogger().fine("Closing " + (this.isServerSide() ? "server" : "client") + " connection with \"" + this.getSocketAddress() + "\" due to lack of activity during " + this.getHelper().getMaxIoIdleTimeMs() + " ms");
        }
        this.getInboundWay().onTimeOut();
        this.getOutboundWay().onTimeOut();
        this.close(false);
    }

    public void open() {
        this.setState(ConnectionState.OPEN);
        this.updateState();
    }

    public void reuse(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        this.init(socketChannel, controller, socketAddress);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
    }

    public void setRegistration(SelectionRegistration registration) {
        this.registration = registration;
    }

    public void setState(ConnectionState state) {
        if (this.getState() != state) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Connection state (old | new) : " + (Object)((Object)this.state) + " | " + (Object)((Object)state));
            }
            this.state = state;
        }
    }

    protected void shutdown(Socket socket) throws IOException {
        socket.shutdownInput();
        socket.shutdownOutput();
    }

    public String toString() {
        return (Object)((Object)this.getState()) + " | " + this.getInboundWay() + " | " + this.getOutboundWay() + " | " + this.isEmpty() + "|" + this.getRegistration();
    }

    public boolean updateState() {
        boolean result = true;
        if (this.getState() != ConnectionState.CLOSED) {
            String newState;
            String oldState = null;
            if (this.getHelper().getLogger().isLoggable(Level.FINEST)) {
                oldState = this.getRegistration().toString();
            }
            this.getInboundWay().updateState();
            this.getOutboundWay().updateState();
            result = this.getRegistration().setInterestOperations(this.getInboundWay().getRegistration().getInterestOperations() | this.getOutboundWay().getRegistration().getInterestOperations());
            if (this.getHelper().getLogger().isLoggable(Level.FINEST) && !oldState.equals(newState = this.getRegistration().toString())) {
                this.getHelper().getLogger().log(Level.FINEST, "Old connection NIO interest: " + oldState);
                this.getHelper().getLogger().log(Level.FINEST, "New connection NIO interest: " + newState);
            }
        }
        return result;
    }
}

