/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.IoUtils;
import org.restlet.representation.Representation;
import org.restlet.util.SelectionListener;

public abstract class ReadableListener
implements SelectionListener {
    private final ByteBuffer byteBuffer;
    private final ReadableByteChannel byteChannel;

    public ReadableListener(Representation source) throws IOException {
        this(source, IoUtils.BUFFER_SIZE);
    }

    public ReadableListener(Representation source, int bufferSize) throws IOException {
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.byteChannel = source.getChannel();
    }

    protected abstract void onContent(ByteBuffer var1);

    protected void onEnd() {
    }

    protected void onError(IOException ioe) {
        Context.getCurrentLogger().log(Level.WARNING, "", ioe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSelected() {
        try {
            ByteBuffer byteBuffer = this.byteBuffer;
            synchronized (byteBuffer) {
                this.byteBuffer.clear();
                int result = this.byteChannel.read(this.byteBuffer);
                if (result > 0) {
                    this.byteBuffer.flip();
                    this.onContent(this.byteBuffer);
                } else if (result == -1) {
                    this.onEnd();
                } else {
                    Context.getCurrentLogger().fine("NIO selection detected with no content available");
                }
            }
        }
        catch (IOException ioe) {
            this.onError(ioe);
        }
    }
}

