/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.swagger;

import javax.ws.rs.core.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.ext.platform.internal.conversion.swagger.v1_2.SwaggerWriter;
import org.restlet.ext.platform.internal.conversion.swagger.v1_2.model.ApiDeclaration;
import org.restlet.ext.platform.internal.conversion.swagger.v1_2.model.ResourceListing;
import org.restlet.ext.platform.internal.introspection.jaxrs.JaxRsIntrospector;
import org.restlet.ext.platform.internal.model.Definition;
import org.restlet.representation.Representation;
import org.restlet.routing.Router;

public class JaxRsApplicationSwaggerSpecificationRestlet
extends Restlet {
    private String apiVersion;
    private Application application;
    private String basePath;
    private Reference baseRef;
    private Definition definition;
    private String swaggerVersion = "1.2";

    public JaxRsApplicationSwaggerSpecificationRestlet(Application application) {
        this(null, application);
    }

    public JaxRsApplicationSwaggerSpecificationRestlet(Context context, Application application) {
        super(context);
        this.application = application;
    }

    public void attach(Router router) {
        this.attach(router, "/api-docs");
    }

    public void attach(Router router, String path) {
        router.attach(path, (Restlet)this);
        router.attach(path + "/{resource}", (Restlet)this);
    }

    public Representation getApiDeclaration(String category) {
        ApiDeclaration apiDeclaration = SwaggerWriter.getApiDeclaration((Definition)this.getDefinition(), (String)category);
        apiDeclaration.setSwaggerVersion(this.swaggerVersion);
        return new JacksonRepresentation((Object)apiDeclaration);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Definition getDefinition() {
        if (this.definition != null) return this.definition;
        Class<JaxRsApplicationSwaggerSpecificationRestlet> clazz = JaxRsApplicationSwaggerSpecificationRestlet.class;
        synchronized (JaxRsApplicationSwaggerSpecificationRestlet.class) {
            this.definition = JaxRsIntrospector.getDefinition((Application)this.application, (Reference)this.baseRef, (boolean)false);
            if (this.definition.getVersion() != null) return this.definition;
            this.definition.setVersion(this.apiVersion != null ? this.apiVersion : "1.0");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.definition;
        }
    }

    public Representation getResourceListing() {
        ResourceListing resourcelisting = SwaggerWriter.getResourcelisting((Definition)this.getDefinition());
        resourcelisting.setSwaggerVersion(this.swaggerVersion);
        return new JacksonRepresentation((Object)resourcelisting);
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (Method.GET.equals((Object)request.getMethod())) {
            Object resource = request.getAttributes().get("resource");
            if (resource instanceof String) {
                response.setEntity(this.getApiDeclaration((String)resource));
            } else {
                response.setEntity(this.getResourceListing());
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
    }

    public void setApiInboundRoot(Application application) {
        this.application = application;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        this.baseRef = basePath != null ? new Reference(basePath) : null;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }
}

