/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalBeanSetterTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalFieldTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.WrapperUtil;
import org.restlet.ext.jaxrs.internal.wrappers.params.ContextInjector;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ProviderWrapper;

abstract class AbstractProviderWrapper
implements ProviderWrapper {
    private final List<MediaType> consumedMimes;
    private final Class<?> genericMbrType;
    private final Class<?> genericMbwType;
    private final List<MediaType> producedMimes;

    AbstractProviderWrapper(Class<?> jaxRsProviderClass) throws IllegalArgumentException, WebApplicationException {
        Consumes pm = jaxRsProviderClass.getAnnotation(Consumes.class);
        this.consumedMimes = pm != null ? WrapperUtil.convertToMediaTypes(pm.value()) : Collections.singletonList(MediaType.ALL);
        Produces cm = jaxRsProviderClass.getAnnotation(Produces.class);
        this.producedMimes = cm != null ? WrapperUtil.convertToMediaTypes(cm.value()) : Collections.singletonList(MediaType.ALL);
        this.genericMbrType = Util.getGenericClass(jaxRsProviderClass, MessageBodyReader.class);
        this.genericMbwType = Util.getGenericClass(jaxRsProviderClass, MessageBodyWriter.class);
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract String getClassName();

    @Override
    public List<MediaType> getConsumedMimes() {
        return this.consumedMimes;
    }

    @Override
    public List<MediaType> getProducedMimes() {
        return this.producedMimes;
    }

    @Override
    public abstract int hashCode();

    void initProvider(Object jaxRsProvider, ThreadLocalizedContext tlContext, Providers allProviders, ExtensionBackwardMapping extensionBackwardMapping) throws IllegalFieldTypeException, IllegalBeanSetterTypeException, InjectException, InvocationTargetException {
        ContextInjector iph = new ContextInjector(jaxRsProvider.getClass(), tlContext, allProviders, extensionBackwardMapping);
        iph.injectInto(jaxRsProvider, false);
    }

    @Override
    public abstract boolean isContextResolver();

    @Override
    public abstract boolean isExceptionMapper();

    @Override
    public abstract boolean isReader();

    @Override
    public abstract boolean isWriter();

    public boolean supportsRead(Class<?> entityClass, Type genericType) {
        if (entityClass == null) {
            return false;
        }
        if (genericType == null) {
            // empty if block
        }
        if (this.genericMbrType == null) {
            return false;
        }
        return this.genericMbrType.isAssignableFrom(entityClass);
    }

    @Override
    public boolean supportsRead(MediaType mediaType) {
        boolean result = false;
        for (int i = 0; !result && i < this.getConsumedMimes().size(); ++i) {
            result = this.getConsumedMimes().get(i).isCompatible((Metadata)mediaType) || mediaType == null;
        }
        return result;
    }

    public boolean supportsWrite(Class<?> entityClass, Type genericType) {
        if (entityClass == null) {
            return false;
        }
        if (genericType == null) {
            // empty if block
        }
        if (this.genericMbwType == null) {
            return false;
        }
        boolean supportsWrite = this.genericMbwType.isAssignableFrom(entityClass);
        return supportsWrite;
    }

    @Override
    public boolean supportsWrite(Iterable<MediaType> mediaTypes) {
        for (MediaType produced : this.getProducedMimes()) {
            for (MediaType requested : mediaTypes) {
                if (!requested.isCompatible((Metadata)produced)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsWrite(javax.ws.rs.core.MediaType requested) {
        return this.supportsWrite(Converter.toRestletMediaType(requested));
    }

    @Override
    public boolean supportsWrite(MediaType requested) {
        for (MediaType produced : this.getProducedMimes()) {
            if (!requested.isCompatible((Metadata)produced)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return this.getClassName();
    }
}

