/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import org.restlet.data.Reference;

public class EncodeOrCheck {
    public static final String FRAGMENT_FORBIDDEN;
    public static final String GEN_DELIMITERS = ":/?#[]@";
    private static final char[] HEX_DIGITS;
    public static final String SUB_DELIMITERS = "!$&'()*+,;=";
    public static final String TEMPL_PARAMS = "{}";
    public static final String RESERVED = ":/?#[]@!$&'()*+,;=";
    public static final String UNRESERVED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-._~";

    public static String all(CharSequence string, boolean encode) throws IllegalArgumentException {
        int length = string.length();
        StringBuilder stb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                EncodeOrCheck.processPercent(i, encode, string, stb);
                continue;
            }
            if (Reference.isValid((int)c)) {
                stb.append(c);
                continue;
            }
            EncodeOrCheck.toHexOrReject(c, stb, encode);
        }
        return stb.toString();
    }

    public static void checkForInvalidUriChars(CharSequence uriPart, int indexForErrMessage, String errMessName) throws IllegalArgumentException {
        int l = uriPart.length();
        boolean inVar = false;
        block4: for (int i = 0; i < l; ++i) {
            char c = uriPart.charAt(i);
            if (inVar) {
                if (c != '}') continue;
                inVar = false;
                continue;
            }
            switch (c) {
                case '{': {
                    inVar = true;
                    continue block4;
                }
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': {
                    throw EncodeOrCheck.throwIllegalArgExc(indexForErrMessage, errMessName, uriPart, " contains at least one reservec character: " + c + ". They must be encoded.");
                }
                default: {
                    if (c != ' ' && c >= ' ' && c < '\u007f') continue block4;
                    throw EncodeOrCheck.throwIllegalArgExc(indexForErrMessage, errMessName, uriPart, " contains at least one illegal character: " + c + ". They must be encoded.");
                }
            }
        }
    }

    static int encode(char toEncode, StringBuilder stb) {
        if (toEncode >= 'A' && toEncode <= 'Z' || toEncode >= 'a' && toEncode <= 'z' || toEncode >= '0' && toEncode <= '9' || toEncode == '-' || toEncode == '.' || toEncode == '_' || toEncode == '~') {
            stb.append(toEncode);
            return 1;
        }
        EncodeOrCheck.toHex(toEncode, stb);
        return 3;
    }

    private static String encodeNotBraces(CharSequence uriPart, boolean allowSemicolon, boolean encodeSlash) throws IllegalArgumentException {
        StringBuilder stb = new StringBuilder();
        int l = uriPart.length();
        for (int i = 0; i < l; ++i) {
            char c = uriPart.charAt(i);
            if (c == '{') {
                i = EncodeOrCheck.processTemplVarname(uriPart, i, stb);
                continue;
            }
            if (c == '%') {
                EncodeOrCheck.processPercent(i, true, uriPart, stb);
                continue;
            }
            if (c == '}') {
                throw new IllegalArgumentException("'}' is only allowed as end of a variable name in \"" + uriPart + "\"");
            }
            if (c == ';') {
                if (allowSemicolon) {
                    EncodeOrCheck.encode(c, stb);
                    continue;
                }
                throw new IllegalArgumentException("A semicolon is not allowed in a path");
            }
            if (!encodeSlash && c == '/') {
                stb.append(c);
                continue;
            }
            EncodeOrCheck.encode(c, stb);
        }
        return stb.toString();
    }

    public static CharSequence fragment(CharSequence fragment) throws IllegalArgumentException {
        StringBuilder stb = new StringBuilder(fragment.length());
        int length = fragment.length();
        for (int i = 0; i < length; ++i) {
            char c = fragment.charAt(i);
            if (c == '{') {
                i = EncodeOrCheck.processTemplVarname(fragment, i, stb);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                stb.append(c);
                continue;
            }
            if (c >= '?' && c <= '[') {
                stb.append(c);
                continue;
            }
            if (c >= '&' && c <= ';') {
                stb.append(c);
                continue;
            }
            if (c == '!' || c == '#' || c == '$' || c == '=' || c == ']' || c == '_' || c == '~') {
                stb.append(c);
                continue;
            }
            if (c == '}') {
                throw new IllegalArgumentException("'}' is only allowed as end of an template variable name");
            }
            if (c == '%') {
                EncodeOrCheck.processPercent(i, true, fragment, stb);
                continue;
            }
            EncodeOrCheck.toHexOrReject(c, stb, true);
        }
        return stb;
    }

    public static CharSequence fullMatrix(CharSequence matrix) throws IllegalArgumentException {
        return EncodeOrCheck.fullQueryOrMatrix(matrix, ';', "%20", true);
    }

    public static CharSequence fullQuery(CharSequence query, boolean encode) {
        return EncodeOrCheck.fullQueryOrMatrix(query, '&', "+", encode);
    }

    private static CharSequence fullQueryOrMatrix(CharSequence string, char delimiter, String spaceReplace, boolean encode) throws IllegalArgumentException {
        int l = string.length();
        StringBuilder stb = new StringBuilder(l + 6);
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                i = EncodeOrCheck.processTemplVarname(string, i, stb);
                continue;
            }
            if (c == delimiter || c == '=') {
                stb.append(c);
                continue;
            }
            if (c == ' ') {
                if (encode) {
                    stb.append(spaceReplace);
                    continue;
                }
                throw new IllegalArgumentException("A space is not allowed. Switch encode to on to auto encode it.");
            }
            if (Reference.isUnreserved((int)c)) {
                stb.append(c);
                continue;
            }
            if (c == '}') {
                throw new IllegalArgumentException("'}' is only allowed as end of a variable name in \"" + string + "\"");
            }
            if (c == '%') {
                EncodeOrCheck.processPercent(i, encode, string, stb);
                continue;
            }
            EncodeOrCheck.toHexOrReject(c, stb, encode);
        }
        return stb;
    }

    public static String host(String host) throws IllegalArgumentException {
        if (host.length() == 0) {
            throw new IllegalArgumentException("The host must not be empty");
        }
        int length = host.length();
        for (int i = 0; i < length; ++i) {
            char ch = host.charAt(i);
            if (ch > ' ' && ch < '\u007f') continue;
            throw new IllegalArgumentException("The " + i + ". character is not valid");
        }
        return host;
    }

    public static String nameOrValue(Object nameOrValue, boolean encode, String nameForMessage) throws IllegalArgumentException {
        if (nameOrValue == null) {
            throw EncodeOrCheck.throwIllegalArgExc(Integer.MIN_VALUE, nameForMessage, nameOrValue, " must not be null");
        }
        CharSequence nov = nameOrValue instanceof CharSequence ? (CharSequence)nameOrValue : nameOrValue.toString();
        if (encode) {
            return EncodeOrCheck.encodeNotBraces(nov, true, true);
        }
        EncodeOrCheck.checkForInvalidUriChars(nov, Integer.MIN_VALUE, nameForMessage);
        return nov.toString();
    }

    public static CharSequence pathSegmentsWithMatrix(CharSequence path, boolean encode) {
        return EncodeOrCheck.pathSegmentWithMatrix(path, encode, false);
    }

    public static CharSequence pathSegmentWithMatrix(CharSequence pathSegments, boolean encode) throws IllegalArgumentException {
        return EncodeOrCheck.pathSegmentWithMatrix(pathSegments, encode, true);
    }

    private static CharSequence pathSegmentWithMatrix(CharSequence pathSegments, boolean encode, boolean encodeSlash) throws IllegalArgumentException {
        int l = pathSegments.length();
        StringBuilder stb = new StringBuilder(l + 6);
        for (int i = 0; i < l; ++i) {
            char c = pathSegments.charAt(i);
            if (c == '{') {
                i = EncodeOrCheck.processTemplVarname(pathSegments, i, stb);
                continue;
            }
            if (c == '%') {
                EncodeOrCheck.processPercent(i, encode, pathSegments, stb);
                continue;
            }
            if (c == '/') {
                if (encodeSlash) {
                    EncodeOrCheck.toHex('/', stb);
                    continue;
                }
                stb.append('/');
                continue;
            }
            if (Reference.isUnreserved((int)c) || Reference.isReserved((int)c)) {
                stb.append(c);
                continue;
            }
            if (c == '}') {
                throw new IllegalArgumentException("'}' is only allowed as end of a variable name in \"" + pathSegments + "\"");
            }
            EncodeOrCheck.toHexOrReject(c, stb, encode);
        }
        return stb;
    }

    public static CharSequence pathWithoutMatrix(CharSequence path) throws IllegalArgumentException {
        return EncodeOrCheck.encodeNotBraces(path, false, false);
    }

    static void processPercent(int i, boolean encode, CharSequence uriPart, StringBuilder stb) {
        if (encode) {
            EncodeOrCheck.toHex('%', stb);
            return;
        }
        if (uriPart.length() <= i + 2) {
            CharSequence hexDigits = uriPart.subSequence(i, uriPart.length());
            throw new IllegalArgumentException("A percent encoding must have two charachters, so " + hexDigits + " is not allowed");
        }
        char c1 = uriPart.charAt(i + 1);
        char c2 = uriPart.charAt(i + 2);
        if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f'))) {
            throw new IllegalArgumentException("The percent encoded char %" + c1 + c2 + " is not valid");
        }
        stb.append('%');
    }

    private static int processTemplVarname(CharSequence uriPart, int braceIndex, StringBuilder stb) throws IllegalArgumentException {
        int l = uriPart.length();
        if (stb != null) {
            stb.append('{');
        }
        for (int i = braceIndex + 1; i < l; ++i) {
            char c = uriPart.charAt(i);
            if (c == '{') {
                throw new IllegalArgumentException("A variable must not contain an extra '{' in \"" + uriPart + "\"");
            }
            if (stb != null) {
                stb.append(c);
            }
            if (c != '}') continue;
            if (i == braceIndex + 1) {
                throw new IllegalArgumentException("The template variable name '{}' is not allowed in \"" + uriPart + "\"");
            }
            return i;
        }
        throw new IllegalArgumentException("No '}' found after '{' at position " + braceIndex + " of \"" + uriPart + "\"");
    }

    public static String scheme(String scheme) throws IllegalArgumentException {
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme must not be null");
        }
        int schemeLength = scheme.length();
        if (schemeLength == 0) {
            throw new IllegalArgumentException("The scheme must not be an empty String");
        }
        for (int i = 0; i < schemeLength; ++i) {
            char c = scheme.charAt(i);
            if (c == '{') {
                i = EncodeOrCheck.processTemplVarname(scheme, i, null);
                continue;
            }
            if (c == '}') {
                throw new IllegalArgumentException("The '}' is only allowed as end of a variable name in \"" + scheme + "\"");
            }
            if (c > '@' && c <= 'Z' || c > '\\' && c <= 'v' || (c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.') && i > 0) continue;
            if (i == 0) {
                throw new IllegalArgumentException("The first character of a scheme must be an alphabetic character or a template variable name begin with '{'. Scheme is \"" + scheme + "\"");
            }
            throw new IllegalArgumentException("The " + i + ". character of a scheme must be an alphabetic character, a number, a '+', a '-' or a '.'. Template variable names are also allowed. Scheme is \"" + scheme + "\"");
        }
        return scheme;
    }

    private static IllegalArgumentException throwIllegalArgExc(int index, String errMessName, Object illegalString, String messageEnd) {
        StringBuilder stb = new StringBuilder();
        stb.append("The ");
        if (index >= 0) {
            stb.append(index);
            stb.append(". ");
        }
        stb.append(errMessName);
        stb.append(" (");
        stb.append(illegalString);
        stb.append(")");
        stb.append(messageEnd);
        if (index >= 0) {
            stb.append(" (index starting with 0)");
        }
        throw new IllegalArgumentException(stb.toString());
    }

    public static void toHex(char toEncode, StringBuilder stb) {
        stb.append('%');
        stb.append(HEX_DIGITS[toEncode >> 4 & 0xF]);
        stb.append(HEX_DIGITS[toEncode & 0xF]);
    }

    private static void toHexOrReject(char c, StringBuilder stb, boolean encode) throws IllegalArgumentException {
        if (!encode) {
            throw new IllegalArgumentException("The character " + c + " is not valid");
        }
        stb.append('%');
        stb.append(HEX_DIGITS[c >> 4 & 0xF]);
        stb.append(HEX_DIGITS[c & 0xF]);
    }

    public static CharSequence userInfo(CharSequence userInfo, boolean encode) throws IllegalArgumentException {
        int length = userInfo.length();
        StringBuilder stb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = userInfo.charAt(i);
            if (c == '{') {
                i = EncodeOrCheck.processTemplVarname(userInfo, i, stb);
                continue;
            }
            if (c == '%') {
                EncodeOrCheck.processPercent(i, encode, userInfo, stb);
                continue;
            }
            if (Reference.isUnreserved((int)c) || Reference.isSubDelimiter((int)c)) {
                stb.append(c);
                continue;
            }
            if (c == '}') {
                throw new IllegalArgumentException("'}' is only allowed as end of a variable name in \"" + userInfo + "\"");
            }
            if (c == ':') {
                stb.append(c);
                continue;
            }
            EncodeOrCheck.toHexOrReject(c, stb, encode);
        }
        return stb;
    }

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder stb = new StringBuilder();
        for (char c = '\u0000'; c < '\u0100'; c = (char)((char)(c + 1))) {
            String cc = new String(new char[]{c});
            if (c == 37 || c == 123 || c == 125 || RESERVED.contains(cc) || UNRESERVED.contains(cc)) continue;
            stb.append(c);
        }
        FRAGMENT_FORBIDDEN = stb.toString();
    }
}

