/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.restlet.ext.jaxrs.internal.util.OneElementIterator;
import org.restlet.ext.jaxrs.internal.util.Util;

public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private List<String> encodings;
    private List<Locale> languages;
    private List<MediaType> mediaTypes;
    private List<Variant> variants;

    private static <T> Iterator<T> createIterator(List<T> list) {
        if (list == null || list.isEmpty()) {
            return new OneElementIterator<Object>(null);
        }
        return list.iterator();
    }

    public Variant.VariantListBuilder add() {
        this.buildVariants();
        return this;
    }

    public List<Variant> build() {
        if (Util.isNotEmpty(this.encodings) || Util.isNotEmpty(this.languages) || Util.isNotEmpty(this.mediaTypes)) {
            this.buildVariants();
        }
        List<Variant> variants = this.variants;
        this.variants = null;
        return variants;
    }

    private void buildVariants() {
        Iterator<MediaType> mediaTypeIter = VariantListBuilderImpl.createIterator(this.mediaTypes);
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        while (mediaTypeIter.hasNext()) {
            MediaType mediaType = mediaTypeIter.next();
            Iterator<Locale> languageIter = VariantListBuilderImpl.createIterator(this.languages);
            while (languageIter.hasNext()) {
                Locale language = languageIter.next();
                Iterator<String> encodingIter = VariantListBuilderImpl.createIterator(this.encodings);
                while (encodingIter.hasNext()) {
                    String encoding = encodingIter.next();
                    Variant variant = new Variant(mediaType, language, encoding);
                    this.variants.add(variant);
                }
            }
        }
        this.encodings.clear();
        this.languages.clear();
        this.mediaTypes.clear();
    }

    public Variant.VariantListBuilder encodings(String ... encodings) {
        if (this.encodings == null) {
            this.encodings = new ArrayList<String>();
        }
        for (String encoding : encodings) {
            this.encodings.add(encoding);
        }
        return this;
    }

    public Variant.VariantListBuilder languages(Locale ... languages) {
        if (this.languages == null) {
            this.languages = new ArrayList<Locale>();
        }
        for (Locale language : languages) {
            this.languages.add(language);
        }
        return this;
    }

    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new ArrayList<MediaType>();
        }
        for (MediaType mediaType : mediaTypes) {
            this.mediaTypes.add(mediaType);
        }
        return this;
    }
}

