/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.restlet.data.Reference;
import org.restlet.engine.util.SystemUtils;
import org.restlet.ext.jaxrs.internal.core.MultivaluedMapImpl;
import org.restlet.ext.jaxrs.internal.util.Util;

public class PathSegmentImpl
implements PathSegment {
    private final boolean decode;
    private volatile MultivaluedMap<String, String> matrixParameters;
    private final String matrParamEncoded;
    private final String path;

    public static MultivaluedMapImpl<String, String> parseMatrixParams(String matrParamString, boolean decoding) {
        String[] paramsEncSpl;
        MultivaluedMapImpl<String, String> matrixParameters = new MultivaluedMapImpl<String, String>();
        if (matrParamString == null) {
            return matrixParameters;
        }
        for (String matrParamEnc : paramsEncSpl = matrParamString.split(";")) {
            String value;
            String name;
            String valueEnc;
            String nameEnc;
            int posEquSign = matrParamEnc.indexOf(61);
            if (posEquSign <= 0) {
                nameEnc = matrParamEnc;
                valueEnc = "";
            } else {
                nameEnc = matrParamEnc.substring(0, posEquSign);
                valueEnc = matrParamEnc.substring(posEquSign + 1);
            }
            if (nameEnc.length() == 0 && valueEnc == null) continue;
            if (decoding) {
                name = Reference.decode((String)nameEnc);
                value = Reference.decode((String)valueEnc);
            } else {
                name = nameEnc;
                value = valueEnc;
            }
            matrixParameters.add(name, value);
        }
        return matrixParameters;
    }

    public PathSegmentImpl(String segmentEnc, boolean decode, int indexForErrMess) throws IllegalArgumentException {
        String path;
        if (segmentEnc == null) {
            if (indexForErrMess >= 0) {
                throw new IllegalArgumentException("The " + indexForErrMess + ". segment must not be null");
            }
            throw new IllegalArgumentException("The segment must not be null");
        }
        this.decode = decode;
        int indexOfSemic = segmentEnc.indexOf(59);
        if (indexOfSemic >= 0) {
            path = segmentEnc.substring(0, indexOfSemic);
            this.matrParamEncoded = segmentEnc.substring(indexOfSemic + 1);
        } else {
            path = segmentEnc;
            this.matrParamEncoded = null;
        }
        this.path = decode ? Reference.decode((String)path) : path;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PathSegmentImpl)) {
            return false;
        }
        PathSegment that = (PathSegment)object;
        return this.getPath().equals(that.getPath()) && this.getMatrixParameters().equals((Object)that.getMatrixParameters());
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        if (this.matrixParameters == null) {
            this.matrixParameters = PathSegmentImpl.parseMatrixParams(this.matrParamEncoded, this.decode);
        }
        return this.matrixParameters;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return SystemUtils.hashCode((Object[])new Object[]{this.getPath(), this.getMatrixParameters()});
    }

    public void toAppendable(Appendable stb, boolean convertBraces) throws IOException {
        Util.append(stb, this.path, convertBraces);
        MultivaluedMap<String, String> matrixParams = this.getMatrixParameters();
        for (Map.Entry mpe : matrixParams.entrySet()) {
            for (String value : (List)mpe.getValue()) {
                stb.append(';');
                Util.append(stb, (CharSequence)mpe.getKey(), convertBraces);
                stb.append('=');
                Util.append(stb, value, convertBraces);
            }
        }
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        this.toStringBuilder(stb, false);
        return stb.toString();
    }

    public void toStringBuilder(StringBuilder stb, boolean convertBraces) {
        try {
            this.toAppendable(stb, convertBraces);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException in StringBuilder; that is normally not possible");
        }
    }
}

