/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.ConverterUtils;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;
import org.restlet.service.Service;

public class ConverterService
extends Service {
    public ConverterService() {
    }

    public ConverterService(boolean enabled) {
        super(enabled);
    }

    public Representation applyPatch(Representation initial, Representation patch) throws IOException {
        return null;
    }

    public Representation createPatch(Representation initial, Representation modified) throws IOException {
        return null;
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        ArrayList result = null;
        List<Class<?>> helperObjectClasses = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            helperObjectClasses = ch.getObjectClasses(source);
            if (helperObjectClasses == null) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(helperObjectClasses);
        }
        return result;
    }

    public List<MediaType> getPatchTypes(MediaType representationType) {
        return null;
    }

    public List<? extends Variant> getVariants(Class<?> source, Variant target) throws IOException {
        return ConverterUtils.getVariants(source, target);
    }

    public Representation revertPatch(Representation modified, Representation patch) throws IOException {
        return null;
    }

    public Object toObject(Representation source) throws IOException {
        return this.toObject(source, null, null);
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        boolean loggable;
        T result = null;
        boolean bl = loggable = resource == null || resource.isLoggable();
        if (source != null && source.isAvailable() && source.getSize() != 0L) {
            ConverterHelper ch = ConverterUtils.getBestHelper(source, target, resource);
            if (ch != null) {
                if (loggable && Context.getCurrentLogger().isLoggable(Level.FINE)) {
                    Context.getCurrentLogger().fine("The following converter was selected for the " + String.valueOf(source) + " representation: " + String.valueOf(ch));
                }
                if ((result = (T)ch.toObject(source, target, resource)) instanceof Representation) {
                    Representation resultRepresentation = (Representation)result;
                    resultRepresentation.setCharacterSet(source.getCharacterSet());
                    resultRepresentation.setMediaType(source.getMediaType());
                    resultRepresentation.getEncodings().addAll(source.getEncodings());
                    resultRepresentation.getLanguages().addAll(source.getLanguages());
                }
            } else if (loggable) {
                Context.getCurrentLogger().warning("Unable to find a converter for this representation : " + String.valueOf(source));
            }
        }
        return result;
    }

    public Representation toRepresentation(Object source) throws IOException {
        return this.toRepresentation(source, null, null);
    }

    public Representation toRepresentation(Object source, MediaType target) throws IOException {
        return this.toRepresentation(source, new Variant(target));
    }

    public Representation toRepresentation(Object source, Variant target) throws IOException {
        return this.toRepresentation(source, target, null);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        Representation result = null;
        boolean loggable = resource == null || resource.isLoggable();
        ConverterHelper ch = ConverterUtils.getBestHelper(source, target, resource);
        if (ch != null) {
            List<VariantInfo> variants;
            if (loggable && Context.getCurrentLogger().isLoggable(Level.FINE)) {
                Context.getCurrentLogger().fine("Converter selected for " + source.getClass().getSimpleName() + ": " + ch.getClass().getSimpleName());
            }
            if (target == null && (variants = ch.getVariants(source.getClass())) != null && !variants.isEmpty()) {
                target = resource != null ? resource.getConnegService().getPreferredVariant(variants, resource.getRequest(), resource.getMetadataService()) : (Variant)variants.get(0);
            }
            if (target == null) {
                target = new Variant();
            }
            if ((result = ch.toRepresentation(source, target, resource)) != null) {
                if (result.getCharacterSet() == null) {
                    result.setCharacterSet(target.getCharacterSet());
                }
                if (result.getMediaType() == null || !result.getMediaType().isConcrete()) {
                    if (target.getMediaType() != null && target.getMediaType().isConcrete()) {
                        result.setMediaType(target.getMediaType());
                    } else if (resource != null) {
                        result.setMediaType(resource.getMetadataService().getDefaultMediaType());
                    } else {
                        result.setMediaType(MediaType.APPLICATION_OCTET_STREAM);
                    }
                }
                if (result.getEncodings().isEmpty()) {
                    result.getEncodings().addAll(target.getEncodings());
                }
                if (result.getLanguages().isEmpty()) {
                    result.getLanguages().addAll(target.getLanguages());
                }
            }
        } else if (loggable) {
            Context.getCurrentLogger().warning("Unable to find a converter for this object : " + String.valueOf(source));
        }
        return result;
    }

    public void updatePreferences(List<Preference<MediaType>> preferences, Class<?> entity) {
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            ch.updatePreferences(preferences, entity);
        }
    }
}

