/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.restlet.engine.Edition;
import org.restlet.engine.Engine;

public class EngineClassLoader
extends ClassLoader {
    private final Engine engine;

    public EngineClassLoader(Engine engine) {
        super(EngineClassLoader.class.getClassLoader());
        this.engine = engine;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        ClassLoader cl = this.getEngine().getUserClassLoader();
        if (cl != null) {
            try {
                result = cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                result = cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    @Override
    protected URL findResource(String name) {
        URL result = null;
        ClassLoader cl = this.getEngine().getUserClassLoader();
        if (cl != null) {
            result = cl.getResource(name);
        }
        if (result == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            result = cl.getResource(name);
        }
        return result;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> result = null;
        ClassLoader cl = this.getEngine().getUserClassLoader();
        if (cl != null) {
            result = cl.getResources(name);
        }
        if (result == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            result = cl.getResources(name);
        }
        return result;
    }

    protected Engine getEngine() {
        return this.engine;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> result;
        block4: {
            Enumeration<URL> allUrls = super.getResources(name);
            result = new Vector<URL>();
            if (allUrls != null) {
                try {
                    while (allUrls.hasMoreElements()) {
                        URL url = allUrls.nextElement();
                        if (result.contains(url)) continue;
                        result.add(url);
                    }
                }
                catch (NullPointerException e) {
                    if (!Edition.ANDROID.isNotCurrentEdition()) break block4;
                    throw e;
                }
            }
        }
        return result.elements();
    }
}

